/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.ThaumCraft;

import Reika.ChromatiCraft.Auxiliary.CrystalNetworkLogger;
import Reika.ChromatiCraft.Auxiliary.Render.MouseoverOverlayRenderer;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalNetworkTile;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalSource;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalTransmitter;
import Reika.ChromatiCraft.Magic.Interfaces.LumenRequestingTile;
import Reika.ChromatiCraft.Magic.Interfaces.NotifiedNetworkTile;
import Reika.ChromatiCraft.Magic.Interfaces.WrapperTile;
import Reika.ChromatiCraft.Magic.Network.CrystalFlow;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Network.CrystalPath;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.ChromaAspectManager;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityCenterBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityLaserFX;
import Reika.ChromatiCraft.Render.Particle.EntityRuneFX;
import Reika.DragonAPI.Auxiliary.ModularLogger;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaThaumHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;

public final class NodeReceiverWrapper
implements CrystalReceiver,
NotifiedNetworkTile,
WrapperTile,
LumenRequestingTile {
    private static final int DELAY = 600;
    private static final int MIN_DELAY = 200;
    private static final int NEW_ASPECT_COST = 240000;
    private static final float ASPECT_EXPANSION_COST_PER_VIS = 200.0f;
    private static final ElementTagCompound brightnessCost = new ElementTagCompound();
    private static final ElementTagCompound typeCost = new ElementTagCompound();
    private static final float EFFICIENCY_FACTOR = 0.8f;
    private static final float EFFICIENCY_FACTOR_JAR = 0.6f;
    private static final String LOGGER_ID = "chromanodes";
    private static final Random rand = new Random();
    private final INode node;
    public final WorldLocation location;
    private final UUID uid = UUID.randomUUID();
    private long age = 0L;
    private int fulltick = 200;
    private int tick = 600;
    private int ticksSinceEnergyInput = 0;
    private Aspect activeAspect;
    private ElementTagCompound currentRequestSet;
    private final WeightedRandom<Aspect> candidateRefillAspects = new WeightedRandom();
    private final WeightedRandom<Aspect> candidateNextAspects = new WeightedRandom();
    private final ElementTagCompound storedEnergy = new ElementTagCompound();
    private NodeImprovementStatus status = NodeImprovementStatus.IDLE;
    private final boolean isJarred;
    private final boolean isClient;
    private boolean needsSync = true;

    NodeReceiverWrapper(INode n) {
        this.node = n;
        this.location = new WorldLocation((TileEntity)n);
        this.isClient = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
        this.isJarred = n.getClass().getSimpleName().contains("Jar");
        ModularLogger.instance.log(LOGGER_ID, "Node wrapper created for node " + this.location);
    }

    private int getCurrentValue(CrystalElement e) {
        int val = 0;
        AspectList al = this.node.getAspects();
        for (Aspect a : al.aspects.keySet()) {
            int amt = al.getAmount(a);
            val += this.getTagValue(a).getValue(e) * amt;
        }
        return val;
    }

    private ElementTagCompound getTagValue(Aspect a) {
        return ChromaAspectManager.instance.getElementCost(a, 1.0f).scale(200.0f);
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return this.currentRequestSet != null && this.currentRequestSet.contains(e);
    }

    @Override
    public void cachePosition() {
    }

    @Override
    public void removeFromCache() {
    }

    @Override
    public double getDistanceSqTo(double x, double y, double z) {
        return this.location.getSquaredDistance(x, y, z);
    }

    @Override
    public World getWorld() {
        return this.location.getWorld();
    }

    @Override
    public int getX() {
        return this.location.xCoord;
    }

    @Override
    public int getY() {
        return this.location.yCoord;
    }

    @Override
    public int getZ() {
        return this.location.zCoord;
    }

    @Override
    public int maxThroughput() {
        int base = this.isJarred ? 40 : 60;
        return this.getAgeModifiedThroughput(base);
    }

    private int getAgeModifiedThroughput(int base) {
        if (this.age < 24000L) {
            return base;
        }
        float f = 1.0f + 2.0f * (float)(this.age - 24000L) / 408000.0f;
        return (int)((float)base * f);
    }

    @Override
    public boolean canConduct() {
        return true;
    }

    @Override
    public UUID getUniqueID() {
        return this.uid;
    }

    @Override
    public UUID getPlacerUUID() {
        return null;
    }

    @Override
    public int receiveElement(CrystalSource src, CrystalElement e, int amt) {
        amt = Math.max(1, MathHelper.func_76141_d((float)((float)amt * this.getEfficiencyFactor())));
        int add = Math.min(this.getRemainingSpace(e), amt);
        if (add > 0) {
            this.storedEnergy.addValueToColor(e, add);
            this.ticksSinceEnergyInput = 0;
            this.needsSync = true;
        }
        return add;
    }

    public void tick() {
        if (this.isClient) {
            return;
        }
        ++this.age;
        ++this.ticksSinceEnergyInput;
        if (rand.nextInt(240) == 0) {
            this.playSound("thaumcraft:zap");
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.CHARGINGNODE.ordinal(), (TileEntity)((TileEntity)this.node), (int)32, (int[])new int[0]);
        }
        if (this.age < 10L) {
            return;
        }
        if (this.status == NodeImprovementStatus.IDLE && rand.nextInt(this.modifyChanceByAge(750)) == 0) {
            this.tryImproveNode();
        }
        if (this.status == NodeImprovementStatus.BRIGHTENING && this.tryImproveNodeBrightness()) {
            this.location.triggerBlockUpdate(false);
        }
        if (this.status == NodeImprovementStatus.HEALING && this.tryImproveNodeType()) {
            this.location.triggerBlockUpdate(false);
        }
        if (this.status == NodeImprovementStatus.IDLE && rand.nextInt(this.modifyChanceByAge(200)) == 0) {
            this.startAspectRefill();
        }
        if (this.status == NodeImprovementStatus.REFILLING && this.activeAspect != null) {
            this.tryAspectRefill(this.activeAspect);
        }
        if (this.status == NodeImprovementStatus.IDLE && rand.nextInt(this.modifyChanceByAge(6000)) == 0) {
            this.startNewAspect();
        }
        if (this.status == NodeImprovementStatus.NEWASPECT && this.activeAspect != null) {
            if (this.tryToAddAspect(this.activeAspect)) {
                ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " gained aspect '" + this.activeAspect.getName() + "'");
                this.activeAspect = null;
            }
            if (this.age % 48L == 0L) {
                ChromaSounds.CASTHARMONIC.playSound(this.getWorld(), (double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5, 0.6f, 0.5f);
            }
        }
        if (this.candidateNextAspects.isEmpty() && this.candidateRefillAspects.isEmpty() && this.node.getNodeType() == NodeType.PURE && this.node.getNodeModifier() == NodeModifier.BRIGHT) {
            boolean flag = true;
            for (Aspect a : this.getCurrentNodeAspects()) {
                if (this.node.getAspects().getAmount(a) >= 720) continue;
                flag = false;
                break;
            }
            if (flag) {
                this.status = NodeImprovementStatus.COMPLETE;
            }
        }
        this.needsSync |= this.age % 64L == 0L;
        if (this.needsSync) {
            this.sync();
        }
    }

    private void sync() {
        ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " sending sync");
        this.needsSync = false;
        NBTTagCompound tag = new NBTTagCompound();
        this.location.writeToNBT("location", tag);
        this.write(tag);
        this.writeSync(tag);
        ReikaPacketHelper.sendNBTPacket((String)"ChromaData", (int)ChromaPackets.NODERECEIVERSYNC.ordinal(), (NBTTagCompound)tag, (PacketTarget)new PacketTarget.RadiusTarget(this.location, 64.0));
    }

    private void writeSync(NBTTagCompound tag) {
        if (this.currentRequestSet != null) {
            tag.func_74768_a("requestSet", ReikaArrayHelper.booleanToBitflags((boolean[])this.currentRequestSet.flagSet()));
        }
    }

    private void startAspectRefill() {
        this.recalculateRefillAspects();
        if (!this.candidateRefillAspects.isEmpty()) {
            this.setStatus(NodeImprovementStatus.REFILLING);
            this.activeAspect = (Aspect)this.candidateRefillAspects.getRandomEntry();
            this.playSound("thaumcraft:runicShieldCharge", 1.0f, 0.5f);
            this.tryAspectRefill(this.activeAspect);
            ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " recharge begin");
        }
    }

    private boolean tryAspectRefill(Aspect a) {
        ElementTagCompound tag = this.getTagValue(a);
        if (this.storedEnergy.containsAtLeast(tag)) {
            this.doAspectRefill(a, tag);
            return true;
        }
        int amt = this.node.getAspectsBase().getAmount(a) - this.node.getAspects().getAmount(a);
        this.requestEnergy(tag.copy().scale(amt));
        this.currentRequestSet = tag.copy().scale(2.938736E-39f);
        return false;
    }

    private void doAspectRefill(Aspect a, ElementTagCompound tag) {
        this.ticksSinceEnergyInput = Math.max(this.ticksSinceEnergyInput, 200);
        if (this.node.getAspectsBase().getAmount(a) > this.node.getAspects().getAmount(a)) {
            this.storedEnergy.subtract(tag);
            this.node.addToContainer(a, 1);
            this.location.triggerBlockUpdate(false);
        }
        if (this.node.getAspects().getAmount(a) >= this.node.getAspectsBase().getAmount(a)) {
            ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " recharge finish " + this.activeAspect.getName());
            this.activeAspect = null;
            this.setStatus(NodeImprovementStatus.IDLE);
        }
    }

    private void startNewAspect() {
        this.recalculateCandidateAspects();
        if (!this.candidateNextAspects.isEmpty()) {
            this.setStatus(NodeImprovementStatus.NEWASPECT);
            this.activeAspect = (Aspect)this.candidateNextAspects.getRandomEntry();
            ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " attempting to gain aspect '" + this.activeAspect.getName() + "'");
        }
    }

    private float getEfficiencyFactor() {
        return this.isJarred ? 0.6f : 0.8f;
    }

    private int modifyChanceByAge(int base) {
        long t = this.age;
        if (this.isJarred) {
            t = (long)((double)t * 0.75);
        }
        return (int)Math.max(5.0, Math.max((double)(base / 10), (double)base / (1.0 + (double)((float)t / 1.2f * ChromaOptions.getNodeGrowthSpeed()) / (double)base)));
    }

    private boolean tryToAddAspect(Aspect a) {
        if (this.currentRequestSet == null) {
            this.currentRequestSet = this.getTagValue(a);
        }
        boolean flag = true;
        for (CrystalElement e : this.currentRequestSet.elementSet()) {
            flag &= this.storedEnergy.getValue(e) >= 240000;
        }
        if (flag) {
            this.doAddAspect(a);
            return true;
        }
        this.requestForNewAspect(a, this.currentRequestSet);
        return false;
    }

    private int getRemainingSpace(CrystalElement e) {
        return this.getMaxStorage(e) - this.storedEnergy.getValue(e);
    }

    private void doAddAspect(Aspect a) {
        for (CrystalElement e : this.currentRequestSet.elementSet()) {
            this.storedEnergy.subtract(e, 240000);
        }
        this.currentRequestSet = null;
        this.node.getAspectsBase().add(a, 1);
        this.node.addToContainer(a, 1);
        this.playSound("thaumcraft:hhon");
        this.playSound("thaumcraft:hhoff");
        ReikaPacketHelper.sendStringPacketWithRadius((String)"ChromaData", (int)ChromaPackets.NEWASPECTNODE.ordinal(), (TileEntity)((TileEntity)this.node), (int)32, (String)a.getName().toLowerCase(Locale.ENGLISH));
        this.location.triggerBlockUpdate(false);
        this.setStatus(NodeImprovementStatus.IDLE);
    }

    @Override
    public void onPathBroken(CrystalFlow p, CrystalNetworkLogger.FlowFail f) {
        if (this.status == NodeImprovementStatus.IDLE) {
            return;
        }
        this.playSound("thaumcraft:craftfail");
        if (rand.nextInt(8) == 0) {
            this.damageNode();
        }
    }

    private void damageNode() {
        ChromaSounds.ERROR.playSound(((TileEntity)this.node).field_145850_b, (double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5, 0.75f, 2.0f);
        ChromaSounds.ERROR.playSound(((TileEntity)this.node).field_145850_b, (double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5, 1.0f, 1.0f);
        ChromaSounds.ERROR.playSound(((TileEntity)this.node).field_145850_b, (double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5, 0.75f, 0.5f);
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.HURTNODE.ordinal(), (TileEntity)((TileEntity)this.node), (int)32, (int[])new int[0]);
        if (rand.nextInt(60) == 0) {
            if (this.node.getNodeModifier() != null) {
                switch (this.node.getNodeModifier()) {
                    case BRIGHT: {
                        this.node.setNodeModifier(null);
                        break;
                    }
                    case PALE: {
                        this.node.setNodeModifier(NodeModifier.FADING);
                        break;
                    }
                    case FADING: {
                        this.emptyNode();
                    }
                }
            } else {
                this.node.setNodeModifier(NodeModifier.PALE);
            }
        }
        if (rand.nextInt(480) == 0) {
            switch (this.node.getNodeType()) {
                case PURE: {
                    this.node.setNodeType(NodeType.NORMAL);
                    break;
                }
                case NORMAL: {
                    this.node.setNodeType(NodeType.UNSTABLE);
                    break;
                }
                case UNSTABLE: {
                    this.node.setNodeType(NodeType.DARK);
                    break;
                }
                case DARK: {
                    this.node.setNodeType(NodeType.TAINTED);
                    break;
                }
                case TAINTED: {
                    this.node.setNodeType(NodeType.HUNGRY);
                    break;
                }
                case HUNGRY: {
                    this.destroyNode();
                }
            }
        }
        AspectList al = this.node.getAspectsBase();
        for (Aspect a : al.aspects.keySet()) {
            int amt = al.getAmount(a);
            if (amt <= 1) continue;
            int rem = Math.min(amt - 1, (int)(rand.nextFloat() * ((float)amt / 2.0f)));
            al.remove(a, rem);
        }
        this.location.triggerBlockUpdate(false);
    }

    private void tryImproveNode() {
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.HEALNODE.ordinal(), (TileEntity)((TileEntity)this.node), (int)32, (int[])new int[0]);
        boolean flag = this.tryExpandNodeCapacity();
        if (rand.nextInt(this.modifyChanceByAge(90)) == 0) {
            flag |= this.tryImproveNodeBrightness();
        }
        if (this.status == NodeImprovementStatus.IDLE && rand.nextInt(this.modifyChanceByAge(360)) == 0) {
            flag |= this.tryImproveNodeType();
        }
        if (flag) {
            this.location.triggerBlockUpdate(false);
        }
    }

    private boolean tryExpandNodeCapacity() {
        boolean flag = false;
        AspectList al = this.node.getAspectsBase();
        for (Aspect a : al.aspects.keySet()) {
            double f;
            int amt = al.getAmount(a);
            int newamt = Math.min(720, Math.max(amt + 1, (int)((double)amt + (f = rand.nextDouble() * MathHelper.func_151237_a((double)((double)this.age / 15000.0 * (double)ChromaOptions.getNodeGrowthSpeed()), (double)1.0, (double)4.0)) * Math.sqrt(amt))));
            if (newamt <= amt) continue;
            al.merge(a, newamt);
            ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " aspect '" + a.getName() + "' cap increased to " + newamt);
            flag = true;
        }
        if (flag) {
            ChromaSounds.CAST.playSoundAtBlock(this.location);
        }
        return flag;
    }

    private boolean tryImproveNodeType() {
        if (this.node.getNodeType() == NodeType.PURE) {
            return false;
        }
        if (this.storedEnergy.containsAtLeast(typeCost)) {
            this.storedEnergy.subtract(typeCost);
            switch (this.node.getNodeType()) {
                case PURE: {
                    break;
                }
                case NORMAL: {
                    this.node.setNodeType(NodeType.PURE);
                    break;
                }
                case UNSTABLE: {
                    this.node.setNodeType(NodeType.NORMAL);
                    break;
                }
                case DARK: {
                    this.node.setNodeType(NodeType.UNSTABLE);
                    break;
                }
                case TAINTED: {
                    this.node.setNodeType(NodeType.DARK);
                    break;
                }
                case HUNGRY: {
                    this.node.setNodeType(NodeType.TAINTED);
                }
            }
            ChromaSounds.DASH.playSoundAtBlock(this.location.getWorld(), this.location.xCoord, this.location.yCoord, this.location.zCoord, 1.0f, 0.5f);
            ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " type change");
            this.setStatus(NodeImprovementStatus.IDLE);
            return true;
        }
        this.setStatus(NodeImprovementStatus.HEALING);
        if (this.requestEnergy(typeCost)) {
            this.playSound("thaumcraft:craftstart");
        }
        return false;
    }

    private boolean tryImproveNodeBrightness() {
        if (this.node.getNodeModifier() == NodeModifier.BRIGHT) {
            return false;
        }
        if (this.storedEnergy.containsAtLeast(brightnessCost)) {
            this.storedEnergy.subtract(brightnessCost);
            if (this.node.getNodeModifier() != null) {
                switch (this.node.getNodeModifier()) {
                    case BRIGHT: {
                        break;
                    }
                    case PALE: {
                        this.node.setNodeModifier(null);
                        break;
                    }
                    case FADING: {
                        this.node.setNodeModifier(NodeModifier.PALE);
                    }
                }
            } else {
                this.node.setNodeModifier(NodeModifier.BRIGHT);
            }
            ChromaSounds.DASH.playSoundAtBlock(this.location.getWorld(), this.location.xCoord, this.location.yCoord, this.location.zCoord, 1.0f, 0.5f);
            ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " brightness change");
            this.setStatus(NodeImprovementStatus.IDLE);
            return true;
        }
        this.setStatus(NodeImprovementStatus.BRIGHTENING);
        if (this.requestEnergy(brightnessCost)) {
            this.playSound("thaumcraft:craftstart");
        }
        return false;
    }

    private void setStatus(NodeImprovementStatus s) {
        this.status = s;
        if (s == NodeImprovementStatus.IDLE) {
            this.currentRequestSet = null;
            CrystalNetworker.instance.breakPaths(this);
        }
    }

    private boolean requestEnergy(ElementTagCompound tag) {
        if (this.ticksSinceEnergyInput < 300) {
            return false;
        }
        boolean flag = false;
        for (CrystalElement e : tag.elementSet()) {
            int req = MathHelper.func_76123_f((float)((float)tag.getValue(e) / this.getEfficiencyFactor()));
            int amt = Math.min(req, this.getRemainingSpace(e));
            flag |= CrystalNetworker.instance.makeRequest(this, e, amt, this.getReceiveRange());
        }
        return flag;
    }

    private void requestForNewAspect(Aspect a, ElementTagCompound tag) {
        if (this.ticksSinceEnergyInput < 300) {
            return;
        }
        for (CrystalElement e : tag.elementSet()) {
            int req = MathHelper.func_76123_f((float)(240000.0f / this.getEfficiencyFactor()));
            int amt = Math.min(req, this.getRemainingSpace(e));
            boolean bl = CrystalNetworker.instance.makeRequest(this, e, amt, this.getReceiveRange());
        }
    }

    private void emptyNode() {
        for (Aspect a : this.node.getAspects().aspects.keySet()) {
            int amt = this.node.getAspects().getAmount(a);
            if (amt <= 1) continue;
            this.node.takeFromContainer(a, amt - 1);
        }
        ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " emptied");
        this.location.triggerBlockUpdate(false);
    }

    private void fillNode() {
        this.node.setAspects(this.node.getAspectsBase());
        ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " filled");
        this.location.triggerBlockUpdate(false);
    }

    private void destroyNode() {
        this.playSound("thaumcraft:craftfail", 2.0f, 1.0f);
        this.playSound("thaumcraft:craftfail", 2.0f, 1.0f);
        this.playSound("thaumcraft:craftfail", 1.0f, 0.5f);
        World world = ((TileEntity)this.node).field_145850_b;
        double x = (double)this.location.xCoord + 0.5;
        double y = (double)this.location.yCoord + 0.5;
        double z = (double)this.location.zCoord + 0.5;
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.DESTROYNODE.ordinal(), (TileEntity)((TileEntity)this.node), (int)32, (int[])new int[0]);
        ChromaSounds.POWERDOWN.playSound(world, x, y, z, 2.0f, 1.0f);
        ChromaSounds.POWERDOWN.playSound(world, x, y, z, 2.0f, 1.0f);
        EntityLightningBolt elb = new EntityLightningBolt(world, x - 0.5, y, z - 0.5);
        world.func_72942_c((Entity)elb);
        ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " destroyed");
        this.location.setBlock(Blocks.field_150350_a);
    }

    @SideOnly(value=Side.CLIENT)
    public static void triggerNewAspectFX(World world, int x, int y, int z, Aspect a) {
        double dx = (double)x + 0.5;
        double dy = (double)y + 0.5;
        double dz = (double)z + 0.5;
        for (int i = 0; i < 16; ++i) {
            float fx = (float)ReikaRandomHelper.getRandomPlusMinus((double)dx, (double)4.0);
            float fy = (float)ReikaRandomHelper.getRandomPlusMinus((double)dy, (double)4.0);
            float fz = (float)ReikaRandomHelper.getRandomPlusMinus((double)dz, (double)4.0);
            ReikaThaumHelper.triggerEffect((ReikaThaumHelper.EffectType)ReikaThaumHelper.EffectType.NODEBOLT, (Object[])new Object[]{world, Float.valueOf((float)dx), Float.valueOf((float)dy), Float.valueOf((float)dz), Float.valueOf(fx), Float.valueOf(fy), Float.valueOf(fz)});
        }
        int color = a.getColor();
        for (int i = 0; i < 64; ++i) {
            float gv = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.25, (double)0.125);
            if (rand.nextInt(3) > 0) {
                gv = -gv;
            }
            double v = 0.125 + rand.nextDouble() * 0.0625;
            double va = rand.nextDouble() * 360.0;
            double vx = v * Math.cos(Math.toDegrees(va));
            double vz = v * Math.sin(Math.toDegrees(va));
            EntityBlurFX fx = new EntityCCBlurFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, vx, 0.0, vz).setColor(color).setGravity(gv).setScale(2.0f).setRapidExpand();
            fx.field_70145_X = true;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        EntityCenterBlurFX fx = new EntityCenterBlurFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5).setColor(a.getColor()).setScale(20.0f);
        fx.field_70145_X = true;
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    @SideOnly(value=Side.CLIENT)
    public static void triggerDestroyFX(World world, int x, int y, int z) {
        Object fx;
        NodeReceiverWrapper wrap = new NodeReceiverWrapper((INode)world.func_147438_o(x, y, z));
        for (int i = 0; i < 512; ++i) {
            Aspect a = (Aspect)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, wrap.node.getAspects().aspects.keySet());
            double v = 0.125 + rand.nextDouble() * 0.25;
            double rx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            double ry = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            double rz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            int color = a.getColor();
            fx = new EntityCCBlurFX(world, (double)x + rand.nextDouble(), (double)y + rand.nextDouble(), (double)z + rand.nextDouble(), rx, ry, rz).setColor(color);
            fx.field_70145_X = true;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        for (int k = 0; k < 16; ++k) {
            CrystalElement e = CrystalElement.elements[k];
            if (wrap.getCurrentValue(e) <= 0) continue;
            for (int i = 0; i < 8; ++i) {
                double v = 0.125 + rand.nextDouble() * 0.25;
                double rx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
                double ry = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
                double rz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
                fx = new EntityRuneFX(world, (double)x + rand.nextDouble(), (double)y + rand.nextDouble(), (double)z + rand.nextDouble(), rx, ry, rz, e);
                fx.field_70145_X = true;
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void triggerDamageFX(World world, int x, int y, int z) {
        ReikaThaumHelper.triggerEffect((ReikaThaumHelper.EffectType)ReikaThaumHelper.EffectType.NODEBURST, (Object[])new Object[]{world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, Float.valueOf(1.0f)});
    }

    @SideOnly(value=Side.CLIENT)
    public static void triggerChargingFX(World world, int x, int y, int z) {
        int i;
        NodeReceiverWrapper wrap = new NodeReceiverWrapper((INode)world.func_147438_o(x, y, z));
        double dx = (double)x + 0.5;
        double dy = (double)y + 0.5;
        double dz = (double)z + 0.5;
        for (i = 0; i < 8; ++i) {
            Aspect a = (Aspect)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, wrap.node.getAspects().aspects.keySet());
            double px = ReikaRandomHelper.getRandomPlusMinus((double)dx, (double)0.125);
            double py = ReikaRandomHelper.getRandomPlusMinus((double)dy, (double)0.125);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)dz, (double)0.125);
            double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.03125);
            double vy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.03125);
            double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.03125);
            EntityLaserFX fx = new EntityLaserFX(CrystalElement.WHITE, world, px, py, pz, vx, vy, vz).setColor(a.getColor());
            fx.field_70145_X = true;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        for (i = 0; i < 6; ++i) {
            double r = rand.nextInt(32) == 0 ? 2.5 : (rand.nextInt(8) == 0 ? 1.25 : 0.75);
            float px = (float)ReikaRandomHelper.getRandomPlusMinus((double)dx, (double)r);
            float py = (float)ReikaRandomHelper.getRandomPlusMinus((double)dy, (double)r);
            float pz = (float)ReikaRandomHelper.getRandomPlusMinus((double)dz, (double)r);
            ReikaThaumHelper.triggerEffect((ReikaThaumHelper.EffectType)ReikaThaumHelper.EffectType.NODEBOLT, (Object[])new Object[]{world, Float.valueOf((float)dx), Float.valueOf((float)dy), Float.valueOf((float)dz), Float.valueOf(px), Float.valueOf(py), Float.valueOf(pz)});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void triggerHealFX(World world, int x, int y, int z) {
        NodeReceiverWrapper wrap = new NodeReceiverWrapper((INode)world.func_147438_o(x, y, z));
        double dx = (double)x + 0.5;
        double dy = (double)y + 0.5;
        double dz = (double)z + 0.5;
        for (double d = -1.0; d <= 1.0; d += 0.125) {
            Aspect a = (Aspect)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, wrap.node.getAspects().aspects.keySet());
            int color = a.getColor();
            EntityBlurFX fx = new EntityCCBlurFX(world, dx, dy + d, dz).setColor(color).setScale(2.5f - 2.0f * (float)Math.abs(d)).setRapidExpand().setLife(20);
            fx.field_70145_X = true;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    private void playSound(String s) {
        this.playSound(s, 1.0f, 1.0f);
    }

    private void playSound(String s, float vol, float p) {
        ReikaSoundHelper.playSoundFromServer((World)((TileEntity)this.node).field_145850_b, (double)((double)this.getX() + 0.5), (double)((double)this.getY() + 0.5), (double)((double)this.getZ() + 0.5), (String)s, (float)vol, (float)p, (boolean)false);
    }

    @Override
    public void onPathCompleted(CrystalFlow p) {
    }

    @Override
    public void onPathConnected(CrystalPath p) {
        ChromaSounds.CAST.playSoundAtBlock(this.getWorld(), this.getX(), this.getY(), this.getZ(), 1.0f, 0.65f);
    }

    @Override
    public void onTileNetworkTopologyChange(CrystalNetworkTile te, boolean remove) {
    }

    @Override
    public int getReceiveRange() {
        return 16;
    }

    @Override
    public DecimalPosition getTargetRenderOffset(CrystalElement e) {
        return null;
    }

    @Override
    public double getIncomingBeamRadius() {
        return 0.0875;
    }

    @Override
    public boolean existsInWorld() {
        return false;
    }

    @Override
    public Class getTileClass() {
        return this.node.getClass();
    }

    public String toString() {
        return ReikaThaumHelper.aspectsToString((AspectList)this.node.getAspectsBase()) + " @ " + this.location;
    }

    public boolean canConductInterdimensionally() {
        return false;
    }

    @Override
    public boolean canReceiveFrom(CrystalTransmitter r) {
        return true;
    }

    @Override
    public boolean needsLineOfSightFromTransmitter(CrystalTransmitter r) {
        return true;
    }

    @Override
    public void triggerBottleneckDisplay(int duration) {
    }

    @Override
    public boolean canBeSuppliedBy(CrystalSource te, CrystalElement e) {
        return true;
    }

    public void load(NBTTagCompound tag, boolean sync) {
        ModularLogger.instance.log(LOGGER_ID, "Node " + this.location + " loading NBT");
        this.age = tag.func_74763_f("age");
        this.tick = tag.func_74762_e("tick");
        this.fulltick = tag.func_74762_e("ftick");
        this.storedEnergy.readFromNBT("energy", tag);
        this.status = NodeImprovementStatus.list[tag.func_74762_e("status")];
        if (tag.func_74764_b("request")) {
            this.activeAspect = Aspect.getAspect((String)tag.func_74779_i("request"));
        } else if (sync) {
            this.activeAspect = null;
        }
        if (tag.func_74764_b("requestSet")) {
            this.currentRequestSet = ElementTagCompound.createFromFlags(ReikaArrayHelper.booleanFromBitflags((int)tag.func_74762_e("requestSet"), (int)16), 1);
        } else if (sync) {
            this.currentRequestSet = null;
        }
        this.ticksSinceEnergyInput = tag.func_74762_e("receiveTime");
        this.recalculateCandidateAspects();
    }

    public void write(NBTTagCompound tag) {
        tag.func_74772_a("age", this.age);
        tag.func_74768_a("tick", this.tick);
        tag.func_74768_a("ftick", this.fulltick);
        tag.func_74768_a("status", this.status.ordinal());
        this.storedEnergy.writeToNBT("energy", tag);
        tag.func_74768_a("receiveTime", this.ticksSinceEnergyInput);
        if (this.activeAspect != null) {
            tag.func_74778_a("request", this.activeAspect.getTag());
        }
    }

    public void recalculateCandidateAspects() {
        this.candidateNextAspects.clear();
        Set<Aspect> set = this.getCurrentNodeAspects();
        for (Aspect a : ReikaThaumHelper.getAllAspects()) {
            if (set.contains(a)) continue;
            boolean prereqs = true;
            if (!a.isPrimal()) {
                for (Aspect par : a.getComponents()) {
                    if (set.contains(par)) continue;
                    prereqs = false;
                    break;
                }
            }
            if (!prereqs) continue;
            this.candidateNextAspects.addEntry((Object)a, (double)(1 + ReikaThaumHelper.getMaxAspectTier() - ReikaThaumHelper.getAspectTier((Aspect)a)));
        }
    }

    public void recalculateRefillAspects() {
        this.candidateRefillAspects.clear();
        AspectList base = this.node.getAspectsBase();
        AspectList in = this.node.getAspects();
        HashMap<Aspect, Integer> significant = new HashMap<Aspect, Integer>();
        for (Aspect aspect : base.aspects.keySet()) {
            int has;
            int cap = base.getAmount(aspect);
            int diff = cap - (has = in.getAmount(aspect));
            if (diff <= 0) continue;
            this.candidateRefillAspects.addEntry((Object)aspect, (double)diff);
            if (has != 0 && (cap - has < 10 || cap / has <= 3)) continue;
            significant.put(aspect, diff);
        }
        if (!significant.isEmpty()) {
            this.candidateRefillAspects.clear();
            for (Map.Entry entry : significant.entrySet()) {
                this.candidateRefillAspects.addEntry(entry.getKey(), (double)((Integer)entry.getValue()).intValue());
            }
        }
    }

    private Set<Aspect> getCurrentNodeAspects() {
        return this.node.getAspectsBase().aspects.keySet();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOverlay(EntityPlayer ep, int gsc) {
        MouseoverOverlayRenderer.instance.renderStorageOverlay(ep, gsc, this);
        Tessellator v5 = Tessellator.field_78398_a;
        int ox = Minecraft.func_71410_x().field_71443_c / (gsc * 2) + 12;
        int oy = Minecraft.func_71410_x().field_71440_d / (gsc * 2) - 12;
        int x = ox;
        int y = oy;
        double t = 0.75 * (double)System.currentTimeMillis() % 360.0;
        int idx = 1 + this.status.ordinal();
        int row = idx / 8;
        int col = idx % 8;
        double u = (double)col / 8.0;
        double v = (double)row / 8.0;
        double du = u + 0.125;
        double dv = v + 0.125;
        int s = 32;
        int dy = 18;
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/nodeoverlays.png");
        v5.func_78382_b();
        v5.func_78378_d(0xFFFFFF);
        v5.func_78374_a((double)x, (double)(y + s - dy), 0.0, u, dv);
        v5.func_78374_a((double)(x + s), (double)(y + s - dy), 0.0, du, dv);
        v5.func_78374_a((double)(x + s), (double)(y - dy), 0.0, du, v);
        v5.func_78374_a((double)x, (double)(y - dy), 0.0, u, v);
        v5.func_78381_a();
        boolean i = false;
        s = 8;
        int n = s + 2;
        if (this.activeAspect != null) {
            IIcon ico;
            ResourceLocation loc = this.activeAspect.getImage();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(loc);
            v5.func_78382_b();
            v5.func_78378_d(this.activeAspect.getColor());
            int s2 = 24;
            int ar = 8;
            int ox2 = Minecraft.func_71410_x().field_71443_c / (gsc * 2) + ar;
            int oy2 = Minecraft.func_71410_x().field_71440_d / (gsc * 2) + ar;
            v5.func_78374_a((double)ox2, (double)(oy2 + s2), 0.0, 0.0, 1.0);
            v5.func_78374_a((double)(ox2 + s2), (double)(oy2 + s2), 0.0, 1.0, 1.0);
            v5.func_78374_a((double)(ox2 + s2), (double)oy2, 0.0, 1.0, 0.0);
            v5.func_78374_a((double)ox2, (double)oy2, 0.0, 0.0, 0.0);
            v5.func_78381_a();
            int s22 = 55;
            int ds = s22 - s2;
            ReikaTextureHelper.bindTerrainTexture();
            int dx = ox2 - ds / 2;
            int dy2 = oy2 - ds / 2;
            if (this.activeAspect.isPrimal()) {
                GL11.glTranslated((double)dx, (double)dy2, (double)0.0);
                GL11.glTranslated((double)((double)s22 / 2.0), (double)((double)s22 / 2.0), (double)0.0);
                GL11.glRotated((double)((double)System.currentTimeMillis() / 9.0 % 360.0), (double)0.0, (double)0.0, (double)1.0);
                GL11.glTranslated((double)((double)(-s22) / 2.0), (double)((double)(-s22) / 2.0), (double)0.0);
            }
            int x2 = 0;
            int y2 = 0;
            if (this.activeAspect.isPrimal()) {
                int blend = this.activeAspect.getBlend();
                ico = blend == 771 ? ChromaIcons.ALPHAHOLE.getIcon() : ChromaIcons.WHITEHOLE.getIcon();
                GL11.glBlendFunc((int)770, (int)blend);
            } else {
                ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
                ico = ChromaIcons.ECLIPSEFLARE.getIcon();
                x2 = dx;
                y2 = dy2;
            }
            v5.func_78382_b();
            v5.func_78378_d(this.activeAspect.getColor());
            v5.func_78374_a((double)(x2 + 0), (double)(y2 + s22), 0.0, (double)ico.func_94209_e(), (double)ico.func_94210_h());
            v5.func_78374_a((double)(x2 + s22), (double)(y2 + s22), 0.0, (double)ico.func_94212_f(), (double)ico.func_94210_h());
            v5.func_78374_a((double)(x2 + s22), (double)(y2 + 0), 0.0, (double)ico.func_94212_f(), (double)ico.func_94206_g());
            v5.func_78374_a((double)(x2 + 0), (double)(y2 + 0), 0.0, (double)ico.func_94209_e(), (double)ico.func_94206_g());
            v5.func_78381_a();
        }
    }

    @Override
    public int getEnergy(CrystalElement e) {
        return this.storedEnergy.getValue(e);
    }

    @Override
    public ElementTagCompound getEnergy() {
        return this.storedEnergy.copy();
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 480000;
    }

    @Override
    public ElementTagCompound getRequestedTotal() {
        switch (this.status) {
            case NEWASPECT: {
                return this.currentRequestSet != null ? this.currentRequestSet.copy().scale(240000.0f) : null;
            }
            case BRIGHTENING: {
                return brightnessCost.copy();
            }
            case HEALING: {
                return typeCost.copy();
            }
            case REFILLING: {
                int amt = this.node.getAspectsBase().getAmount(this.activeAspect) - this.node.getAspects().getAmount(this.activeAspect);
                return this.activeAspect != null ? this.getTagValue(this.activeAspect).scale(amt) : null;
            }
        }
        return null;
    }

    @Override
    public int getTicksExisted() {
        return (int)(this.age % Integer.MAX_VALUE);
    }

    @Override
    public boolean isRemoved() {
        return ((TileEntity)this.node).func_145837_r();
    }

    public void debug(ArrayList<String> li) {
        li.add("Status: " + (Object)((Object)this.status));
        li.add("Age: " + this.age);
        li.add("Ticks Since Energy: " + this.ticksSinceEnergyInput);
        li.add("Active Aspect: " + (this.activeAspect != null ? this.activeAspect.getTag() : "None"));
        li.add("Requesting Element Set: " + this.currentRequestSet);
        li.add("Queued New Aspects: " + this.candidateNextAspects);
        li.add("Queued Fill Aspects: " + this.candidateRefillAspects);
        li.add("Energy: " + this.storedEnergy);
        li.add("Jar: " + this.isJarred);
    }

    static {
        ModularLogger.instance.addLogger((DragonAPIMod)ChromatiCraft.instance, LOGGER_ID);
        brightnessCost.addTag(CrystalElement.BLACK, 40000);
        brightnessCost.addTag(CrystalElement.YELLOW, 10000);
        brightnessCost.addTag(CrystalElement.BLUE, 2000);
        brightnessCost.addTag(CrystalElement.PURPLE, 5000);
        typeCost.addTag(CrystalElement.BLACK, 90000);
        typeCost.addTag(CrystalElement.MAGENTA, 60000);
        typeCost.addTag(CrystalElement.WHITE, 40000);
    }

    public static enum NodeImprovementStatus {
        IDLE,
        REFILLING,
        BRIGHTENING,
        HEALING,
        NEWASPECT,
        COMPLETE;

        private static final NodeImprovementStatus[] list;

        static {
            list = NodeImprovementStatus.values();
        }
    }
}

