/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.ThaumCraft;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalNetworkTile;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.NodeReceiverWrapper;
import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;
import thaumcraft.api.nodes.INode;

public class NodeRecharger
implements TickRegistry.TickHandler {
    public static final NodeRecharger instance = new NodeRecharger();
    private static final String NBT_TAG = "PYLON_RECHARGE_DATA";
    private static final String EXTRA_TAG = "EXTRA_NODE_DATA";
    private final HashMap<Integer, HashMap<WorldLocation, NodeReceiverWrapper>> nodes = new HashMap();
    private final HashSet<BlockKey> blacklist = new HashSet();
    private final HashSet<Integer> ticked = new HashSet();

    private NodeRecharger() {
        Block b = GameRegistry.findBlock((String)"ThaumicHorizons", (String)"synthNode");
        if (b != null) {
            this.blacklist.add(new BlockKey(b));
        }
    }

    public boolean addNode(INode n) {
        TileEntity te = (TileEntity)n;
        if (this.blacklist.contains(new BlockKey(te.func_145838_q(), te.func_145832_p()))) {
            return false;
        }
        WorldLocation loc = new WorldLocation(te);
        this.addLocation(loc, n);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateClient(WorldLocation loc, NBTTagCompound data) {
        TileEntity te;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        HashMap<WorldLocation, NodeReceiverWrapper> map = this.getOrCreateMap(world.field_73011_w.field_76574_g);
        NodeReceiverWrapper wrap = map.get(loc);
        if (wrap == null && (te = loc.getTileEntity((IBlockAccess)world)) instanceof INode) {
            wrap = new NodeReceiverWrapper((INode)te);
            map.put(loc, wrap);
        }
        if (wrap != null) {
            wrap.load(data, true);
        }
    }

    private HashMap<WorldLocation, NodeReceiverWrapper> getOrCreateMap(int id) {
        HashMap<Object, NodeReceiverWrapper> map = this.nodes.get(id);
        if (map == null) {
            map = new HashMap();
            this.nodes.put(id, map);
        }
        return map;
    }

    public boolean isValidNode(INode tile) {
        return !(tile instanceof CrystalNetworkTile) && !tile.getAspectsBase().aspects.isEmpty();
    }

    public void tick(TickRegistry.TickType type, Object ... tickData) {
        World world = (World)tickData[0];
        int id = world.field_73011_w.field_76574_g;
        HashMap<WorldLocation, NodeReceiverWrapper> map = this.nodes.get(id);
        NodeRechargeData.initNetworkData(world).func_76186_a(true);
        if (map != null) {
            HashSet<WorldLocation> remove = new HashSet<WorldLocation>();
            for (WorldLocation loc : map.keySet()) {
                NodeReceiverWrapper node = map.get(loc);
                if (loc.getTileEntity() instanceof INode) {
                    node.tick();
                    continue;
                }
                remove.add(loc);
            }
            for (WorldLocation loc : remove) {
                this.removeLocation(loc, world, true);
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload evt) {
        this.ticked.remove(evt.world.field_73011_w.field_76574_g);
    }

    private void loadLocation(NBTTagCompound tag) {
        WorldLocation loc = WorldLocation.readTag((NBTTagCompound)tag);
        TileEntity te = loc.getTileEntity();
        if (!(te instanceof INode)) {
            ChromatiCraft.logger.logError((Object)("Data saved a TC aura node at " + loc + ", but the node was deleted between world save and reload?!"));
            return;
        }
        INode n = (INode)te;
        NodeReceiverWrapper wrap = new NodeReceiverWrapper(n);
        if (tag.func_74764_b(EXTRA_TAG)) {
            wrap.load(tag.func_74775_l(EXTRA_TAG), false);
        }
        this.register(loc, wrap);
    }

    private void addLocation(WorldLocation loc, INode n) {
        NodeReceiverWrapper wrap = new NodeReceiverWrapper(n);
        this.register(loc, wrap);
        NodeRechargeData.initNetworkData(((TileEntity)n).field_145850_b).func_76186_a(true);
    }

    private void register(WorldLocation loc, NodeReceiverWrapper wrap) {
        HashMap<WorldLocation, NodeReceiverWrapper> map = this.getOrCreateMap(loc.dimensionID);
        map.put(loc, wrap);
    }

    public boolean hasLocation(WorldLocation loc) {
        HashMap<WorldLocation, NodeReceiverWrapper> map = this.nodes.get(loc.dimensionID);
        return map != null && map.containsKey(loc);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderNodeOverlay(EntityPlayer ep, int gsc, INode te) {
        HashMap<WorldLocation, NodeReceiverWrapper> map = this.nodes.get(ep.field_70170_p.field_73011_w.field_76574_g);
        if (map == null) {
            return;
        }
        NodeReceiverWrapper w = map.get(new WorldLocation((TileEntity)te));
        if (w != null) {
            w.renderOverlay(ep, gsc);
        }
    }

    private boolean removeLocation(WorldLocation loc, World world, boolean save) {
        HashMap<WorldLocation, NodeReceiverWrapper> map = this.nodes.get(world.field_73011_w.field_76574_g);
        if (map != null) {
            CrystalNetworker.instance.breakPaths(map.get(loc));
            map.remove(loc);
            if (save) {
                NodeRechargeData.initNetworkData(world).func_76186_a(false);
            }
            return true;
        }
        return false;
    }

    public NodeReceiverWrapper getWrapper(WorldLocation loc, boolean create) {
        TileEntity te;
        HashMap<WorldLocation, NodeReceiverWrapper> map = create ? this.getOrCreateMap(loc.dimensionID) : this.nodes.get(loc.dimensionID);
        NodeReceiverWrapper wrap = map.get(loc);
        if (wrap == null && create && (te = loc.getTileEntity()) instanceof INode) {
            this.addLocation(loc, (INode)te);
        }
        return wrap;
    }

    public EnumSet<TickRegistry.TickType> getType() {
        return EnumSet.of(TickRegistry.TickType.WORLD);
    }

    public boolean canFire(TickEvent.Phase p) {
        return p == TickEvent.Phase.END;
    }

    public String getLabel() {
        return "CC-TC Node Crystal Net Recharging";
    }

    private void save(NBTTagCompound NBT) {
        NBTTagCompound tag = NBT.func_74775_l(NBT_TAG);
        NBTTagList li = new NBTTagList();
        for (HashMap<WorldLocation, NodeReceiverWrapper> map : this.nodes.values()) {
            for (Map.Entry<WorldLocation, NodeReceiverWrapper> e : map.entrySet()) {
                NBTTagCompound nbt = new NBTTagCompound();
                e.getKey().writeToTag(nbt);
                NBTTagCompound meta = new NBTTagCompound();
                e.getValue().write(meta);
                nbt.func_74782_a(EXTRA_TAG, (NBTBase)meta);
                li.func_74742_a((NBTBase)nbt);
            }
        }
        tag.func_74782_a("list", (NBTBase)li);
        NBT.func_74782_a(NBT_TAG, (NBTBase)tag);
    }

    private void load(NBTTagCompound NBT) {
        NBTTagCompound tag = NBT.func_74775_l(NBT_TAG);
        NBTTagList li = tag.func_150295_c("list", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            NBTTagCompound nbt = (NBTTagCompound)o;
            this.loadLocation(nbt);
        }
    }

    public ArrayList<String> debug(WorldLocation loc) {
        ArrayList<String> li = new ArrayList<String>();
        NodeReceiverWrapper wrap = this.getWrapper(loc, false);
        if (wrap != null) {
            wrap.debug(li);
        }
        return li;
    }

    public static class NodeRechargeData
    extends WorldSavedData {
        private static final String IDENTIFIER = "PYLON_RECHARGE_DATA";

        public NodeRechargeData() {
            super("PYLON_RECHARGE_DATA");
        }

        public NodeRechargeData(String s) {
            super(s);
        }

        public void func_76184_a(NBTTagCompound NBT) {
            if (ModList.THAUMCRAFT.isLoaded()) {
                instance.load(NBT);
            }
        }

        public void func_76187_b(NBTTagCompound NBT) {
            instance.save(NBT);
        }

        private static NodeRechargeData initNetworkData(World world) {
            NodeRechargeData data = (NodeRechargeData)world.func_72943_a(NodeRechargeData.class, "PYLON_RECHARGE_DATA");
            if (data == null) {
                data = new NodeRechargeData();
                world.func_72823_a("PYLON_RECHARGE_DATA", (WorldSavedData)data);
            }
            return data;
        }
    }
}

