/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.ThaumCraft;

import Reika.ChromatiCraft.Base.TileEntity.CrystalReceiverBase;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.ChromaAspectManager;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.TileEntityAspectJar;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCenterBlurFX;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityAccelerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.ModList;
import com.google.common.base.Strings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;

public class TileEntityAspectFormer
extends CrystalReceiverBase
implements GuiController {
    private Aspect selected;
    private ForgeDirection facing = ForgeDirection.DOWN;
    private AspectMode mode = AspectMode.DEMAND;
    private ElementTagCompound currentRequest = new ElementTagCompound();
    private static int CAPACITY;

    public static void initCapacity() {
        int max = 0;
        if (ModList.THAUMCRAFT.isLoaded()) {
            for (Aspect a : Aspect.aspects.values()) {
                ElementTagCompound cost = TileEntityAspectFormer.getAspectCost(a);
                max = Math.max(max, cost.getMaximumValue());
            }
        }
        CAPACITY = max * 3 / 2;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        TileEntity te = this.getAdjacentTileEntity(this.facing);
        if (te instanceof IAspectContainer) {
            IAspectContainer iac = (IAspectContainer)te;
            this.mode.collectEnergy(this, world, x, y, z, iac);
            this.checkAndRequest();
            this.mode.generateAspects(this, world, x, y, z, iac);
            if (world.field_72995_K) {
                this.spawnParticles(world, x, y, z, iac);
            }
        }
    }

    public void stepMode() {
        this.mode = this.mode.next();
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z, IAspectContainer iac) {
        double h = 0.2875;
        Aspect a = null;
        switch (this.mode) {
            case DEMAND: {
                a = this.selected;
                break;
            }
            case SUSTAIN: {
                AspectList al = iac.getAspects();
                if (al == null || al.aspects.isEmpty()) break;
                ArrayList li = new ArrayList(al.aspects.keySet());
                a = (Aspect)li.get(this.getTicksExisted() / 20 % li.size());
            }
        }
        if (a == null) {
            return;
        }
        if (ReikaRandomHelper.doWithChance((double)15.0)) {
            double rx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)0.375);
            double rz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)0.375);
            EntityCenterBlurFX fx = new EntityCenterBlurFX(world, rx, (double)y + h, rz, 0.0, 0.0, 0.0).setColor(a.getColor());
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        if (NBT.func_74764_b("aspect")) {
            this.selectAspect(NBT.func_74779_i("aspect"));
        }
        this.mode = AspectMode.list[NBT.func_74762_e("mode")];
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74778_a("aspect", this.selected != null ? this.selected.getTag() : "null");
        NBT.func_74768_a("mode", this.mode.ordinal());
    }

    public void selectAspect(String asp) {
        Aspect old = this.selected;
        Aspect aspect = this.selected = Strings.isNullOrEmpty((String)asp) ? null : (Aspect)Aspect.aspects.get(asp);
        if (this.selected != old) {
            CrystalNetworker.instance.breakPaths(this);
        }
    }

    public Aspect getAspectForRender() {
        switch (this.mode) {
            case DEMAND: {
                return this.selected;
            }
            case SUSTAIN: {
                TileEntity te = this.getAdjacentTileEntity(this.facing);
                if (te instanceof IAspectContainer) {
                    AspectList al = ((IAspectContainer)te).getAspects();
                    if (al == null || al.aspects.isEmpty()) {
                        return null;
                    }
                    ArrayList li = new ArrayList(al.aspects.keySet());
                    return (Aspect)li.get(this.getTicksExisted() / 20 % li.size());
                }
                return null;
            }
        }
        return null;
    }

    public static ElementTagCompound getAspectCost(Aspect a) {
        return ChromaAspectManager.instance.getElementCost(a, 2.0f).power(1.67).scale(20.0f);
    }

    private void checkAndRequest(Aspect a) {
        if (a != null) {
            int n = 64;
            int f = TileEntityAdjacencyUpgrade.getAdjacentUpgrade(this, CrystalElement.LIGHTBLUE);
            if (f > 0) {
                n *= TileEntityAccelerator.getAccelFromTier(f - 1);
            }
            ElementTagCompound tag = TileEntityAspectFormer.getAspectCost(a).scale(n);
            tag.clamp(CAPACITY);
            this.currentRequest.add(tag);
        }
    }

    private void checkAndRequest() {
        for (CrystalElement e : this.currentRequest.elementSet()) {
            int max = Math.min(this.currentRequest.getValue(e), this.getMaxStorage(e));
            int diff = max - this.getEnergy(e);
            if (diff <= 0) continue;
            this.requestEnergy(e, diff);
        }
        this.currentRequest.clear();
    }

    @Override
    public int getReceiveRange() {
        return 16;
    }

    @Override
    public DecimalPosition getTargetRenderOffset(CrystalElement e) {
        double d = -0.28125;
        double dx = d + (double)(e.ordinal() / 4) * 0.1875;
        double dz = d + (double)(e.ordinal() % 4) * 0.1875;
        return new DecimalPosition(dx, 0.4, dz);
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return true;
    }

    @Override
    public int maxThroughput() {
        int base = 250;
        int add = TileEntityAdjacencyUpgrade.getAdjacentUpgrade(this, CrystalElement.PURPLE);
        return base + add * 50;
    }

    @Override
    public boolean canConduct() {
        return false;
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return CAPACITY;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.ASPECT;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d - 1), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 2));
    }

    @Override
    public ElementTagCompound getRequestedTotal() {
        return this.selected != null ? TileEntityAspectFormer.getAspectCost(this.selected) : null;
    }

    @Override
    public double getIncomingBeamRadius() {
        return 0.25;
    }

    public AspectMode getMode() {
        return this.mode;
    }

    public static enum AspectMode {
        DEMAND,
        SUSTAIN;

        private static AspectMode[] list;

        public AspectMode next() {
            return list[(this.ordinal() + 1) % list.length];
        }

        private void collectEnergy(TileEntityAspectFormer te, World world, int x, int y, int z, IAspectContainer iac) {
            if (!world.field_72995_K && te.getCooldown() == 0 && te.checkTimer.checkCap()) {
                switch (this) {
                    case DEMAND: {
                        if (te.selected == null) break;
                        te.checkAndRequest(te.selected);
                        break;
                    }
                    case SUSTAIN: {
                        AspectList al = iac.getAspects();
                        if (al == null) break;
                        for (Aspect a : al.aspects.keySet()) {
                            te.checkAndRequest(a);
                        }
                        break;
                    }
                }
            }
        }

        private void generateAspects(TileEntityAspectFormer te, World world, int x, int y, int z, IAspectContainer iac) {
            switch (this) {
                case DEMAND: {
                    if (te.selected == null) break;
                    this.addAspect(te, te.selected, iac);
                    break;
                }
                case SUSTAIN: {
                    AspectList al = iac.getAspects();
                    if (al == null) break;
                    for (Aspect a : al.aspects.keySet()) {
                        this.addAspect(te, a, iac);
                    }
                    break;
                }
            }
        }

        private void addAspect(TileEntityAspectFormer te, Aspect a, IAspectContainer iac) {
            int left;
            int added;
            int amt = iac instanceof TileEntityAspectJar ? 100 : (a.isPrimal() ? 4 : 1);
            ElementTagCompound tag = TileEntityAspectFormer.getAspectCost(a);
            int frac = (int)te.energy.divide(tag);
            if ((amt = Math.min(amt, frac)) > 0 && (added = amt - (left = iac.addToContainer(a, amt))) > 0) {
                te.drainEnergy(tag.scale(added));
            }
        }

        static {
            list = AspectMode.values();
        }
    }
}

