/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.ThaumCraft;

import Reika.ChromatiCraft.Auxiliary.HoldingChecks;
import Reika.ChromatiCraft.Auxiliary.Interfaces.SneakPop;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.EssentiaNetwork;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.WorldCoordinates;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaTransport;

@APIStripper.Strippable(value={"thaumcraft.api.aspects.IEssentiaTransport"})
public class TileEntityEssentiaRelay
extends TileEntityChromaticBase
implements IEssentiaTransport,
BreakAction,
SneakPop {
    public static final int SEARCH_RANGE = 8;
    public static final int THROUGHPUT = 4;
    private final StepTimer scanTimer = new StepTimer(50);
    private final Collection<EssentiaNetwork.EssentiaPath> activePaths = new ArrayList<EssentiaNetwork.EssentiaPath>();
    private EssentiaNetwork.EssentiaSubnet network;
    private boolean isController;
    private boolean alreadyDropped;
    private static Class infusionMatrix;
    private static Class essentiaHandler;
    private static HashMap<WorldCoordinates, ArrayList<WorldCoordinates>> essentiaHandlerData;

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("controller", this.isController);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.isController = NBT.func_74767_n("controller");
    }

    public void tryBuildNetwork() {
        if (this.network != null) {
            this.network.destroy(this.field_145850_b, false);
            ChromaSounds.USE.playSoundAtBlock((TileEntity)this, 1.0f, 0.5f);
        } else {
            this.network = EssentiaNetwork.NetworkBuilder.buildFrom(this);
            if (this.network != null) {
                this.isController = true;
                ChromaSounds.CAST.playSoundAtBlock((TileEntity)this);
            } else {
                ChromaSounds.ERROR.playSoundAtBlock((TileEntity)this);
            }
        }
    }

    public Map<Coordinate, Boolean> getNetworkTiles() {
        return this.network != null ? this.network.getGeneralizedNetworkRenderer() : null;
    }

    public Collection<Coordinate> getVisibleOtherNodes() {
        return this.network != null ? this.network.getNode(this).getNeighbors() : null;
    }

    public Collection<Coordinate> getVisibleEndpoints() {
        return this.network != null ? this.network.getNode(this).getVisibleEndpoints() : null;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.ESSENTIARELAY;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        HashSet<Coordinate> activeTargets = new HashSet<Coordinate>();
        Iterator<EssentiaNetwork.EssentiaPath> it = this.activePaths.iterator();
        while (it.hasNext()) {
            EssentiaNetwork.EssentiaPath p = it.next();
            p.update(world, x, y, z);
            if (p.target != null) {
                activeTargets.add(p.target);
            }
            it.remove();
        }
        if (this.network != null) {
            if (!world.field_72995_K) {
                EssentiaNetwork.EssentiaMovement em;
                IEssentiaTransport ie;
                Aspect pull;
                TileEntity te;
                EssentiaNetwork.EssentiaMovement mov = this.network.tick(world);
                if (mov != null) {
                    for (EssentiaNetwork.EssentiaPath p : mov.paths()) {
                        this.addPath(p);
                    }
                }
                if ((te = this.getAdjacentTileEntity(ForgeDirection.DOWN)) != null && te.getClass() == EssentiaNetwork.getCentrifugeClass() && (pull = (ie = (IEssentiaTransport)te).getEssentiaType(ForgeDirection.UP)) != null && ie.getEssentiaAmount(ForgeDirection.UP) > 0 && (em = this.network.addEssentia(this, ForgeDirection.DOWN, pull, 1)) != null && em.totalAmount > 0) {
                    int rem = ie.takeEssentia(pull, 1, ForgeDirection.UP);
                    for (EssentiaNetwork.EssentiaPath p : em.paths()) {
                        this.addPath(p);
                    }
                }
            } else {
                this.doNetworkConnectivityParticles(world, x, y, z);
            }
        }
        this.scanTimer.update();
        if (this.scanTimer.checkCap()) {
            this.scan(world, x, y, z, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doNetworkConnectivityParticles(World world, int x, int y, int z) {
        if (HoldingChecks.MANIPULATOR.isClientHolding()) {
            int n = 12;
            int n2 = 48;
            Coordinate h = new Coordinate((TileEntity)this);
            for (Coordinate c : this.getVisibleOtherNodes()) {
                if (c.hashCode() < h.hashCode() || this.getTicksExisted() % n != (c.hashCode() ^ h.hashCode()) % n) continue;
                this.doConnectionParticles(world, x, y, z, c.xCoord, c.yCoord, c.zCoord, true);
            }
            for (Coordinate c : this.getVisibleEndpoints()) {
                if (this.getTicksExisted() % (n2 + n) != (c.hashCode() ^ h.hashCode()) % (n2 + n)) continue;
                this.doConnectionParticles(world, x, y, z, c.xCoord, c.yCoord, c.zCoord, false);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doConnectionParticles(World world, int x, int y, int z, int x2, int y2, int z2, boolean isNode) {
        for (double d = 0.0; d <= 1.0; d += 0.03125) {
            double dx = (double)x + (double)(x2 - x) * d;
            double dy = (double)y + (double)(y2 - y) * d;
            double dz = (double)z + (double)(z2 - z) * d;
            int c = isNode ? 0x6F6FFF : 0x6FFF6F;
            float s = 0.5f + (float)(2.0 * Math.min(d, 1.0 - d));
            EntityBlurFX fx = new EntityCCBlurFX(world, dx + 0.5, dy + 0.5, dz + 0.5).setIcon(ChromaIcons.CENTER).setScale(s).setColor(c).setAlphaFading().setLife(10);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        if (this.isController && this.network == null) {
            this.tryBuildNetwork();
        }
    }

    private void scan(World world, int x, int y, int z, boolean rebuild) {
        if (world.field_72995_K) {
            return;
        }
        if (this.network == null) {
            return;
        }
        HashSet<Coordinate> matrices = new HashSet<Coordinate>();
        for (int i = -8; i <= 8; ++i) {
            for (int j = -8; j <= 8; ++j) {
                for (int k = -8; k <= 8; ++k) {
                    int dx = x + i;
                    int dy = y + j;
                    int dz = z + k;
                    TileEntity te = world.func_147438_o(dx, dy, dz);
                    if (te == null || te.getClass() != infusionMatrix) continue;
                    matrices.add(new Coordinate(te));
                }
            }
        }
        if (!matrices.isEmpty()) {
            for (Coordinate loc : matrices) {
                Collection<Coordinate> li = this.network.getAllEndpoints();
                for (Coordinate c : li) {
                    if (!this.network.isFilteredJar(c)) continue;
                    this.injectFilteredJar(loc, c);
                }
            }
        }
    }

    private void injectFilteredJar(Coordinate loc, Coordinate c) {
        if (essentiaHandlerData == null) {
            try {
                Field f = essentiaHandler.getDeclaredField("sources");
                f.setAccessible(true);
                essentiaHandlerData = (HashMap)f.get(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (essentiaHandlerData != null) {
            WorldCoordinates add;
            WorldCoordinates key = new WorldCoordinates(loc.xCoord, loc.yCoord, loc.zCoord, this.field_145850_b.field_73011_w.field_76574_g);
            ArrayList<Object> li = essentiaHandlerData.get(key);
            if (li == null) {
                li = new ArrayList();
                essentiaHandlerData.put(key, li);
            }
            if (!li.contains(add = new WorldCoordinates(c.xCoord, c.yCoord, c.zCoord, this.field_145850_b.field_73011_w.field_76574_g))) {
                li.add(add);
            }
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    private void addPath(EssentiaNetwork.EssentiaPath p) {
        this.activePaths.add(p);
    }

    public boolean isConnectable(ForgeDirection face) {
        return true;
    }

    public boolean canInputFrom(ForgeDirection face) {
        return true;
    }

    public boolean canOutputTo(ForgeDirection face) {
        return true;
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public Aspect getSuctionType(ForgeDirection face) {
        return null;
    }

    public int getSuctionAmount(ForgeDirection face) {
        return 36;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        if (this.network == null) {
            return 0;
        }
        EssentiaNetwork.EssentiaMovement r = this.network.removeEssentia(this, face, aspect, amount = Math.min(4, amount));
        if (r != null) {
            for (EssentiaNetwork.EssentiaPath p : r.paths()) {
                this.addPath(p);
            }
            return r.totalAmount;
        }
        return 0;
    }

    private int collectEssentiaToTarget(Aspect a, int amt, Coordinate tgt) {
        if (this.network == null) {
            return 0;
        }
        EssentiaNetwork.EssentiaMovement r = this.network.removeEssentia(this, ForgeDirection.DOWN, a, amt = Math.min(4, amt), tgt);
        if (r != null) {
            for (EssentiaNetwork.EssentiaPath p : r.paths()) {
                this.addPath(p);
            }
            return r.totalAmount;
        }
        return 0;
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        if (this.network == null) {
            return 0;
        }
        EssentiaNetwork.EssentiaMovement s = this.network.addEssentia(this, face, aspect, amount = Math.min(4, amount));
        if (s != null) {
            for (EssentiaNetwork.EssentiaPath p : s.paths()) {
                this.addPath(p);
            }
            return s.totalAmount;
        }
        return 0;
    }

    public Aspect getEssentiaType(ForgeDirection face) {
        if (this.network == null) {
            return null;
        }
        TileEntity te = this.getAdjacentTileEntity(face);
        return te instanceof IEssentiaTransport ? ((IEssentiaTransport)te).getSuctionType(face.getOpposite()) : null;
    }

    public int getEssentiaAmount(ForgeDirection face) {
        if (this.network == null) {
            return 0;
        }
        Aspect a = this.getEssentiaType(face);
        return a != null ? this.network.countEssentia(this.field_145850_b, a) : 0;
    }

    public int getMinimumSuction() {
        return 24;
    }

    public boolean renderExtendedTube() {
        return false;
    }

    public void breakBlock() {
        if (this.network != null) {
            this.network.destroy(this.field_145850_b, true);
        }
        this.network = null;
        this.isController = false;
    }

    public void reset() {
        this.network = null;
        this.isController = false;
    }

    void setNetwork(EssentiaNetwork.EssentiaSubnet net) {
        this.network = net;
    }

    EssentiaNetwork.EssentiaSubnet getNetwork() {
        return this.network;
    }

    @Override
    public boolean allowMining(EntityPlayer ep) {
        return false;
    }

    @Override
    public final void drop() {
        if (this.alreadyDropped) {
            return;
        }
        this.alreadyDropped = true;
        ItemStack is = this.getTile().getCraftedProduct();
        is.field_77990_d = new NBTTagCompound();
        ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)is);
        this.delete();
    }

    @Override
    public final boolean canDrop(EntityPlayer ep) {
        return ep.func_110124_au().equals(this.placerUUID);
    }

    static {
        if (ModList.THAUMCRAFT.isLoaded()) {
            try {
                infusionMatrix = Class.forName("thaumcraft.common.tiles.TileInfusionMatrix");
                essentiaHandler = Class.forName("thaumcraft.common.lib.events.EssentiaHandler");
            }
            catch (Exception e) {
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.THAUMCRAFT, e);
                ChromatiCraft.logger.logError((Object)"Could not access TC infusion matrix classes!");
                e.printStackTrace();
            }
        }
    }
}

