/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.ThaumCraft;

import Reika.ChromatiCraft.Auxiliary.Interfaces.OperationInterval;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedRelayPowered;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.Maps.TimerMap;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Instantiable.Effects.EntityFluidFX;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.OpenTopTank;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class TileEntityFluxMaker
extends InventoriedRelayPowered
implements OperationInterval {
    private static final ElementTagCompound required = new ElementTagCompound();
    private static final WeightedRandom<Fluid> fluidRand = new WeightedRandom();
    public int processTimer;
    private final StepTimer timer = new StepTimer(10);
    private final HashMap<String, Integer> fluxCache = new HashMap();
    private final TimerMap<String> particleTimers = new TimerMap();

    private static void addFluid(String s, int wt) {
        Fluid f = FluidRegistry.getFluid((String)s);
        if (f != null) {
            fluidRand.addEntry((Object)f, (double)wt);
        }
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.FLUXMAKER;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        this.particleTimers.tick();
        if (world.field_72995_K) {
            this.doParticles(world, x, y, z);
        } else if (this.energy.containsAtLeast(required)) {
            Fluid f = (Fluid)fluidRand.getRandomEntry();
            if (f != null) {
                this.timer.update();
                this.processTimer = this.timer.getTick();
                if (this.timer.checkCap()) {
                    int amt = 125;
                    if (this.inv[0] != null && this.isItemValid(this.inv[0])) {
                        ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
                        amt = 1000;
                    }
                    if (this.spawnBlock(world, x, y, z, f, amt)) {
                        this.energy.subtract(required);
                        this.particleTimers.put((Object)f.getName(), 5 + this.timer.getCap());
                        if (rand.nextInt(amt == 1000 ? 2 : 8) == 0) {
                            ForgeDirection dir = this.dirs[1 + rand.nextInt(5)];
                            Block b = GameRegistry.findBlock((String)ModList.THAUMCRAFT.modLabel, (String)"blockFluxGas");
                            int dx = x + dir.offsetX;
                            int dy = y + dir.offsetY;
                            int dz = z + dir.offsetZ;
                            if (world.func_147439_a(dx, dy, dz).isAir((IBlockAccess)world, dx, dy, dz)) {
                                world.func_147449_b(dx, dy, dz, b);
                            }
                        }
                    }
                }
            } else {
                this.timer.reset();
            }
        } else {
            this.timer.reset();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        for (String s : this.particleTimers.keySet()) {
            Fluid f = FluidRegistry.getFluid((String)s);
            if (f != null) {
                for (int i = 0; i < 2; ++i) {
                    double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.025);
                    double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.025);
                    double vy = ReikaRandomHelper.getRandomBetween((double)0.0, (double)0.0625);
                    EntityFluidFX fx = new EntityFluidFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, vx, vy, vz, f).setGravity(0.125f).setLife(30).setScale(0.5f);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                }
                if (rand.nextInt(32) != 0) continue;
                String snd = "";
                switch (rand.nextInt(4)) {
                    case 0: {
                        snd = "thaumcraft:gore";
                        break;
                    }
                    case 1: {
                        snd = "liquid.lavapop";
                        break;
                    }
                    case 2: {
                        snd = "liquid.lava";
                        break;
                    }
                    case 3: {
                        snd = "game.neutral.swim";
                    }
                }
                if (snd.isEmpty()) continue;
                ReikaSoundHelper.playClientSound((String)snd, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)1.0f, (float)(0.5f + rand.nextFloat()), (boolean)true);
                continue;
            }
            throw new IllegalStateException("Fluid '" + s + "' exists on the server but not the client! This is a mod installation error!");
        }
    }

    private boolean spawnBlock(World world, int x, int y, int z, Fluid f, int amt) {
        TileEntity te = this.getAdjacentTileEntity(ForgeDirection.DOWN);
        if (te instanceof OpenTopTank) {
            OpenTopTank tk = (OpenTopTank)te;
            int add = tk.addLiquid(f, amt, false);
            if (add >= amt) {
                tk.addLiquid(f, amt, true);
                return true;
            }
            return false;
        }
        if (te instanceof IFluidHandler) {
            IFluidHandler ifl = (IFluidHandler)te;
            FluidStack fs = new FluidStack(f, amt);
            int add = ifl.fill(ForgeDirection.UP, fs, false);
            if (add >= amt) {
                ifl.fill(ForgeDirection.UP, fs, true);
                return true;
            }
            return false;
        }
        boolean flag = false;
        String s = f.getName();
        Integer has = this.fluxCache.get(s);
        if (has == null) {
            has = 0;
        }
        has = has + amt;
        boolean flag2 = true;
        while (flag2 && has >= 1000) {
            for (int i = 0; i < 6 && flag2 && has >= 1000; ++i) {
                BlockFluidFinite bf;
                int[] dirList = new int[]{0, 2, 3, 4, 5, 1};
                ForgeDirection dir = this.dirs[dirList[i]];
                int dx = x + dir.offsetX;
                int dy = y + dir.offsetY;
                int dz = z + dir.offsetZ;
                Block b = world.func_147439_a(dx, dy, dz);
                boolean added = false;
                if (b.isAir((IBlockAccess)world, dx, dy, dz)) {
                    world.func_147449_b(dx, dy, dz, f.getBlock());
                    added = true;
                } else if (b instanceof BlockFluidFinite && (bf = (BlockFluidFinite)b).getFluid() == f && bf.getQuantaPercentage((IBlockAccess)world, dx, dy, dz) < 1.0f) {
                    world.func_72921_c(dx, dy, dz, world.func_72805_g(dx, dy, dz) + 1, 3);
                    added = true;
                }
                if (added) {
                    has = has - 1000;
                    flag = true;
                    continue;
                }
                if (i != 5) continue;
                flag2 = false;
            }
        }
        if (has > 0) {
            this.fluxCache.put(s, has);
        } else {
            this.fluxCache.remove(s);
        }
        return flag;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return slot == 0 && this.isItemValid(is);
    }

    private boolean isItemValid(ItemStack is) {
        if (is.func_77973_b() == GameRegistry.findItem((String)ModList.THAUMCRAFT.modLabel, (String)"ItemCrystalEssence") && is.field_77990_d != null) {
            AspectList al = new AspectList();
            al.readFromNBT(is.field_77990_d);
            return al.size() == 1 && al.getAmount(Aspect.TAINT) > 0;
        }
        return false;
    }

    @Override
    public ElementTagCompound getRequiredEnergy() {
        return required.copy();
    }

    public static ElementTagCompound getTags() {
        return required.copy();
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 2400;
    }

    @Override
    protected boolean canReceiveFrom(CrystalElement e, ForgeDirection dir) {
        return this.isAcceptingColor(e);
    }

    @Override
    public boolean isAcceptingColor(CrystalElement e) {
        return required.contains(e);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.processTimer = NBT.func_74762_e("time");
        HashMap map = ReikaNBTHelper.readMapFromNBT((NBTTagCompound)NBT.func_74775_l("particles"));
        this.particleTimers.clear();
        this.particleTimers.putAll((Map)map);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("time", this.processTimer);
        ReikaNBTHelper.writeMapToNBT((String)"particles", (NBTTagCompound)NBT, (Map)this.particleTimers.toMap());
    }

    public int getCookProgressScaled(int a) {
        return this.processTimer * a / this.timer.getCap();
    }

    @Override
    public float getOperationFraction() {
        return (float)this.processTimer / (float)this.timer.getCap();
    }

    @Override
    public OperationInterval.OperationState getState() {
        return this.energy.containsAtLeast(required) ? OperationInterval.OperationState.RUNNING : OperationInterval.OperationState.PENDING;
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        ReikaNBTHelper.writeMapToNBT((String)"fluids", (NBTTagCompound)NBT, this.fluxCache);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        HashMap map = ReikaNBTHelper.readMapFromNBT((NBTTagCompound)NBT.func_74775_l("fluids"));
        this.fluxCache.clear();
        this.fluxCache.putAll(map);
    }

    public boolean hasWork() {
        return this.getState() == OperationInterval.OperationState.RUNNING;
    }

    static {
        required.addTag(CrystalElement.LIGHTGRAY, 60);
        required.addTag(CrystalElement.BLACK, 60);
        TileEntityFluxMaker.addFluid("fluxgoo", 500);
        TileEntityFluxMaker.addFluid("fluxGas", 2000);
        TileEntityFluxMaker.addFluid("fluiddeath", 5);
    }
}

