/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityCCFloatingSeedsFX;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.ProportionedBlockBox;
import Reika.DragonAPI.Interfaces.TileEntity.AdjacentUpdateWatcher;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Interfaces.TileEntity.ConditionalUnbreakability;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import buildcraft.api.tiles.ITileAreaProvider;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"buildcraft.api.tiles.ITileAreaProvider"})
public class TileEntityFloatingLandmark
extends TileEntityChromaticBase
implements ITileAreaProvider,
BreakAction,
AdjacentUpdateWatcher,
ConditionalUnbreakability {
    private static final int RANGE = 256;
    private ProportionedBlockBox area;
    private boolean isPrimary = true;
    private Coordinate primary;
    private boolean anchored;
    private HashSet<Coordinate> connections = new HashSet();

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.LANDMARK;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (world.field_72995_K) {
            this.doBlockParticles(world, x, y, z);
            if (this.area == null || this.area.volume.getVolume() == 1) {
                this.doAxisParticles(world, x, y, z);
            } else if (this.isPrimary) {
                this.doAreaParticles(world, x, y, z);
            }
        } else {
            if (this.area == null) {
                this.findArea(world, x, y, z);
            }
            if (this.isPrimary) {
                // empty if block
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doAxisParticles(World world, int x, int y, int z) {
        int dz;
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        ForgeDirection dir = this.dirs[this.getTicksExisted() % 6];
        for (int d = 1; d < 256; d += 4) {
            int dx = x + dir.offsetX * d;
            int dy = y + dir.offsetY * d;
            int dz2 = z + dir.offsetZ * d;
            if (dy < 0 || dy > 255 || !(ep.func_70092_e((double)dx + 0.5, (double)dy + 0.5, (double)dz2 + 0.5) <= 256.0) || !world.func_147439_a(dx, dy, dz2).isAir((IBlockAccess)world, dx, dy, dz2)) continue;
            double v = 0.25;
            double vx = (double)dir.offsetX * v;
            double vy = (double)dir.offsetY * v;
            double vz = (double)dir.offsetZ * v;
            EntityCCBlurFX fx = new EntityCCBlurFX(world, (double)dx + 0.5, (double)dy + 0.5, (double)dz2 + 0.5, vx, vy, vz);
            int c = ReikaColorAPI.getModifiedHue((int)0xFF0000, (int)(d * 360 / 256));
            fx.setRapidExpand().setAlphaFading().setLife(20).forceIgnoreLimits().setScale(1.4f).setColor(c);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        int dx = x + dir.offsetX * 256;
        int dy = MathHelper.func_76125_a((int)(y + dir.offsetY * 256), (int)0, (int)255);
        if (world.func_147439_a(dx, dy, dz = z + dir.offsetZ * 256).isAir((IBlockAccess)world, dx, dy, dz)) {
            EntityCCBlurFX fx = new EntityCCBlurFX(world, (double)dx + 0.5, (double)dy + 0.5, (double)dz + 0.5);
            fx.setIcon(ChromaIcons.BIGFLARE).setRapidExpand().setAlphaFading().setLife(20).forceIgnoreLimits().setScale(3.0f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doBlockParticles(World world, int x, int y, int z) {
        double r = 0.0625;
        double dx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)r);
        double dy = ReikaRandomHelper.getRandomPlusMinus((double)((double)y + 0.5), (double)r);
        double dz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)r);
        double a1 = rand.nextDouble() * 360.0;
        double a2 = rand.nextDouble() * 360.0;
        EntityCCFloatingSeedsFX fx = new EntityCCFloatingSeedsFX(world, dx, dy, dz, a1, a2);
        fx.particleVelocity *= ReikaRandomHelper.getRandomBetween((double)0.25, (double)0.5);
        fx.angleVelocity *= 4.0;
        fx.freedom *= 1.6;
        fx.tolerance *= 1.2;
        int l = ReikaRandomHelper.getRandomBetween((int)25, (int)80);
        float s = (float)ReikaRandomHelper.getRandomBetween((double)3.5, (double)4.5);
        int c = ReikaColorAPI.mixColors((int)0xFFFFFF, (int)0, (float)((float)ReikaRandomHelper.getRandomBetween((double)0.25, (double)0.75)));
        if (this.isPrimary) {
            c = ReikaColorAPI.mixColors((int)65535, (int)255, (float)((float)ReikaRandomHelper.getRandomBetween((double)0.25, (double)0.75)));
        }
        fx.setIcon(ChromaIcons.FADE_GENTLE).setColor(c).setRapidExpand().setAlphaFading().setScale(s).setLife(l);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    private void findArea(World world, int x, int y, int z) {
        this.isPrimary = true;
        this.area = new ProportionedBlockBox(BlockBox.block((TileEntity)this));
        if (world.field_72995_K) {
            return;
        }
        this.connections.add(new Coordinate((TileEntity)this));
        TileEntityFloatingLandmark te = this.findParent(world, x, y, z);
        if (te != null && te.area != null) {
            this.slaveTo(te);
        }
        this.syncAllData(false);
    }

    private void slaveTo(TileEntityFloatingLandmark te) {
        this.isPrimary = false;
        this.primary = new Coordinate((TileEntity)te);
        te.addLink(this);
        te.isPrimary = true;
        this.area = te.area;
    }

    private void addLink(TileEntityFloatingLandmark te) {
        this.area = new ProportionedBlockBox(this.area.volume.addCoordinate(te.field_145851_c, te.field_145848_d, te.field_145849_e));
        this.connections.addAll(te.connections);
        this.connections.add(new Coordinate((TileEntity)te));
        te.connections = this.connections;
        this.syncAllData(false);
    }

    public void reset(boolean propagate) {
        this.area = null;
        this.isPrimary = true;
        if (propagate) {
            for (Coordinate c : new HashSet<Coordinate>(this.connections)) {
                TileEntity te = c.getTileEntity((IBlockAccess)this.field_145850_b);
                if (!(te instanceof TileEntityFloatingLandmark)) continue;
                ((TileEntityFloatingLandmark)te).reset(false);
            }
        }
        this.connections.clear();
        this.primary = null;
        this.syncAllData(false);
    }

    @SideOnly(value=Side.CLIENT)
    private void doAreaParticles(World world, int x, int y, int z) {
        int n = 18 * Math.min(40, Math.max(1, this.area.volume.getSurfaceArea() / 20));
        for (int i = 0; i < n; ++i) {
            boolean valid;
            double dx = 0.0;
            double dy = 0.0;
            double dz = 0.0;
            if (rand.nextInt(5) < 2) {
                ProportionedBlockBox.CubeEdge edge = this.area.getRandomEdge();
                dx = ReikaRandomHelper.getRandomBetween((double)edge.root.xCoord, (double)((double)edge.root.xCoord + (double)((edge.length + 0) * edge.axis.offsetX)));
                dy = ReikaRandomHelper.getRandomBetween((double)edge.root.yCoord, (double)((double)edge.root.yCoord + (double)((edge.length + 0) * edge.axis.offsetY)));
                dz = ReikaRandomHelper.getRandomBetween((double)edge.root.zCoord, (double)((double)edge.root.zCoord + (double)((edge.length + 0) * edge.axis.offsetZ)));
                if (edge.isPositiveX) {
                    dx += 1.0;
                }
                if (edge.isPositiveY) {
                    dy += 1.0;
                }
                if (edge.isPositiveZ) {
                    dz += 1.0;
                }
            } else {
                dx = ReikaRandomHelper.getRandomBetween((double)this.area.volume.minX, (double)this.area.volume.maxX);
                dy = ReikaRandomHelper.getRandomBetween((double)this.area.volume.minY, (double)this.area.volume.maxY);
                dz = ReikaRandomHelper.getRandomBetween((double)this.area.volume.minZ, (double)this.area.volume.maxZ);
                switch (this.area.getRandomFace()) {
                    case WEST: {
                        dx = this.area.volume.minX;
                        break;
                    }
                    case EAST: {
                        dx = this.area.volume.maxX;
                        break;
                    }
                    case DOWN: {
                        dy = this.area.volume.minY;
                        break;
                    }
                    case UP: {
                        dy = this.area.volume.maxY;
                        break;
                    }
                    case NORTH: {
                        dz = this.area.volume.minZ;
                        break;
                    }
                    case SOUTH: {
                        dz = this.area.volume.maxZ;
                        break;
                    }
                }
            }
            int ix = MathHelper.func_76128_c((double)dx);
            int iy = MathHelper.func_76128_c((double)dy);
            int iz = MathHelper.func_76128_c((double)dz);
            boolean bl = valid = world.func_147439_a(ix, iy, iz).isAir((IBlockAccess)world, ix, iy, iz) || ChromaTiles.getTile((IBlockAccess)world, ix, iy, iz) == this.getTile();
            if (!valid) continue;
            double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.00390625);
            double vy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.00390625);
            double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.00390625);
            EntityCCBlurFX fx = new EntityCCBlurFX(world, dx, dy, dz, vx, vy, vz);
            int hue = (int)(((double)(this.getTicksExisted() * 2) + dx * 3.0 + dy * 1.0 + dz * 2.0) % 360.0);
            int c = ReikaColorAPI.getModifiedHue((int)0xFF0000, (int)hue);
            int l = ReikaRandomHelper.getRandomBetween((int)10, (int)40);
            float s = (float)ReikaRandomHelper.getRandomBetween((double)0.5, (double)1.0);
            ChromaIcons ico = ChromaIcons.FADE;
            switch (rand.nextInt(6)) {
                case 1: {
                    ico = ChromaIcons.NODE2;
                    break;
                }
                case 2: {
                    ico = ChromaIcons.BIGFLARE;
                    break;
                }
                case 3: {
                    ico = ChromaIcons.SPARKLEPARTICLE;
                    break;
                }
                case 4: {
                    ico = ChromaIcons.FLARE;
                    break;
                }
                case 5: {
                    ico = ChromaIcons.RINGFLARE;
                }
            }
            fx.setIcon(ico).setColor(c).setLife(l).setScale(s);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.findArea(world, x, y, z);
    }

    private TileEntityFloatingLandmark findParent(World world, int x, int y, int z) {
        for (int d = 1; d < 256; ++d) {
            for (int i = 0; i < 6; ++i) {
                int dx = x + this.dirs[i].offsetX * d;
                int dy = y + this.dirs[i].offsetY * d;
                int dz = z + this.dirs[i].offsetZ * d;
                if (ChromaTiles.getTile((IBlockAccess)world, dx, dy, dz) != this.getTile()) continue;
                TileEntityFloatingLandmark te = (TileEntityFloatingLandmark)world.func_147438_o(dx, dy, dz);
                return te.getPrimary();
            }
        }
        return null;
    }

    public TileEntityFloatingLandmark getPrimary() {
        if (this.isPrimary) {
            return this;
        }
        TileEntity te = this.primary != null ? this.primary.getTileEntity((IBlockAccess)this.field_145850_b) : null;
        return te instanceof TileEntityFloatingLandmark ? (TileEntityFloatingLandmark)te : null;
    }

    public int getUpdatePacketRadius() {
        return 256;
    }

    public boolean isAnchored() {
        return this.anchored;
    }

    public void anchor() {
        this.anchored = true;
        ChromaSounds.USE.playSoundAtBlock((TileEntity)this);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("primary", this.isPrimary);
        if (this.area != null) {
            this.area.volume.writeToNBT(NBT);
        }
        if (this.primary != null) {
            this.primary.writeToNBT("root", NBT);
        }
        NBT.func_74757_a("anchor", this.anchored);
        ReikaNBTHelper.writeCollectionToNBT(this.connections, (NBTTagCompound)NBT, (String)"links", (ReikaNBTHelper.NBTIO)Coordinate.nbtHandler);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.isPrimary = NBT.func_74767_n("primary");
        if (NBT.func_74764_b("minx")) {
            this.area = new ProportionedBlockBox(BlockBox.readFromNBT((NBTTagCompound)NBT));
        }
        if (NBT.func_74764_b("root")) {
            this.primary = Coordinate.readFromNBT((String)"root", (NBTTagCompound)NBT);
        }
        this.anchored = NBT.func_74767_n("anchor");
        ReikaNBTHelper.readCollectionFromNBT(this.connections, (NBTTagCompound)NBT, (String)"links", (ReikaNBTHelper.NBTIO)Coordinate.nbtHandler);
    }

    public int xMin() {
        return this.area.volume.minX;
    }

    public int yMin() {
        return this.area.volume.minY;
    }

    public int zMin() {
        return this.area.volume.minZ;
    }

    public int xMax() {
        return this.area.volume.maxX - 1;
    }

    public int yMax() {
        return this.area.volume.maxY - 1;
    }

    public int zMax() {
        return this.area.volume.maxZ - 1;
    }

    public void removeFromWorld() {
    }

    public boolean isValidFromLocation(int x, int y, int z) {
        return this.isAnchored() && new Coordinate(x, y, z).getTaxicabDistanceTo(new Coordinate((TileEntity)this)) == 1;
    }

    public void breakBlock() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.reset(true);
    }

    public void onAdjacentUpdate(World world, int x, int y, int z, Block b) {
        if (!this.isAnchored() && !ReikaWorldHelper.checkForAdjSolidBlock((World)world, (int)x, (int)y, (int)z)) {
            ChromaSounds.RIFT.playSoundAtBlock((TileEntity)this);
            this.delete();
            ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (ItemStack)this.getTile().getCraftedProduct());
        }
    }

    public boolean isUnbreakable(EntityPlayer ep) {
        return this.isAnchored();
    }
}

