/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityWirelessPowered;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.ModInterface.EntityChromaManaBurst;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.ASM.InterfaceInjector;
import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BreadthFirstSearch;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.OpenPathFinder;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Maps.PathMap;
import Reika.DragonAPI.Instantiable.Math.Spline;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.subtile.ISpecialFlower;
import vazkii.botania.api.subtile.ISubTileContainer;
import vazkii.botania.api.subtile.SubTileEntity;
import vazkii.botania.api.subtile.SubTileGenerating;

@InterfaceInjector.Injectable(value={"vazkii.botania.api.mana.IManaCollector"})
public class TileEntityManaBooster
extends TileEntityWirelessPowered {
    private static final int FLOWER_RANGE = 8;
    private static final int POOL_RANGE = 12;
    public static final int BOOST_FACTOR = 6;
    private static final ElementTagCompound required = new ElementTagCompound();
    private static Field manaField;
    private static Field spreaderBindField;
    private final StepTimer flowerScan = new StepTimer(50);
    private final StepTimer poolScan = new StepTimer(300);
    private final StepTimer manaCollection = new StepTimer(8);
    private final StepTimer maxBurstRate = new StepTimer(4);
    private final ArrayList<ManaTarget> poolCache = new ArrayList();
    private final ArrayList<ManaTarget> flowerCache = new ArrayList();
    private final PathMap<ManaPath> pathCache = new PathMap();

    @DependentMethodStripper.ModDependent(value={ModList.BOTANIA})
    private static void initFields() throws Exception {
        manaField = SubTileGenerating.class.getDeclaredField("mana");
        manaField.setAccessible(true);
        spreaderBindField = SubTileGenerating.class.getDeclaredField("linkedCollector");
        spreaderBindField.setAccessible(true);
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K) {
            if (this.isTickingNaturally()) {
                if (this.getTicksExisted() % 8 == 0) {
                    for (CrystalElement e : required.elementSet()) {
                        if (this.energy.getValue(e) >= this.getMaxStorage(e)) continue;
                        this.requestEnergy(e, this.getMaxStorage(e) - this.energy.getValue(e));
                    }
                }
                this.flowerScan.update();
                this.poolScan.update();
                this.maxBurstRate.update();
                if (this.flowerScan.checkCap()) {
                    this.scanAndCache(world, x, y, z, false);
                }
                if (this.poolScan.checkCap()) {
                    this.scanAndCache(world, x, y, z, true);
                }
            }
            if (!this.energy.containsAtLeast(required)) {
                return;
            }
            boolean accel = false;
            this.manaCollection.setCap(accel ? 4 : 8);
            if (!this.flowerCache.isEmpty() && !this.poolCache.isEmpty()) {
                this.manaCollection.update();
                if (this.manaCollection.checkCap() && this.maxBurstRate.isAtCap()) {
                    this.distributeMana(world, accel);
                }
            }
        }
    }

    private void distributeMana(World world, boolean accel) {
        int idx = rand.nextInt(this.flowerCache.size());
        ManaFlower c = (ManaFlower)this.flowerCache.get(idx);
        if (c.isCooldown(this)) {
            return;
        }
        int mana = TileEntityManaBooster.receiveMana(world, c.location, Integer.MAX_VALUE, false);
        if (mana == -1) {
            this.flowerCache.remove(idx);
        } else if (mana > 0) {
            int transfer;
            idx = rand.nextInt(this.poolCache.size());
            Coordinate c2 = this.poolCache.get((int)idx).location;
            int space = TileEntityManaBooster.dumpMana(world, c2, Integer.MAX_VALUE, false);
            if (space == -1) {
                this.poolCache.remove(idx);
            } else if (space > 0 && (transfer = Math.min(mana, space / 6)) > 0 && this.doManaTransfer(world, c.location, c2, transfer, accel)) {
                this.energy.subtract(required);
                c.reset(this);
                this.maxBurstRate.reset();
            }
        }
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 1200;
    }

    @Override
    protected int getReceiveRange(CrystalElement e) {
        return 8;
    }

    private boolean doManaTransfer(World world, Coordinate from, Coordinate to, int transfer, boolean accelerated) {
        ManaPath path = this.getPathForBurst(world, from, to);
        if (path != null) {
            EntityChromaManaBurst e = new EntityChromaManaBurst(world, transfer, path, accelerated);
            world.func_72838_d((Entity)e);
            return true;
        }
        return false;
    }

    private ManaPath getPathForBurst(World world, Coordinate from, Coordinate to) {
        ManaPath p = (ManaPath)this.pathCache.get(from, to);
        if (p != null && !p.isValid(world)) {
            p = null;
        }
        if (p == null) {
            p = this.calculateManaPath(world, from, to);
            this.pathCache.put((Object)p, from, to);
        }
        return p;
    }

    private ManaPath calculateManaPath(World world, Coordinate from, Coordinate to) {
        Coordinate mid = new Coordinate((TileEntity)this);
        LinkedList li = BreadthFirstSearch.getOpenPathBetween((World)world, (Coordinate)from, (Coordinate)mid, (int)40);
        LinkedList li2 = BreadthFirstSearch.getOpenPathBetween((World)world, (Coordinate)mid, (Coordinate)to, (int)40);
        if (li != null && li2 != null) {
            HashSet<Object> set = new HashSet<Object>();
            Spline s1 = new Spline(Spline.SplineType.CENTRIPETAL);
            s1.addPoint((Spline.SplineAnchor)new Spline.BasicSplinePoint(new DecimalPosition(from)));
            int i = -1;
            for (Object c : li) {
                if (i % 4 == 0 && c != li.getLast()) {
                    if (!c.equals((Object)to) && !c.equals((Object)from) && !c.equals((Object)mid) && OpenPathFinder.isEmptyBlock((World)world, (int)((Coordinate)c).xCoord, (int)((Coordinate)c).yCoord, (int)((Coordinate)c).zCoord)) {
                        set.add(c);
                    }
                    s1.addPoint((Spline.SplineAnchor)new Spline.BasicSplinePoint(new DecimalPosition((Coordinate)c)));
                }
                ++i;
            }
            s1.addPoint((Spline.SplineAnchor)new Spline.BasicSplinePoint(new DecimalPosition(mid)));
            Spline s2 = new Spline(Spline.SplineType.CENTRIPETAL);
            s2.addPoint((Spline.SplineAnchor)new Spline.BasicSplinePoint(new DecimalPosition(mid)));
            i = -1;
            for (Coordinate c : li2) {
                if (i % 4 == 0 && c != li2.getLast()) {
                    if (!c.equals((Object)to) && !c.equals((Object)from) && !c.equals((Object)mid) && OpenPathFinder.isEmptyBlock((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord)) {
                        set.add(c);
                    }
                    s2.addPoint((Spline.SplineAnchor)new Spline.BasicSplinePoint(new DecimalPosition(c)));
                }
                ++i;
            }
            s2.addPoint((Spline.SplineAnchor)new Spline.BasicSplinePoint(new DecimalPosition(to)));
            ManaPath p = new ManaPath(from, to, mid, s1, s2, set);
            return p;
        }
        return null;
    }

    @DependentMethodStripper.ModDependent(value={ModList.BOTANIA})
    public static int receiveMana(World world, Coordinate c, int amt, boolean doRemove) {
        TileEntity te = c.getTileEntity((IBlockAccess)world);
        if (!TileEntityManaBooster.isGeneratingFlower(te)) {
            return -1;
        }
        try {
            SubTileGenerating gen = (SubTileGenerating)((ISubTileContainer)te).getSubTile();
            int has = manaField.getInt(gen);
            if (has >= gen.getMaxMana() / 4) {
                int rem = Math.min(amt, has);
                if (doRemove && rem > 0) {
                    manaField.set(gen, has - rem);
                    c.triggerBlockUpdate(world, false);
                }
                return rem;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.BOTANIA})
    public static int dumpMana(World world, Coordinate c, int amt, boolean doAdd) {
        TileEntity te = c.getTileEntity((IBlockAccess)world);
        if (!TileEntityManaBooster.isValidPool(te)) {
            return -1;
        }
        int add = Math.min(amt, ((ISparkAttachable)te).getAvailableSpaceForMana());
        if (doAdd && add > 0) {
            ((IManaPool)te).recieveMana(add);
            c.triggerBlockUpdate(world, false);
        }
        return add;
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.scanAndCache(world, x, y, z, true);
        this.scanAndCache(world, x, y, z, false);
    }

    private void scanAndCache(World world, int x, int y, int z, boolean pools) {
        ArrayList<ManaTarget> set = pools ? this.poolCache : this.flowerCache;
        set.clear();
        int r = pools ? 12 : 8;
        for (int i = -r; i <= r; ++i) {
            block1: for (int k = -r; k <= r; ++k) {
                if (Math.abs(i) + Math.abs(k) > r) continue;
                for (int j = 1; j <= 3; ++j) {
                    boolean flag;
                    int dx = x + i;
                    int dy = y - j;
                    int dz = z + k;
                    boolean bl = flag = !world.func_147439_a(dx, dy, dz).isAir((IBlockAccess)world, dx, dy, dz);
                    if (!flag) continue;
                    TileEntity te = world.func_147438_o(dx, dy, dz);
                    if (pools) {
                        if (!TileEntityManaBooster.isValidPool(te)) continue block1;
                    } else if (!TileEntityManaBooster.isGeneratingFlower(te)) continue block1;
                    if (pools) {
                        set.add(new ManaTarget(te));
                        continue block1;
                    }
                    set.add(new ManaFlower(te));
                    this.bindFlowerToPool(te);
                    continue block1;
                }
            }
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.BOTANIA})
    private void bindFlowerToPool(TileEntity te) {
        SubTileEntity st;
        if (te instanceof ISubTileContainer && (st = ((ISubTileContainer)te).getSubTile()) instanceof SubTileGenerating) {
            try {
                spreaderBindField.set(st, this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.BOTANIA})
    private static boolean isValidPool(TileEntity te) {
        return te instanceof IManaPool && te instanceof ISparkAttachable;
    }

    @DependentMethodStripper.ModDependent(value={ModList.BOTANIA})
    private static boolean isGeneratingFlower(TileEntity te) {
        SubTileEntity st;
        return te instanceof ISubTileContainer && (st = ((ISubTileContainer)te).getSubTile()) instanceof SubTileGenerating;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.MANABOOSTER;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public boolean isFull() {
        return true;
    }

    public void recieveMana(int mana) {
    }

    public boolean canRecieveManaFromBursts() {
        return false;
    }

    public int getCurrentMana() {
        return 0;
    }

    public void onClientDisplayTick() {
    }

    @DependentMethodStripper.ModDependent(value={ModList.BOTANIA})
    public float getManaYieldMultiplier(IManaBurst burst) {
        return 1.0f;
    }

    public int getMaxMana() {
        return Integer.MAX_VALUE;
    }

    static {
        if (ModList.BOTANIA.isLoaded()) {
            try {
                TileEntityManaBooster.initFields();
            }
            catch (Exception e) {
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.BOTANIA, e);
                ChromatiCraft.logger.logError((Object)"Could not access generating flower mana variable!");
                e.printStackTrace();
            }
        }
        required.addTag(CrystalElement.BLACK, 250);
        required.addTag(CrystalElement.GRAY, 100);
        required.addTag(CrystalElement.YELLOW, 100);
        required.addTag(CrystalElement.LIME, 50);
    }

    public static class ManaPath {
        public final Coordinate manaSource;
        public final Coordinate manaTarget;
        public final DecimalPosition boosterCenter;
        public final List<DecimalPosition> pathToBooster;
        public final List<DecimalPosition> pathToPool;
        public final DecimalPosition boosterEntry;
        public final DecimalPosition boosterExit;
        private final HashSet<Coordinate> coords;

        private ManaPath(Coordinate c1, Coordinate c2, Coordinate booster, Spline s1, Spline s2, HashSet<Coordinate> set) {
            this.manaSource = c1;
            this.manaTarget = c2;
            this.boosterCenter = new DecimalPosition(booster);
            this.pathToBooster = Collections.unmodifiableList(s1.get(8, false));
            this.pathToPool = Collections.unmodifiableList(s2.get(8, false));
            this.boosterEntry = this.pathToBooster.get(this.pathToBooster.size() - 1);
            this.boosterExit = this.pathToPool.get(0);
            this.coords = set;
        }

        public boolean isValid(World world) {
            for (Coordinate c : this.coords) {
                if (c.equals((Object)this.manaSource) || c.equals((Object)this.manaTarget) || c.getTaxicabDistanceTo(this.boosterCenter.xCoord, this.boosterCenter.yCoord, this.boosterCenter.zCoord) <= 1 || c.getBlock((IBlockAccess)world) instanceof ISpecialFlower || OpenPathFinder.isEmptyBlock((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord)) continue;
                ChromatiCraft.logger.log((Object)("Invalidating old mana path: " + c.getBlock((IBlockAccess)world).func_149732_F() + " @ " + c));
                return false;
            }
            return true;
        }
    }

    private static class ManaTarget {
        public final Coordinate location;

        protected ManaTarget(TileEntity te) {
            this.location = new Coordinate(te);
        }
    }

    private static class ManaFlower
    extends ManaTarget {
        private static final int MAX_RATE = 20;
        private int lastReceiveTick;

        private ManaFlower(TileEntity te) {
            super(te);
        }

        public boolean isCooldown(TileEntityManaBooster te) {
            return te.getTicksExisted() - this.lastReceiveTick < 20;
        }

        public void reset(TileEntityManaBooster te) {
            this.lastReceiveTick = te.getTicksExisted();
        }
    }
}

