/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface;

import Reika.ChromatiCraft.Auxiliary.Interfaces.ItemOnRightClick;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OperationInterval;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedRelayPowered;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModList;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPageExtractor
extends InventoriedRelayPowered
implements ItemOnRightClick,
OperationInterval {
    private static ItemStack lastItem;
    private static final ElementTagCompound required;
    private final WeightedRandom<IAgeSymbol> symbolMap = new WeightedRandom();
    private final StepTimer timer = new StepTimer(100);
    public float progressFraction;

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (!world.field_72995_K) {
            ItemStack is = this.inv[0];
            if (is != lastItem) {
                this.rebuildSymbolMap(is);
                lastItem = is;
            }
            if (this.inv[1] == null && !this.symbolMap.isEmpty()) {
                IAgeSymbol ia = (IAgeSymbol)this.symbolMap.getRandomEntry();
                ItemStack page = ReikaMystcraftHelper.getSymbolPage((IAgeSymbol)ia);
                if (page != null) {
                    this.timer.update();
                    this.progressFraction = this.timer.getFraction();
                    if (this.timer.checkCap()) {
                        this.inv[1] = page.func_77946_l();
                        double c = this.getConsumptionChance(ia);
                        if (ReikaRandomHelper.doWithChance((double)c)) {
                            this.inv[0] = null;
                        }
                    }
                } else {
                    this.timer.reset();
                }
            } else {
                this.timer.reset();
            }
        }
    }

    private void rebuildSymbolMap(ItemStack is) {
        this.symbolMap.clear();
        if (is != null && this.isBook(is)) {
            ArrayList li = ReikaMystcraftHelper.getPagesInBook((ItemStack)is, (boolean)false);
            for (IAgeSymbol ia : li) {
                int rank = ReikaMystcraftHelper.getSymbolRank((IAgeSymbol)ia);
                double weight = Math.exp((double)(-rank) / 2.0);
                this.symbolMap.addEntry((Object)ia, weight);
            }
        }
    }

    private boolean isBook(ItemStack is) {
        return ModList.MYSTCRAFT.isLoaded() && is.func_77973_b() == GameRegistry.findItem((String)ModList.MYSTCRAFT.modLabel, (String)"agebook");
    }

    private double getConsumptionChance(IAgeSymbol ia) {
        int rank = ReikaMystcraftHelper.getSymbolRank((IAgeSymbol)ia);
        boolean boost = TileEntityAdjacencyUpgrade.getAdjacentUpgrade(this, CrystalElement.PURPLE) > 1;
        double f = boost ? 99.5 : 98.0;
        double p = boost ? 5.0 : 3.0;
        return 100.0 - f * Math.exp((double)(-rank) / p);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.progressFraction = NBT.func_74760_g("prog");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74776_a("prog", this.progressFraction);
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return slot == 1;
    }

    public int func_70302_i_() {
        return 2;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return this.isBook(is) && slot == 0;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.BOOKDECOMP;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public ItemStack onRightClickWith(ItemStack item, EntityPlayer ep) {
        if (ep.func_70093_af()) {
            ItemStack ret = this.inv[0];
            this.inv[0] = null;
            ReikaSoundHelper.playSoundAtBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (String)"random.pop");
            return ret;
        }
        if (item == null && this.inv[1] != null) {
            ItemStack ret = this.inv[1];
            this.inv[1] = null;
            ReikaSoundHelper.playSoundAtBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (String)"random.pop");
            return ret;
        }
        if (this.inv[0] == null && item != null && this.func_94041_b(0, item)) {
            this.inv[0] = item.func_77946_l();
            ReikaSoundHelper.playSoundAtBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (String)"random.pop");
            return null;
        }
        return item;
    }

    @Override
    public float getOperationFraction() {
        return this.progressFraction;
    }

    @Override
    public OperationInterval.OperationState getState() {
        return !this.symbolMap.isEmpty() && this.inv[0] != null && this.inv[1] == null ? (this.energy.containsAtLeast(required) ? OperationInterval.OperationState.RUNNING : OperationInterval.OperationState.PENDING) : OperationInterval.OperationState.INVALID;
    }

    @Override
    protected boolean canReceiveFrom(CrystalElement e, ForgeDirection dir) {
        return this.isAcceptingColor(e) && dir != ForgeDirection.DOWN;
    }

    @Override
    public ElementTagCompound getRequiredEnergy() {
        return required;
    }

    @Override
    public boolean isAcceptingColor(CrystalElement e) {
        return required.contains(e);
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 2000;
    }

    public boolean hasWork() {
        return this.getState() == OperationInterval.OperationState.RUNNING;
    }

    static {
        required = new ElementTagCompound();
        required.addTag(CrystalElement.LIGHTGRAY, 20);
        required.addTag(CrystalElement.GRAY, 10);
        required.addTag(CrystalElement.BROWN, 10);
    }
}

