/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface;

import Reika.ChromatiCraft.Auxiliary.RangeTracker;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockVector;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.ParticlePath;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaLiquidRenderer;
import Reika.DragonAPI.ModInteract.DeepInteract.TinkerSmelteryHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerToolHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntitySmelteryDistributor
extends TileEntityChromaticBase {
    public static final int SCAN_RADIUS_XZ = 16;
    private final RangeTracker range = new RangeTracker(16);
    private final StepTimer cacheTimer = new StepTimer(40);
    private final StepTimer operationTimer = new StepTimer(5);
    private final ArrayList<SmelteryDrain> drains = new ArrayList();
    private final ArrayList<CastingBlock> targets = new ArrayList();
    private double rotation;
    private double rotationSpeed;
    private double MAX_ROTATION_SPEED = 3.5;
    private float colorIntensity = 1.0f;

    private void sendFluid(Fluid f, ForgeDirection dir, Coordinate drain, Coordinate target) {
        int x = drain.xCoord;
        int y = drain.yCoord;
        int z = drain.zCoord;
        int x2 = target.xCoord;
        int y2 = target.yCoord;
        int z2 = target.zCoord;
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.SMELTERYFLUIDSEND.ordinal(), (TileEntity)this, (int)48, (int[])new int[]{x, y, z, x2, y2, z2, dir.ordinal(), f.getID()});
        ChromaSounds.FIRE.playSoundAtBlock((TileEntity)this, 0.7f, 2.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void sendFluidToClient(int x, int y, int z, int x2, int y2, int z2, ForgeDirection drainFace, Fluid f) {
        ParticlePath p = ParticlePath.getPath((World)this.field_145850_b, (BlockVector)new BlockVector(x, y, z, drainFace), (BlockVector)new BlockVector(x2, y2 + 1, z2, ForgeDirection.UP), (double)0.5, (double)0.5);
        List path = p.getPath();
        for (int i = 0; i < path.size(); ++i) {
            DecimalPosition pos = (DecimalPosition)path.get(i);
            double f2a = (double)(i + 1) / (double)path.size();
            double f2b = 1.0 - f2a;
            double f2 = 2.0 * Math.min(f2a, f2b);
            int l = (int)(90.0 * f2);
            float s = 0.75f + (float)(1.25 * f2);
            IIcon ico = ReikaLiquidRenderer.getFluidIconSafe((Fluid)f);
            EntityBlurFX fx = new EntityCCBlurFX(this.field_145850_b, pos.xCoord, pos.yCoord, pos.zCoord).setIcon(ico).setLife(l).setScale(s).setRapidExpand().setAlphaFading().setBasicBlend();
            fx.field_70145_X = true;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.SMELTERYDISTRIBUTOR;
    }

    public double getRotation() {
        return this.rotation;
    }

    public float getColorIntensity() {
        return this.colorIntensity;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        boolean active;
        boolean bl = active = !this.hasRedstoneSignal();
        if (world.field_72995_K) {
            this.rotation += this.rotationSpeed;
            if (active) {
                this.doParticles(world, x, y, z);
                double d = Math.max(1.0, 3.0 - (double)this.getTicksExisted() / 32.0);
                this.rotationSpeed = Math.min(this.rotationSpeed + 0.1 * d * d, this.MAX_ROTATION_SPEED * d);
                this.colorIntensity = Math.min(1.0f, this.colorIntensity * 1.05f + 0.05f);
            } else {
                this.rotationSpeed = Math.max(this.rotationSpeed - 0.08, 0.0);
                this.colorIntensity = (float)((double)this.colorIntensity * 0.9);
            }
        } else {
            this.cacheTimer.setCap(this.drains.isEmpty() || this.targets.isEmpty() ? 40 : 160);
            this.cacheTimer.update();
            this.operationTimer.update();
            if (this.cacheTimer.checkCap() || this.getTicksExisted() == 0) {
                this.findDrainsAndTargets(world, x, y, z);
            }
            if (active && !this.drains.isEmpty() && this.operationTimer.checkCap()) {
                SmelteryDrain sd = (SmelteryDrain)ReikaJavaLibrary.getRandomListEntry((Random)rand, this.drains);
                if (sd.isValid(world)) {
                    FluidStack fs = this.getTransferrableFluid(world, sd);
                    if (fs != null) {
                        for (CastingBlock cb : this.targets) {
                            cb.update(world);
                        }
                        Collections.sort(this.targets);
                        CastingBlock cb = this.getFirstValidTarget(world, fs);
                        if (cb != null) {
                            this.doTransfer(world, sd, cb, fs.getFluid());
                        }
                    }
                } else {
                    this.drains.remove(sd);
                }
            }
        }
    }

    private void findDrainsAndTargets(World world, int x, int y, int z) {
        this.drains.clear();
        this.targets.clear();
        int r = this.range.getRange();
        int r2 = r / 2;
        for (int i = -r; i <= r; ++i) {
            for (int k = -r; k <= r; ++k) {
                for (int j = -r2; j <= 0; ++j) {
                    TileEntity te = world.func_147438_o(x + i, y + j, z + k);
                    if (te == null) continue;
                    if (te.getClass() == TinkerSmelteryHandler.drainClass()) {
                        this.drains.add(new SmelteryDrain(te));
                        continue;
                    }
                    if (te.getClass() != TinkerSmelteryHandler.basinClass() && (te.getClass() != TinkerSmelteryHandler.tableClass() || this.isPartmaker(te))) continue;
                    this.targets.add(new CastingBlock(te));
                }
            }
        }
    }

    private boolean isPartmaker(TileEntity te) {
        for (int y = te.field_145848_d + 1; y <= te.field_145848_d + 4; ++y) {
            TileEntity at = te.field_145850_b.func_147438_o(te.field_145851_c, y, te.field_145849_e);
            if (at == null || at.getClass() != TinkerSmelteryHandler.faucetClass()) continue;
            return true;
        }
        return false;
    }

    private FluidStack getTransferrableFluid(World world, SmelteryDrain sd) {
        IFluidHandler te = (IFluidHandler)sd.location.getTileEntity((IBlockAccess)world);
        return te.drain(sd.facing, Integer.MAX_VALUE, false);
    }

    private CastingBlock getFirstValidTarget(World world, FluidStack fs) {
        Iterator<CastingBlock> it = this.targets.iterator();
        while (it.hasNext()) {
            CastingBlock cb = it.next();
            if (cb.isValid(world)) {
                IFluidHandler te;
                int space;
                int capacity = cb.getCapacity(world, fs.getFluid());
                if (capacity <= 0 || capacity > fs.amount || (space = (te = cb.getTile(world)).fill(ForgeDirection.UP, fs, false)) < capacity) continue;
                return cb;
            }
            it.remove();
        }
        return null;
    }

    private void doTransfer(World world, SmelteryDrain sd, CastingBlock cb, Fluid f) {
        IFluidHandler te = cb.getTile(world);
        int amt = cb.getCapacity(world, f);
        FluidStack out = sd.drain(world, f, amt);
        if (out != null && out.amount > 0 && te.fill(ForgeDirection.DOWN, new FluidStack(f, out.amount), true) > 0) {
            this.sendFluid(f, sd.facing, sd.location, cb.location);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        if (rand.nextInt(3) == 0) {
            double px = (double)x + 0.5;
            double py = (double)y + 0.5;
            double pz = (double)z + 0.5;
            int l = 20 + rand.nextInt(60);
            float g = -((float)ReikaRandomHelper.getRandomBetween((double)0.03125, (double)0.125));
            float s = 1.5f;
            double v = 0.0625;
            double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            double vy = ReikaRandomHelper.getRandomBetween((double)0.0, (double)(1.25 * (double)g));
            EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz, vx, vy, vz).setIcon(ChromaIcons.FADE_RAY).setColor(16754432).setLife(l).setScale(s).setGravity(g).setRapidExpand();
            EntityBlurFX fx2 = new EntityCCBlurFX(world, px, py, pz, vx, vy, vz).setColor(0xFFFFFF).setLife(l).setScale(s / 2.5f).setGravity(g).setRapidExpand();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    private static class CastingBlock
    implements Comparable<CastingBlock> {
        private final Coordinate location;
        private final boolean isBasin;
        private boolean isOutputFull;
        private boolean hasCast;
        private boolean hasNonIngotCast;

        private CastingBlock(TileEntity te) {
            this.location = new Coordinate(te);
            this.isBasin = te.getClass() == TinkerSmelteryHandler.basinClass();
        }

        public int getCapacity(World world, Fluid f) {
            return this.getTile(world).fill(ForgeDirection.UP, new FluidStack(f, Integer.MAX_VALUE), false);
        }

        public IFluidHandler getTile(World world) {
            return (IFluidHandler)this.location.getTileEntity((IBlockAccess)world);
        }

        private void update(World world) {
            IInventory ii = (IInventory)this.location.getTileEntity((IBlockAccess)world);
            this.isOutputFull = ii.func_70301_a(1) != null;
            this.hasCast = ii.func_70301_a(0) != null;
            this.hasNonIngotCast = this.hasCast && !ReikaItemHelper.matchStacks((ItemStack)ii.func_70301_a(0), (ItemStack)TinkerToolHandler.getInstance().getIngotCast());
        }

        public boolean isValid(World world) {
            TileEntity te = this.location.getTileEntity((IBlockAccess)world);
            return te != null && (te.getClass() == TinkerSmelteryHandler.basinClass() || te.getClass() == TinkerSmelteryHandler.tableClass());
        }

        @Override
        public int compareTo(CastingBlock o) {
            return Integer.compare(o.getPriority(), this.getPriority());
        }

        private int getPriority() {
            if (this.isOutputFull) {
                return -1000;
            }
            if (this.isBasin) {
                return 100;
            }
            if (this.hasNonIngotCast) {
                return 500;
            }
            if (this.hasCast) {
                return 50;
            }
            return 0;
        }
    }

    private static final class SmelteryDrain {
        private final Coordinate location;
        private final ForgeDirection facing;

        private SmelteryDrain(TileEntity te) {
            this.location = new Coordinate(te);
            this.facing = TinkerSmelteryHandler.getDrainDirection((TileEntity)te);
        }

        public FluidStack drain(World world, Fluid f, int amt) {
            return this.getTile(world).drain(this.facing, new FluidStack(f, amt), true);
        }

        public boolean isValid(World world) {
            TileEntity te = this.location.getTileEntity((IBlockAccess)world);
            return te != null && te.getClass() == TinkerSmelteryHandler.drainClass();
        }

        public IFluidHandler getTile(World world) {
            return (IFluidHandler)this.location.getTileEntity((IBlockAccess)world);
        }
    }
}

