/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.VoidRitual;

import Reika.ChromatiCraft.Auxiliary.ChromaAux;
import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.Interfaces.Linkable;
import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedCrystalReceiver;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.ModInterface.VoidRitual.VoidMonsterDestructionRitual;
import Reika.ChromatiCraft.ModInterface.VoidRitual.VoidMonsterNetherStructure;
import Reika.ChromatiCraft.ModInterface.VoidRitual.VoidMonsterRitualStructure;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.TileEntity.TileEntityLumenWire;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Auxiliary.ChunkManager;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.ThreadSafeTileCache;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Math.Spline;
import Reika.DragonAPI.Instantiable.Math.VariableEndpointSpline;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Interfaces.TileEntity.ChunkLoadingTile;
import Reika.DragonAPI.Interfaces.TileEntity.InertIInv;
import Reika.DragonAPI.Interfaces.TileEntity.LocationCached;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.ModList;
import Reika.VoidMonster.API.MonsterAPI;
import Reika.VoidMonster.Entity.EntityVoidMonster;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TileEntityVoidMonsterTrap
extends InventoriedCrystalReceiver
implements MultiBlockChromaTile,
TileEntityLumenWire.WireWatcher,
LocationCached,
Linkable,
ChunkLoadingTile,
BreakAction,
InertIInv {
    private static final ElementTagCompound required = new ElementTagCompound();
    private static final ThreadSafeTileCache cache = new ThreadSafeTileCache().setTileClass(TileEntityVoidMonsterTrap.class);
    private static final int RING_DURATION = 400;
    private Collection<Coordinate> wires;
    private ArrayList<Coordinate> wireSeek = new ArrayList();
    private ArrayList<Coordinate> explosionSeek = new ArrayList();
    private ConcurrentHashMap<Integer, VoidMonsterTether> tethers = new ConcurrentHashMap();
    private float flashFactor = 0.0f;
    private float shaderRotation = 0.0f;
    private float shaderRotationSpeed = 0.0f;
    private int outerRingActivation = 0;
    private int innerRingActivation = 0;
    private boolean hasStructure;
    private WorldLocation link;
    private VoidMonsterDestructionRitual ritual;

    public static ElementTagCompound getRequiredEnergy() {
        return required.copy();
    }

    public void activateOuterRing() {
        this.outerRingActivation = 400;
    }

    public void activateInnerRing() {
        if (this.outerRingActivation > 0) {
            this.outerRingActivation = 400;
            this.innerRingActivation = 400;
        }
    }

    @Override
    public void validateStructure() {
        ChromaStructures s = this.getPrimaryStructure();
        s.getStructure().resetToDefaults();
        this.hasStructure = s.getArray(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).matchInWorld();
    }

    public boolean canAttractMonster() {
        return this.hasStructure && (this.link != null || !this.isNether()) && !this.isActive();
    }

    public boolean isNether() {
        return this.field_145850_b != null && this.field_145850_b.field_73011_w.field_76574_g == -1;
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        if (this.isNether()) {
            this.explosionSeek.addAll(VoidMonsterNetherStructure.getTNTLocations());
        } else {
            this.wires = VoidMonsterRitualStructure.getWireLocations();
            this.wireSeek.addAll(this.wires);
        }
        WorldLocation loc = new WorldLocation((TileEntity)this);
        if (!cache.contains((Object)loc)) {
            cache.add((Object)loc);
        }
        this.validateStructure();
        ChunkManager.instance.loadChunks((ChunkLoadingTile)this);
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
        ChunkManager.instance.unloadChunks((TileEntity)this);
    }

    public Collection<ChunkCoordIntPair> getChunksToLoad() {
        return ChunkManager.getChunkSquare((int)this.field_145851_c, (int)this.field_145848_d, (int)2);
    }

    public void breakBlock() {
        WorldLocation loc = new WorldLocation((TileEntity)this);
        cache.remove((Object)loc);
        if (this.ritual != null) {
            this.ritual.onPrematureTermination();
            this.ritual = null;
        }
        this.resetOther();
        this.reset();
    }

    private void checkAndRequest() {
        for (CrystalElement e : required.elementSet()) {
            int amt = this.getRemainingSpace(e);
            if (amt <= 0) continue;
            boolean bl = this.requestEnergy(e, amt);
        }
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        block13: {
            block11: {
                double dist;
                EntityLiving e;
                int idx;
                Coordinate c;
                block12: {
                    super.updateEntity(world, x, y, z, meta);
                    if (!world.field_72995_K && this.hasStructure() && this.getCooldown() == 0 && this.checkTimer.checkCap()) {
                        this.checkAndRequest();
                    }
                    if (!world.field_72995_K && !this.hasStructure && this.getTicksExisted() < 5) {
                        this.validateStructure();
                    }
                    if (world.field_72995_K) break block11;
                    if (this.inv[0] == null || this.inv[0].field_77994_a < this.func_70297_j_()) {
                        this.searchForItems(world, x, y, z);
                    }
                    if (this.explosionSeek.size() < 4) {
                        this.hasStructure = false;
                        this.explosionSeek.clear();
                        this.explosionSeek.addAll(VoidMonsterNetherStructure.getTNTLocations());
                    }
                    if (!this.isNether()) break block12;
                    if (this.canAttractMonster()) {
                        this.attractMonster(world, x, y, z);
                    }
                    break block13;
                }
                if (!this.wireSeek.isEmpty() && (c = this.wireSeek.get(idx = rand.nextInt(this.wireSeek.size()))).getBlock((IBlockAccess)world) == ChromaTiles.LUMENWIRE.getBlock() && c.getBlockMetadata((IBlockAccess)world) == ChromaTiles.LUMENWIRE.getBlockMetadata()) {
                    TileEntityLumenWire te = (TileEntityLumenWire)c.getTileEntity((IBlockAccess)world);
                    te.addWatcher(this);
                }
                if ((e = this.getMonster(world, x, y, z)) == null || !ReikaItemHelper.matchStacks((ItemStack)this.inv[0], (ItemStack)ChromaStacks.voidmonsterEssence) || !this.energy.containsAtLeast(required)) break block13;
                if (this.isActive()) {
                    if (this.ritual.tick()) {
                        this.ritual.onCompletion();
                        this.ritual = null;
                    }
                } else if (this.canAttractMonster() && (dist = this.attractMonster(world, x, y, z)) < 1.0) {
                    this.activate(world, x, y, z, e);
                }
                this.drainEnergy(required);
                if (rand.nextInt(this.isActive() ? 20 : 60) != 0) break block13;
                ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
                break block13;
            }
            for (VoidMonsterTether t : this.tethers.values()) {
                if (!t.tick(world)) continue;
                this.removeTether(t, world);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void doEatFX(World world, int x, int y, int z) {
        for (int i = 0; i < 20; ++i) {
            int l = 20 + rand.nextInt(60);
            float s = 1.5f + rand.nextFloat() * 2.5f;
            int c1 = 0xDF3FFF;
            int c2 = 0x202020;
            double dx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)0.25);
            double dz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)0.25);
            double dy = (double)y + rand.nextDouble();
            float f = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.6, (double)0.2);
            double vel = ReikaRandomHelper.getRandomBetween((double)0.0625, (double)0.25);
            double[] v = ReikaPhysicsHelper.polarToCartesian((double)vel, (double)(rand.nextDouble() * 360.0), (double)(rand.nextDouble() * 360.0));
            EntityBlurFX fx1 = new EntityCCBlurFX(world, dx, dy, dz, v[0], v[1], v[2]).setIcon(ChromaIcons.TRANSFADE).setScale(s).setLife(l).setColor(c1).setBasicBlend();
            EntityBlurFX fx2 = new EntityCCBlurFX(world, dx, dy, dz, v[0], v[1], v[2]).setIcon(ChromaIcons.TRANSFADE).setScale(s * f).setLife(l).setColor(c2).setBasicBlend().lockTo((EntityFX)fx1);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx1);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        }
    }

    private void searchForItems(World world, int x, int y, int z) {
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b(8.0, 5.0, 8.0);
        List li = world.func_82733_a(EntityItem.class, box, (IEntitySelector)new ReikaEntityHelper.SpecificItemSelector(ChromaStacks.voidmonsterEssence));
        double v = 2.5;
        for (EntityItem ent : li) {
            if (ent.field_70173_aa <= 5) continue;
            double dx = (double)x + 0.5 - ent.field_70165_t;
            double dy = (double)y + 0.5 - ent.field_70163_u;
            double dz = (double)z + 0.5 - ent.field_70161_v;
            double ddt = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
            if (ddt < 0.5) {
                ItemStack is = ent.func_92059_d();
                ItemStack is2 = ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)1);
                if (!ReikaInventoryHelper.addOrSetStack((ItemStack)is2, (ItemStack[])this.inv, (int)0)) continue;
                --is.field_77994_a;
                if (is.field_77994_a <= 0) {
                    ent.func_70106_y();
                } else {
                    ent.func_92058_a(is);
                }
                ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.VOIDTRAPEAT.ordinal(), (TileEntity)this, (int)32, (int[])new int[0]);
                ChromaSounds.BOUNCE.playSoundAtBlock((TileEntity)this, 1.0f, 2.0f);
                continue;
            }
            double vx = v * dx / ddt;
            double vy = v * dy / ddt;
            double vz = v * dz / ddt;
            double vmax = 0.0625;
            double f = Math.min(1.0, (double)ent.field_70173_aa / 80.0);
            vx = MathHelper.func_151237_a((double)vx, (double)(-vmax), (double)vmax);
            vy = MathHelper.func_151237_a((double)vy, (double)(-vmax), (double)vmax);
            vz = MathHelper.func_151237_a((double)vz, (double)(-vmax), (double)vmax);
            ent.field_70159_w = ent.field_70159_w * (1.0 - f) + vx * f;
            ent.field_70181_x = ent.field_70181_x * (1.0 - f) + vy * f;
            ent.field_70179_y = ent.field_70179_y * (1.0 - f) + vz * f;
            if (ent.field_70163_u < (double)y) {
                ent.field_70181_x += 0.125;
            }
            if (world.field_72995_K) continue;
            ent.field_70133_I = true;
        }
    }

    private EntityLiving getMonster(World world, int x, int y, int z) {
        return this.ritual != null ? this.ritual.getEntity() : MonsterAPI.getNearestMonster((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5));
    }

    private void activate(World world, int x, int y, int z, EntityLiving e) {
        this.ritual = new VoidMonsterDestructionRitual(this, e);
        ReikaJavaLibrary.pConsole((Object)("Activating ritual with " + this + " " + e));
    }

    @DependentMethodStripper.ModDependent(value={ModList.VOIDMONSTER})
    private double attractMonster(World world, int x, int y, int z) {
        EntityVoidMonster e = (EntityVoidMonster)this.getMonster(world, x, y, z);
        if (e == null) {
            return Double.POSITIVE_INFINITY;
        }
        VoidMonsterTether t = this.getOrCreateTether((Entity)e);
        double dist = e.func_70092_e((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        if (this.isNether()) {
            if (dist > 256.0) {
                this.removeTether(t, world);
                return dist;
            }
            t.setDistance(e.moveTowards((double)x + 0.5, (double)y - 0.5, (double)z + 0.5, Math.min(1.0, 20.0 / dist)));
            return t.distance;
        }
        if (dist > 64.0) {
            this.removeTether(t, world);
            return dist;
        }
        double s = 1.5;
        t.setDistance(e.moveTowards((double)x + 0.5, (double)y - 0.5, (double)z + 0.5, s * Math.min(1.0, 20.0 / dist)));
        return t.distance;
    }

    private void removeTether(VoidMonsterTether t, World world) {
        this.tethers.remove(t.ID);
        Entity e = t.getEntity(world);
        if (e != null) {
            // empty if block
        }
    }

    private VoidMonsterTether getOrCreateTether(Entity e) {
        VoidMonsterTether t = this.tethers.get(e.func_145782_y());
        if (t == null) {
            t = new VoidMonsterTether((TileEntity)this, e);
            this.tethers.put(t.ID, t);
            this.syncAllData(true);
        }
        return t;
    }

    public Collection<VoidMonsterTether> getTethers() {
        return Collections.unmodifiableCollection(this.tethers.values());
    }

    @DependentMethodStripper.ModDependent(value={ModList.VOIDMONSTER})
    private void triggerTeleport() {
        EntityVoidMonster e = (EntityVoidMonster)MonsterAPI.getNearestMonster((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5));
        if (e == null) {
            return;
        }
        e.forcePersist = true;
        e.field_98038_p = true;
        MonsterTeleporter tel = new MonsterTeleporter((WorldServer)this.link.getWorld(), this.link, 24.0, 60.0, 6.0);
        ReikaEntityHelper.transferEntityToDimension((Entity)e, (int)this.link.dimensionID, (Teleporter)tel);
        this.field_145850_b.func_72885_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d - 0.5, (double)this.field_145849_e + 0.5, 9.0f, true, true);
        this.delete();
    }

    protected void animateWithTick(World world, int x, int y, int z) {
        if (world != null && world.field_72995_K) {
            if (this.flashFactor > 0.0f) {
                this.flashFactor = Math.max(this.flashFactor * 0.92f - 0.09f, 0.0f);
            } else if (rand.nextInt(70) == 0) {
                this.flashFactor = 2.0f;
            }
            if (this.shaderRotationSpeed > 0.0f) {
                boolean flag = this.shaderRotation < 0.0f;
                this.shaderRotation += this.shaderRotationSpeed;
                if (this.shaderRotation >= 1.0f) {
                    this.shaderRotation = -1.0f;
                } else if (flag && this.shaderRotation >= 0.0f) {
                    this.shaderRotation = 0.0f;
                    this.shaderRotationSpeed = 0.0f;
                }
            } else if (rand.nextInt(40) == 0) {
                this.shaderRotationSpeed = 0.0625f + rand.nextFloat() * 0.0625f;
            }
        }
    }

    public float getFlashBrightness() {
        if (this.flashFactor <= 0.0f || this.flashFactor > 2.0f) {
            return 0.0f;
        }
        return this.flashFactor <= 1.0f ? this.flashFactor : 2.0f - this.flashFactor;
    }

    public float getShaderRotation() {
        return this.shaderRotation;
    }

    public boolean isActive() {
        return this.ritual != null;
    }

    public int func_70302_i_() {
        return 1;
    }

    public int func_70297_j_() {
        return ChromaStacks.voidmonsterEssence.func_77976_d();
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return false;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.VOIDTRAP;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b(2.0, 2.0, 2.0);
    }

    @Override
    public void onToggle(Coordinate wire, boolean active) {
        if (wire.yCoord == this.field_145848_d - 1) {
            this.activateInnerRing();
        } else {
            this.activateOuterRing();
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.hasStructure = NBT.func_74767_n("struct");
        NBTTagList li = NBT.func_150295_c("tethers", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            VoidMonsterTether t = VoidMonsterTether.readFromNBT((NBTTagCompound)o);
            VoidMonsterTether has = this.tethers.get(t.ID);
            if (has == null) {
                this.tethers.put(t.ID, t);
                continue;
            }
            has.copyFrom(t);
        }
        this.link = NBT.func_74764_b("link") ? WorldLocation.readFromNBT((String)"link", (NBTTagCompound)NBT) : null;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("struct", this.hasStructure);
        NBTTagList li = new NBTTagList();
        for (Map.Entry<Integer, VoidMonsterTether> e : this.tethers.entrySet()) {
            li.func_74742_a((NBTBase)e.getValue().writeToNBT());
        }
        NBT.func_74782_a("tethers", (NBTBase)li);
        if (this.link != null) {
            this.link.writeToNBT("link", NBT);
        }
    }

    public int getPacketDelay() {
        int base = super.getPacketDelay();
        return this.tethers.isEmpty() ? base : base / 2;
    }

    public boolean hasStructure() {
        return this.hasStructure;
    }

    @Override
    public ChromaStructures getPrimaryStructure() {
        return this.isNether() ? ChromaStructures.NETHERTRAP : ChromaStructures.VOIDRITUAL;
    }

    @Override
    public Coordinate getStructureOffset() {
        return null;
    }

    @Override
    public boolean canStructureBeInspected() {
        return true;
    }

    public static boolean handleTNTTrigger(World world, Entity e) {
        return cache.lookForMatch(world, true, (loc, te) -> ((TileEntityVoidMonsterTrap)te).handleTNTTrigger(e), (loc, te) -> ChromaAux.logTileCacheError(world, loc, te, ChromaTiles.VOIDTRAP));
    }

    private boolean handleTNTTrigger(Entity e) {
        Coordinate c;
        if (this.isNether() && (this.hasStructure || this.explosionSeek.size() < 4) && this.link != null && ModList.VOIDMONSTER.isLoaded() && this.explosionSeek.contains(c = new Coordinate(e).offset(-this.field_145851_c + 2, -this.field_145848_d + 6, -this.field_145849_e + 2))) {
            this.explosionSeek.remove(c);
            this.hasStructure = false;
            if (this.explosionSeek.isEmpty()) {
                this.triggerTeleport();
            }
            return true;
        }
        return false;
    }

    public static void clearCache() {
        cache.clear();
    }

    public void reset() {
        this.link = null;
    }

    public void resetOther() {
        if (this.link == null) {
            return;
        }
        TileEntity te = this.link.getTileEntity();
        if (te instanceof Linkable) {
            ((Linkable)te).reset();
        }
    }

    public boolean tryConnect(World world, int x, int y, int z) {
        if (ChromaTiles.getTile((IBlockAccess)world, x, y, z) == this.getTile()) {
            TileEntityVoidMonsterTrap te = (TileEntityVoidMonsterTrap)world.func_147438_o(x, y, z);
            te.link = new WorldLocation((TileEntity)this);
            this.link = new WorldLocation((TileEntity)te);
            return true;
        }
        return false;
    }

    public boolean isEmitting() {
        return true;
    }

    public WorldLocation getConnection() {
        return this.link;
    }

    public boolean hasValidConnection() {
        return this.link != null && this.link.getTileEntity() instanceof TileEntityVoidMonsterTrap;
    }

    @Override
    public int getReceiveRange() {
        return 24;
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return required.contains(e);
    }

    @Override
    public int maxThroughput() {
        return 100;
    }

    @Override
    public boolean canConduct() {
        return this.hasStructure;
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return required.getValue(e) * 600;
    }

    static {
        required.addTag(CrystalElement.BLACK, 5);
        required.addTag(CrystalElement.PINK, 20);
        required.addTag(CrystalElement.LIGHTGRAY, 4);
        required.addTag(CrystalElement.GRAY, 1);
        required.addTag(CrystalElement.WHITE, 10);
        required.addTag(CrystalElement.MAGENTA, 2);
    }

    public static class VoidMonsterTether {
        public final int ID;
        public final Coordinate location;
        private double distance;
        private final VariableEndpointSpline[] splines = new VariableEndpointSpline[3];

        VoidMonsterTether(TileEntity te, Entity e) {
            this(new Coordinate(te), e.func_145782_y(), new DecimalPosition(e));
        }

        private VoidMonsterTether(Coordinate c, int id, DecimalPosition p2) {
            this.location = c;
            this.ID = id;
            for (int i = 0; i < this.splines.length; ++i) {
                this.splines[i] = new VariableEndpointSpline((double)c.xCoord + 0.5, (double)c.yCoord + 0.5, (double)c.zCoord + 0.5, p2.xCoord, p2.yCoord, p2.zCoord, Spline.SplineType.CENTRIPETAL, 6, 1.2, 0.125);
            }
        }

        public boolean tick(World world) {
            Entity e = this.getEntity(world);
            if (e == null) {
                return true;
            }
            for (int i = 0; i < this.splines.length; ++i) {
                this.splines[i].setEndpoint(e.field_70165_t, e.field_70163_u + (double)(e.field_70131_O / 2.0f), e.field_70161_v);
                this.splines[i].tick();
            }
            return false;
        }

        public void copyFrom(VoidMonsterTether t) {
            this.distance = t.distance;
        }

        public Collection<VariableEndpointSpline> getSplines() {
            return Arrays.asList(this.splines);
        }

        private void setDistance(double d) {
            this.distance = d;
        }

        public double getDistance() {
            return this.distance;
        }

        public Entity getEntity(World world) {
            return world.func_73045_a(this.ID);
        }

        private NBTTagCompound writeToNBT() {
            NBTTagCompound ret = new NBTTagCompound();
            ret.func_74768_a("id", this.ID);
            ret.func_74780_a("dist", this.distance);
            this.location.writeToTag(ret);
            return ret;
        }

        private static VoidMonsterTether readFromNBT(NBTTagCompound tag) {
            VoidMonsterTether ret = new VoidMonsterTether(Coordinate.readTag((NBTTagCompound)tag), tag.func_74762_e("id"), new DecimalPosition(0.0, 0.0, 0.0));
            ret.distance = tag.func_74769_h("dist");
            return ret;
        }
    }

    private static class MonsterTeleporter
    extends Teleporter {
        private final WorldLocation target;
        private final double minFuzzRadius;
        private final double maxFuzzRadius;
        private final double maxFuzzY;
        private final World world;

        public MonsterTeleporter(WorldServer world, WorldLocation loc, double r, double y) {
            this(world, loc, r, r, y);
        }

        public MonsterTeleporter(WorldServer world, WorldLocation loc, double r1, double r2, double y) {
            super(world);
            this.target = loc;
            this.world = world;
            this.minFuzzRadius = r1;
            this.maxFuzzRadius = r2;
            this.maxFuzzY = y;
        }

        public void func_77185_a(Entity e, double x, double y, double z, float facing) {
            double r = ReikaRandomHelper.getRandomBetween((double)this.minFuzzRadius, (double)this.maxFuzzRadius);
            double ang = Math.toRadians(rand.nextDouble() * 360.0);
            double dx = r * Math.cos(ang);
            double dz = r * Math.sin(ang);
            double dy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)this.maxFuzzY);
            double dr = 1.5;
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(dx - dr), (double)(dy - dr), (double)(dz - dr), (double)(dx + dr), (double)(dy + dr), (double)(dz + dr));
            while (!this.world.func_72945_a(e, box).isEmpty()) {
                r = ReikaRandomHelper.getRandomBetween((double)this.minFuzzRadius, (double)this.maxFuzzRadius);
                ang = Math.toRadians(rand.nextDouble() * 360.0);
                dx = r * Math.cos(ang);
                dz = r * Math.sin(ang);
                dy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)this.maxFuzzY);
            }
            e.func_70012_b((double)this.target.xCoord + 0.5 + dx, (double)this.target.yCoord + 0.5 + dy, (double)this.target.zCoord + 0.5 + dz, e.field_70177_z, e.field_70125_A);
            this.func_77184_b(e, x, y, z, facing);
        }

        public boolean func_77184_b(Entity entity, double x, double y, double z, float facing) {
            return true;
        }

        private void makeReturnPortal(World world, int x, int y, int z) {
        }

        public boolean func_85188_a(Entity e) {
            return false;
        }
    }
}

