/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.VoidRitual;

import Reika.ChromatiCraft.ModInterface.VoidRitual.TileEntityVoidMonsterTrap;
import Reika.ChromatiCraft.ModInterface.VoidRitual.VoidMonsterRitualClientEffects;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Auxiliary.Trackers.TickScheduler;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Event.ScheduledTickEvent;
import Reika.DragonAPI.Instantiable.Formula.MathExpression;
import Reika.DragonAPI.Instantiable.Formula.PeriodicExpression;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Instantiable.Interpolation;
import Reika.DragonAPI.Instantiable.ParticleController.CollectingPositionController;
import Reika.DragonAPI.Instantiable.ParticleController.FlashColorController;
import Reika.DragonAPI.Interfaces.ColorController;
import Reika.DragonAPI.Interfaces.PositionController;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.ModList;
import Reika.VoidMonster.Entity.EntityVoidMonster;
import Reika.VoidMonster.World.MonsterGenerator;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class VoidMonsterDestructionRitual {
    private final WorldLocation center;
    private final EntityPlayer startingPlayer;
    private final int monsterID;
    private final World world;
    private final int targetDuration;
    private final Interpolation healthCurve = new Interpolation(false);
    private int tick;
    private int effectCooldown = 0;
    private long lastWorldTick = -1L;
    private static final Random rand = new Random();
    private static final Collection<VoidMonsterDestructionRitual> activeRituals = new HashSet<VoidMonsterDestructionRitual>();
    private static final HashSet<Integer> ritualEntities = new HashSet();
    private static final int MIN_DURATION = 1200;
    private static final int MAX_DURATION = 3600;

    public VoidMonsterDestructionRitual(TileEntityVoidMonsterTrap loc, EntityLiving e) {
        this(new WorldLocation((TileEntity)loc), loc.getPlacer(), e);
    }

    private VoidMonsterDestructionRitual(WorldLocation loc, EntityPlayer ep, EntityLiving e) {
        this.startingPlayer = ep;
        this.center = loc;
        this.monsterID = e.func_145782_y();
        this.world = ep.field_70170_p;
        this.targetDuration = ReikaRandomHelper.getRandomBetween((int)1200, (int)3600);
        this.healthCurve.addPoint(0.0, 1.0);
        for (double d = 0.1; d < 1.0; d += 0.1) {
            double f = 1.0 - d;
            this.healthCurve.addPoint(ReikaRandomHelper.getRandomPlusMinus((double)d, (double)0.045) * (double)this.targetDuration, ReikaRandomHelper.getRandomPlusMinus((double)f, (double)0.2));
        }
        this.healthCurve.addPoint((double)this.targetDuration, 0.0);
    }

    public EntityLiving getEntity() {
        return (EntityLiving)this.world.func_73045_a(this.monsterID);
    }

    @DependentMethodStripper.ModDependent(value={ModList.VOIDMONSTER})
    public boolean tick() {
        if (this.world.func_82737_E() <= this.lastWorldTick) {
            return false;
        }
        this.lastWorldTick = this.world.func_82737_E();
        activeRituals.add(this);
        ++this.tick;
        if (this.effectCooldown > 0) {
            --this.effectCooldown;
        }
        EntityVoidMonster e = (EntityVoidMonster)this.getEntity();
        e.moveTowards((double)this.center.xCoord + 0.5, (double)this.center.yCoord + 0.5, (double)this.center.zCoord + 0.5, 2.0);
        if (this.effectCooldown == 0) {
            for (Effects ef : Effects.list) {
                if (rand.nextInt(ef.effectChance) != 0) continue;
                ef.doEffectServer(this, (EntityLiving)e);
                this.effectCooldown = ef.cooldown;
                break;
            }
        }
        return e.func_110143_aJ() <= 0.0f;
    }

    public static void sync() {
        ritualEntities.clear();
        for (VoidMonsterDestructionRitual v : activeRituals) {
            ritualEntities.add(v.monsterID);
        }
        NBTTagCompound NBT = new NBTTagCompound();
        ReikaNBTHelper.writeCollectionToNBT(ritualEntities, (NBTTagCompound)NBT, (String)"data");
        ReikaPacketHelper.sendNBTPacket((String)"ChromaData", (int)ChromaPackets.VOIDMONSTERRITUALSET.ordinal(), (NBTTagCompound)NBT, (PacketTarget)PacketTarget.allPlayers);
    }

    @DependentMethodStripper.ModDependent(value={ModList.VOIDMONSTER})
    void onPrematureTermination() {
        this.onEnd();
        EntityVoidMonster el = (EntityVoidMonster)this.getEntity();
        el.func_70691_i(6000.0f);
        el.func_70624_b((EntityLivingBase)this.startingPlayer);
        el.increaseDifficulty(2.0f);
    }

    @DependentMethodStripper.ModDependent(value={ModList.VOIDMONSTER})
    void onCompletion() {
        MonsterGenerator.instance.addCooldown(this.getEntity(), 1200 * ReikaRandomHelper.getRandomBetween((int)20, (int)45));
        this.onEnd();
    }

    private void onEnd() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            for (Effects ef : Effects.list) {
                ef.visuals.clearShader();
            }
        } else {
            activeRituals.remove(this);
            VoidMonsterDestructionRitual.sync();
        }
    }

    public float getCurrentTargetHealthFraction() {
        return (float)this.healthCurve.getValue((double)this.tick);
    }

    @SideOnly(value=Side.CLIENT)
    public static void readSync(NBTTagCompound tag) {
        ritualEntities.clear();
        if (tag != null) {
            ReikaNBTHelper.readCollectionFromNBT(ritualEntities, (NBTTagCompound)tag, (String)"data");
        }
    }

    public static boolean ritualsActive() {
        return !ritualEntities.isEmpty();
    }

    public static boolean isFocusOfActiveRitual(Entity e) {
        return ritualEntities.contains(e.func_145782_y());
    }

    @SideOnly(value=Side.CLIENT)
    @DependentMethodStripper.ModDependent(value={ModList.VOIDMONSTER})
    public static void handlePacket(int entity, int effect) {
        Entity e = Minecraft.func_71410_x().field_71441_e.func_73045_a(entity);
        Effects.list[effect].doEffectClient((EntityLiving)e);
    }

    private static void runAttack(EntityLiving e, DamageSource src, int amt) {
        if ((float)amt >= e.func_110143_aJ()) {
            e.func_70606_j(0.1f);
            e.func_70097_a(src, 1.0f);
        } else {
            e.func_70606_j(e.func_110143_aJ() - (float)amt + 1.0f);
            e.func_70097_a(src, 1.0f);
        }
    }

    public static class VoidMonsterRitualDamage
    extends DamageSource {
        private final EntityPlayer player;

        public VoidMonsterRitualDamage(EntityPlayer ep) {
            super("voidmonster.ritual");
            this.player = ep;
        }

        public Entity func_76346_g() {
            return this.player;
        }

        public boolean func_82725_o() {
            return true;
        }
    }

    private static class ScheduledDamage
    implements ScheduledTickEvent.ScheduledEvent {
        private final EntityLiving entity;
        private final DamageSource source;
        private final int amount;

        public ScheduledDamage(EntityLiving e, DamageSource src, int amt) {
            this.entity = e;
            this.source = src;
            this.amount = amt;
        }

        public void fire() {
            VoidMonsterDestructionRitual.runAttack(this.entity, this.source, this.amount);
        }

        public boolean runOnSide(Side s) {
            return s == Side.SERVER;
        }
    }

    public static enum Effects {
        COLLAPSING_SPHERE(70, 20, 40),
        RAYS(40, 40, 20),
        EXPLOSION(200, 0, 20),
        WAVE(400, 20, 120),
        CURL(400, 40, 30, 100),
        STRETCH(400, 30, 20, 160);

        private final int effectChance;
        private final int damageAmount;
        private final int damageDelay;
        private final int cooldown;
        @SideOnly(value=Side.CLIENT)
        public VoidMonsterRitualClientEffects.EffectVisual visuals;
        static Effects[] list;

        private Effects(int c, int dmg, int cl) {
            this(c, dmg, 0, cl);
        }

        private Effects(int c, int dmg, int del, int cl) {
            this.effectChance = c;
            this.cooldown = cl;
            this.damageAmount = dmg;
            this.damageDelay = del;
        }

        @DependentMethodStripper.ModDependent(value={ModList.VOIDMONSTER})
        public void doEffectServer(VoidMonsterDestructionRitual rit, EntityLiving e) {
            if (e.func_110143_aJ() / e.func_110138_aP() >= rit.getCurrentTargetHealthFraction()) {
                VoidMonsterRitualDamage src = new VoidMonsterRitualDamage(rit.startingPlayer);
                this.doAttack(e, src, this.damageAmount);
            }
            switch (this) {
                case COLLAPSING_SPHERE: {
                    break;
                }
                case RAYS: {
                    break;
                }
                case EXPLOSION: {
                    e.field_70170_p.func_72885_a((Entity)e, e.field_70165_t, e.field_70163_u, e.field_70161_v, 9.0f, true, false);
                    break;
                }
                case WAVE: {
                    break;
                }
                case CURL: {
                    break;
                }
            }
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.VOIDMONSTERRITUAL.ordinal(), (PacketTarget)new PacketTarget.RadiusTarget((Entity)e, 128.0), (int[])new int[]{e.func_145782_y(), this.ordinal()});
        }

        private void doAttack(EntityLiving e, DamageSource src, int amt) {
            if (this.damageDelay > 0) {
                TickScheduler.instance.scheduleEvent(new ScheduledTickEvent((ScheduledTickEvent.ScheduledEvent)new ScheduledDamage(e, src, amt)), this.damageDelay);
            } else {
                VoidMonsterDestructionRitual.runAttack(e, src, amt);
            }
        }

        @SideOnly(value=Side.CLIENT)
        @DependentMethodStripper.ModDependent(value={ModList.VOIDMONSTER})
        public void doEffectClient(EntityLiving e) {
            float f = 1.0f;
            double ex = e.field_70165_t;
            double ey = e.field_70163_u + 1.0;
            double ez = e.field_70161_v;
            if (this.visuals != null) {
                this.visuals.activate(e);
            }
            switch (this) {
                case COLLAPSING_SPHERE: {
                    for (int i = 0; i < 128; ++i) {
                        double a1 = rand.nextDouble() * 360.0;
                        double a2 = rand.nextDouble() * 360.0;
                        double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)(4.0 + rand.nextDouble() * 0.25), (double)a1, (double)a2);
                        double px = ex + xyz[0];
                        double py = ey + xyz[1];
                        double pz = ez + xyz[2];
                        EntityBlurFX fx = new EntityCCBlurFX(e.field_70170_p, px, py, pz).setAlphaFading();
                        int t = ReikaRandomHelper.getRandomBetween((int)5, (int)8);
                        fx.setPositionController((PositionController)new CollectingPositionController(px, py, pz, ex, ey, ez, t));
                        fx.setLife(t + 1).setScale(1.0f + rand.nextFloat() * 0.5f);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    }
                    break;
                }
                case RAYS: {
                    for (int k = 0; k < 9; ++k) {
                        double a1 = rand.nextDouble() * 360.0;
                        double a2 = rand.nextDouble() * 360.0;
                        for (int i = 0; i < 128; ++i) {
                            double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)(rand.nextDouble() * 96.0), (double)a1, (double)a2);
                            double px = ex + xyz[0];
                            double py = ey + xyz[1];
                            double pz = ez + xyz[2];
                            px = ReikaRandomHelper.getRandomPlusMinus((double)px, (double)0.125);
                            py = ReikaRandomHelper.getRandomPlusMinus((double)py, (double)0.125);
                            pz = ReikaRandomHelper.getRandomPlusMinus((double)pz, (double)0.125);
                            EntityBlurFX fx = new EntityCCBlurFX(e.field_70170_p, px, py, pz).setAlphaFading();
                            fx.setLife(40).setScale(1.5f + rand.nextFloat() * 1.5f);
                            double d = rand.nextDouble() * 360.0;
                            PeriodicExpression exp = new PeriodicExpression().addWave(1.0, 1.0, d).addWave(0.5, 2.0, d + 90.0).addWave(0.125, 4.0, d).normalize();
                            fx.setColorController((ColorController)new FlashColorController((MathExpression)exp, 0xFFFFFF, 0));
                            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                        }
                    }
                    f = 0.5f;
                    break;
                }
                case EXPLOSION: {
                    break;
                }
                case WAVE: {
                    break;
                }
                case CURL: {
                    break;
                }
            }
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.FLAREATTACK, (Entity)e, (float)1.0f, (float)f, (boolean)false);
        }

        static {
            list = Effects.values();
        }
    }
}

