/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.VoidRitual;

import Reika.ChromatiCraft.ModInterface.VoidRitual.VoidMonsterDestructionRitual;
import Reika.ChromatiCraft.Registry.ChromaShaders;
import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.MathHelper;

@SideOnly(value=Side.CLIENT)
public class VoidMonsterRitualClientEffects
implements TickRegistry.TickHandler {
    public static final VoidMonsterRitualClientEffects instance = new VoidMonsterRitualClientEffects();
    private final HashSet<EffectVisual> active = new HashSet();

    private VoidMonsterRitualClientEffects() {
        new SphereVisual();
        new WaveVisual();
        new CurlVisual();
        new StretchVisual();
    }

    public void tick(TickRegistry.TickType type, Object ... tickData) {
        if (!this.active.isEmpty() && !Minecraft.func_71410_x().func_147113_T()) {
            Iterator<EffectVisual> it = this.active.iterator();
            while (it.hasNext()) {
                EffectVisual e = it.next();
                if (e.tick()) {
                    e.clearShader();
                    it.remove();
                    continue;
                }
                e.getShader().setIntensity(e.shaderIntensity);
                e.getShader().getShader().setFields(e.shaderData);
                e.getShader().getShader().updateEnabled();
            }
        }
    }

    public EnumSet<TickRegistry.TickType> getType() {
        return EnumSet.of(TickRegistry.TickType.CLIENT);
    }

    public boolean canFire(TickEvent.Phase p) {
        return p == TickEvent.Phase.END;
    }

    public String getLabel() {
        return "voidritual";
    }

    public void setShaderFoci(Entity el) {
        for (VoidMonsterDestructionRitual.Effects e : VoidMonsterDestructionRitual.Effects.list) {
            if (e.visuals == null) continue;
            e.visuals.getShader().getShader().setFocus(el);
            e.visuals.getShader().getShader().setMatricesToCurrent();
        }
    }

    private static class StretchVisual
    extends EffectVisual {
        private boolean released;
        private float amplitude;
        private int time;
        private final float frequency = 0.125f;

        private StretchVisual() {
            super(VoidMonsterDestructionRitual.Effects.STRETCH, true);
        }

        @Override
        protected boolean tick() {
            float f = ((Float)this.shaderData.get("stretchFactor")).floatValue();
            if (f >= this.amplitude + 1.0f) {
                this.released = true;
            }
            if (this.released) {
                float df = (float)((double)this.amplitude * Math.cos((float)this.time * 0.125f));
                f = df < 0.0f ? 1.0f / (1.0f + Math.abs(df)) : 1.0f + df;
                this.amplitude = (float)((double)this.amplitude * 0.965);
                ++this.time;
            } else {
                f = (float)((double)f * 1.0625);
            }
            this.shaderData.put("stretchFactor", Float.valueOf(f));
            this.shaderData.put("stretchApplication", Float.valueOf(1.0f));
            if (this.amplitude < 1.0f) {
                this.shaderIntensity = (float)((double)this.shaderIntensity * 0.9975);
            }
            return (double)this.shaderIntensity <= 0.01;
        }

        @Override
        protected void initShaderData(EntityLiving e) {
            this.shaderData.put("stretchFactor", Float.valueOf(1.0f));
            this.shaderData.put("stretchRadius", Float.valueOf(1000.0f));
            this.amplitude = 4.0f;
            this.released = false;
            this.time = 0;
        }

        @Override
        protected ChromaShaders getShader() {
            return ChromaShaders.VOIDRITUAL$WORLD;
        }
    }

    private static class CurlVisual
    extends EffectVisual {
        private CurlVisual() {
            super(VoidMonsterDestructionRitual.Effects.CURL, true);
        }

        @Override
        protected boolean tick() {
            float d = ((Float)this.shaderData.get("curlMovementXZ")).floatValue();
            float h = ((Float)this.shaderData.get("curlMovementY")).floatValue();
            h = (double)(d = d * 3.0f / 4.0f + (float)Math.sqrt(d) / 4.0f) < 0.75 ? (float)((double)h + 0.02) : (float)((double)h * 0.95);
            d = Math.min(d, 0.95f);
            this.shaderData.put("curlMovementXZ", Float.valueOf(d));
            this.shaderData.put("curlMovementY", Float.valueOf(h));
            if ((double)d >= 0.9) {
                this.shaderIntensity *= 0.9f;
            }
            return (double)this.shaderIntensity < 0.01;
        }

        @Override
        protected void initShaderData(EntityLiving e) {
            this.shaderData.put("curlMovementXZ", Float.valueOf(1.0E-4f));
            this.shaderData.put("curlMovementY", Float.valueOf(0.0f));
        }

        @Override
        protected ChromaShaders getShader() {
            return ChromaShaders.VOIDRITUAL$WORLD;
        }
    }

    private static class WaveVisual
    extends EffectVisual {
        private WaveVisual() {
            super(VoidMonsterDestructionRitual.Effects.WAVE, true);
        }

        @Override
        protected boolean tick() {
            float r = ((Float)this.shaderData.get("waveRadius")).floatValue();
            float t = ((Float)this.shaderData.get("waveThickness")).floatValue();
            float a = ((Float)this.shaderData.get("waveAmplitude")).floatValue();
            float s = ((Float)this.shaderData.get("waveSpeed")).floatValue();
            r += 1.25f * s;
            t = MathHelper.func_76131_a((float)((r *= 1.0f + 0.01f * s) / 3.0f), (float)4.0f, (float)35.0f);
            a = MathHelper.func_76131_a((float)(r / 24.0f), (float)1.0f, (float)4.0f);
            this.shaderData.put("waveRadius", Float.valueOf(r));
            this.shaderData.put("waveThickness", Float.valueOf(t));
            this.shaderData.put("waveAmplitude", Float.valueOf(a));
            this.shaderData.put("waveSpeed", Float.valueOf(Math.max(0.25f, s * 0.99f)));
            if (r > 200.0f) {
                this.shaderIntensity *= 0.95f;
            }
            return (double)this.shaderIntensity < 0.05;
        }

        @Override
        protected void initShaderData(EntityLiving e) {
            this.shaderData.put("waveRadius", Float.valueOf(0.0f));
            this.shaderData.put("waveThickness", Float.valueOf(4.0f));
            this.shaderData.put("waveAmplitude", Float.valueOf(1.0f));
            this.shaderData.put("waveSpeed", Float.valueOf(1.0f));
        }

        @Override
        protected ChromaShaders getShader() {
            return ChromaShaders.VOIDRITUAL$WORLD;
        }
    }

    private static class SphereVisual
    extends EffectVisual {
        private SphereVisual() {
            super(VoidMonsterDestructionRitual.Effects.COLLAPSING_SPHERE, false);
        }

        @Override
        protected boolean tick() {
            float r = ((Float)this.shaderData.get("size")).floatValue();
            r = r * 1.005f + 0.005f;
            this.shaderData.put("size", Float.valueOf(r));
            float t = ((Float)this.shaderData.get("thickness")).floatValue();
            this.shaderData.put("thickness", Float.valueOf(t * 1.05f));
            if ((double)r >= 0.5) {
                this.shaderIntensity = 0.0f;
            } else if ((double)r >= 0.35) {
                this.shaderIntensity = (float)((double)this.shaderIntensity * 0.75);
            }
            return this.shaderIntensity <= 0.0f;
        }

        @Override
        protected void initShaderData(EntityLiving e) {
            this.shaderData.put("size", Float.valueOf(0.0f));
            this.shaderData.put("thickness", Float.valueOf(0.0125f));
        }

        @Override
        protected ChromaShaders getShader() {
            return ChromaShaders.VOIDRITUAL$SPHERE;
        }
    }

    public static abstract class EffectVisual {
        public final VoidMonsterDestructionRitual.Effects cause;
        public final boolean hasTerrainShader;
        private final float shaderDecayFactor;
        private final float shaderDecayLinear;
        protected final HashMap<String, Object> shaderData = new HashMap();
        protected float shaderIntensity = 0.0f;
        private static final Collection<EffectVisual> terrainShaderEffects = new HashSet<EffectVisual>();

        private EffectVisual(VoidMonsterDestructionRitual.Effects e, boolean shader) {
            this(e, shader, 0.0f, 0.0f);
        }

        private EffectVisual(VoidMonsterDestructionRitual.Effects e, boolean shader, float f, float l) {
            this.cause = e;
            this.cause.visuals = this;
            this.hasTerrainShader = shader;
            this.shaderDecayFactor = f;
            this.shaderDecayLinear = l;
            if (this.hasTerrainShader) {
                terrainShaderEffects.add(this);
            }
        }

        public static Collection<EffectVisual> getTerrainShaders() {
            return Collections.unmodifiableCollection(terrainShaderEffects);
        }

        final void activate(EntityLiving e) {
            this.shaderIntensity = 1.0f;
            this.initShaderData(e);
            this.getShader().setIntensity(this.shaderIntensity);
            this.getShader().getShader().setFields(this.shaderData);
            this.getShader().getShader().updateEnabled();
            instance.active.add(this);
        }

        public final void clearShader() {
            this.shaderData.clear();
            this.getShader().getShader().clearData();
            this.shaderIntensity = 0.0f;
            this.getShader().setIntensity(this.shaderIntensity);
            this.getShader().getShader().updateEnabled();
        }

        protected final void fadeShader() {
            this.shaderIntensity = Math.max(0.0f, this.shaderIntensity * this.shaderDecayFactor - this.shaderDecayLinear);
        }

        public final Map<String, Object> getShaderData() {
            return Collections.unmodifiableMap(this.shaderData);
        }

        public final float getShaderIntensity() {
            return this.shaderIntensity;
        }

        protected abstract boolean tick();

        protected abstract void initShaderData(EntityLiving var1);

        protected abstract ChromaShaders getShader();

        public final String toString() {
            return "Visual effect for " + (Object)((Object)this.cause) + " [" + this.hasTerrainShader + "] F=" + this.shaderIntensity + " with data " + this.shaderData;
        }
    }
}

