/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Registry;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityAccelerator;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityBlockShuffler;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityBlockTicker;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityDamageBoost;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityEfficiencyUpgrade;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityEnergyIncrease;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityHealingCore;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityHeatRelay;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityOreCreator;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityPerformanceBoost;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityPlayerDelegate;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityProtectionUpgrade;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityRangeBoost;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityStabilityCore;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityTankCapacityUpgrade;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;

public enum AdjacencyUpgrades {
    BLACK(0, 0x505050, TileEntityEfficiencyUpgrade.class),
    RED(0xFF0000, 0x800000, TileEntityProtectionUpgrade.class),
    GREEN(51470, 33286, TileEntityBlockTicker.class),
    BROWN(10510649, 5649439, TileEntityOreCreator.class),
    BLUE(255, 26111),
    PURPLE(12452074, 7602410, TileEntityPerformanceBoost.class),
    CYAN(40844, 40944, TileEntityTankCapacityUpgrade.class),
    LIGHTGRAY(0x808080, 0xC0C0C0, TileEntityPlayerDelegate.class),
    GRAY(0x404040, 0x808080, TileEntityBlockShuffler.class),
    PINK(0xFF4040, 0xFFCFCF, TileEntityDamageBoost.class),
    LIME(65280, 65535, TileEntityRangeBoost.class),
    YELLOW(0xFFFF00, 0xFFFFFF, TileEntityEnergyIncrease.class),
    LIGHTBLUE(255, 65535, TileEntityAccelerator.class),
    MAGENTA(16736732, 14221532, TileEntityHealingCore.class),
    ORANGE(0xFFCF00, 0xFF4000, TileEntityHeatRelay.class),
    WHITE(0xFFFFFF, 0xFFFFFF, TileEntityStabilityCore.class);

    public final int color1;
    public final int color2;
    private final Class tileClass;
    private TileEntity renderInstance;
    public static final AdjacencyUpgrades[] upgrades;

    private AdjacencyUpgrades(int c1, int c2) {
        this(c1, c2, null);
    }

    private AdjacencyUpgrades(int c1, int c2, Class c) {
        this.tileClass = c;
        this.color1 = c1;
        this.color2 = c2;
    }

    @SideOnly(value=Side.CLIENT)
    public TileEntity createTEInstanceForRender() {
        if (this.renderInstance == null) {
            this.renderInstance = this.createTileEntity();
        }
        return this.renderInstance;
    }

    public boolean isImplemented() {
        return this.tileClass != null;
    }

    public Class getTileClass() {
        return this.tileClass;
    }

    public TileEntityAdjacencyUpgrade createTileEntity() {
        if (!this.isImplemented()) {
            return null;
        }
        try {
            return (TileEntityAdjacencyUpgrade)this.tileClass.newInstance();
        }
        catch (Exception e) {
            throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Could not instantiate an adjacency upgrade TileEntity " + (Object)((Object)this), (Throwable)e);
        }
    }

    public String getName() {
        return StatCollector.func_74838_a((String)("adjacency." + this.name().toLowerCase()));
    }

    public String getDesc(int tier) {
        switch (this) {
            case BLACK: {
                return String.format("Reduces lumen consumption by %sx", ReikaStringParser.getAutoDecimal((double)(1.0 - this.getFactor(tier))));
            }
            case RED: {
                return String.format("Protects against explosions up to %sx TNT", ReikaStringParser.getAutoDecimal((double)(this.getFactor(tier) / 4.0)));
            }
            case GREEN: {
                return String.format("Ticks blocks around it, %d times per 5 seconds", (int)(this.getFactor(tier) * 50.0));
            }
            case BROWN: {
                return String.format("Transmutes stone into mineral, %s per second, up to rarity '%s'", ReikaStringParser.getAutoDecimal((double)(this.getFactor(tier) * 20.0)), TileEntityOreCreator.getMaxSpawnableRarity(tier));
            }
            case BLUE: {
                break;
            }
            case PURPLE: {
                return String.format("Improves the performance of adjacent constructs, Tier %d", tier);
            }
            case CYAN: {
                return String.format("Increases fluid capacity %sx", ReikaStringParser.getAutoDecimal((double)this.getFactor(tier)));
            }
            case GRAY: {
                return String.format("Shuffles blocks around it %s times a second", ReikaStringParser.getAutoDecimal((double)this.getFactor(tier)));
            }
            case LIGHTGRAY: {
                return "Fakes player interaction";
            }
            case PINK: {
                return String.format("Increases construct damage %sx", ReikaStringParser.getAutoDecimal((double)this.getFactor(tier)));
            }
            case LIME: {
                return String.format("Increases construct range %sx", ReikaStringParser.getAutoDecimal((double)this.getFactor(tier)));
            }
            case YELLOW: {
                return String.format("Multiplies energy output %sx", ReikaStringParser.getAutoDecimal((double)this.getFactor(tier)));
            }
            case LIGHTBLUE: {
                return String.format("Accelerates time by %dx for TileEntities adjacent to it.", (int)this.getFactor(tier));
            }
            case MAGENTA: {
                return String.format("Repairs adjacent blocks, Tier %d", tier);
            }
            case ORANGE: {
                return String.format("Exchanges and balances heat, %s%s per tick", ReikaStringParser.getAutoDecimal((double)this.getFactor(tier)), "%");
            }
            case WHITE: {
                return String.format("Stabilizes adjacent constructs, Tier %d", tier);
            }
        }
        return "Does nothing...yet";
    }

    public double getFactor(int tier) {
        switch (this) {
            case BLACK: {
                return TileEntityEfficiencyUpgrade.getCostFactor(tier);
            }
            case RED: {
                return TileEntityProtectionUpgrade.getMaxProtectedPower(tier);
            }
            case GREEN: {
                return TileEntityBlockTicker.getTicksPerTick(tier);
            }
            case BROWN: {
                return TileEntityOreCreator.getOreChance(tier);
            }
            case BLUE: {
                break;
            }
            case PURPLE: {
                break;
            }
            case CYAN: {
                return TileEntityTankCapacityUpgrade.getCapacityFactor(tier);
            }
            case GRAY: {
                return TileEntityBlockShuffler.getOperationsPerSecond(tier);
            }
            case LIGHTGRAY: {
                break;
            }
            case PINK: {
                return TileEntityDamageBoost.getFactor(tier);
            }
            case LIME: {
                return TileEntityRangeBoost.getFactor(tier);
            }
            case YELLOW: {
                return 1.0 + TileEntityEnergyIncrease.getFactor(tier);
            }
            case LIGHTBLUE: {
                return 1 + TileEntityAccelerator.getAccelFromTier(tier);
            }
            case MAGENTA: {
                break;
            }
            case ORANGE: {
                return 100.0 * TileEntityHeatRelay.getFactor(tier);
            }
        }
        return 0.0;
    }

    public ItemStack getStackOfTier(int tier) {
        ItemStack is = ChromaItems.ADJACENCY.getStackOfMetadata(this.ordinal());
        is.field_77990_d = new NBTTagCompound();
        is.field_77990_d.func_74768_a("tier", tier);
        return is;
    }

    static {
        upgrades = AdjacencyUpgrades.values();
    }
}

