/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Registry;

import Reika.ChromatiCraft.API.AbilityAPI;
import Reika.ChromatiCraft.Auxiliary.Ability.AbilityHelper;
import Reika.ChromatiCraft.Auxiliary.ChromaDescriptions;
import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.Interfaces.DynamicallyGeneratedSubpage;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipes.Special.RepeaterTurboRecipe;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.PoolRecipes;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.RecipesCastingTable;
import Reika.ChromatiCraft.Base.ItemCrystalBasic;
import Reika.ChromatiCraft.Base.ItemPoweredChromaTool;
import Reika.ChromatiCraft.Block.BlockPylonStructure;
import Reika.ChromatiCraft.Block.Crystal.BlockCrystalGlow;
import Reika.ChromatiCraft.Block.Dimension.BlockDimensionDeco;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredOre;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Entity.EntityBallLightning;
import Reika.ChromatiCraft.Items.ItemBlock.ItemBlockCrystal;
import Reika.ChromatiCraft.Items.ItemBlock.ItemBlockCrystalColors;
import Reika.ChromatiCraft.Items.ItemBlock.ItemBlockDyeTypes;
import Reika.ChromatiCraft.Items.ItemMagicBranch;
import Reika.ChromatiCraft.Magic.Interfaces.PoweredItem;
import Reika.ChromatiCraft.Magic.Progression.ChromaResearchManager;
import Reika.ChromatiCraft.Magic.Progression.ProgressAccess;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Magic.Progression.ProgressionManager;
import Reika.ChromatiCraft.Magic.Progression.ResearchLevel;
import Reika.ChromatiCraft.Magic.ToolChargingSystem;
import Reika.ChromatiCraft.ModInterface.Bees.CrystalBees;
import Reika.ChromatiCraft.Registry.AdjacencyUpgrades;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.Render.TESR.RenderDataNode;
import Reika.ChromatiCraft.TileEntity.Auxiliary.TileEntityFocusCrystal;
import Reika.DragonAPI.Auxiliary.Trackers.PackModificationTracker;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.InstallationException;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.Configuration.ConfigList;
import Reika.DragonAPI.Interfaces.Registry.Dependency;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.Bees.BeeSpecies;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumItemHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerToolHandler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.PowerTypes;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public enum ChromaResearch implements ChromaResearchManager.ProgressElement,
ProgressAccess
{
    INTRO("Introduction", ""),
    START("Getting Started", new ItemStack(Blocks.field_150346_d), ResearchLevel.ENTRY, new ProgressStage[0]),
    LEXICON("The Lexicon", ChromaItems.HELP.getStackOf(), ResearchLevel.ENTRY, new ProgressStage[0]),
    ENERGY("Crystal Energy", new ItemStack(Blocks.field_150346_d), ResearchLevel.ENERGY, ProgressStage.ALLCOLORS, ProgressStage.CHARGE),
    ELEMENTS("Crystal Elements", ChromaItems.ELEMENTAL.getStackOf(CrystalElement.BLUE), ResearchLevel.BASICCRAFT, ProgressStage.ALLCOLORS),
    CRYSTALS("Crystals", ChromaBlocks.CRYSTAL.getStackOfMetadata(4), ResearchLevel.ENTRY, ProgressStage.CRYSTALS),
    PYLONS("Pylons", ChromaTiles.PYLON.getCraftedProduct(), ResearchLevel.ENTRY, ProgressStage.PYLON),
    STRUCTURES("Scattered Structures", ChromaBlocks.PYLONSTRUCT.getStackOf(), ResearchLevel.RAWEXPLORE, new ProgressStage[0]),
    TRANSMISSION("Signal Transmission", ChromaStacks.beaconDust, ResearchLevel.ENERGY, new ProgressStage[0]),
    CRAFTING("Casting", ChromaTiles.TABLE.getCraftedProduct(), ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    ENCHANTS("Enchantments", ChromaTiles.ENCHANTER.getCraftedProduct(), ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    CRAFTING2("Casting II", ChromaTiles.TABLE.getCraftedProduct(), ResearchLevel.RUNECRAFT, ProgressStage.RUNEUSE),
    BALLLIGHTNING("Ball Lightning", ChromaStacks.auraDust, ResearchLevel.ENERGY, ProgressStage.BALLLIGHTNING),
    APIRECIPES("Other Recipes", new ItemStack(Blocks.field_150346_d), ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    LEYLINES("Ley Lines", ChromaTiles.REPEATER.getCraftedProduct(), ResearchLevel.NETWORKING, ProgressStage.REPEATER),
    USINGRUNES("Crafting With Runes", ChromaBlocks.RUNE.getStackOfMetadata(1), ResearchLevel.RUNECRAFT, ProgressStage.RUNEUSE),
    DIMENSION("Another World", ChromaBlocks.PORTAL.getStackOf(), ResearchLevel.ENDGAME, ProgressionManager.instance.getPrereqsArray(ProgressStage.DIMENSION)),
    DIMENSION2("A Volatile World", ChromaBlocks.GLOWSAPLING.getStackOf(), ResearchLevel.ENDGAME, ProgressStage.DIMENSION),
    DIMENSION3("The Far Regions", ChromaBlocks.DIMGEN.getStackOfMetadata(BlockDimensionDeco.DimDecoTypes.FLOATSTONE.ordinal()), ResearchLevel.ENDGAME, ProgressStage.STRUCTCOMPLETE),
    TURBO("Turbocharging", ChromaStacks.elementUnit, ResearchLevel.ENDGAME, ProgressionManager.instance.getPrereqsArray(ProgressStage.TURBOCHARGE)),
    TURBOREPEATER("Repeater Turbocharging", ChromaStacks.turboRepeater, ResearchLevel.ENDGAME, ProgressStage.TURBOCHARGE),
    TURBOREPEATER2("Maximized Networking", ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.RESORING.ordinal()), ResearchLevel.CTM, ProgressStage.TURBOCHARGE),
    PACKCHANGES("Modpack Changes", new ItemStack(Blocks.field_150346_d), ResearchLevel.ENTRY, new ProgressStage[0]),
    NODENET("Networking Aura Nodes", new ItemStack(Blocks.field_150346_d), ResearchLevel.CTM, ProgressStage.CTM),
    SELFCHARGE("Energy Internalization", ChromaItems.TOOL.getStackOf(), ResearchLevel.ENERGY, ProgressStage.CHARGE),
    MYSTPAGE("World Authoring", new ItemStack((Item)Items.field_151148_bJ), ResearchLevel.RAWEXPLORE, new ProgressStage[0]),
    ENCHANTING("Crystal Enchanting", new ItemStack((Item)Items.field_151134_bR), ResearchLevel.MULTICRAFT, ProgressStage.MULTIBLOCK),
    STRUCTUREPASSWORDS("Structure Keys", ChromaBlocks.DIMDATA.getStackOfMetadata(1), ResearchLevel.ENDGAME, ProgressStage.STRUCTCOMPLETE),
    DIMTUNING("Portal Tuning", ChromaStacks.bedrockloot2, ResearchLevel.ENDGAME, ProgressStage.DIMENSION),
    ABILITIES("Abilities", ChromaTiles.RITUAL.getCraftedProduct(), ResearchLevel.ENERGY, new ProgressStage[0]),
    CASTTUNING("Personalized Casting", new ItemStack(Blocks.field_150465_bP, 1, 3), ResearchLevel.NETWORKING, ProgressionManager.instance.getPrereqsArray(ProgressStage.TUNECAST)),
    MULTIBLOCKS("Functional Construction", ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.COLUMN.ordinal()), ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    PYLONLINK("Interconnected Energy", ChromaTiles.PYLONLINK.getCraftedProduct(), ResearchLevel.ENERGY, ProgressStage.PYLONLINK),
    MACHINEDESC("Constructs", ""),
    REPEATER(ChromaTiles.REPEATER, ResearchLevel.NETWORKING, ProgressStage.BLOWREPEATER),
    GUARDIAN(ChromaTiles.GUARDIAN, ResearchLevel.PYLONCRAFT, new ProgressStage[0]),
    REPROGRAMMER(ChromaTiles.REPROGRAMMER, ResearchLevel.PYLONCRAFT, new ProgressStage[0]),
    ACCEL(ChromaTiles.ADJACENCY, ResearchLevel.ENDGAME, new ProgressStage[0]),
    RIFT(ChromaTiles.RIFT, ResearchLevel.PYLONCRAFT, new ProgressStage[0]),
    TANK(ChromaTiles.TANK, ResearchLevel.PYLONCRAFT, ProgressStage.OCEAN),
    COMPOUND(ChromaTiles.COMPOUND, ResearchLevel.NETWORKING, ProgressStage.REPEATER),
    CHARGER(ChromaTiles.CHARGER, ResearchLevel.MULTICRAFT, ProgressStage.STORAGE),
    LILY(ChromaTiles.HEATLILY, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    TICKER(ChromaTiles.TICKER, ResearchLevel.MULTICRAFT, new ProgressStage[0]),
    FENCE(ChromaTiles.FENCE, ResearchLevel.MULTICRAFT, new ProgressStage[0]),
    FURNACE(ChromaTiles.FURNACE, ResearchLevel.PYLONCRAFT, ProgressStage.MINE),
    TELEPUMP(ChromaTiles.TELEPUMP, ResearchLevel.PYLONCRAFT, new ProgressStage[0]),
    MINER(ChromaTiles.MINER, ResearchLevel.CTM, ProgressStage.MINE),
    ITEMSTAND(ChromaTiles.STAND, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    LASER(ChromaTiles.LASER, ResearchLevel.PYLONCRAFT, new ProgressStage[0]),
    ITEMRIFT(ChromaTiles.ITEMRIFT, ResearchLevel.ENERGY, new ProgressStage[0]),
    CRYSTAL(ChromaTiles.CRYSTAL, ResearchLevel.ENDGAME, new ProgressStage[0]),
    INFUSER(ChromaTiles.INFUSER, ResearchLevel.MULTICRAFT, new ProgressStage[0]),
    FABRICATOR(ChromaTiles.FABRICATOR, ResearchLevel.PYLONCRAFT, new ProgressStage[0]),
    ENCHANTER(ChromaTiles.ENCHANTER, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    CHROMAFLOWER(ChromaTiles.CHROMAFLOWER, ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    COLLECTOR(ChromaTiles.COLLECTOR, ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    BREWER(ChromaTiles.BREWER, ResearchLevel.BASICCRAFT, ProgressStage.POTION),
    RITUALTABLE(ChromaTiles.RITUAL, ResearchLevel.ENERGY, new ProgressStage[0]),
    CASTTABLE(ChromaTiles.TABLE, ResearchLevel.ENTRY, new ProgressStage[0]),
    BEACON(ChromaTiles.BEACON, ResearchLevel.ENDGAME, new ProgressStage[0]),
    ITEMCOLLECTOR(ChromaTiles.ITEMCOLLECTOR, ResearchLevel.PYLONCRAFT, new ProgressStage[0]),
    AISHUTDOWN(ChromaTiles.AISHUTDOWN, ResearchLevel.MULTICRAFT, new ProgressStage[0]),
    ASPECT(ChromaTiles.ASPECT, ResearchLevel.ENERGY, ProgressStage.NODE),
    LAMP(ChromaTiles.LAMP, ResearchLevel.ENERGY, new ProgressStage[0]),
    POWERTREE(ChromaTiles.POWERTREE, ResearchLevel.ENDGAME, ProgressStage.POWERCRYSTAL),
    LAMPCONTROL(ChromaTiles.LAMPCONTROL, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    BIOMEPAINT(ChromaTiles.BIOMEPAINTER, ResearchLevel.ENDGAME, ProgressStage.RAINBOWFOREST),
    ASPECTJAR(ChromaTiles.ASPECTJAR, ResearchLevel.PYLONCRAFT, ProgressStage.NODE),
    FARMER(ChromaTiles.FARMER, ResearchLevel.PYLONCRAFT, ProgressStage.HARVEST),
    AUTO(ChromaTiles.AUTOMATOR, ResearchLevel.ENDGAME, new ProgressStage[0]),
    MEDISTRIB(ChromaTiles.MEDISTRIBUTOR, ResearchLevel.MULTICRAFT, new ProgressStage[0]),
    WINDOW(ChromaTiles.WINDOW, ResearchLevel.MULTICRAFT, new ProgressStage[0]),
    RFDISTRIB(ChromaTiles.RFDISTRIBUTOR, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    PERSONAL(ChromaTiles.PERSONAL, ResearchLevel.ENERGY, ProgressStage.CHARGE),
    MUSIC(ChromaTiles.MUSIC, ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    PYLONTURBO(ChromaTiles.PYLONTURBO, ResearchLevel.ENDGAME, ProgressStage.DIMENSION),
    TURRET(ChromaTiles.TURRET, ResearchLevel.BASICCRAFT, ProgressStage.KILLMOB),
    BROADCAST(ChromaTiles.BROADCAST, ResearchLevel.NETWORKING, ProgressStage.REPEATER),
    CLOAKING(ChromaTiles.CLOAKING, ResearchLevel.MULTICRAFT, ProgressStage.KILLMOB),
    CAVELIGHTER(ChromaTiles.LIGHTER, ResearchLevel.RUNECRAFT, ProgressStage.DEEPCAVE),
    GLOWFIRE(ChromaTiles.GLOWFIRE, ResearchLevel.ENERGY, ProgressStage.SHARDCHARGE),
    ESSENTIA(ChromaTiles.ESSENTIARELAY, ResearchLevel.RUNECRAFT, ProgressStage.NODE),
    INSERTER(ChromaTiles.INSERTER, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    LOTUS(ChromaTiles.REVERTER, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    COBBLEGEN(ChromaTiles.COBBLEGEN, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    PLANTACCEL(ChromaTiles.PLANTACCEL, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    CROPSPEED(ChromaTiles.CROPSPEED, ResearchLevel.RUNECRAFT, ProgressStage.HARVEST),
    WEAKREPEATER(ChromaTiles.WEAKREPEATER, ResearchLevel.ENERGY, ProgressStage.PYLON, ProgressStage.MAKECHROMA),
    ENCHANTDECOMP(ChromaTiles.ENCHANTDECOMP, ResearchLevel.ENERGY, ProgressStage.MAKECHROMA),
    LUMENWIRE(ChromaTiles.LUMENWIRE, ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    PARTICLES(ChromaTiles.PARTICLES, ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    METEOR(ChromaTiles.METEOR, ResearchLevel.PYLONCRAFT, new ProgressStage[0]),
    FLUIDDISTRIB(ChromaTiles.FLUIDDISTRIBUTOR, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    VILLAGEREPAIR(ChromaTiles.VILLAGEREPAIR, ResearchLevel.MULTICRAFT, ProgressStage.VILLAGECASTING),
    AREABREAKER(ChromaTiles.AREABREAKER, ResearchLevel.MULTICRAFT, new ProgressStage[0]),
    WIRELESS(ChromaTiles.WIRELESS, ResearchLevel.MULTICRAFT, ProgressStage.USEENERGY),
    GATE(ChromaTiles.TELEPORT, ResearchLevel.ENDGAME, ProgressStage.END),
    FLUIDRELAY(ChromaTiles.FLUIDRELAY, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    BOOKDECOMP(ChromaTiles.BOOKDECOMP, ResearchLevel.ENERGY, ProgressStage.MYST),
    PLANTHARVEST(ChromaTiles.HARVESTPLANT, ResearchLevel.RUNECRAFT, ProgressStage.HARVEST),
    AVOLASER(ChromaTiles.AVOLASER, ResearchLevel.ENDGAME, BlockTieredOre.TieredOres.AVOLITE.level),
    ALVEARY(ChromaTiles.ALVEARY, ResearchLevel.PYLONCRAFT, ProgressStage.HIVE),
    ROUTER(ChromaTiles.ROUTERHUB, ResearchLevel.MULTICRAFT, new ProgressStage[0]),
    FOCUSCRYSTALS(ChromaTiles.FOCUSCRYSTAL, ResearchLevel.ENERGY, ProgressStage.FOCUSCRYSTAL),
    FLUXMAKER(ChromaTiles.FLUXMAKER, ResearchLevel.ENERGY, new ProgressStage[0]),
    FUNCRELAY(ChromaTiles.FUNCTIONRELAY, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    CHROMACRAFTER(ChromaTiles.CHROMACRAFTER, ResearchLevel.PYLONCRAFT, ProgressStage.ALLOY),
    MULTIBUILDER(ChromaTiles.MULTIBUILDER, ResearchLevel.MULTICRAFT, new ProgressStage[0]),
    EXPLOSIONSHIELD(ChromaTiles.EXPLOSIONSHIELD, ResearchLevel.PYLONCRAFT, new ProgressStage[0]),
    AURALOCUS(ChromaTiles.AURAPOINT, ResearchLevel.CTM, new ProgressStage[0]),
    PROGRESSLINK(ChromaTiles.PROGRESSLINK, ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    MANABOOSTER(ChromaTiles.MANABOOSTER, ResearchLevel.PYLONCRAFT, new ProgressStage[0]),
    NETWORKOPT(ChromaTiles.OPTIMIZER, ResearchLevel.ENDGAME, BlockTieredOre.TieredOres.LUMA.level),
    LANDMARK(ChromaTiles.LANDMARK, ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    INJECTOR(ChromaTiles.INJECTOR, ResearchLevel.MULTICRAFT, new ProgressStage[0]),
    HOVERPAD(ChromaTiles.HOVERPAD, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    DEATHFOG(ChromaTiles.DEATHFOG, ResearchLevel.RUNECRAFT, ProgressStage.VOIDMONSTER),
    VOIDTRAP(ChromaTiles.VOIDTRAP, ResearchLevel.PYLONCRAFT, ProgressStage.VOIDMONSTERDIE, ProgressStage.CHARGECRYSTAL),
    PLAYERINFUSER(ChromaTiles.PLAYERINFUSER, ResearchLevel.MULTICRAFT, ProgressStage.INFUSE),
    SMELTERY(ChromaTiles.SMELTERYDISTRIBUTOR, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    LAUNCHPAD(ChromaTiles.LAUNCHPAD, ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    TOOLSTORAGE(ChromaTiles.TOOLSTORAGE, ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    BEESTORAGE(ChromaTiles.BEESTORAGE, ResearchLevel.RUNECRAFT, ProgressStage.HIVE),
    NETWORKTRANSPORT(ChromaTiles.NETWORKITEM, ResearchLevel.PYLONCRAFT, new ProgressStage[0]),
    BLOCKS("Other Blocks", ""),
    RUNES(ChromaBlocks.RUNE, CrystalElement.LIGHTBLUE.ordinal(), ResearchLevel.BASICCRAFT, ProgressStage.ALLCOLORS),
    CHROMA(ChromaBlocks.CHROMA, ResearchLevel.RAWEXPLORE, new ProgressStage[0]),
    HEATLAMP(ChromaBlocks.HEATLAMP, ResearchLevel.RUNECRAFT, ProgressStage.NETHER),
    TNT(ChromaBlocks.TNT, ResearchLevel.PYLONCRAFT, new ProgressStage[0]),
    TANKAUX(ChromaBlocks.TANK, ResearchLevel.MULTICRAFT, new ProgressStage[0]),
    FENCEAUX(ChromaBlocks.FENCE, ResearchLevel.MULTICRAFT, new ProgressStage[0]),
    LUMENLEAVES(ChromaBlocks.POWERTREE, CrystalElement.LIME.ordinal(), ResearchLevel.ENDGAME, ProgressStage.POWERCRYSTAL),
    DYELEAVES(ChromaBlocks.DYELEAF, CrystalElement.BROWN.ordinal(), ResearchLevel.ENTRY, ProgressStage.DYETREE),
    RAINBOWLEAVES(ChromaBlocks.RAINBOWLEAF, 3, ResearchLevel.RAWEXPLORE, ProgressStage.RAINBOWLEAF),
    LAMPAUX(ChromaBlocks.LAMPBLOCK, CrystalElement.WHITE.ordinal(), ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    CRYSTALLAMP(ChromaBlocks.LAMP, CrystalElement.YELLOW.ordinal(), ResearchLevel.RAWEXPLORE, new ProgressStage[0]),
    SUPERLAMP(ChromaBlocks.SUPER, CrystalElement.MAGENTA.ordinal(), ResearchLevel.PYLONCRAFT, ProgressStage.POTION),
    PATH(ChromaBlocks.PATH, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    GLOW(ChromaBlocks.GLOW, CrystalElement.RED.ordinal(), ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    RELAY(ChromaBlocks.RELAY, ResearchLevel.ENERGY, new ProgressStage[0]),
    PORTAL(ChromaBlocks.PORTAL, ResearchLevel.ENDGAME, ProgressionManager.instance.getPrereqsArray(ProgressStage.DIMENSION)),
    COLORALTAR(ChromaBlocks.COLORALTAR, CrystalElement.WHITE.ordinal(), ResearchLevel.ENERGY, new ProgressStage[0]),
    DOOR(ChromaBlocks.DOOR, ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    GLASS(ChromaBlocks.GLASS, CrystalElement.BLUE.ordinal(), ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    MUSICTRIGGER(ChromaBlocks.MUSICTRIGGER, ResearchLevel.BASICCRAFT, ProgressStage.ANYSTRUCT),
    SELECTIVEGLASS(ChromaBlocks.SELECTIVEGLASS, ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    AVOLAMP(ChromaBlocks.AVOLAMP, ResearchLevel.ENDGAME, BlockTieredOre.TieredOres.AVOLITE.level),
    REPEATERLAMP(ChromaBlocks.REPEATERLAMP, ResearchLevel.ENERGY, new ProgressStage[0]),
    REDSTONEPOD(ChromaBlocks.REDSTONEPOD, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    FAKESKY(ChromaBlocks.FAKESKY, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    CHUNKLOADER(ChromaBlocks.CHUNKLOADER, ResearchLevel.ENDGAME, ProgressStage.DIMENSION),
    LUMA(ChromaBlocks.LUMA, ResearchLevel.RAWEXPLORE, ProgressStage.LUMA),
    TRAPFLOOR(ChromaBlocks.TRAPFLOOR, ResearchLevel.RAWEXPLORE, ProgressStage.SNOWSTRUCT),
    WARPNODE(ChromaBlocks.WARPNODE, ResearchLevel.RAWEXPLORE, ProgressStage.WARPNODE),
    RFPOD(ChromaBlocks.RFPOD, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    ENCRUSTED(ChromaBlocks.ENCRUSTED, CrystalElement.RED.ordinal(), ResearchLevel.RAWEXPLORE, ProgressStage.PYLON),
    INJECTORAUX(ChromaBlocks.INJECTORAUX, ResearchLevel.MULTICRAFT, new ProgressStage[0]),
    HOVERPADAUX(ChromaBlocks.PAD, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    TOOLDESC("Tools", ""),
    WAND(ChromaItems.TOOL, ResearchLevel.ENTRY, new ProgressStage[0]),
    FINDER(ChromaItems.FINDER, ResearchLevel.BASICCRAFT, ProgressStage.PYLON),
    EXCAVATOR(ChromaItems.EXCAVATOR, ResearchLevel.ENERGY, ProgressStage.MINE),
    TRANSITION(ChromaItems.TRANSITION, ResearchLevel.ENERGY, new ProgressStage[0]),
    INVLINK(ChromaItems.LINK, ResearchLevel.ENERGY, new ProgressStage[0]),
    PENDANT(ChromaItems.PENDANT, ResearchLevel.ENERGY, ProgressStage.POTION),
    LENS(ChromaItems.LENS, ResearchLevel.ENERGY, new ProgressStage[0]),
    STORAGE(ChromaItems.STORAGE, ResearchLevel.ENERGY, ProgressStage.USEENERGY),
    LINKTOOL(ChromaItems.LINKTOOL, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    WARP(ChromaItems.WARP, ResearchLevel.PYLONCRAFT, new ProgressStage[0]),
    TELEPORT(ChromaItems.TELEPORT, ResearchLevel.MULTICRAFT, new ProgressStage[0]),
    DUPLICATOR(ChromaItems.DUPLICATOR, ResearchLevel.PYLONCRAFT, new ProgressStage[0]),
    BUILDER(ChromaItems.BUILDER, ResearchLevel.MULTICRAFT, new ProgressStage[0]),
    CAPTURE(ChromaItems.CAPTURE, ResearchLevel.MULTICRAFT, ProgressStage.KILLMOB),
    VOIDCELL(ChromaItems.VOIDCELL, ResearchLevel.ENDGAME, new ProgressStage[0]),
    AURAPOUCH(ChromaItems.AURAPOUCH, ResearchLevel.MULTICRAFT, new ProgressStage[0]),
    MULTITOOL(ChromaItems.MULTITOOL, ResearchLevel.RUNECRAFT, ProgressStage.MINE),
    OREPICK(ChromaItems.OREPICK, ResearchLevel.RUNECRAFT, ProgressStage.MINE),
    ORESILK(ChromaItems.ORESILK, ResearchLevel.RUNECRAFT, ProgressStage.MINE),
    GROWTH(ChromaItems.GROWTH, ResearchLevel.MULTICRAFT, ProgressStage.HARVEST),
    ENDERCRYS(ChromaItems.ENDERCRYSTAL, ResearchLevel.ENDGAME, ProgressStage.END),
    BULKMOVER(ChromaItems.BULKMOVER, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    CHAINGUN(ChromaItems.CHAINGUN, ResearchLevel.MULTICRAFT, ProgressStage.KILLMOB),
    HOVER(ChromaItems.HOVERWAND, ResearchLevel.PYLONCRAFT, ProgressStage.KILLMOB),
    SPLASH(ChromaItems.SPLASHGUN, ResearchLevel.MULTICRAFT, ProgressStage.KILLMOB),
    VACUUMGUN(ChromaItems.VACUUMGUN, ResearchLevel.ENDGAME, ProgressStage.DIMENSION),
    DOORKEY(ChromaItems.KEY, ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    OWNERKEY(ChromaItems.SHARE, ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    CRYSTALCELL(ChromaItems.CRYSTALCELL, ResearchLevel.MULTICRAFT, ProgressStage.CHARGE),
    PURIFY(ChromaItems.PURIFY, ResearchLevel.ENDGAME, ProgressStage.RAINBOWLEAF, ProgressStage.ALLOY),
    EFFICIENCY(ChromaItems.EFFICIENCY, ResearchLevel.CTM, new ProgressStage[0]),
    KILLAURA(ChromaItems.KILLAURAGUN, ResearchLevel.ENDGAME, ProgressStage.KILLMOB),
    FLOATBOOTS(ChromaItems.FLOATBOOTS, ResearchLevel.ENDGAME, ProgressStage.DIMENSION),
    TELECAPSULE(ChromaItems.WARPCAPSULE, ResearchLevel.RUNECRAFT, ProgressStage.DEEPCAVE),
    BEEFRAME(ChromaItems.BEEFRAME, ResearchLevel.RUNECRAFT, ProgressStage.HIVE),
    STRUCTFIND(ChromaItems.STRUCTUREFINDER, ResearchLevel.RUNECRAFT, ProgressStage.RUNEUSE, ProgressStage.ANYSTRUCT),
    MOBSONAR(ChromaItems.MOBSONAR, ResearchLevel.RUNECRAFT, ProgressStage.KILLMOB, ProgressStage.CHARGE),
    CAVEEXIT(ChromaItems.CAVEPATHER, ResearchLevel.BASICCRAFT, ProgressStage.DEEPCAVE),
    SPLINEATTACK(ChromaItems.SPLINEATTACK, ResearchLevel.RUNECRAFT, ProgressStage.KILLMOB),
    SHIELDEDCELL(ChromaItems.SHIELDEDCELL, ResearchLevel.BASICCRAFT, ProgressStage.ARTEFACT),
    BOTTLENECK(ChromaItems.BOTTLENECK, ResearchLevel.NETWORKING, ProgressStage.REPEATER),
    SPAWNERBYPASS(ChromaItems.SPAWNERBYPASS, ResearchLevel.ENERGY, ProgressStage.FINDSPAWNER),
    ENDEREYE(ChromaItems.ENDEREYE, ResearchLevel.ENERGY, ProgressStage.NETHERROOF),
    LIGHTGUN(ChromaItems.LIGHTGUN, ResearchLevel.BASICCRAFT, ProgressStage.DEEPCAVE),
    PROBE(ChromaItems.PROBE, ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    TELEGATELOCK(ChromaItems.TELEGATELOCK, ResearchLevel.ENDGAME, new ProgressStage[0]),
    ENDERBUCKET(ChromaItems.ENDERBUCKET, ResearchLevel.RUNECRAFT, ProgressStage.END),
    WIDECOLLECTOR(ChromaItems.WIDECOLLECTOR, ResearchLevel.MULTICRAFT, new ProgressStage[0]),
    NETHERKEY(ChromaItems.NETHERKEY, ResearchLevel.RUNECRAFT, ProgressStage.NETHER, ProgressStage.ANYSTRUCT),
    RECIPECACHE(ChromaItems.RECIPECACHE, ResearchLevel.MULTICRAFT, ProgressStage.MULTIBLOCK),
    ETHERPENDANT(ChromaItems.ETHERPENDANT, ResearchLevel.MULTICRAFT, ProgressStage.LUMA, ProgressStage.END),
    RESOURCEDESC("Resources", ""),
    BERRIES("Berries", ChromaItems.BERRY.getStackOf(CrystalElement.ORANGE), ResearchLevel.RAWEXPLORE, ProgressStage.DYETREE),
    SHARDS("Shards", ChromaStacks.redShard, ResearchLevel.RAWEXPLORE, ProgressStage.CRYSTALS),
    DUSTS("Plants", ChromaStacks.auraDust, ResearchLevel.ENERGY, new ProgressStage[0]),
    GROUPS("Groups", ChromaStacks.crystalCore, ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    CORES("Cores", ChromaStacks.energyCore, ResearchLevel.ENERGY, new ProgressStage[0]),
    HICORES("Energized Cores", ChromaStacks.energyCoreHigh, ResearchLevel.PYLONCRAFT, new ProgressStage[0]),
    IRID("Iridescent Crystal", ChromaStacks.iridCrystal, ResearchLevel.MULTICRAFT, ProgressStage.ALLOY),
    ORES("Buried Secrets", ChromaStacks.bindingCrystal, ResearchLevel.RAWEXPLORE, ProgressStage.CRYSTALS),
    CRYSTALSTONE("Crystal Stone", ChromaBlocks.PYLONSTRUCT.getBlockInstance(), ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    SEED("Crystal Seeds", ChromaItems.SEED.getStackOf(CrystalElement.MAGENTA), ResearchLevel.RUNECRAFT, new ProgressStage[0]),
    FRAGMENT("Fragments", ChromaItems.FRAGMENT, ResearchLevel.ENTRY, new ProgressStage[0]),
    AUGMENT("Upgrades", ChromaStacks.speedUpgrade, ResearchLevel.PYLONCRAFT, ProgressStage.STORAGE),
    ALLOYS("Alloying", ChromaStacks.chromaIngot, ResearchLevel.ENERGY, ProgressionManager.instance.getPrereqsArray(ProgressStage.ALLOY)),
    INSCRIPTION("Inscription", ChromaItems.DATACRYSTAL.getStackOf(), ResearchLevel.RAWEXPLORE, ProgressStage.TOWER),
    BEES("Crystal Bees", new ItemStack(Blocks.field_150346_d), ResearchLevel.RAWEXPLORE, ProgressStage.HIVE),
    TINKERTOOLS("Mix-And-Magic Tools", new ItemStack(Blocks.field_150346_d), ResearchLevel.MULTICRAFT, new ProgressStage[0]),
    BRANCHES("Magic Branches", ItemMagicBranch.BranchTypes.CRYSTAL.getStack(), ResearchLevel.ENERGY, new ProgressStage[0]),
    FERTILITYSEED("Fertility Seeds", ChromaItems.FERTILITYSEED.getStackOf(), ResearchLevel.RAWEXPLORE, new ProgressStage[0]),
    ARTEFACT("Mysterious Artifacts", ChromaItems.ARTEFACT.getStackOf(), ResearchLevel.RAWEXPLORE, ProgressStage.ARTEFACT),
    PROXESSENCE("Proximal Essence", ChromaStacks.bedrockloot, ResearchLevel.ENDGAME, ProgressStage.DIMENSION),
    ABILITYDESC("Abilities", ""),
    REACH(Chromabilities.REACH),
    MAGNET(Chromabilities.MAGNET),
    SONIC(Chromabilities.SONIC),
    SHIFT(Chromabilities.SHIFT),
    HEAL(Chromabilities.HEAL),
    SHIELD(Chromabilities.SHIELD),
    FIREBALL(Chromabilities.FIREBALL),
    COMMUNICATE(Chromabilities.COMMUNICATE),
    HEALTH(Chromabilities.HEALTH),
    PYLONPROTECT(Chromabilities.PYLON, ResearchLevel.ENERGY),
    LIGHTNING(Chromabilities.LIGHTNING),
    LIFEPOINT(Chromabilities.LIFEPOINT),
    DEATHPROOF(Chromabilities.DEATHPROOF),
    SHOCKWAVE(Chromabilities.SHOCKWAVE),
    WARPLOC(Chromabilities.TELEPORT, ResearchLevel.ENDGAME),
    LEECH(Chromabilities.LEECH, ResearchLevel.ENERGY),
    FLOAT(Chromabilities.FLOAT, ResearchLevel.ENERGY),
    SPAWNERSEE(Chromabilities.SPAWNERSEE, ResearchLevel.ENDGAME),
    BREADCRUMB(Chromabilities.BREADCRUMB),
    RANGEBOOST(Chromabilities.RANGEDBOOST),
    DIMPING(Chromabilities.DIMPING, ResearchLevel.ENDGAME),
    DASH(Chromabilities.DASH),
    LASERBILITY(Chromabilities.LASER, ResearchLevel.ENDGAME),
    FIRERAIN(Chromabilities.FIRERAIN, ResearchLevel.CTM),
    KEEPINV(Chromabilities.KEEPINV, ResearchLevel.ENDGAME),
    ORECLIP(Chromabilities.ORECLIP, ResearchLevel.CTM),
    DOUBLECRAFT(Chromabilities.DOUBLECRAFT, ResearchLevel.CTM),
    GROWAURA(Chromabilities.GROWAURA, ResearchLevel.ENDGAME),
    RECHARGE(Chromabilities.RECHARGE, ResearchLevel.ENDGAME),
    MEINV(Chromabilities.MEINV, ResearchLevel.ENDGAME),
    MOBSEEK(Chromabilities.MOBSEEK, ResearchLevel.ENDGAME),
    BEEALYZE(Chromabilities.BEEALYZE),
    NUKER(Chromabilities.NUKER, ResearchLevel.ENDGAME),
    LIGHTCAST(Chromabilities.LIGHTCAST, ResearchLevel.ENERGY),
    JUMPABILITY(Chromabilities.JUMP, ResearchLevel.ENERGY),
    SUPERBUILD(Chromabilities.SUPERBUILD, ResearchLevel.ENERGY),
    CHESTCLEAR(Chromabilities.CHESTCLEAR, ResearchLevel.ENERGY),
    MOBBAIT(Chromabilities.MOBBAIT, ResearchLevel.ENERGY),
    STRUCTUREDESC("Structures", ""),
    PYLON(ChromaStructures.PYLON, BlockPylonStructure.StoneTypes.FOCUS.ordinal(), ResearchLevel.ENERGY, ProgressStage.PYLON),
    CASTING1(ChromaStructures.CASTING1, BlockPylonStructure.StoneTypes.SMOOTH.ordinal(), ResearchLevel.BASICCRAFT, ProgressStage.CRYSTALS),
    CASTING2(ChromaStructures.CASTING2, BlockPylonStructure.StoneTypes.BEAM.ordinal(), ResearchLevel.RUNECRAFT, ProgressStage.RUNEUSE),
    CASTING3(ChromaStructures.CASTING3, BlockPylonStructure.StoneTypes.COLUMN.ordinal(), ResearchLevel.NETWORKING, ProgressStage.MULTIBLOCK, ProgressStage.BLOWREPEATER),
    RITUAL(ChromaStructures.RITUAL, BlockPylonStructure.StoneTypes.ENGRAVED.ordinal(), ResearchLevel.ENERGY, ProgressStage.CHARGE),
    INFUSION(ChromaStructures.INFUSION, BlockPylonStructure.StoneTypes.BRICKS.ordinal(), ResearchLevel.MULTICRAFT, ProgressStage.CHROMA),
    PLAYERINFUSION(ChromaStructures.PLAYERINFUSION, BlockPylonStructure.StoneTypes.BEAM.ordinal(), ResearchLevel.MULTICRAFT, ProgressStage.INFUSE),
    TREE(ChromaStructures.TREE, BlockPylonStructure.StoneTypes.STABILIZER.ordinal(), ResearchLevel.ENDGAME, ProgressStage.POWERCRYSTAL),
    TREESEND(ChromaStructures.TREE_SENDER, BlockPylonStructure.StoneTypes.FOCUSFRAME.ordinal(), ResearchLevel.ENDGAME, ProgressStage.POWERTREE),
    REPEATERSTRUCT(ChromaStructures.REPEATER, BlockPylonStructure.StoneTypes.SMOOTH.ordinal(), ResearchLevel.NETWORKING, ProgressStage.RUNEUSE, ProgressStage.BLOWREPEATER),
    COMPOUNDSTRUCT(ChromaStructures.COMPOUND, BlockPylonStructure.StoneTypes.MULTICHROMIC.ordinal(), ResearchLevel.NETWORKING, ProgressStage.REPEATER),
    CAVERN(ChromaStructures.CAVERN, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata, ResearchLevel.RAWEXPLORE, ProgressStage.CAVERN),
    BURROW(ChromaStructures.BURROW, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata, ResearchLevel.RAWEXPLORE, ProgressStage.BURROW),
    OCEAN(ChromaStructures.OCEAN, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.MOSS.metadata, ResearchLevel.RAWEXPLORE, ProgressStage.OCEAN),
    DESERT(ChromaStructures.DESERT, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.COBBLE.metadata, ResearchLevel.RAWEXPLORE, ProgressStage.DESERTSTRUCT),
    SNOW(ChromaStructures.SNOWSTRUCT, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.LIGHT.metadata, ResearchLevel.RAWEXPLORE, ProgressStage.SNOWSTRUCT),
    PORTALSTRUCT(ChromaStructures.PORTAL, BlockPylonStructure.StoneTypes.SMOOTH.ordinal(), ResearchLevel.ENDGAME, ProgressionManager.instance.getPrereqsArray(ProgressStage.DIMENSION)),
    MINIPYLON(ChromaStructures.PERSONAL, BlockPylonStructure.StoneTypes.FOCUSFRAME.ordinal(), ResearchLevel.ENERGY, ProgressStage.CHARGE),
    BROADCASTER(ChromaStructures.BROADCAST, BlockPylonStructure.StoneTypes.RESORING.ordinal(), ResearchLevel.NETWORKING, ProgressStage.MULTIBLOCK, ProgressStage.REPEATER),
    CLOAKTOWER(ChromaStructures.CLOAKTOWER, BlockPylonStructure.StoneTypes.GLOWCOL.ordinal(), ResearchLevel.MULTICRAFT, ProgressStage.KILLMOB),
    BOOSTTREE(ChromaStructures.TREE_BOOSTED, BlockPylonStructure.StoneTypes.STABILIZER.ordinal(), ResearchLevel.CTM, ProgressStage.TURBOCHARGE),
    BEACONSTRUCT(ChromaStructures.PROTECT, BlockPylonStructure.StoneTypes.CORNER.ordinal(), ResearchLevel.ENDGAME, new ProgressStage[0]),
    MINIREPEATER(ChromaStructures.WEAKREPEATER, Blocks.field_150364_r, 0, ResearchLevel.ENERGY, ProgressStage.PYLON),
    METEOR1(ChromaStructures.METEOR1, BlockPylonStructure.StoneTypes.BRICKS.ordinal(), ResearchLevel.PYLONCRAFT, new ProgressStage[0]),
    METEOR2(ChromaStructures.METEOR2, BlockPylonStructure.StoneTypes.BRICKS.ordinal(), ResearchLevel.ENDGAME, new ProgressStage[0]),
    METEOR3(ChromaStructures.METEOR3, BlockPylonStructure.StoneTypes.BRICKS.ordinal(), ResearchLevel.ENDGAME, ProgressStage.DIMENSION),
    RITUAL2(ChromaStructures.RITUAL2, BlockPylonStructure.StoneTypes.ENGRAVED.ordinal(), ResearchLevel.ENDGAME, ProgressStage.DIMENSION),
    GATESTRUCT(ChromaStructures.TELEGATE, BlockPylonStructure.StoneTypes.COLUMN.ordinal(), ResearchLevel.ENDGAME, ProgressStage.END),
    RELAYSTRUCT(ChromaStructures.RELAY, BlockPylonStructure.StoneTypes.FOCUSFRAME.ordinal(), ResearchLevel.ENDGAME, ProgressStage.POWERCRYSTAL),
    PYLONBROADCAST(ChromaStructures.PYLONBROADCAST, BlockPylonStructure.StoneTypes.FOCUS.ordinal(), ResearchLevel.ENDGAME, ProgressStage.DIMENSION),
    PYLONTURBORING(ChromaStructures.PYLONTURBO, BlockPylonStructure.StoneTypes.FOCUS.ordinal(), ResearchLevel.ENDGAME, ProgressionManager.instance.getPrereqsArray(ProgressStage.TURBOCHARGE)),
    WIRELESSPED(ChromaStructures.WIRELESSPEDESTAL, BlockPylonStructure.StoneTypes.MULTICHROMIC.ordinal(), ResearchLevel.ENDGAME, new ProgressStage[0]),
    WIRELESSPED2(ChromaStructures.WIRELESSPEDESTAL2, BlockPylonStructure.StoneTypes.MULTICHROMIC.ordinal(), ResearchLevel.CTM, new ProgressStage[0]),
    DATATOWER(ChromaStructures.DATANODE, BlockPylonStructure.StoneTypes.SMOOTH.ordinal(), ResearchLevel.RAWEXPLORE, ProgressStage.TOWER),
    PROGLINKSTRUCT(ChromaStructures.PROGRESSLINK, BlockPylonStructure.StoneTypes.CORNER.ordinal(), ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    OPTIMISTRUCT(ChromaStructures.OPTIMIZER, BlockPylonStructure.StoneTypes.RESORING.ordinal(), ResearchLevel.ENDGAME, BlockTieredOre.TieredOres.LUMA.level),
    VOIDTRAPSTRUCT(ChromaStructures.VOIDRITUAL, Blocks.field_150429_aA, 5, ResearchLevel.PYLONCRAFT, ProgressStage.VOIDMONSTERDIE, ProgressStage.CHARGECRYSTAL),
    VOIDTRAPSTRUCTN(ChromaStructures.NETHERTRAP, Blocks.field_150335_W, 0, ResearchLevel.PYLONCRAFT, ProgressStage.VOIDMONSTERDIE, ProgressStage.CHARGECRYSTAL),
    LAUNCHPADSTRUCT(ChromaStructures.LAUNCHPAD, BlockPylonStructure.StoneTypes.ENGRAVED.ordinal(), ResearchLevel.BASICCRAFT, new ProgressStage[0]),
    BIOMESTRUCT(ChromaStructures.BIOMEFRAG, ChromaBlocks.COLORLOCK.getBlockInstance(), 0, ResearchLevel.MULTICRAFT, ProgressStage.BIOMESTRUCT);

    private final ItemStack iconItem;
    private final String pageTitle;
    private boolean isParent = false;
    private ChromaTiles machine;
    private ChromaBlocks block;
    private ChromaItems item;
    private final ProgressStage[] progress;
    public final ResearchLevel level;
    private Chromabilities ability;
    private ChromaStructures struct;
    private int sectionIndex = 0;
    public static final ChromaResearch[] researchList;
    static final MultiMap<ResearchLevel, ChromaResearch> levelMap;
    private static final ItemHashMap<ChromaResearch> itemMap;
    private static final EnumMap<ChromaTiles, ChromaResearch> tileMap;
    private static final HashMap<AbilityAPI.Ability, ChromaResearch> abilityMap;
    private static final List<ChromaResearch> parents;
    private static final List<ChromaResearch> nonParents;
    private static final List<ChromaResearch> obtainable;
    private static final HashMap<String, ChromaResearch> byName;
    private static final IdentityHashMap<Object, ChromaResearch> duplicateChecker;

    private ChromaResearch() {
        this("");
    }

    private ChromaResearch(ChromaTiles r, ResearchLevel rl, ProgressStage ... p) {
        this(r.getName(), r.getCraftedProduct(), rl, p);
        this.machine = r;
        if (rl.ordinal() < ResearchLevel.ENERGY.ordinal() && r.isRelayPowered()) {
            throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Machine fragment " + (Object)((Object)r) + " relay powered but available before relays!");
        }
    }

    private ChromaResearch(ChromaBlocks r, ResearchLevel rl, ProgressStage ... p) {
        this(r.getBasicName(), r.getStackOf(), rl, p);
        this.block = r;
    }

    private ChromaResearch(ChromaBlocks r, int meta, ResearchLevel rl, ProgressStage ... p) {
        this(r.getBasicName(), r.getStackOfMetadata(meta), rl, p);
        this.block = r;
    }

    private ChromaResearch(ChromaItems i, ResearchLevel rl, ProgressStage ... p) {
        this(i.getBasicName(), i.getStackOf(), rl, p);
        this.item = i;
    }

    private ChromaResearch(String name, String s) {
        this(name);
        this.isParent = true;
    }

    private ChromaResearch(String name) {
        this(name, (ItemStack)null, null, new ProgressStage[0]);
    }

    private ChromaResearch(String name, ChromaItems i, ResearchLevel rl, ProgressStage ... p) {
        this(name, i.getStackOf(), rl, p);
    }

    private ChromaResearch(String name, ChromaTiles r, ResearchLevel rl, ProgressStage ... p) {
        this(name, r.getCraftedProduct(), rl, p);
    }

    private ChromaResearch(String name, Item icon, ResearchLevel rl, ProgressStage ... p) {
        this(name, new ItemStack(icon), rl, p);
    }

    private ChromaResearch(String name, Block icon, ResearchLevel rl, ProgressStage ... p) {
        this(name, new ItemStack(icon), rl, p);
    }

    private ChromaResearch(String name, ItemStack icon, ResearchLevel rl, ProgressStage ... p) {
        this.iconItem = icon != null ? icon.func_77946_l() : null;
        this.pageTitle = name;
        this.progress = p;
        this.level = rl;
    }

    private ChromaResearch(Chromabilities c) {
        this(c, ResearchLevel.PYLONCRAFT);
    }

    private ChromaResearch(Chromabilities c, ResearchLevel rl) {
        this.iconItem = ChromaTiles.RITUAL.getCraftedProduct();
        this.pageTitle = c.getDisplayName();
        Collection<ProgressStage> p = AbilityHelper.instance.getProgressFor(c);
        if (rl == ResearchLevel.PYLONCRAFT) {
            for (ProgressStage ps : p) {
                if (!ps.isGatedAfter(ProgressStage.DIMENSION)) continue;
                throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Ability fragment " + c + " gated behind " + ps + " but is only level " + rl + "!");
            }
        }
        this.progress = p.toArray(new ProgressStage[p.size()]);
        this.level = rl;
        this.ability = c;
    }

    private ChromaResearch(ChromaStructures s, int meta, ResearchLevel r, ProgressStage ... p) {
        this(s, ChromaBlocks.PYLONSTRUCT.getBlockInstance(), meta, r, p);
    }

    private ChromaResearch(ChromaStructures s, Block b, int meta, ResearchLevel r, ProgressStage ... p) {
        this.iconItem = new ItemStack(b, 1, meta);
        this.pageTitle = s.getDisplayName();
        this.progress = p;
        this.level = r;
        this.struct = s;
    }

    public int sectionIndex() {
        return this.sectionIndex;
    }

    public boolean isAlwaysPresent() {
        return this == START || this == LEXICON;
    }

    public boolean playerCanSee(EntityPlayer ep) {
        if (this.isDummiedOut()) {
            return DragonAPICore.isReikasComputer();
        }
        if (this.progress != null) {
            for (int i = 0; i < this.progress.length; ++i) {
                ProgressStage p = this.progress[i];
                if (p.isPlayerAtStage(ep)) continue;
                return false;
            }
        }
        return ChromaResearchManager.instance.playerHasFragment(ep, this);
    }

    public boolean playerCanRead(EntityPlayer ep) {
        return this.playerCanSee(ep) || ChromaResearchManager.instance.canPlayerStepTo(ep, this);
    }

    public boolean canPlayerProgressTo(EntityPlayer ep) {
        if (this.progress != null) {
            for (int i = 0; i < this.progress.length; ++i) {
                ProgressStage p = this.progress[i];
                if (p.isPlayerAtStage(ep)) continue;
                return false;
            }
        }
        return this.ability == null || this.ability.isAvailableToPlayer(ep);
    }

    public ProgressStage[] getRequiredProgress() {
        return Arrays.copyOf(this.progress, this.progress.length);
    }

    public boolean isMachine() {
        return this.machine != null;
    }

    public Chromabilities getAbility() {
        return this.ability;
    }

    public ChromaStructures getStructure() {
        return this.struct;
    }

    public ChromaTiles getMachine() {
        return this.machine;
    }

    public ChromaBlocks getBlock() {
        return this.block;
    }

    public ChromaItems getItem() {
        return this.item;
    }

    @SideOnly(value=Side.CLIENT)
    private ItemStack getTabIcon() {
        if (this == BEES) {
            return CrystalBees.getCrystalBee().getBeeItem((World)Minecraft.func_71410_x().field_71441_e, EnumBeeType.QUEEN);
        }
        if (this == TINKERTOOLS) {
            int mat = ExtraChromaIDs.CHROMAMATID.getValue();
            return TinkerToolHandler.Tools.HAMMER.getToolOfMaterials(mat, mat, mat, mat);
        }
        if (this == ENDERCRYS) {
            return this.item.getStackOfMetadata(1);
        }
        if (this == FOCUSCRYSTALS) {
            return TileEntityFocusCrystal.CrystalTier.REFINED.getCraftedItem();
        }
        if (this == ACCEL) {
            return ChromaItems.ADJACENCY.getStackOfMetadata(CrystalElement.LIGHTBLUE.ordinal());
        }
        if (this.item != null && this.item.getItemInstance() instanceof PoweredItem) {
            PoweredItem i = (PoweredItem)this.item.getItemInstance();
            return ToolChargingSystem.instance.getChargedItem((Item)((PoweredItem)((Item)i)), i.getMaxCharge());
        }
        return this.iconItem;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderIcon(RenderItem ri, FontRenderer fr, int x, int y) {
        this.drawTabIcon(ri, x, y);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawTabIcon(RenderItem ri, int x, int y) {
        if (this == START) {
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)2896);
            ReikaTextureHelper.bindTerrainTexture();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ReikaGuiAPI.instance.func_94065_a(x, y + 1, ChromaIcons.QUESTION.getIcon(), 16, 14);
            GL11.glPopAttrib();
            return;
        }
        if (this == BALLLIGHTNING) {
            EntityBallLightning eb = new EntityBallLightning((World)Minecraft.func_71410_x().field_71441_e);
            eb.field_70128_L = true;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            double d = 8.0;
            GL11.glTranslated((double)((double)x + d), (double)((double)y + d), (double)0.0);
            double s = 18.0;
            GL11.glScaled((double)(-s), (double)s, (double)1.0);
            ReikaEntityHelper.getEntityRenderer(EntityBallLightning.class).func_76986_a((Entity)eb, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glPopMatrix();
            return;
        }
        if (this == PACKCHANGES) {
            ReikaTextureHelper.bindTerrainTexture();
            ReikaGuiAPI.instance.func_94065_a(x, y + 1, ChromaIcons.QUESTION.getIcon(), 16, 14);
            return;
        }
        if (this == CASTTUNING) {
            GL11.glPushMatrix();
            double s = 18.0;
            GL11.glTranslated((double)((double)x + 2.5), (double)((double)y + 13.5), (double)0.0);
            GL11.glScaled((double)s, (double)s, (double)s);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            try {
                GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                GL11.glRotated((double)20.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)-60.0, (double)0.0, (double)1.0, (double)0.0);
                TileEntityRendererDispatcher.field_147556_a.func_147549_a((TileEntity)ReikaPlayerAPI.getPlayerHead((World)Minecraft.func_71410_x().field_71441_e, (GameProfile)ReikaPlayerAPI.getClientProfile()), 0.0, 0.0, 0.0, ReikaRenderHelper.getPartialTickTime());
            }
            catch (Exception e) {
                ReikaChatHelper.write((Object)("Threw exception rendering fragment " + this + "! Check your console!"));
                e.printStackTrace();
            }
            GL11.glPopMatrix();
            return;
        }
        if (this == NODENET) {
            ItemStack is = ThaumItemHelper.BlockEntry.NODE.getItem();
            GL11.glPushMatrix();
            double s = 2.0;
            GL11.glTranslated((double)(x - 8), (double)(y - 6), (double)0.0);
            GL11.glScaled((double)s, (double)s, (double)1.0);
            ReikaGuiAPI.instance.drawItemStack(ri, is, 0, 0);
            GL11.glPopMatrix();
            return;
        }
        if (this == TURBO) {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            ReikaTextureHelper.bindTerrainTexture();
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
            GL11.glRotated((double)0.0, (double)0.0, (double)0.0, (double)1.0);
            int ds = 4;
            ReikaGuiAPI.instance.func_94065_a(x - ds, y - ds, ChromaIcons.TURBO.getIcon(), 16 + ds * 2, 16 + ds * 2);
            ds = -1;
            float f = 0.5f;
            GL11.glColor4f((float)f, (float)f, (float)f, (float)f);
            ReikaGuiAPI.instance.func_94065_a(x - ds, y - ds, ChromaIcons.RADIATE.getIcon(), 16 + ds * 2, 16 + ds * 2);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
            GL11.glPopAttrib();
            return;
        }
        if (this == WARPNODE) {
            ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/warpnode-small.png");
            int idx = (int)(System.currentTimeMillis() / 20L % 64L);
            double u = (double)(idx % 8) / 8.0;
            double v = (double)(idx / 8) / 8.0;
            double du = u + 0.125;
            double dv = v + 0.125;
            GL11.glPushAttrib((int)1048575);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
            int d = 2;
            int w = 16;
            int h = 16;
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)(x + 0 - d), (double)(y + h + d), 0.0, u, dv);
            tessellator.func_78374_a((double)(x + w + d), (double)(y + h + d), 0.0, du, dv);
            tessellator.func_78374_a((double)(x + w + d), (double)(y + 0 - d), 0.0, du, v);
            tessellator.func_78374_a((double)(x + 0 - d), (double)(y + 0 - d), 0.0, u, v);
            tessellator.func_78381_a();
            GL11.glPopAttrib();
            return;
        }
        if (this == ENERGY) {
            ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/infoicons.png");
            int idx = 24;
            double u = (double)(idx % 8) / 8.0;
            double v = (double)(idx / 8) / 8.0;
            double du = u + 0.125;
            double dv = v + 0.125;
            GL11.glPushAttrib((int)1048575);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
            GL11.glShadeModel((int)7425);
            int d = 2;
            int w = 16;
            int h = 16;
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78378_d(CrystalElement.getBlendedColor(Minecraft.func_71410_x().field_71439_g.field_70173_aa, 10));
            tessellator.func_78374_a((double)(x + 0 - d), (double)(y + h + d), 0.0, u, dv);
            tessellator.func_78378_d(CrystalElement.getBlendedColor(Minecraft.func_71410_x().field_71439_g.field_70173_aa + 5, 10));
            tessellator.func_78374_a((double)(x + w + d), (double)(y + h + d), 0.0, du, dv);
            tessellator.func_78378_d(CrystalElement.getBlendedColor(Minecraft.func_71410_x().field_71439_g.field_70173_aa + 15, 10));
            tessellator.func_78374_a((double)(x + w + d), (double)(y + 0 - d), 0.0, du, v);
            tessellator.func_78378_d(CrystalElement.getBlendedColor(Minecraft.func_71410_x().field_71439_g.field_70173_aa + 10, 10));
            tessellator.func_78374_a((double)(x + 0 - d), (double)(y + 0 - d), 0.0, u, v);
            tessellator.func_78381_a();
            GL11.glPopAttrib();
            return;
        }
        if (this == DATATOWER) {
            ReikaGuiAPI.instance.drawItemStack(ri, ChromaItems.DATACRYSTAL.getStackOf(), x, y);
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
            double s = 0.75;
            double d = 16.0;
            GL11.glTranslated((double)((double)x - d), (double)((double)y - d), (double)0.0);
            GL11.glScaled((double)s, (double)s, (double)0.0);
            RenderDataNode.renderFlare(Tessellator.field_78398_a, (float)(0.75 + 0.25 * Math.sin((double)System.currentTimeMillis() / 500.0)), false);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
            return;
        }
        if (this == APIRECIPES) {
            ArrayList<ItemStack> ico = new ArrayList<ItemStack>();
            for (CastingRecipe cr : RecipesCastingTable.instance.getAllAPIRecipes()) {
                if (ReikaItemHelper.collectionContainsItemStack(ico, (ItemStack)cr.getOutput())) continue;
                ico.add(cr.getOutput());
            }
            for (CastingRecipe cr : RecipesCastingTable.instance.getAllModdedItemRecipes()) {
                if (ReikaItemHelper.collectionContainsItemStack(ico, (ItemStack)cr.getOutput())) continue;
                ico.add(cr.getOutput());
            }
            if (!ico.isEmpty()) {
                int idx = (int)(System.currentTimeMillis() / 400L % (long)ico.size());
                ReikaGuiAPI.instance.drawItemStack(ri, ReikaItemHelper.getSizedItemStack((ItemStack)((ItemStack)ico.get(idx)), (int)1), x, y);
            } else {
                ReikaGuiAPI.instance.func_94065_a(x, y, ChromaIcons.NOENTER.getIcon(), 16, 16);
            }
            return;
        }
        float zp = ri.field_77023_b;
        if (this.isUnloadable()) {
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            ReikaTextureHelper.bindTerrainTexture();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            ReikaGuiAPI.instance.func_94065_a(x, y, ChromaIcons.NOENTER.getIcon(), 16, 16);
            GL11.glPopAttrib();
            ri.field_77023_b = 0.0f;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)-50.0);
        ItemStack ico = this.getTabIcon().func_77946_l();
        if (ico.field_77990_d == null) {
            ico.field_77990_d = new NBTTagCompound();
        }
        ico.field_77990_d.func_74757_a("tooltip", true);
        ReikaGuiAPI.instance.drawItemStack(ri, ico, x, y);
        ri.field_77023_b = zp;
        if (this == DIMENSION3) {
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            ReikaTextureHelper.bindTerrainTexture();
            GL11.glTranslated((double)0.0, (double)0.0, (double)-240.0);
            int s = 32;
            int ds = (s - 16) / 2;
            ReikaGuiAPI.instance.func_94065_a(x - ds, y - ds, ChromaIcons.PURPLESPIN.getIcon(), s, s);
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    public boolean isUnloadable() {
        return !ChromatiCraft.instance.isDimensionLoadable() && (this == DIMENSION || this == DIMENSION2 || this == PORTAL || this == PORTALSTRUCT);
    }

    public String getData() {
        if (this == PACKCHANGES) {
            return "These are changes made to the way the mod works by the creator of the pack. None of these are normal behavior of the mod, and any negative effects of these changes should be discussed with the pack creator, not the mod developer.";
        }
        return ChromaDescriptions.getData(this);
    }

    public String getNotes(int subpage) {
        DynamicallyGeneratedSubpage iw;
        if (this == PACKCHANGES) {
            return ((PackModificationTracker.PackModification)PackModificationTracker.instance.getModifications((DragonAPIMod)ChromatiCraft.instance).get(subpage - 1)).toString();
        }
        if (this == ACCEL) {
            return ChromaDescriptions.getNotes(this, subpage - 1);
        }
        String ret = ChromaDescriptions.getNotes(this, 0);
        if (this.item != null && this.item.getItemInstance() instanceof DynamicallyGeneratedSubpage && !(iw = (DynamicallyGeneratedSubpage)this.getItem().getItemInstance()).replaceOriginal()) {
            ret = ret + (ret.isEmpty() ? "" : "\n") + iw.getNotes(subpage);
        }
        return ret;
    }

    public boolean sameTextAllSubpages() {
        return false;
    }

    public boolean isGating() {
        if (this.isDummiedOut()) {
            return false;
        }
        if (this.isMachine() && this.getMachine().isIncomplete()) {
            return false;
        }
        if (this == TINKERTOOLS) {
            return false;
        }
        if (this == TRAPFLOOR) {
            return false;
        }
        for (ProgressStage p : this.progress) {
            if (p.isGating(this.level)) continue;
            return false;
        }
        return this.struct == null || !this.struct.isNatural();
    }

    public boolean isAbility() {
        if (this.isParent) {
            return false;
        }
        return this.getParent() == ABILITYDESC;
    }

    public boolean isCrafting() {
        if (this.isParent) {
            return false;
        }
        if (this == APIRECIPES) {
            return true;
        }
        if (this == TURBOREPEATER) {
            return true;
        }
        if (this == AURALOCUS) {
            return false;
        }
        if (this.isMachine() || this.isTool()) {
            return true;
        }
        if (this == GROUPS) {
            return true;
        }
        if (this == CORES) {
            return true;
        }
        if (this == HICORES) {
            return true;
        }
        if (this == ALLOYS) {
            return true;
        }
        if (this == IRID) {
            return true;
        }
        if (this == TINKERTOOLS) {
            return true;
        }
        if (this == SEED) {
            return true;
        }
        if (this == AUGMENT) {
            return true;
        }
        if (this == RELAY) {
            return true;
        }
        if (this == RUNES) {
            return true;
        }
        if (this == TANKAUX) {
            return true;
        }
        if (this == FENCEAUX) {
            return true;
        }
        if (this == TNT) {
            return true;
        }
        if (this == LAMPAUX) {
            return true;
        }
        if (this == CRYSTALLAMP || this == SUPERLAMP) {
            return true;
        }
        if (this == CRYSTALSTONE) {
            return true;
        }
        if (this == PATH) {
            return true;
        }
        if (this == GLOW) {
            return true;
        }
        if (this == PORTAL) {
            return true;
        }
        if (this == HEATLAMP) {
            return true;
        }
        if (this == REDSTONEPOD) {
            return true;
        }
        if (this == RFPOD) {
            return true;
        }
        if (this == COLORALTAR) {
            return true;
        }
        if (this == DOOR) {
            return true;
        }
        if (this == GLASS) {
            return true;
        }
        if (this == MUSICTRIGGER) {
            return true;
        }
        if (this == SELECTIVEGLASS) {
            return true;
        }
        if (this == AVOLAMP) {
            return true;
        }
        if (this == REPEATERLAMP) {
            return true;
        }
        if (this == FAKESKY) {
            return true;
        }
        if (this == TRAPFLOOR) {
            return true;
        }
        if (this == INJECTORAUX) {
            return true;
        }
        return this == HOVERPADAUX;
    }

    public boolean isTool() {
        return this.getParent() == TOOLDESC;
    }

    public boolean requiresProgress(ProgressStage p) {
        for (int i = 0; i < this.progress.length; ++i) {
            if (this.progress[i] != p) continue;
            return true;
        }
        return false;
    }

    public ArrayList<ItemStack> getItemStacks() {
        if (this == ACCEL) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < 16; ++i) {
                if (!AdjacencyUpgrades.upgrades[i].isImplemented()) continue;
                for (int k = 0; k < 8; ++k) {
                    ItemStack is = ChromaItems.ADJACENCY.getStackOfMetadata(i);
                    is.field_77990_d = new NBTTagCompound();
                    is.field_77990_d.func_74768_a("tier", k);
                    li.add(is);
                }
            }
            return li;
        }
        if (this == ROUTER) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(this.machine.getCraftedProduct());
            li.add(ChromaBlocks.ROUTERNODE.getStackOfMetadata(0));
            li.add(ChromaBlocks.ROUTERNODE.getStackOfMetadata(1));
            return li;
        }
        if (this == HEATLAMP) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < ChromaBlocks.HEATLAMP.getNumberMetadatas(); ++i) {
                if (!ChromaBlocks.HEATLAMP.isMetaInCreative(i)) continue;
                li.add(new ItemStack(ChromaBlocks.HEATLAMP.getBlockInstance(), 1, i));
            }
            return li;
        }
        if (this == FOCUSCRYSTALS) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < TileEntityFocusCrystal.CrystalTier.tierList.length; ++i) {
                li.add(TileEntityFocusCrystal.CrystalTier.tierList[i].getCraftedItem());
            }
            return li;
        }
        if (this.isMachine()) {
            return ReikaJavaLibrary.makeListFrom((Object)this.machine.getCraftedProduct());
        }
        if (this == TURBOREPEATER) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ChromaStacks.turboRepeater);
            li.add(ChromaStacks.turboMultiRepeater);
            li.add(ChromaStacks.turboBroadcastRepeater);
            return li;
        }
        if (this == STORAGE) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < ChromaItems.STORAGE.getNumberMetadatas(); ++i) {
                li.add(ChromaItems.STORAGE.getStackOfMetadata(i));
            }
            return li;
        }
        if (this == GLOW) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < 16 * BlockCrystalGlow.Bases.baseList.length; ++i) {
                li.add(ChromaBlocks.GLOW.getStackOfMetadata(i));
            }
            return li;
        }
        if (this == RELAY) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ChromaTiles.RELAYSOURCE.getCraftedProduct());
            li.add(ChromaBlocks.RELAYFILTER.getStackOf());
            for (int i = 0; i < 16; ++i) {
                li.add(ChromaBlocks.RELAY.getStackOfMetadata(i));
            }
            li.add(ChromaBlocks.RELAY.getStackOfMetadata(16));
            li.add(ChromaBlocks.FLOATINGRELAY.getStackOf());
            return li;
        }
        if (this == PENDANT) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < 16; ++i) {
                li.add(ChromaItems.PENDANT.getStackOfMetadata(i));
                li.add(ChromaItems.PENDANT3.getStackOfMetadata(i));
            }
            return li;
        }
        if (this == ENDERCRYS) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ChromaItems.ENDERCRYSTAL.getStackOfMetadata(0));
            li.add(ChromaItems.ENDERCRYSTAL.getStackOfMetadata(1));
            return li;
        }
        if (this == AUGMENT) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ChromaStacks.speedUpgrade);
            li.add(ChromaStacks.efficiencyUpgrade);
            li.add(ChromaStacks.silkUpgrade);
            return li;
        }
        if (this.item != null) {
            if (this.item.getItemInstance() instanceof ItemPoweredChromaTool) {
                ItemPoweredChromaTool it = (ItemPoweredChromaTool)this.item.getItemInstance();
                ArrayList<ItemStack> li = new ArrayList<ItemStack>();
                for (int i = 0; i < it.getChargeStates(); ++i) {
                    li.add(this.item.getStackOfMetadata(i));
                }
                return li;
            }
            if (this.item.getItemInstance() instanceof ItemCrystalBasic) {
                ArrayList<ItemStack> li = new ArrayList<ItemStack>();
                for (int i = 0; i < 16; ++i) {
                    li.add(this.item.getStackOfMetadata(i));
                }
                return li;
            }
            return ReikaJavaLibrary.makeListFrom((Object)this.item.getStackOf());
        }
        if (this.iconItem != null && this.iconItem.func_77973_b() instanceof ItemCrystalBasic) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < 16; ++i) {
                li.add(new ItemStack(this.iconItem.func_77973_b(), 1, i));
            }
            return li;
        }
        if (this == GROUPS) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < 13; ++i) {
                li.add(ChromaItems.CLUSTER.getStackOfMetadata(i));
            }
            li.add(ChromaStacks.elementUnit);
            return li;
        }
        if (this == ALLOYS) {
            return new ArrayList<ItemStack>(PoolRecipes.instance.getAllOutputItems());
        }
        if (this == ORES) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ChromaStacks.chromaDust);
            for (int i = 0; i < 16; ++i) {
                li.add(ChromaItems.ELEMENTAL.getStackOfMetadata(i));
            }
            li.add(ChromaStacks.focusDust);
            li.add(ChromaStacks.bindingCrystal);
            li.add(ChromaStacks.enderDust);
            li.add(ChromaStacks.waterDust);
            li.add(ChromaStacks.firaxite);
            li.add(ChromaStacks.spaceDust);
            li.add(ChromaStacks.resocrystal);
            li.add(ChromaStacks.lumaDust);
            li.add(ChromaStacks.echoCrystal);
            li.add(ChromaStacks.fireEssence);
            li.add(ChromaStacks.thermiticCrystal);
            li.add(ChromaStacks.lumenGem);
            li.add(ChromaStacks.avolite);
            li.add(ChromaStacks.echoCrystal);
            return li;
        }
        if (this == DUSTS) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ChromaStacks.auraDust);
            li.add(ChromaStacks.purityDust);
            li.add(ChromaStacks.elementDust);
            li.add(ChromaStacks.beaconDust);
            li.add(ChromaStacks.resonanceDust);
            li.add(ChromaStacks.teleDust);
            li.add(ChromaStacks.icyDust);
            li.add(ChromaStacks.etherBerries);
            li.add(ChromaStacks.energyPowder);
            li.add(ChromaStacks.livingEssence);
            li.add(ChromaStacks.voidDust);
            return li;
        }
        if (this == IRID) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ChromaStacks.rawCrystal);
            li.add(ChromaStacks.iridCrystal);
            li.add(ChromaStacks.iridChunk);
            return li;
        }
        if (this == CORES) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ChromaStacks.crystalFocus);
            li.add(ChromaStacks.energyCore);
            li.add(ChromaStacks.transformCore);
            li.add(ChromaStacks.voidCore);
            li.add(ChromaStacks.crystalLens);
            return li;
        }
        if (this == HICORES) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ChromaStacks.energyCoreHigh);
            li.add(ChromaStacks.transformCoreHigh);
            li.add(ChromaStacks.voidCoreHigh);
            li.add(ChromaStacks.glowChunk);
            li.add(ChromaStacks.lumenCore);
            return li;
        }
        if (this == PATH) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < ChromaBlocks.PATH.getNumberMetadatas(); ++i) {
                li.add(new ItemStack(ChromaBlocks.PATH.getBlockInstance(), 1, i));
            }
            return li;
        }
        if (this == HOVERPADAUX) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < ChromaBlocks.PAD.getNumberMetadatas(); ++i) {
                li.add(new ItemStack(ChromaBlocks.PAD.getBlockInstance(), 1, i));
            }
            return li;
        }
        if (this == REPEATERLAMP) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < ChromaBlocks.REPEATERLAMP.getNumberMetadatas(); ++i) {
                li.add(new ItemStack(ChromaBlocks.REPEATERLAMP.getBlockInstance(), 1, i));
            }
            return li;
        }
        if (this == CRYSTALSTONE) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < ChromaBlocks.PYLONSTRUCT.getNumberMetadatas(); ++i) {
                li.add(new ItemStack(ChromaBlocks.PYLONSTRUCT.getBlockInstance(), 1, i));
            }
            return li;
        }
        if (this == BEES) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            World world = ReikaWorldHelper.getBasicReferenceWorld();
            Collection<BeeSpecies> c = CrystalBees.getBasicBees();
            for (BeeSpecies b : c) {
                li.add(b.getBeeItem(world, EnumBeeType.DRONE));
                li.add(b.getBeeItem(world, EnumBeeType.PRINCESS));
                li.add(b.getBeeItem(world, EnumBeeType.QUEEN));
            }
            for (int i = 0; i < 16; ++i) {
                CrystalElement e = CrystalElement.elements[i];
                li.add(CrystalBees.getElementalBee(e).getBeeItem(world, EnumBeeType.DRONE));
                li.add(CrystalBees.getElementalBee(e).getBeeItem(world, EnumBeeType.PRINCESS));
                li.add(CrystalBees.getElementalBee(e).getBeeItem(world, EnumBeeType.QUEEN));
            }
            c = CrystalBees.getAdvancedBees();
            for (BeeSpecies b : c) {
                li.add(b.getBeeItem(world, EnumBeeType.DRONE));
                li.add(b.getBeeItem(world, EnumBeeType.PRINCESS));
                li.add(b.getBeeItem(world, EnumBeeType.QUEEN));
            }
            return li;
        }
        if (this == TINKERTOOLS) {
            int i;
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (i = 0; i < TinkerToolHandler.ToolParts.partList.length; ++i) {
                li.add(TinkerToolHandler.ToolParts.partList[i].getItem(ExtraChromaIDs.CHROMAMATID.getValue()));
            }
            for (i = 0; i < TinkerToolHandler.WeaponParts.partList.length; ++i) {
                li.add(TinkerToolHandler.ToolParts.partList[i].getItem(ExtraChromaIDs.CHROMAMATID.getValue()));
            }
            return li;
        }
        if (this == TANKAUX) {
            return ReikaJavaLibrary.makeListFrom((Object[])new ItemStack[]{ChromaBlocks.TANK.getStackOf(), ChromaBlocks.TANK.getStackOfMetadata(2)});
        }
        if (this == FENCEAUX || this == TNT) {
            return ReikaJavaLibrary.makeListFrom((Object)this.iconItem);
        }
        if (this == PROXESSENCE) {
            return ReikaJavaLibrary.makeListFrom((Object[])new ItemStack[]{ChromaStacks.bedrockloot, ChromaStacks.bedrockloot2});
        }
        if (this.block != null) {
            Item item = Item.func_150898_a((Block)this.block.getBlockInstance());
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            if (item instanceof ItemBlockDyeTypes || item instanceof ItemBlockCrystalColors || item instanceof ItemBlockCrystal) {
                for (int i = 0; i < 16; ++i) {
                    li.add(this.block.getStackOfMetadata(i));
                }
            } else {
                li.add(this.block.getStackOf());
            }
            return li;
        }
        if (this == APIRECIPES) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (CastingRecipe c : RecipesCastingTable.instance.getAllAPIRecipes()) {
                li.add(c.getOutput());
            }
            for (CastingRecipe c : RecipesCastingTable.instance.getAllModdedItemRecipes()) {
                li.add(c.getOutput());
            }
            return li;
        }
        return null;
    }

    public int getRecipeCount() {
        return this.getCraftingRecipes().size();
    }

    public int getVanillaRecipeCount() {
        return this.getVanillaRecipes().size();
    }

    public boolean isCraftable() {
        if (this == ALLOYS) {
            return true;
        }
        if (!this.isConfigDisabled() && this.isCrafting()) {
            return this.isVanillaRecipe() ? this.getVanillaRecipeCount() > 0 : this.getRecipeCount() > 0;
        }
        return false;
    }

    public boolean isVanillaRecipe() {
        switch (this) {
            case CASTTABLE: 
            case WAND: {
                return true;
            }
        }
        return false;
    }

    public boolean crafts(ItemStack is) {
        if (!this.isCrafting()) {
            return false;
        }
        if (this == ALLOYS) {
            return ReikaItemHelper.listContainsItemStack(this.getItemStacks(), (ItemStack)is, (boolean)false);
        }
        if (this.isVanillaRecipe()) {
            for (IRecipe ir : this.getVanillaRecipes()) {
                if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ir.func_77571_b())) continue;
                return true;
            }
        } else {
            for (CastingRecipe c : this.getCraftingRecipes()) {
                if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)c.getOutput())) continue;
                return true;
            }
        }
        return false;
    }

    public ChromaGuis getCraftingType() {
        if (this == ALLOYS) {
            return ChromaGuis.ALLOYING;
        }
        return this.isVanillaRecipe() ? ChromaGuis.CRAFTING : ChromaGuis.RECIPE;
    }

    public ArrayList<CastingRecipe> getCraftingRecipes() {
        if (this == APIRECIPES) {
            HashSet<CastingRecipe> li = new HashSet<CastingRecipe>();
            li.addAll(RecipesCastingTable.instance.getAllAPIRecipes());
            li.addAll(RecipesCastingTable.instance.getAllModdedItemRecipes());
            return new ArrayList<CastingRecipe>(li);
        }
        if (this == TURBOREPEATER) {
            ArrayList<CastingRecipe> li = new ArrayList<CastingRecipe>();
            for (CastingRecipe cr : RecipesCastingTable.instance.getAllRecipes()) {
                if (!(cr instanceof RepeaterTurboRecipe)) continue;
                li.add(cr);
            }
            return li;
        }
        if (!this.isCrafting()) {
            return new ArrayList<CastingRecipe>();
        }
        ArrayList<ItemStack> li = this.getItemStacks();
        if (li == null || li.isEmpty()) {
            return new ArrayList<CastingRecipe>();
        }
        ArrayList<CastingRecipe> rec = new ArrayList<CastingRecipe>();
        for (ItemStack is : li) {
            ArrayList<CastingRecipe> cr = RecipesCastingTable.instance.getAllRecipesMaking(is);
            for (CastingRecipe c : cr) {
                if (!c.isIndexed()) continue;
                rec.add(c);
            }
        }
        return rec;
    }

    public int getRecipeIndex(ItemStack is, EntityPlayer ep) {
        if (this == ALLOYS) {
            return new ArrayList<PoolRecipes.PoolRecipe>(PoolRecipes.instance.getAllPoolRecipesForPlayer(ep)).indexOf(PoolRecipes.instance.getPoolRecipeByOutput(is));
        }
        if (this == METEOR && is.field_77990_d != null) {
            return is.field_77990_d.func_74762_e("tier");
        }
        ArrayList<CastingRecipe> li = this.getCraftingRecipes();
        for (int i = 0; i < li.size(); ++i) {
            if (!ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)li.get(i).getOutput())) continue;
            return i;
        }
        return 0;
    }

    public CastingRecipe.RecipeType getRecipeLevel(int recipe) {
        ArrayList<CastingRecipe> li = this.getCraftingRecipes();
        if (li.isEmpty()) {
            return null;
        }
        return li.get((int)recipe).type;
    }

    public ArrayList<IRecipe> getVanillaRecipes() {
        if (!this.isCrafting()) {
            return new ArrayList<IRecipe>();
        }
        ArrayList<ItemStack> li = this.getItemStacks();
        if (li == null || li.isEmpty()) {
            return new ArrayList<IRecipe>();
        }
        ArrayList<IRecipe> rec = new ArrayList<IRecipe>();
        for (ItemStack is : li) {
            rec.addAll(ReikaRecipeHelper.getAllRecipesByOutput((List)CraftingManager.func_77594_a().func_77592_b(), (ItemStack)is));
        }
        return rec;
    }

    @Override
    public String getTitle() {
        if (this == ACCEL) {
            return "Adjacency Cores";
        }
        return this.pageTitle;
    }

    public ChromaResearch getParent() {
        ChromaResearch parent = null;
        for (int i = 0; i < researchList.length; ++i) {
            if (!ChromaResearch.researchList[i].isParent || this.ordinal() < researchList[i].ordinal()) continue;
            parent = researchList[i];
        }
        return parent;
    }

    public boolean isParent() {
        return this.isParent;
    }

    public boolean isConfigDisabled() {
        if (this.machine != null) {
            return this.machine.isConfigDisabled();
        }
        if (this.item != null) {
            return this.item.isConfigDisabled();
        }
        return false;
    }

    public boolean isDummiedOut() {
        if (this.machine != null) {
            return this.machine.isDummiedOut();
        }
        if (this.item != null) {
            return this.item.isDummiedOut();
        }
        if (this.ability != null) {
            return this.ability.isDummiedOut();
        }
        if (this == APIRECIPES && DragonAPICore.hasGameLoaded()) {
            return RecipesCastingTable.instance.getAllAPIRecipes().isEmpty() && RecipesCastingTable.instance.getAllModdedItemRecipes().isEmpty();
        }
        if (this == PACKCHANGES && !PackModificationTracker.instance.modificationsExist((DragonAPIMod)ChromatiCraft.instance)) {
            return true;
        }
        if (this == AUGMENT) {
            return true;
        }
        Dependency dep = this.getDependency();
        if (dep != null && !dep.isLoaded()) {
            return true;
        }
        for (int i = 0; i < this.progress.length; ++i) {
            if (this.progress[i].active) continue;
            return true;
        }
        return false;
    }

    public Dependency getDependency() {
        switch (this) {
            case BEES: {
                return ModList.FORESTRY;
            }
            case TINKERTOOLS: {
                return ModList.TINKERER;
            }
            case RFDISTRIB: {
                return PowerTypes.RF;
            }
            case BALLLIGHTNING: {
                return ChromaOptions.BALLLIGHTNING;
            }
            case NODENET: {
                return ModList.THAUMCRAFT;
            }
            case MYSTPAGE: {
                return ModList.MYSTCRAFT;
            }
            case DEATHFOG: 
            case VOIDTRAP: 
            case VOIDTRAPSTRUCT: {
                return ModList.VOIDMONSTER;
            }
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getShortDesc() {
        return "Something new to investigate";
    }

    @Override
    public String getFormatting() {
        return EnumChatFormatting.ITALIC.toString();
    }

    private Object getIDObject() {
        if (this.machine != null) {
            return this.machine;
        }
        if (this.block != null) {
            return this.block;
        }
        if (this.item != null) {
            return this.item;
        }
        if (this.ability != null) {
            return this.ability;
        }
        if (this.struct != null) {
            return this.struct;
        }
        return this.ordinal();
    }

    @Override
    public boolean giveToPlayer(EntityPlayer ep, boolean notify) {
        return ChromaResearchManager.instance.givePlayerFragment(ep, this, notify);
    }

    @Override
    public boolean playerHas(EntityPlayer ep) {
        return ChromaResearchManager.instance.playerHasFragment(ep, this);
    }

    public boolean playerCanSeeRecipe(ItemStack is, EntityPlayer ep) {
        if (this == ALLOYS) {
            return PoolRecipes.instance.getPoolRecipeByOutput(is).playerHasProgress(ep);
        }
        return true;
    }

    public static void loadPostCache() {
        for (int i = 0; i < researchList.length; ++i) {
            ChromaResearch r = researchList[i];
            if (r.isDummiedOut()) continue;
            try {
                ArrayList<ItemStack> c = r.getItemStacks();
                if (c != null) {
                    for (ItemStack is : c) {
                        if (is == null || is.func_77973_b() == null) continue;
                        itemMap.put(is, (Object)r);
                    }
                }
                ArrayList<CastingRecipe> crc = r.getCraftingRecipes();
                for (CastingRecipe cr : crc) {
                    cr.setFragment(r);
                }
                if (r.ability != null) {
                    abilityMap.put(r.ability, r);
                }
                if (r.machine == null) continue;
                tileMap.put(r.machine, r);
                continue;
            }
            catch (Exception e) {
                Dependency dep = r.getDependency();
                if (dep != null && !(dep instanceof ConfigList)) {
                    e.printStackTrace();
                    throw new InstallationException((DragonAPIMod)ChromatiCraft.instance, "Another mod/API, '" + dep.getDisplayName() + "' is an incompatible version. Update both mods if possible, or if updating " + dep.getDisplayName() + " caused this, revert to the previous version.");
                }
                throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Could not initialize Info Fragment '" + r + "'!", (Throwable)e);
            }
        }
    }

    public static ArrayList<ChromaResearch> getInfoTabs() {
        return ChromaResearch.getAllUnder(INTRO);
    }

    public static ArrayList<ChromaResearch> getMachineTabs() {
        return ChromaResearch.getAllUnder(MACHINEDESC);
    }

    public static ArrayList<ChromaResearch> getBlockTabs() {
        return ChromaResearch.getAllUnder(BLOCKS);
    }

    public static ArrayList<ChromaResearch> getAbilityTabs() {
        return ChromaResearch.getAllUnder(ABILITYDESC);
    }

    public static ArrayList<ChromaResearch> getToolTabs() {
        return ChromaResearch.getAllUnder(TOOLDESC);
    }

    public static ArrayList<ChromaResearch> getResourceTabs() {
        return ChromaResearch.getAllUnder(RESOURCEDESC);
    }

    public static ArrayList<ChromaResearch> getStructureTabs() {
        return ChromaResearch.getAllUnder(STRUCTUREDESC);
    }

    private static ArrayList<ChromaResearch> getAllUnder(ChromaResearch parent) {
        ChromaResearch r;
        ArrayList<ChromaResearch> li = new ArrayList<ChromaResearch>();
        for (int i = parent.ordinal() + 1; i < researchList.length && (r = researchList[i]).getParent() == parent; ++i) {
            li.add(r);
        }
        return li;
    }

    public static ChromaResearch getPageFor(ItemStack is) {
        return (ChromaResearch)itemMap.get(is);
    }

    public static ChromaResearch getPageFor(Chromabilities a) {
        return abilityMap.get(a);
    }

    public static ChromaResearch getPageFor(ChromaTiles c) {
        return tileMap.get((Object)c);
    }

    public static Collection<ChromaResearch> getPagesFor(ResearchLevel l) {
        return levelMap.get((Object)l);
    }

    public static List<ChromaResearch> getAllParents() {
        return Collections.unmodifiableList(parents);
    }

    public static List<ChromaResearch> getAllNonParents() {
        return Collections.unmodifiableList(nonParents);
    }

    public static List<ChromaResearch> getAllObtainableFragments() {
        return Collections.unmodifiableList(obtainable);
    }

    public static ChromaResearch getByName(String s) {
        return byName.get(s);
    }

    static {
        researchList = ChromaResearch.values();
        levelMap = new MultiMap(MultiMap.CollectionType.HASHSET);
        itemMap = new ItemHashMap();
        tileMap = new EnumMap(ChromaTiles.class);
        abilityMap = new HashMap();
        parents = new ArrayList<ChromaResearch>();
        nonParents = new ArrayList<ChromaResearch>();
        obtainable = new ArrayList<ChromaResearch>();
        byName = new HashMap();
        duplicateChecker = new IdentityHashMap();
        int index = 0;
        for (int i = 0; i < researchList.length; ++i) {
            ChromaResearch pre;
            ChromaResearch r = researchList[i];
            if (!r.isDummiedOut()) {
                if (r.level != null) {
                    levelMap.addValue((Object)r.level, (Object)r);
                }
                byName.put(r.name(), r);
                if (r.isParent) {
                    parents.add(r);
                    ++index;
                } else {
                    nonParents.add(r);
                    if (!r.isAlwaysPresent()) {
                        obtainable.add(r);
                    }
                    r.sectionIndex = index;
                }
            }
            if ((pre = duplicateChecker.get(r.getIDObject())) != null) {
                throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Two research fragments have the same block/item/ability/etc: " + r + " & " + pre);
            }
            duplicateChecker.put(r.getIDObject(), r);
            ChromaResearchManager.instance.register(r);
        }
    }
}

