/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Registry;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.IO.Shaders.ShaderHook;
import Reika.DragonAPI.IO.Shaders.ShaderProgram;
import Reika.DragonAPI.IO.Shaders.ShaderRegistry;
import java.util.Locale;

public enum ChromaShaders implements ShaderHook
{
    PYLON,
    DIMCORE,
    AURALOC,
    DATANODE,
    PORTAL,
    PORTAL_INCOMPLETE,
    VOIDTRAP,
    WARPNODE,
    WARPNODE_OPEN,
    STRUCTCONTROL,
    DIMGLOWCLOUD,
    VACGUN,
    LENSPARTICLE,
    PINCHPARTICLE,
    CRYSTALLIZEPARTICLE,
    INSKYRIVER,
    DIMFLOOR,
    GAINPROGRESS,
    PYLONAURA,
    PYLONTURBO$OVERBRIGHT,
    PYLONTURBO$PINCH(ShaderRegistry.ShaderDomain.GLOBAL),
    VOIDRITUAL$SPHERE,
    VOIDRITUAL$WORLD(ShaderRegistry.ShaderDomain.WORLD),
    ARTEALLOY$SHOCK,
    ARTEALLOY$GLOW,
    MONUMENT$GENERAL,
    MONUMENT$CHORDS(ShaderRegistry.ShaderDomain.WORLD);

    private final ShaderRegistry.ShaderDomain domain;
    private ShaderProgram shader;
    private float intensity;
    public boolean clearOnRender = false;
    public float rampDownFactor = 1.0f;
    public float rampDownAmount;
    public int lingerTime;
    private int renderAge;
    private static boolean registered;
    public static final ChromaShaders[] shaders;
    private String id;

    private ChromaShaders() {
        this(ShaderRegistry.ShaderDomain.GLOBALNOGUI);
    }

    private ChromaShaders(ShaderRegistry.ShaderDomain d) {
        this.domain = d;
    }

    public ShaderProgram getShader() {
        return this.shader;
    }

    public void create() {
        try {
            int idx;
            String path = "Shaders/";
            this.id = this.name().toLowerCase(Locale.ENGLISH);
            if (this == GAINPROGRESS && ChromaOptions.PROGSHADER.getState()) {
                this.id = "gainprogress2";
            }
            if ((idx = this.id.indexOf(36)) >= 0) {
                path = path + this.id.substring(0, idx) + "/";
                this.id = this.id.substring(idx + 1);
            }
            this.shader = ShaderRegistry.createShader((DragonAPIMod)ChromatiCraft.instance, (String)this.id, ChromatiCraft.class, (String)path, (ShaderRegistry.ShaderDomain)this.domain);
            this.shader.setHook((ShaderHook)this);
        }
        catch (Exception e) {
            throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Could not create shader " + (Object)((Object)this) + "!", (Throwable)e);
        }
    }

    public static void registerAll() {
        if (registered) {
            return;
        }
        for (int i = 0; i < shaders.length; ++i) {
            ChromaShaders s = shaders[i];
            s.create();
        }
        registered = true;
    }

    public void onPreRender(ShaderProgram s) {
        s.setEnabled(this.intensity > 0.0f);
        s.setIntensity(this.intensity);
    }

    public void setIntensity(float f) {
        this.intensity = f;
    }

    public void rampUpIntensity(float linear, float factor) {
        this.intensity = Math.min(1.0f, this.intensity * factor + linear);
    }

    public void rampDownIntensity(float linear, float factor) {
        this.intensity = Math.max(0.0f, this.intensity * factor - linear);
    }

    public float getIntensity() {
        return this.intensity;
    }

    public void onPostRender(ShaderProgram s) {
        if (this.clearOnRender && !s.hasOngoingFoci()) {
            this.intensity = 0.0f;
            s.clearFoci();
        }
        ++this.renderAge;
        if (this.renderAge > this.lingerTime && (this.rampDownAmount > 0.0f || this.rampDownFactor < 1.0f)) {
            this.rampDownIntensity(this.rampDownAmount, this.rampDownFactor);
        }
    }

    public void updateEnabled(ShaderProgram s) {
        s.setEnabled(this.intensity > 0.0f);
    }

    public void refresh() {
        this.renderAge = 0;
    }

    static {
        registered = false;
        shaders = ChromaShaders.values();
    }
}

