/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Registry;

import Reika.ChromatiCraft.Auxiliary.Interfaces.ChromaSound;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.IO.SoundVariant;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Interfaces.Registry.VariableSound;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public enum ChromaSounds implements ChromaSound,
VariableSound
{
    RIFT("rift"),
    POWERDOWN("powerdown-2"),
    DISCHARGE("discharge"),
    CAST("cast3"),
    POWER("ambient"),
    CRAFTING("ambient1_short"),
    CRAFTING_BOOST("ambient1_short_boost"),
    CRAFTDONE("craftdone2"),
    UPGRADE("upgrade"),
    ABILITY("ability"),
    ERROR("error"),
    INFUSE("infuse"),
    INFUSION("infuse2"),
    INFUSION_SHORT("infuse2s"),
    USE("use2"),
    TRAP("slam2"),
    DING("ding2", true),
    SHOCKWAVE("shockwave3"),
    BALLLIGHTNING("balllightning"),
    ITEMSTAND("stand"),
    GLOWCLOUD("powercrystal"),
    GUICLICK("gui2"),
    GUISEL("gui4"),
    DRONE("drone2"),
    DRONE_HI("drone2_hi"),
    PORTAL("portal2"),
    ORB("orb/orb", true),
    GOTODIM("todim"),
    OVERLOAD("discharge2"),
    PYLONFLASH("pylonboost"),
    PYLONTURBO("pylonturbo"),
    PYLONBOOSTRITUAL("pylonboost_ritual_short"),
    PYLONBOOSTSTART("pylonbooststart"),
    DASH("dash"),
    REPEATERSURGE("repeatersurge"),
    REPEATERSURGE_WEAK("repeatersurge_weak"),
    FIRE("fire"),
    LASER("laser"),
    MONUMENT("monument/s"),
    MONUMENTRAY("monumentray"),
    BUFFERWARNING("buffer_warning"),
    BUFFERWARNING_LOW("buffer_warning2"),
    BUFFERWARNING_EMPTY("buffer_warning3"),
    KILLAURA("killaura"),
    KILLAURA_CHARGE("killaura_charge"),
    POWERCRAFT("powercraft"),
    METEOR("meteor"),
    IMPACT("impact"),
    NOCLIPON("rumble-in"),
    NOCLIPOFF("rumble-out"),
    NOCLIPRUN("rumble"),
    FLAREATTACK("flareattack"),
    BOUNCE("bounce"),
    SKYRIVER("lumenstream"),
    PING("ping2"),
    GAINPROGRESS("progress2"),
    AVOLASER("avolaser2"),
    CLIFFSOUND("cliffambience"),
    CLIFFSOUND2("cliffambience2"),
    CLIFFSOUND3("cliffambience3"),
    CLIFFSOUND4("cliffambience4"),
    INSCRIBE("inscribe"),
    LOREHEX("lore"),
    LORECOMPLETE("lorecomplete2"),
    LIGHTCAST("lightcast"),
    WATERLOCK("waterlock"),
    REPEATERRING("repeaterring"),
    FAIL("fail"),
    DIMENSIONHUM("dimensionhum"),
    DIMENSIONHUM_HI("dimensionhum_hi"),
    RADIANCE("radiance2"),
    CASTHARMONIC("castingharmonic2"),
    ABILITYCOMPLETE("abilityfinish2"),
    NETWORKOPT("networkopt"),
    NETWORKOPTCHARGE("networkopt_charge2"),
    TUNNELNUKERAMBIENT("nukerfly2"),
    TUNNELNUKERCALL("nukercall"),
    TOWEREXTEND1("tower_extend_1"),
    TOWEREXTEND2("tower_extend_2b"),
    TOWERAMBIENT("tower_ambient2"),
    CASTTUNEREJECT("casttunereject"),
    DINGCHARGE("dingcharge"),
    ARTEALLOY("artealloy2b"),
    ARTEALLOYHIT("artealloy-hit2"),
    LOWAMBIENT("lowambient_fade"),
    LOWAMBIENT_SHORT("lowambient_fade_short"),
    AURALOCUS("auralocus");

    public static final ChromaSounds[] soundList;
    public static final String PREFIX = "Reika/ChromatiCraft/";
    public static final String SOUND_FOLDER = "Sounds/";
    private static final String SOUND_PREFIX = "Reika.ChromatiCraft.Sounds.";
    private static final String SOUND_DIR = "Sounds/";
    private static final String SOUND_EXT = ".ogg";
    private final String path;
    private final String relative;
    private final String folder;
    private final boolean widePitch;
    private final HashMap<String, SoundVariant> variants = new HashMap();
    private boolean isVolumed = false;

    private ChromaSounds(String n2) {
        this(n2, false);
    }

    private ChromaSounds(String n2, boolean wide) {
        if (n2.startsWith("#")) {
            this.isVolumed = true;
            n2 = n2.substring(1);
        }
        this.relative = n2;
        String f = "";
        int idx = n2.lastIndexOf(47);
        if (idx >= 0) {
            f = n2.substring(0, idx);
        }
        this.folder = f;
        this.widePitch = wide;
        this.path = "Reika/ChromatiCraft/Sounds/" + n2 + SOUND_EXT;
        if (this.hasWiderPitchRange()) {
            this.createVariant("LO");
            this.createVariant("HI");
        }
    }

    private ChromaSoundVariant createVariant(String name) {
        ChromaSoundVariant var = new ChromaSoundVariant(this, name);
        this.variants.put(name, var);
        return var;
    }

    public float getSoundVolume() {
        float vol = 1.0f;
        if (vol < 0.0f) {
            vol = 0.0f;
        }
        if (vol > 1.0f) {
            vol = 1.0f;
        }
        return vol;
    }

    public float getModulatedVolume() {
        if (!this.isVolumed) {
            return 1.0f;
        }
        return this.getSoundVolume();
    }

    public void playSound(Entity e) {
        this.playSound(e, 1.0f, 1.0f);
    }

    public void playSound(Entity e, float vol, float pitch) {
        this.playSound(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, vol, pitch);
    }

    public void playSound(World world, double x, double y, double z, float vol, float pitch) {
        if (world.field_72995_K) {
            return;
        }
        ReikaSoundHelper.playSound((SoundEnum)this, (World)world, (double)x, (double)y, (double)z, (float)vol, (float)pitch);
    }

    public void playSound(World world, double x, double y, double z, float vol, float pitch, boolean attenuate) {
        if (world.field_72995_K) {
            return;
        }
        ReikaSoundHelper.playSound((SoundEnum)this, (World)world, (double)x, (double)y, (double)z, (float)vol, (float)pitch, (boolean)attenuate);
    }

    @Override
    public void playSoundAtBlock(World world, int x, int y, int z, float vol, float pitch) {
        this.playSound(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, vol, pitch);
    }

    public void playSoundAtBlock(World world, int x, int y, int z) {
        this.playSound(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 1.0f, 1.0f);
    }

    @Override
    public void playSoundAtBlock(TileEntity te, float vol, float pitch) {
        this.playSoundAtBlock(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e, vol, pitch);
    }

    @Override
    public void playSoundAtBlockNoAttenuation(TileEntity te, float vol, float pitch, int broadcast) {
        this.playSoundNoAttenuation(te.field_145850_b, (double)te.field_145851_c + 0.5, (double)te.field_145848_d + 0.5, (double)te.field_145849_e + 0.5, vol, pitch, broadcast);
    }

    public void playSoundNoAttenuation(World world, double x, double y, double z, float vol, float pitch, int broadcast) {
        if (world.field_72995_K) {
            return;
        }
        ReikaPacketHelper.sendSoundPacket((SoundEnum)this, (World)world, (double)x, (double)y, (double)z, (float)vol, (float)pitch, (boolean)false, (int)broadcast);
    }

    public void playSoundAtBlock(TileEntity te) {
        this.playSoundAtBlock(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public void playSoundAtBlock(WorldLocation loc) {
        this.playSoundAtBlock(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord);
    }

    public String getName() {
        return this.name();
    }

    public String getPath() {
        return this.path;
    }

    public URL getURL() {
        return ChromatiCraft.class.getResource("Sounds/" + this.relative + SOUND_EXT);
    }

    @SideOnly(value=Side.CLIENT)
    public SoundCategory getCategory() {
        if (this == GLOWCLOUD || this == BALLLIGHTNING) {
            return SoundCategory.MOBS;
        }
        return SoundCategory.MASTER;
    }

    public boolean canOverlap() {
        return this == RIFT || this == CAST || this == USE || this == ERROR || this == INFUSE || this == DING || this == DRONE || this == ITEMSTAND || this == KILLAURA_CHARGE || this == DASH || this == ORB;
    }

    public boolean attenuate() {
        return this != GOTODIM && this != PYLONTURBO && this != PYLONFLASH && this != PYLONBOOSTRITUAL && this != PYLONBOOSTSTART && this != REPEATERSURGE && this != MONUMENT && this != MONUMENTRAY && this != GAINPROGRESS && this != LORECOMPLETE;
    }

    @Override
    public boolean hasWiderPitchRange() {
        return this.widePitch;
    }

    @Override
    public ChromaSound getUpshiftedPitch() {
        ChromaSound ret = (ChromaSound)this.getVariant("HI");
        return ret != null ? ret : this;
    }

    @Override
    public ChromaSound getDownshiftedPitch() {
        ChromaSound ret = (ChromaSound)this.getVariant("LO");
        return ret != null ? ret : this;
    }

    public boolean preload() {
        switch (this) {
            case MONUMENT: 
            case CRAFTING: 
            case CRAFTING_BOOST: 
            case POWERCRAFT: 
            case INFUSION: 
            case ABILITY: 
            case GOTODIM: 
            case PYLONBOOSTRITUAL: 
            case REPEATERSURGE: {
                return true;
            }
        }
        return false;
    }

    public float getAudibleDistance() {
        switch (this) {
            case POWER: {
                return 27.0f;
            }
        }
        return -1.0f;
    }

    public String getRelativePath() {
        return "Sounds/" + this.relative + SOUND_EXT;
    }

    private String getFolder() {
        return this.folder.isEmpty() ? "" : this.folder + "/";
    }

    public Collection<SoundVariant> getVariants() {
        return Collections.unmodifiableCollection(this.variants.values());
    }

    public SoundVariant getVariant(String name) {
        return this.variants.get(name);
    }

    @Override
    public float getRangeInterval() {
        return 4.0f;
    }

    public boolean isStreamed() {
        return this == MONUMENT;
    }

    static {
        soundList = ChromaSounds.values();
        ORB.createVariant("PURE");
        ORB.createVariant("PURE_HI");
        ORB.createVariant("PURE_LO");
        for (int i = 1; i <= 6; ++i) {
            MONUMENT.createVariant(String.valueOf(i));
        }
    }

    private static class ChromaSoundVariant
    extends SoundVariant<ChromaSounds>
    implements ChromaSound {
        protected ChromaSoundVariant(ChromaSounds s, String k) {
            super((SoundEnum)s, k, "Reika/ChromatiCraft/Sounds/" + s.relative + "_" + k.toLowerCase(Locale.ENGLISH) + ChromaSounds.SOUND_EXT);
        }

        public String getRelativePath() {
            return "Sounds/" + ((ChromaSounds)this.root).relative + "_" + this.key.toLowerCase(Locale.ENGLISH) + ChromaSounds.SOUND_EXT;
        }

        public void playSound(Entity e) {
            this.playSound(e, 1.0f, 1.0f);
        }

        public void playSound(Entity e, float vol, float pitch) {
            this.playSound(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, vol, pitch);
        }

        public void playSound(World world, double x, double y, double z, float vol, float pitch) {
            if (world.field_72995_K) {
                return;
            }
            ReikaSoundHelper.playSound((SoundEnum)this, (World)world, (double)x, (double)y, (double)z, (float)vol, (float)pitch);
        }

        public void playSound(World world, double x, double y, double z, float vol, float pitch, boolean attenuate) {
            if (world.field_72995_K) {
                return;
            }
            ReikaSoundHelper.playSound((SoundEnum)this, (World)world, (double)x, (double)y, (double)z, (float)vol, (float)pitch, (boolean)attenuate);
        }

        @Override
        public void playSoundAtBlock(World world, int x, int y, int z, float vol, float pitch) {
            this.playSound(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, vol, pitch);
        }

        public void playSoundAtBlock(World world, int x, int y, int z) {
            this.playSound(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 1.0f, 1.0f);
        }

        @Override
        public void playSoundAtBlock(TileEntity te, float vol, float pitch) {
            this.playSoundAtBlock(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e, vol, pitch);
        }

        @Override
        public void playSoundAtBlockNoAttenuation(TileEntity te, float vol, float pitch, int broadcast) {
            this.playSoundNoAttenuation(te.field_145850_b, (double)te.field_145851_c + 0.5, (double)te.field_145848_d + 0.5, (double)te.field_145849_e + 0.5, vol, pitch, broadcast);
        }

        public void playSoundNoAttenuation(World world, double x, double y, double z, float vol, float pitch, int broadcast) {
            if (world.field_72995_K) {
                return;
            }
            ReikaPacketHelper.sendSoundPacket((SoundEnum)this, (World)world, (double)x, (double)y, (double)z, (float)vol, (float)pitch, (boolean)false, (int)broadcast);
        }

        public void playSoundAtBlock(TileEntity te) {
            this.playSoundAtBlock(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e);
        }

        public void playSoundAtBlock(WorldLocation loc) {
            this.playSoundAtBlock(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord);
        }

        @Override
        public boolean hasWiderPitchRange() {
            return ((ChromaSounds)this.root).hasWiderPitchRange();
        }

        @Override
        public ChromaSound getUpshiftedPitch() {
            return (ChromaSound)((ChromaSounds)this.root).getVariant(this.key + "_HI");
        }

        @Override
        public ChromaSound getDownshiftedPitch() {
            return (ChromaSound)((ChromaSounds)this.root).getVariant(this.key + "_LO");
        }

        @Override
        public float getRangeInterval() {
            return ((ChromaSounds)this.root).getRangeInterval();
        }

        public boolean isStreamed() {
            return ((ChromaSounds)this.root).isStreamed();
        }

        public float getAudibleDistance() {
            return ((ChromaSounds)this.root).getAudibleDistance();
        }
    }
}

