/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Registry;

import Reika.ChromatiCraft.API.AbilityAPI;
import Reika.ChromatiCraft.Auxiliary.Ability.AbilityCalls;
import Reika.ChromatiCraft.Auxiliary.Ability.AbilityHelper;
import Reika.ChromatiCraft.Auxiliary.Ability.AbilitySorter;
import Reika.ChromatiCraft.Auxiliary.ChromaDescriptions;
import Reika.ChromatiCraft.Auxiliary.Render.ChromaFontRenderer;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.PlayerElementBuffer;
import Reika.ChromatiCraft.Magic.Progression.ChromaResearchManager;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.ScaledDirection;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.ModList;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.StatCollector;

public enum Chromabilities implements AbilityAPI.Ability
{
    REACH(null, true),
    MAGNET(TickEvent.Phase.END, false),
    SONIC(null, true),
    SHIFT(null, false),
    HEAL(null, false),
    SHIELD(TickEvent.Phase.START, false),
    FIREBALL(null, false),
    COMMUNICATE(TickEvent.Phase.START, false),
    HEALTH(null, true),
    PYLON(null, false),
    LIGHTNING(null, false),
    LIFEPOINT(null, false, ModList.BLOODMAGIC),
    DEATHPROOF(null, false),
    HOTBAR(null, true),
    SHOCKWAVE(null, true),
    TELEPORT(null, true),
    LEECH(null, false),
    FLOAT(TickEvent.Phase.END, true),
    SPAWNERSEE(null, true),
    BREADCRUMB(null, true),
    RANGEDBOOST(null, false),
    DIMPING(null, false),
    DASH(TickEvent.Phase.END, false),
    LASER(null, true),
    FIRERAIN(TickEvent.Phase.START, true),
    KEEPINV(null, false),
    ORECLIP(TickEvent.Phase.START, true),
    DOUBLECRAFT(null, true),
    GROWAURA(TickEvent.Phase.END, true),
    RECHARGE(null, false),
    MEINV(null, false, ModList.APPENG),
    MOBSEEK(null, true),
    BEEALYZE(null, true),
    NUKER(TickEvent.Phase.START, false),
    LIGHTCAST(null, false),
    JUMP(null, false),
    SUPERBUILD(null, false),
    CHESTCLEAR(TickEvent.Phase.END, false),
    MOBBAIT(null, false);

    private final boolean tickBased;
    private final TickEvent.Phase tickPhase;
    private final boolean actOnClient;
    private ModList dependency;
    public static final UUID HEALTH_UUID;
    public static final UUID FAKE_UUID;
    public static final int MAX_REACH = 128;
    private static long lastNullPlayerDump;
    private static final String NBT_TAG = "chromabilities";
    private static final HashMap<String, AbilityAPI.Ability> tagMap;
    private static final Chromabilities[] abilities;
    private static final HashMap<String, AbilityAPI.Ability> abilityMap;
    private static final HashBiMap<Integer, AbilityAPI.Ability> intMap;
    private static int maxID;
    private static ArrayList<AbilityAPI.Ability> sortedList;
    private static final MultiMap<TickEvent.Phase, AbilityAPI.Ability> tickAbilities;

    private Chromabilities(TickEvent.Phase tick, boolean client) {
        this(tick, client, null);
    }

    private Chromabilities(TickEvent.Phase tick, boolean client, ModList mod) {
        this.tickBased = tick != null;
        this.tickPhase = tick;
        this.actOnClient = client;
        this.dependency = mod;
    }

    public static AbilityAPI.Ability getAbility(String id) {
        return abilityMap.get(id);
    }

    public static List<AbilityAPI.Ability> getAbilities() {
        return Collections.unmodifiableList(sortedList);
    }

    public static Collection<AbilityAPI.Ability> getAbilitiesAvailableToPlayer(EntityPlayer ep) {
        ArrayList<AbilityAPI.Ability> li = new ArrayList<AbilityAPI.Ability>();
        for (AbilityAPI.Ability c : sortedList) {
            if (!c.isAvailableToPlayer(ep)) continue;
            li.add(c);
        }
        return li;
    }

    public static Collection<AbilityAPI.Ability> getAbilitiesForTick(TickEvent.Phase p) {
        return Collections.unmodifiableCollection(tickAbilities.get((Object)p));
    }

    @Override
    public boolean isAvailableToPlayer(EntityPlayer ep) {
        return AbilityHelper.instance.playerCanGetAbility(this, ep);
    }

    @Override
    public String getDisplayName() {
        String s = StatCollector.func_74838_a((String)("chromability." + this.name().toLowerCase(Locale.ENGLISH)));
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && DragonAPICore.hasGameLoaded()) {
            s = this.deobfuscateIf(s);
        }
        return s;
    }

    @SideOnly(value=Side.CLIENT)
    private String deobfuscateIf(String s) {
        if (!ChromaResearchManager.instance.playerHasFragment((EntityPlayer)Minecraft.func_71410_x().field_71439_g, ChromaResearch.getPageFor(this))) {
            s = ChromaFontRenderer.FontType.OBFUSCATED.id + s;
        }
        return s;
    }

    @Override
    public String getDescription() {
        return ChromaDescriptions.getAbilityDescription(this);
    }

    @Override
    public boolean isTickBased() {
        return this.tickBased;
    }

    @Override
    public TickEvent.Phase getTickPhase() {
        return this.tickPhase;
    }

    @Override
    public boolean actOnClient() {
        return this.actOnClient;
    }

    public ModList getModDependency() {
        return this.dependency;
    }

    public boolean isDummiedOut() {
        if (this == HOTBAR) {
            return true;
        }
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment()) {
            return false;
        }
        return this.dependency != null && !this.dependency.isLoaded();
    }

    public ElementTagCompound getTickCost(EntityPlayer ep) {
        return Chromabilities.getTickCost(this, ep);
    }

    public static ElementTagCompound getTickCost(AbilityAPI.Ability c, EntityPlayer ep) {
        if (c.isTickBased() || c.costsPerTick()) {
            return AbilityHelper.instance.getUsageElementsFor(c, ep);
        }
        return null;
    }

    @Override
    public boolean costsPerTick() {
        switch (this) {
            case HEALTH: 
            case PYLON: 
            case LEECH: 
            case DEATHPROOF: 
            case BREADCRUMB: 
            case SPAWNERSEE: 
            case REACH: 
            case RANGEDBOOST: 
            case FIRERAIN: 
            case KEEPINV: 
            case DASH: 
            case ORECLIP: 
            case GROWAURA: 
            case RECHARGE: 
            case MEINV: 
            case MOBSEEK: 
            case BEEALYZE: 
            case NUKER: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void apply(EntityPlayer ep) {
        switch (this) {
            case MAGNET: {
                AbilityCalls.attractItemsAndXP(ep, 24, AbilityHelper.instance.isMagnetNoClip(ep));
                break;
            }
            case SHIELD: {
                AbilityCalls.stopArrows(ep);
                break;
            }
            case COMMUNICATE: {
                AbilityCalls.deAggroMobs(ep);
                break;
            }
            case FLOAT: {
                AbilityCalls.waterRun(ep);
                break;
            }
            case DASH: {
                PotionEffect pot = ep.func_70660_b(Potion.field_76424_c);
                if (pot != null && pot.func_76458_c() >= 60) {
                    ep.field_70138_W = 2.75f;
                    break;
                }
                ep.field_70138_W = 0.5f;
                break;
            }
            case FIRERAIN: {
                AbilityCalls.tickFireRain(ep);
                break;
            }
            case GROWAURA: {
                AbilityCalls.doGrowthAura(ep);
                break;
            }
            case ORECLIP: {
                AbilityCalls.setNoclipState(ep, true);
                break;
            }
            case BEEALYZE: {
                AbilityCalls.analyzeBees(ep);
                break;
            }
            case NUKER: {
                AbilityCalls.breakSurroundingBlocks(ep);
                break;
            }
            case CHESTCLEAR: {
                AbilityCalls.doChestCollection((EntityPlayerMP)ep);
                break;
            }
        }
    }

    @Override
    public boolean trigger(EntityPlayer ep, int data) {
        switch (this) {
            case REACH: {
                AbilityCalls.setReachDistance(ep, this.enabledOn(ep) ? AbilityHelper.REACH_SCALE[data] : -1);
                return true;
            }
            case SONIC: {
                AbilityCalls.destroyBlocksAround(ep, data);
                return true;
            }
            case SHIFT: {
                if (this.enabledOn(ep)) {
                    AbilityHelper.instance.startDrawingBoxes(ep);
                    AbilityHelper.instance.shifts.put(ep, (Object)new ScaledDirection(ReikaEntityHelper.getDirectionFromEntityLook((EntityLivingBase)ep, (boolean)true), data));
                } else {
                    AbilityHelper.instance.stopDrawingBoxes(ep);
                    AbilityHelper.instance.shifts.remove(ep);
                }
                return true;
            }
            case HEAL: {
                AbilityCalls.healPlayer(ep, data);
                return true;
            }
            case FIREBALL: {
                AbilityCalls.launchFireball(ep, data);
                return true;
            }
            case HEALTH: {
                AbilityCalls.setPlayerMaxHealth(ep, this.enabledOn(ep) ? data : 0);
                return true;
            }
            case LIGHTNING: {
                return AbilityCalls.spawnLightning(ep, data);
            }
            case LIFEPOINT: {
                AbilityCalls.convertBufferToLP(ep, data);
                return true;
            }
            case HOTBAR: {
                AbilityCalls.addInvPage(ep);
                return true;
            }
            case SHOCKWAVE: {
                AbilityCalls.causeShockwave(ep);
                return true;
            }
            case TELEPORT: {
                AbilityCalls.teleportPlayerMenu(ep);
                return true;
            }
            case BREADCRUMB: {
                AbilityHelper.instance.setPathLength(ep, this.enabledOn(ep) ? ReikaMathLibrary.intpow2((int)2, (int)data) : 0);
                return true;
            }
            case DIMPING: {
                AbilityCalls.doDimensionPing(ep);
                return true;
            }
            case LASER: {
                return AbilityCalls.doLaserPulse(ep);
            }
            case LIGHTCAST: {
                return AbilityCalls.doLightCast(ep);
            }
            case JUMP: {
                return AbilityCalls.doJump(ep, data);
            }
            case MOBBAIT: {
                return AbilityCalls.doMobBait(ep);
            }
        }
        return false;
    }

    public static void triggerAbility(EntityPlayer ep, AbilityAPI.Ability a, int data) {
        Chromabilities.triggerAbility(ep, a, data, 1.0f);
    }

    public static void triggerAbility(EntityPlayer ep, AbilityAPI.Ability a, int data, float costScale) {
        if (ep.field_70170_p.field_72995_K) {
            ReikaPacketHelper.sendPacketToServer((String)"ChromaData", (int)ChromaPackets.ABILITY.ordinal(), (int[])new int[]{Chromabilities.getAbilityInt(a), data});
            if (!a.actOnClient()) {
                return;
            }
        } else if (a.actOnClient() && a.isPureEventDriven()) {
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.ABILITYSEND.ordinal(), (PacketTarget)PacketTarget.allPlayers, (int[])new int[]{Chromabilities.getAbilityInt(a), data, ep.func_145782_y()});
        }
        ProgressStage.ABILITY.stepPlayerTo(ep);
        ElementTagCompound use = AbilityHelper.instance.getUsageElementsFor(a, ep);
        use.scale(costScale);
        if (a == HEALTH) {
            use.scale(10 * (1 + data));
        }
        if (a == SHIFT) {
            use.scale(10.0f);
        }
        if (a == LIGHTNING) {
            use.scale(10 * (1 + data * data));
        }
        if (a == BREADCRUMB) {
            use.scale(5 * (1 + data * 4));
        }
        if (a == LIFEPOINT) {
            use.scale(5.0f);
        }
        if (a == DIMPING) {
            use.scale(125.0f);
        }
        if (a == LASER) {
            use.scale(800.0f);
        }
        if (a == LIGHTCAST) {
            use.scale(20.0f);
        }
        if (a == JUMP) {
            use.scale(1 + data);
        }
        boolean flag = Chromabilities.enabledOn(ep, a) || a.isPureEventDriven();
        Chromabilities.setToPlayer(ep, !flag, a);
        if (flag) {
            a.onRemoveFromPlayer(ep);
        }
        if (a == MAGNET) {
            AbilityHelper.instance.setNoClippingMagnet(ep, !flag && data > 0);
        }
        if (a == GROWAURA) {
            AbilityHelper.instance.setGrowAuraState(ep, !flag ? data : 0);
        }
        if (!a.isTickBased() && a.trigger(ep, data)) {
            PlayerElementBuffer.instance.removeFromPlayer(ep, use);
        }
    }

    @Override
    public boolean isPureEventDriven() {
        switch (this) {
            case SONIC: 
            case HEAL: 
            case FIREBALL: 
            case LIGHTNING: 
            case HOTBAR: 
            case SHOCKWAVE: 
            case TELEPORT: 
            case DIMPING: 
            case LASER: 
            case LIGHTCAST: 
            case JUMP: 
            case MOBBAIT: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isFunctioningOn(EntityPlayer ep) {
        switch (this) {
            case COMMUNICATE: {
                return AbilityHelper.instance.isPeaceActive(ep);
            }
        }
        return true;
    }

    public static ArrayList<AbilityAPI.Ability> getFrom(EntityPlayer ep) {
        ArrayList<AbilityAPI.Ability> li = new ArrayList<AbilityAPI.Ability>();
        NBTTagCompound nbt = ep.getEntityData();
        NBTTagCompound abilities = nbt.func_74775_l(NBT_TAG);
        if (abilities != null && !abilities.func_82582_d()) {
            for (String n : abilities.func_150296_c()) {
                AbilityAPI.Ability c;
                if (!abilities.func_74767_n(n) || (c = tagMap.get(n)) == null) continue;
                li.add(c);
            }
        }
        return li;
    }

    public static ArrayList<AbilityAPI.Ability> getAvailableFrom(EntityPlayer ep) {
        ArrayList<AbilityAPI.Ability> li = new ArrayList<AbilityAPI.Ability>();
        NBTTagCompound nbt = ep.getEntityData();
        NBTTagCompound abilities = nbt.func_74775_l(NBT_TAG);
        if (abilities != null && !abilities.func_82582_d()) {
            for (String n : abilities.func_150296_c()) {
                AbilityAPI.Ability c = tagMap.get(n);
                if (c == null) continue;
                li.add(c);
            }
        }
        return li;
    }

    public static HashMap<AbilityAPI.Ability, Boolean> getAbilitiesOn(EntityPlayer ep) {
        HashMap<AbilityAPI.Ability, Boolean> li = new HashMap<AbilityAPI.Ability, Boolean>();
        NBTTagCompound nbt = ep.getEntityData();
        NBTTagCompound abilities = nbt.func_74775_l(NBT_TAG);
        if (abilities != null && !abilities.func_82582_d()) {
            for (String n : abilities.func_150296_c()) {
                AbilityAPI.Ability c = tagMap.get(n);
                if (c == null) continue;
                li.put(c, abilities.func_74767_n(n));
            }
        }
        return li;
    }

    public boolean enabledOn(EntityPlayer ep) {
        return Chromabilities.enabledOn(ep, this);
    }

    public boolean playerHasAbility(EntityPlayer ep) {
        return Chromabilities.playerHasAbility(ep, this);
    }

    public void setToPlayer(EntityPlayer ep, boolean set) {
        Chromabilities.setToPlayer(ep, set, this);
    }

    public void give(EntityPlayer ep) {
        Chromabilities.give(ep, this);
    }

    public static void give(EntityPlayer ep, AbilityAPI.Ability a) {
        Chromabilities.setToPlayer(ep, false, a, true);
    }

    public void removeFromPlayer(EntityPlayer ep) {
        Chromabilities.removeFromPlayer(ep, this);
    }

    public static boolean enabledOn(EntityPlayer ep, AbilityAPI.Ability a) {
        if (ep == null) {
            if (System.currentTimeMillis() - lastNullPlayerDump > 5000L) {
                ChromatiCraft.logger.logError((Object)"Tried to get ability status of null player!?");
                Thread.dumpStack();
                lastNullPlayerDump = System.currentTimeMillis();
            }
            return false;
        }
        NBTTagCompound nbt = ep.getEntityData();
        NBTTagCompound abilities = nbt.func_74775_l(NBT_TAG);
        return abilities != null && abilities.func_74767_n(a.getID());
    }

    public static boolean playerHasAbility(EntityPlayer ep, String id) {
        return Chromabilities.playerHasAbility(ep, Chromabilities.getAbility(id));
    }

    public static boolean playerHasAbility(EntityPlayer ep, AbilityAPI.Ability a) {
        NBTTagCompound nbt = ep.getEntityData();
        NBTTagCompound abilities = nbt.func_74775_l(NBT_TAG);
        return abilities != null && abilities.func_74764_b(a.getID());
    }

    public static void setToPlayer(EntityPlayer ep, boolean set, AbilityAPI.Ability a) {
        Chromabilities.setToPlayer(ep, set, a, false);
    }

    private static void setToPlayer(EntityPlayer ep, boolean set, AbilityAPI.Ability a, boolean force) {
        NBTTagCompound nbt = ep.getEntityData();
        NBTTagCompound abilities = nbt.func_74775_l(NBT_TAG);
        if (abilities == null) {
            abilities = new NBTTagCompound();
        }
        if (force || set || abilities.func_74764_b(a.getID())) {
            abilities.func_74757_a(a.getID(), set);
        }
        nbt.func_74782_a(NBT_TAG, (NBTBase)abilities);
        if (ep instanceof EntityPlayerMP) {
            ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
        }
    }

    public static void removeFromPlayer(EntityPlayer ep, AbilityAPI.Ability a) {
        NBTTagCompound nbt = ep.getEntityData();
        NBTTagCompound abilities = nbt.func_74775_l(NBT_TAG);
        if (abilities == null) {
            abilities = new NBTTagCompound();
        }
        abilities.func_82580_o(a.getID());
        a.onRemoveFromPlayer(ep);
        if (ep instanceof EntityPlayerMP) {
            ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
        }
    }

    @Override
    public void onRemoveFromPlayer(EntityPlayer ep) {
        if (this == REACH) {
            AbilityCalls.setReachDistance(ep, -1);
        } else if (this == HEALTH) {
            AbilityCalls.setPlayerMaxHealth(ep, 0);
        } else if (this == MAGNET) {
            AbilityHelper.instance.setNoClippingMagnet(ep, false);
        } else if (this == ORECLIP) {
            AbilityCalls.setNoclipState(ep, false);
        } else if (this == GROWAURA) {
            AbilityHelper.instance.setGrowAuraState(ep, 0);
        }
    }

    public static boolean canPlayerExecuteAt(EntityPlayer ep, AbilityAPI.Ability a) {
        ElementTagCompound use = AbilityHelper.instance.getUsageElementsFor(a, ep);
        return PlayerElementBuffer.instance.playerHas(ep, use) && a.canPlayerExecuteAt(ep);
    }

    @Override
    public boolean canPlayerExecuteAt(EntityPlayer player) {
        return true;
    }

    public static int maxPower(EntityPlayer ep, AbilityAPI.Ability a) {
        int base = a.getMaxPower();
        if (ep.field_71075_bZ.field_75098_d) {
            return base;
        }
        int lvl = base;
        ElementTagCompound use = AbilityHelper.instance.getElementsFor(a).scale(0.01f);
        for (CrystalElement e : use.elementSet()) {
            lvl = (int)Math.min((float)lvl, (float)PlayerElementBuffer.instance.getPlayerContent(ep, e) / (float)use.getValue(e));
        }
        return Math.max(1, lvl);
    }

    @Override
    public int getMaxPower() {
        switch (this) {
            case SONIC: {
                return 12;
            }
            case SHIFT: {
                return 24;
            }
            case HEAL: {
                return 4;
            }
            case FIREBALL: {
                return 8;
            }
            case HEALTH: {
                return 50;
            }
            case LIGHTNING: {
                return 2;
            }
            case MAGNET: {
                return 1;
            }
            case BREADCRUMB: {
                return 12;
            }
            case REACH: {
                return AbilityHelper.REACH_SCALE.length - 1;
            }
            case JUMP: {
                return 8;
            }
            case GROWAURA: {
                return 3;
            }
        }
        return 0;
    }

    @Override
    public String getID() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTexturePath(boolean gray) {
        String base = this.getID();
        String name = !gray ? base : base + "_g";
        String path = "Textures/Ability/" + name + ".png";
        return path;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Class getTextureReferenceClass() {
        return ChromatiCraft.class;
    }

    public int getInt() {
        return Chromabilities.getAbilityInt(this);
    }

    public static int getAbilityInt(AbilityAPI.Ability a) {
        return (Integer)intMap.inverse().get((Object)a);
    }

    public static AbilityAPI.Ability getAbilityByInt(int id) {
        return (AbilityAPI.Ability)intMap.get((Object)id);
    }

    public static void addAbility(AbilityAPI.Ability c) {
        String id = c.getID();
        Chromabilities.checkIDValidity(id);
        tagMap.put(id, c);
        abilityMap.put(id, c);
        intMap.put((Object)maxID, (Object)c);
        if (c.isTickBased()) {
            tickAbilities.addValue((Object)c.getTickPhase(), (Object)c);
        }
        ChromatiCraft.logger.log((Object)("Added ability '" + c.getDisplayName() + "', assigned IDs '" + id + "' and #" + maxID));
        sortedList = new ArrayList<AbilityAPI.Ability>(abilityMap.values());
        Collections.sort(sortedList, AbilitySorter.sorter);
        ++maxID;
    }

    private static void checkIDValidity(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("ID cannot be null or empty!");
        }
        if (id.equals("null") || id.equals(" ")) {
            throw new IllegalArgumentException("Invalid ID string " + id + "!");
        }
        if (id.equals("all") || id.equals("none")) {
            throw new IllegalArgumentException("Reserved ID string " + id + "!");
        }
        if (abilityMap.containsKey(id)) {
            throw new IllegalArgumentException("ID string " + id + " already taken!");
        }
    }

    public static void copyTo(EntityPlayer from, EntityPlayer to) {
        NBTTagCompound nbt = from.getEntityData();
        NBTTagCompound data = nbt.func_74775_l(NBT_TAG);
        to.getEntityData().func_74782_a(NBT_TAG, (NBTBase)data);
    }

    static {
        HEALTH_UUID = UUID.fromString("71d6a916-a54b-11e7-abc4-cec278b6b50a");
        FAKE_UUID = UUID.randomUUID();
        lastNullPlayerDump = -1L;
        tagMap = new HashMap();
        abilities = Chromabilities.values();
        abilityMap = new HashMap();
        intMap = HashBiMap.create();
        maxID = 0;
        tickAbilities = new MultiMap(MultiMap.CollectionType.HASHSET);
        for (int i = 0; i < abilities.length; ++i) {
            Chromabilities c = abilities[i];
            if (c.isDummiedOut()) continue;
            Chromabilities.addAbility(c);
        }
    }
}

