/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render;

import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Math.Spline;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class GlowTendril {
    private static final Random rand = new Random();
    public final double size;
    private final ArrayList<Tendril> tendrils = new ArrayList();

    public GlowTendril(double size, int count) {
        this.size = size;
        for (int i = 0; i < count; ++i) {
            Tendril t = new Tendril();
            double phi = rand.nextDouble() * 360.0;
            double theta = rand.nextDouble() * 360.0;
            t.spline.addPoint((Spline.SplineAnchor)new Spline.BasicSplinePoint(0.0, 0.0, 0.0));
            t.spline.addPoint((Spline.SplineAnchor)new TendrilPoint(size / 2.0, phi, theta));
            t.spline.addPoint((Spline.SplineAnchor)new TendrilPoint(size, phi, theta));
            this.tendrils.add(t);
        }
    }

    public void render(double x, double y, double z, int color, float ptick) {
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2896);
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        GL11.glDisable((int)3008);
        GL11.glDepthMask((boolean)false);
        Tessellator v5 = Tessellator.field_78398_a;
        for (Tendril t : this.tendrils) {
            t.render(x, y, z, color, ptick);
        }
        GL11.glPopAttrib();
    }

    public void update() {
        for (Tendril t : this.tendrils) {
            t.spline.update();
        }
    }

    private static class TendrilPoint
    implements Spline.SplineAnchor {
        private final double radius;
        private double theta;
        private double phi;
        private double targetTheta;
        private double targetPhi;

        private TendrilPoint(double r, double t, double p) {
            this.radius = r;
            this.theta = t;
            this.phi = p;
            this.pickNewTarget();
        }

        public DecimalPosition asPosition() {
            double[] dat = ReikaPhysicsHelper.polarToCartesian((double)this.radius, (double)this.theta, (double)this.phi);
            return new DecimalPosition(dat[0], dat[1], dat[2]);
        }

        public void update() {
            double dt = this.targetTheta - this.theta;
            double dp = this.targetPhi - this.phi;
            if (this.atTarget(dt, dp)) {
                this.pickNewTarget();
            }
            this.move(dt, dp);
        }

        private void move(double dt, double dp) {
            if (Math.abs(dt) >= 1.0) {
                this.theta += 0.375 * Math.signum(dt) * this.radius;
            }
            if (Math.abs(dp) >= 1.0) {
                this.phi += 0.375 * Math.signum(dp) * this.radius;
            }
        }

        private boolean atTarget(double dt, double dp) {
            return Math.abs(dt) < 1.0 && Math.abs(dp) < 1.0;
        }

        private void pickNewTarget() {
            this.targetTheta = rand.nextDouble() * 360.0;
            this.targetPhi = rand.nextDouble() * 360.0;
        }
    }

    private static class Tendril {
        private final Spline spline = new Spline(Spline.SplineType.CENTRIPETAL);

        private Tendril() {
        }

        private void render(double x, double y, double z, int color, float ptick) {
            List li = this.spline.get(8, false);
            for (int i = 0; i < li.size() - 1; ++i) {
                DecimalPosition pos1 = (DecimalPosition)li.get(i);
                DecimalPosition pos2 = (DecimalPosition)li.get(i + 1);
                double t = 0.1875 + 0.0625 * Math.sin((double)System.identityHashCode(this) + (double)System.currentTimeMillis() / 200.0 + (double)i / 128.0);
                ChromaFX.renderBeam(pos1.xCoord + 0.5, pos1.yCoord + 0.5, pos1.zCoord + 0.5, pos2.xCoord + 0.5, pos2.yCoord + 0.5, pos2.zCoord + 0.5, ptick, 255, t, color);
            }
        }
    }
}

