/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render.ISBRH;

import Reika.ChromatiCraft.Block.BlockEncrustedCrystal;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Base.ISBRH;
import Reika.DragonAPI.Instantiable.CubePoints;
import Reika.DragonAPI.Instantiable.GridDistortion;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class CrystalEncrustingRenderer
extends ISBRH {
    private static final int MIN_SEGMENTS = 4;
    private static final int MAX_SEGMENTS = 8;
    private final GridDistortion[] distortions = new GridDistortion[5];
    private final CubePoints renderBlock = CubePoints.fullBlock();

    public CrystalEncrustingRenderer(int id) {
        super(id);
    }

    public void renderInventoryBlock(Block bk, int metadata, int modelId, RenderBlocks rb) {
        Tessellator v5 = Tessellator.field_78398_a;
        rb.field_147861_i = 1.0;
        rb.field_147855_j = 0.0;
        rb.field_147853_m = 1.0;
        rb.field_147859_h = 0.0;
        rb.field_147851_l = 0.0;
        rb.field_147857_k = 1.0;
        IIcon ico = bk.func_149691_a(0, metadata);
        int c = ReikaColorAPI.mixColors((int)CrystalElement.elements[metadata].getColor(), (int)0xFFFFFF, (float)0.85f);
        this.rand.setSeed(Minecraft.func_71410_x().field_71439_g.func_110124_au().hashCode() ^ metadata);
        this.rand.nextBoolean();
        int pieces = 12;
        int n = 6;
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        v5.func_78382_b();
        v5.func_78378_d(c);
        boolean[][] rendered = new boolean[n][n];
        for (int i = 0; i < pieces; ++i) {
            int a = this.rand.nextInt(n);
            int b = this.rand.nextInt(n);
            double w = 1.0 / (double)n;
            double a1 = w * (double)a;
            double a2 = a1 + w;
            double b1 = w * (double)b;
            double b2 = b1 + w;
            if (rendered[a][b]) continue;
            rendered[a][b] = true;
            double h = 0.2 + this.rand.nextDouble() * 0.6;
            rb.field_147849_o = true;
            rb.field_147837_f = true;
            rb.func_147782_a(a1, 0.0, b1, a2, h, b2);
            v5.func_78375_b(0.0f, -1.0f, 0.0f);
            rb.func_147768_a(bk, 0.0, 0.0, 0.0, ico);
            v5.func_78378_d(c);
            v5.func_78375_b(0.0f, 1.0f, 0.0f);
            rb.func_147806_b(bk, 0.0, 0.0, 0.0, ico);
            v5.func_78378_d(c);
            v5.func_78375_b(0.0f, 0.0f, -1.0f);
            rb.func_147761_c(bk, 0.0, 0.0, 0.0, ico);
            v5.func_78378_d(c);
            v5.func_78375_b(0.0f, 0.0f, 1.0f);
            rb.func_147734_d(bk, 0.0, 0.0, 0.0, ico);
            v5.func_78378_d(c);
            v5.func_78375_b(-1.0f, 0.0f, 0.0f);
            rb.func_147798_e(bk, 0.0, 0.0, 0.0, ico);
            v5.func_78378_d(c);
            v5.func_78375_b(1.0f, 0.0f, 0.0f);
            rb.func_147764_f(bk, 0.0, 0.0, 0.0, ico);
        }
        v5.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block b, int modelId, RenderBlocks rb) {
        if (this.renderPass != 1) {
            return false;
        }
        this.rand.setSeed(this.calcSeed(x, y, z));
        this.rand.nextBoolean();
        this.rand.nextBoolean();
        BlockEncrustedCrystal.TileCrystalEncrusted te = (BlockEncrustedCrystal.TileCrystalEncrusted)world.func_147438_o(x, y, z);
        Collection<BlockEncrustedCrystal.CrystalGrowth> c = te.getGrowths();
        if (c.isEmpty()) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        for (BlockEncrustedCrystal.CrystalGrowth g : c) {
            this.renderCrystalFace(world, x, y, z, b, te, g, rb, CrystalElement.elements[meta].getColor());
        }
        return true;
    }

    private GridDistortion getDistortion(int n) {
        int idx = n - 4;
        if (this.distortions[idx] == null) {
            GridDistortion grid = new GridDistortion(n);
            grid.maxDeviation *= 0.66;
            this.distortions[idx] = grid;
        }
        return this.distortions[idx];
    }

    private void renderCrystalFace(IBlockAccess world, int x, int y, int z, Block bk, BlockEncrustedCrystal.TileCrystalEncrusted te, BlockEncrustedCrystal.CrystalGrowth g, RenderBlocks rb, int color) {
        int amt = g.getGrowth();
        int h1 = 3 + amt * 2;
        int h2 = 8 + amt * 4;
        int n = 4 + this.rand.nextInt(5);
        double w = 1.0 / (double)n;
        GridDistortion grid = this.getDistortion(n);
        grid.snapToEdges = false;
        grid.randomize(this.rand);
        int pieces = Math.min(n * n / 2, 6 + amt * amt / 10);
        if (te.isSpecial()) {
            pieces = (int)((double)pieces * 1.5);
        }
        boolean[][] rendered = new boolean[n][n];
        for (int i = 0; i < pieces; ++i) {
            int b;
            int a = this.rand.nextInt(n);
            if (rendered[a][b = this.rand.nextInt(n)]) continue;
            rendered[a][b] = true;
            int rh = h1 + this.rand.nextInt(h2 - h1 + 1);
            double h = (double)rh / 96.0;
            this.renderCrystalPiece(world, x, y, z, bk, te, g, rb, color, a, b, w, h, grid);
        }
    }

    private void renderCrystalPiece(IBlockAccess world, int x, int y, int z, Block bk, BlockEncrustedCrystal.TileCrystalEncrusted te, BlockEncrustedCrystal.CrystalGrowth g, RenderBlocks rb, int color, int a, int b, double w, double h, GridDistortion grid) {
        float f1 = 0.75f + this.rand.nextFloat() * 0.25f;
        float f2 = 0.75f + this.rand.nextFloat() * 0.25f;
        color = ReikaColorAPI.mixColors((int)color, (int)0xFFFFFF, (float)f1);
        color = ReikaColorAPI.mixColors((int)color, (int)0, (float)f2);
        int hue = ReikaColorAPI.getHue((int)color);
        hue = hue - 5 + this.rand.nextInt(11);
        color = ReikaColorAPI.getModifiedHue((int)color, (int)hue);
        Tessellator.field_78398_a.func_78380_c(240);
        Tessellator.field_78398_a.func_78384_a(color, te.isSpecial() ? 160 : 255);
        GridDistortion.OffsetGroup off = grid.getOffset(a, b);
        switch (g.side) {
            case DOWN: {
                this.renderBlock.setSidePosition(ForgeDirection.DOWN, 0.0);
                this.renderBlock.setSidePosition(ForgeDirection.UP, h);
                this.renderBlock.setSidePosition(ForgeDirection.WEST, (double)a * w);
                this.renderBlock.setSidePosition(ForgeDirection.EAST, (double)a * w + w);
                this.renderBlock.setSidePosition(ForgeDirection.NORTH, (double)b * w);
                this.renderBlock.setSidePosition(ForgeDirection.SOUTH, (double)b * w + w);
                break;
            }
            case UP: {
                this.renderBlock.setSidePosition(ForgeDirection.DOWN, 1.0 - h);
                this.renderBlock.setSidePosition(ForgeDirection.UP, 1.0);
                this.renderBlock.setSidePosition(ForgeDirection.WEST, (double)a * w);
                this.renderBlock.setSidePosition(ForgeDirection.EAST, (double)a * w + w);
                this.renderBlock.setSidePosition(ForgeDirection.NORTH, (double)b * w);
                this.renderBlock.setSidePosition(ForgeDirection.SOUTH, (double)b * w + w);
                break;
            }
            case WEST: {
                this.renderBlock.setSidePosition(ForgeDirection.DOWN, (double)b * w);
                this.renderBlock.setSidePosition(ForgeDirection.UP, (double)b * w + w);
                this.renderBlock.setSidePosition(ForgeDirection.WEST, 0.0);
                this.renderBlock.setSidePosition(ForgeDirection.EAST, h);
                this.renderBlock.setSidePosition(ForgeDirection.NORTH, (double)a * w);
                this.renderBlock.setSidePosition(ForgeDirection.SOUTH, (double)a * w + w);
                break;
            }
            case EAST: {
                this.renderBlock.setSidePosition(ForgeDirection.DOWN, (double)b * w);
                this.renderBlock.setSidePosition(ForgeDirection.UP, (double)b * w + w);
                this.renderBlock.setSidePosition(ForgeDirection.WEST, 1.0 - h);
                this.renderBlock.setSidePosition(ForgeDirection.EAST, 1.0);
                this.renderBlock.setSidePosition(ForgeDirection.NORTH, (double)a * w);
                this.renderBlock.setSidePosition(ForgeDirection.SOUTH, (double)a * w + w);
                break;
            }
            case NORTH: {
                this.renderBlock.setSidePosition(ForgeDirection.DOWN, (double)b * w);
                this.renderBlock.setSidePosition(ForgeDirection.UP, (double)b * w + w);
                this.renderBlock.setSidePosition(ForgeDirection.WEST, (double)a * w);
                this.renderBlock.setSidePosition(ForgeDirection.EAST, (double)a * w + w);
                this.renderBlock.setSidePosition(ForgeDirection.NORTH, 0.0);
                this.renderBlock.setSidePosition(ForgeDirection.SOUTH, h);
                break;
            }
            case SOUTH: {
                this.renderBlock.setSidePosition(ForgeDirection.DOWN, (double)b * w);
                this.renderBlock.setSidePosition(ForgeDirection.UP, (double)b * w + w);
                this.renderBlock.setSidePosition(ForgeDirection.WEST, (double)a * w);
                this.renderBlock.setSidePosition(ForgeDirection.EAST, (double)a * w + w);
                this.renderBlock.setSidePosition(ForgeDirection.NORTH, 1.0 - h);
                this.renderBlock.setSidePosition(ForgeDirection.SOUTH, 1.0);
                break;
            }
        }
        this.renderBlock.applyOffset(g.side, off);
        this.renderBlock.applyOffset(g.side.getOpposite(), off);
        this.renderBlock.clamp();
        ReikaRenderHelper.renderBlockPieceNonCuboid((IBlockAccess)world, (int)x, (int)y, (int)z, (Block)bk, (Tessellator)Tessellator.field_78398_a, (CubePoints)this.renderBlock);
        Tessellator.field_78398_a.func_78380_c(240);
        Tessellator.field_78398_a.func_78384_a(ReikaColorAPI.mixColors((int)color, (int)0xFFFFFF, (float)0.9f), te.isSpecial() ? 240 : 192);
        this.renderBlock.renderIconOnSides(world, x, y, z, ChromaIcons.GLOWFRAME_TRANS.getIcon(), Tessellator.field_78398_a);
        if (te.isSpecial()) {
            Tessellator.field_78398_a.func_78380_c(240);
            Tessellator.field_78398_a.func_78384_a(0xFFFFFF, te.isSpecial() ? 48 : 32);
            this.renderBlock.renderIconOnSides(world, x, y, z, BlockEncrustedCrystal.specialIcon, Tessellator.field_78398_a);
        }
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }
}

