/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render.ISBRH;

import Reika.ChromatiCraft.Auxiliary.Interfaces.DecoType;
import Reika.ChromatiCraft.Block.Dimension.BlockDimensionDeco;
import Reika.ChromatiCraft.Block.Dimension.BlockDimensionDecoTile;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.DragonAPI.Base.ISBRH;
import Reika.DragonAPI.Instantiable.Rendering.TessellatorVertexList;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class DimensionDecoRenderer
extends ISBRH {
    private static double[][][] latticeRotations = new double[3][4][6];

    public DimensionDecoRenderer(int id) {
        super(id);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks rb) {
        Enum type = block instanceof BlockDimensionDecoTile ? BlockDimensionDecoTile.DimDecoTileTypes.list[metadata] : BlockDimensionDeco.DimDecoTypes.list[metadata];
        GL11.glPushAttrib((int)1048575);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaRenderHelper.disableEntityLighting();
        GL11.glDisable((int)2896);
        if (block instanceof BlockDimensionDecoTile) {
            GL11.glRotated((double)45.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)60.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glTranslated((double)-0.79, (double)0.0, (double)-0.79);
            double s = 1.6;
            GL11.glScaled((double)s, (double)s, (double)s);
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78378_d(0xFFFFFF);
            Tessellator.field_78398_a.func_78380_c(240);
            Tessellator.field_78398_a.func_78372_c(0.0f, -0.08f, 0.0f);
            IIcon ico = BlockDimensionDecoTile.DimDecoTileTypes.list[metadata].getItemIcon();
            float u = ico.func_94209_e();
            float v = ico.func_94206_g();
            float du = ico.func_94212_f();
            float dv = ico.func_94210_h();
            Tessellator.field_78398_a.func_78374_a(0.0, 0.0, 1.0, (double)u, (double)dv);
            Tessellator.field_78398_a.func_78374_a(1.0, 0.0, 1.0, (double)du, (double)dv);
            Tessellator.field_78398_a.func_78374_a(1.0, 0.0, 0.0, (double)du, (double)v);
            Tessellator.field_78398_a.func_78374_a(0.0, 0.0, 0.0, (double)u, (double)v);
            Tessellator.field_78398_a.func_78372_c(0.0f, 0.08f, 0.0f);
            Tessellator.field_78398_a.func_78381_a();
        } else {
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78378_d(0xFFFFFF);
            Tessellator.field_78398_a.func_78380_c(240);
            Tessellator.field_78398_a.func_78372_c(0.0f, -0.08f, 0.0f);
            for (int pass = 0; pass <= 1; ++pass) {
                List<IIcon> li = type.getItemIcons(pass);
                for (IIcon ico : li) {
                    float f = 0.5f;
                    Tessellator.field_78398_a.func_78386_a(f, f, f);
                    rb.func_147768_a(block, 0.0, 0.0, 0.0, ico);
                    f = 1.0f;
                    Tessellator.field_78398_a.func_78386_a(f, f, f);
                    rb.func_147806_b(block, 0.0, 0.0, 0.0, ico);
                    f = 0.66f;
                    Tessellator.field_78398_a.func_78386_a(f, f, f);
                    rb.func_147798_e(block, 0.0, 0.0, 0.0, ico);
                    rb.func_147764_f(block, 0.0, 0.0, 0.0, ico);
                    f = 0.8f;
                    Tessellator.field_78398_a.func_78386_a(f, f, f);
                    rb.func_147761_c(block, 0.0, 0.0, 0.0, ico);
                    rb.func_147734_d(block, 0.0, 0.0, 0.0, ico);
                }
            }
            Tessellator.field_78398_a.func_78372_c(0.0f, 0.08f, 0.0f);
            Tessellator.field_78398_a.func_78381_a();
        }
        GL11.glPopAttrib();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block b, int modelId, RenderBlocks rb) {
        Enum type;
        this.rand.setSeed(ChunkCoordIntPair.func_77272_a((int)x, (int)z) ^ (long)y);
        this.rand.nextBoolean();
        int meta = world.func_72805_g(x, y, z);
        Enum enum_ = type = b instanceof BlockDimensionDecoTile ? BlockDimensionDecoTile.DimDecoTileTypes.list[meta] : BlockDimensionDeco.DimDecoTypes.list[meta];
        if (this.renderPass == 0) {
            if (type.hasBlockRender()) {
                rb.func_147751_a(b, x, y, z, 1.0f, 1.0f, 1.0f);
                List<IIcon> li = type.getIcons(world, x, y, z, 0, this.rand);
                int idx = 0;
                for (IIcon ico : li) {
                    Tessellator.field_78398_a.func_78380_c(240);
                    Tessellator.field_78398_a.func_78378_d(idx == 1 ? b.func_149720_d(world, x, y, z) : 0xFFFFFF);
                    if (b.func_149646_a(world, x, y - 1, z, ForgeDirection.DOWN.ordinal())) {
                        rb.func_147768_a(b, (double)x, (double)y, (double)z, ico);
                    }
                    if (b.func_149646_a(world, x, y + 1, z, ForgeDirection.UP.ordinal())) {
                        rb.func_147806_b(b, (double)x, (double)y, (double)z, ico);
                    }
                    if (b.func_149646_a(world, x, y, z - 1, ForgeDirection.NORTH.ordinal())) {
                        rb.func_147761_c(b, (double)x, (double)y, (double)z, ico);
                    }
                    if (b.func_149646_a(world, x, y, z + 1, ForgeDirection.SOUTH.ordinal())) {
                        rb.func_147734_d(b, (double)x, (double)y, (double)z, ico);
                    }
                    if (b.func_149646_a(world, x - 1, y, z, ForgeDirection.WEST.ordinal())) {
                        rb.func_147798_e(b, (double)x, (double)y, (double)z, ico);
                    }
                    if (b.func_149646_a(world, x + 1, y, z, ForgeDirection.EAST.ordinal())) {
                        rb.func_147764_f(b, (double)x, (double)y, (double)z, ico);
                    }
                    ++idx;
                }
            } else {
                Tessellator v5 = Tessellator.field_78398_a;
                v5.func_78372_c((float)x, (float)y, (float)z);
                if (type instanceof BlockDimensionDeco.DimDecoTypes) {
                    this.render(v5, world, x, y, z, (BlockDimensionDeco.DimDecoTypes)type, b, rb);
                } else if (type instanceof BlockDimensionDecoTile.DimDecoTileTypes) {
                    this.render(v5, world, x, y, z, (BlockDimensionDecoTile.DimDecoTileTypes)type, b, rb);
                }
                v5.func_78372_c((float)(-x), (float)(-y), (float)(-z));
            }
        } else if (this.renderPass == 1) {
            if (type.hasBlockRender()) {
                List<IIcon> li = type.getIcons(world, x, y, z, 1, this.rand);
                int idx = 0;
                for (IIcon ico : li) {
                    Tessellator.field_78398_a.func_78380_c(240);
                    Tessellator.field_78398_a.func_78378_d(idx == 0 ? b.func_149720_d(world, x, y, z) : 0xFFFFFF);
                    if (b.func_149646_a(world, x, y - 1, z, ForgeDirection.DOWN.ordinal())) {
                        rb.func_147768_a(b, (double)x, (double)y, (double)z, ico);
                    }
                    if (b.func_149646_a(world, x, y + 1, z, ForgeDirection.UP.ordinal())) {
                        rb.func_147806_b(b, (double)x, (double)y, (double)z, ico);
                    }
                    if (b.func_149646_a(world, x, y, z - 1, ForgeDirection.NORTH.ordinal())) {
                        rb.func_147761_c(b, (double)x, (double)y, (double)z, ico);
                    }
                    if (b.func_149646_a(world, x, y, z + 1, ForgeDirection.SOUTH.ordinal())) {
                        rb.func_147734_d(b, (double)x, (double)y, (double)z, ico);
                    }
                    if (b.func_149646_a(world, x - 1, y, z, ForgeDirection.WEST.ordinal())) {
                        rb.func_147798_e(b, (double)x, (double)y, (double)z, ico);
                    }
                    if (b.func_149646_a(world, x + 1, y, z, ForgeDirection.EAST.ordinal())) {
                        rb.func_147764_f(b, (double)x, (double)y, (double)z, ico);
                    }
                    ++idx;
                }
            }
            this.renderAuxEffect(world, x, y, z, (DecoType)((Object)type), b, modelId, rb);
        }
        return true;
    }

    private void renderAuxEffect(IBlockAccess world, int x, int y, int z, DecoType type, Block block, int modelId, RenderBlocks rb) {
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78372_c((float)x, (float)y, (float)z);
        if (type instanceof BlockDimensionDeco.DimDecoTypes) {
            this.renderEffect(v5, world, x, y, z, (BlockDimensionDeco.DimDecoTypes)type, block, rb);
        } else if (type instanceof BlockDimensionDecoTile.DimDecoTileTypes) {
            this.renderEffect(v5, world, x, y, z, (BlockDimensionDecoTile.DimDecoTileTypes)type, block, rb);
        }
        v5.func_78374_a(0.0, 0.0, 0.0, 0.0, 0.0);
        v5.func_78374_a(0.0, 0.0, 0.0, 0.0, 0.0);
        v5.func_78374_a(0.0, 0.0, 0.0, 0.0, 0.0);
        v5.func_78374_a(0.0, 0.0, 0.0, 0.0, 0.0);
        v5.func_78372_c((float)(-x), (float)(-y), (float)(-z));
    }

    private void render(Tessellator v5, IBlockAccess world, int x, int y, int z, BlockDimensionDeco.DimDecoTypes type, Block b, RenderBlocks rb) {
        switch (type) {
            case MIASMA: {
                break;
            }
            case FLOATSTONE: {
                break;
            }
            case AQUA: {
                break;
            }
            case LIFEWATER: {
                break;
            }
            case LATTICE: {
                break;
            }
            case GEMSTONE: {
                break;
            }
            case CRYSTALLEAF: {
                break;
            }
            case OCEANSTONE: {
                break;
            }
            case CLIFFGLASS: {
                break;
            }
        }
    }

    private void render(Tessellator v5, IBlockAccess world, int x, int y, int z, BlockDimensionDecoTile.DimDecoTileTypes type, Block b, RenderBlocks rb) {
        switch (type) {
            case GLOWCRACKS: {
                break;
            }
            case FIREJET: {
                IIcon ico = ChromaBlocks.STRUCTSHIELD.getBlockInstance().func_149691_a(1, 0);
                float u = ico.func_94209_e();
                float v = ico.func_94206_g();
                float du = ico.func_94212_f();
                float dv = ico.func_94210_h();
                v5.func_78372_c((float)(-x), (float)(-y), (float)(-z));
                v5.func_78378_d(0xFFFFFF);
                rb.func_147768_a(b, (double)x, (double)y, (double)z, ico);
                rb.func_147761_c(b, (double)x, (double)y, (double)z, ico);
                rb.func_147734_d(b, (double)x, (double)y, (double)z, ico);
                rb.func_147798_e(b, (double)x, (double)y, (double)z, ico);
                rb.func_147764_f(b, (double)x, (double)y, (double)z, ico);
                v5.func_78372_c((float)x, (float)y, (float)z);
                double w = 0.375;
                double h = 0.25;
                v5.func_78374_a(0.0, 1.0, w, (double)u, (double)v);
                v5.func_78374_a(w, 1.0 - h, w, (double)du, (double)v);
                v5.func_78374_a(w, 1.0, 0.0, (double)du, (double)dv);
                v5.func_78374_a(0.0, 1.0, 0.0, (double)u, (double)dv);
                v5.func_78374_a(1.0 - w, 1.0 - h, w, (double)u, (double)v);
                v5.func_78374_a(1.0, 1.0, w, (double)du, (double)v);
                v5.func_78374_a(1.0, 1.0, 0.0, (double)du, (double)dv);
                v5.func_78374_a(1.0 - w, 1.0, 0.0, (double)u, (double)dv);
                v5.func_78374_a(0.0, 1.0, 1.0, (double)u, (double)v);
                v5.func_78374_a(w, 1.0, 1.0, (double)du, (double)v);
                v5.func_78374_a(w, 1.0 - h, 1.0 - w, (double)du, (double)dv);
                v5.func_78374_a(0.0, 1.0, 1.0 - w, (double)u, (double)dv);
                v5.func_78374_a(1.0 - w, 1.0, 1.0, (double)u, (double)v);
                v5.func_78374_a(1.0, 1.0, 1.0, (double)du, (double)v);
                v5.func_78374_a(1.0, 1.0, 1.0 - w, (double)du, (double)dv);
                v5.func_78374_a(1.0 - w, 1.0 - h, 1.0 - w, (double)u, (double)dv);
                v5.func_78374_a(w, 1.0 - h, 1.0 - w, (double)u, (double)v);
                v5.func_78374_a(1.0 - w, 1.0 - h, 1.0 - w, (double)du, (double)v);
                v5.func_78374_a(1.0 - w, 1.0 - h, w, (double)du, (double)dv);
                v5.func_78374_a(w, 1.0 - h, w, (double)u, (double)dv);
                v5.func_78374_a(w, 1.0 - h, w, (double)u, (double)v);
                v5.func_78374_a(1.0 - w, 1.0 - h, w, (double)du, (double)v);
                v5.func_78374_a(1.0 - w, 1.0, 0.0, (double)du, (double)dv);
                v5.func_78374_a(w, 1.0, 0.0, (double)u, (double)dv);
                v5.func_78374_a(w, 1.0, 1.0, (double)u, (double)v);
                v5.func_78374_a(1.0 - w, 1.0, 1.0, (double)du, (double)v);
                v5.func_78374_a(1.0 - w, 1.0 - h, 1.0 - w, (double)du, (double)dv);
                v5.func_78374_a(w, 1.0 - h, 1.0 - w, (double)u, (double)dv);
                v5.func_78374_a(0.0, 1.0, w, (double)u, (double)dv);
                v5.func_78374_a(0.0, 1.0, 1.0 - w, (double)du, (double)dv);
                v5.func_78374_a(w, 1.0 - h, 1.0 - w, (double)du, (double)v);
                v5.func_78374_a(w, 1.0 - h, w, (double)u, (double)v);
                v5.func_78374_a(1.0 - w, 1.0 - h, w, (double)u, (double)v);
                v5.func_78374_a(1.0 - w, 1.0 - h, 1.0 - w, (double)du, (double)v);
                v5.func_78374_a(1.0, 1.0, 1.0 - w, (double)du, (double)dv);
                v5.func_78374_a(1.0, 1.0, w, (double)u, (double)dv);
            }
        }
    }

    private void renderEffect(Tessellator v5, IBlockAccess world, int x, int y, int z, BlockDimensionDecoTile.DimDecoTileTypes type, Block b, RenderBlocks rb) {
        switch (type) {
            case FIREJET: {
                break;
            }
        }
    }

    private void renderEffect(Tessellator v5, IBlockAccess world, int x, int y, int z, BlockDimensionDeco.DimDecoTypes type, Block b, RenderBlocks rb) {
        switch (type) {
            case MIASMA: {
                v5.func_78380_c(240);
                int c = ReikaColorAPI.getModifiedHue((int)255, (int)(220 + (int)(80.0 * Math.sin((double)(x * x * 2 + y * y + z * z * 8) / 2000000.0))));
                v5.func_78378_d(c);
                IIcon ico = type.getIcons(world, x, y, z, 1, this.rand).get(0);
                float u = ico.func_94209_e();
                float v = ico.func_94206_g();
                float du = ico.func_94212_f();
                float dv = ico.func_94210_h();
                double s = 1.0;
                v5.func_78374_a(0.5 - s, 0.5, 0.5 - s, (double)u, (double)v);
                v5.func_78374_a(0.5 + s, 0.5, 0.5 - s, (double)du, (double)v);
                v5.func_78374_a(0.5 + s, 0.5, 0.5 + s, (double)du, (double)dv);
                v5.func_78374_a(0.5 - s, 0.5, 0.5 + s, (double)u, (double)dv);
                v5.func_78374_a(0.5 - s, 0.5, 0.5 + s, (double)u, (double)dv);
                v5.func_78374_a(0.5 + s, 0.5, 0.5 + s, (double)du, (double)dv);
                v5.func_78374_a(0.5 + s, 0.5, 0.5 - s, (double)du, (double)v);
                v5.func_78374_a(0.5 - s, 0.5, 0.5 - s, (double)u, (double)v);
                v5.func_78374_a(0.5 - s * 0.75, 0.5 - s, 0.5 - s * 0.75, (double)u, (double)v);
                v5.func_78374_a(0.5 + s * 0.75, 0.5 - s, 0.5 + s * 0.75, (double)du, (double)v);
                v5.func_78374_a(0.5 + s * 0.75, 0.5 + s, 0.5 + s * 0.75, (double)du, (double)dv);
                v5.func_78374_a(0.5 - s * 0.75, 0.5 + s, 0.5 - s * 0.75, (double)u, (double)dv);
                v5.func_78374_a(0.5 - s * 0.75, 0.5 + s, 0.5 - s * 0.75, (double)u, (double)dv);
                v5.func_78374_a(0.5 + s * 0.75, 0.5 + s, 0.5 + s * 0.75, (double)du, (double)dv);
                v5.func_78374_a(0.5 + s * 0.75, 0.5 - s, 0.5 + s * 0.75, (double)du, (double)v);
                v5.func_78374_a(0.5 - s * 0.75, 0.5 - s, 0.5 - s * 0.75, (double)u, (double)v);
                v5.func_78374_a(0.5 + s * 0.75, 0.5 - s, 0.5 - s * 0.75, (double)u, (double)v);
                v5.func_78374_a(0.5 - s * 0.75, 0.5 - s, 0.5 + s * 0.75, (double)du, (double)v);
                v5.func_78374_a(0.5 - s * 0.75, 0.5 + s, 0.5 + s * 0.75, (double)du, (double)dv);
                v5.func_78374_a(0.5 + s * 0.75, 0.5 + s, 0.5 - s * 0.75, (double)u, (double)dv);
                v5.func_78374_a(0.5 + s * 0.75, 0.5 + s, 0.5 - s * 0.75, (double)u, (double)dv);
                v5.func_78374_a(0.5 - s * 0.75, 0.5 + s, 0.5 + s * 0.75, (double)du, (double)dv);
                v5.func_78374_a(0.5 - s * 0.75, 0.5 - s, 0.5 + s * 0.75, (double)du, (double)v);
                v5.func_78374_a(0.5 + s * 0.75, 0.5 - s, 0.5 - s * 0.75, (double)u, (double)v);
                break;
            }
            case FLOATSTONE: {
                v5.func_78380_c(240);
                v5.func_78378_d(0xFFFFFF);
                IIcon ico = ChromaIcons.PURPLESPIN.getIcon();
                float u = ico.func_94209_e();
                float v = ico.func_94206_g();
                float du = ico.func_94212_f();
                float dv = ico.func_94210_h();
                double s = 1.5;
                v5.func_78374_a(0.5 - s, 0.5, 0.5 - s, (double)u, (double)v);
                v5.func_78374_a(0.5 + s, 0.5, 0.5 - s, (double)du, (double)v);
                v5.func_78374_a(0.5 + s, 0.5, 0.5 + s, (double)du, (double)dv);
                v5.func_78374_a(0.5 - s, 0.5, 0.5 + s, (double)u, (double)dv);
                v5.func_78374_a(0.5 - s, 0.5, 0.5 + s, (double)u, (double)dv);
                v5.func_78374_a(0.5 + s, 0.5, 0.5 + s, (double)du, (double)dv);
                v5.func_78374_a(0.5 + s, 0.5, 0.5 - s, (double)du, (double)v);
                v5.func_78374_a(0.5 - s, 0.5, 0.5 - s, (double)u, (double)v);
                v5.func_78374_a(0.5 - s * 0.75, 0.5 - s, 0.5 - s * 0.75, (double)u, (double)v);
                v5.func_78374_a(0.5 + s * 0.75, 0.5 - s, 0.5 + s * 0.75, (double)du, (double)v);
                v5.func_78374_a(0.5 + s * 0.75, 0.5 + s, 0.5 + s * 0.75, (double)du, (double)dv);
                v5.func_78374_a(0.5 - s * 0.75, 0.5 + s, 0.5 - s * 0.75, (double)u, (double)dv);
                v5.func_78374_a(0.5 - s * 0.75, 0.5 + s, 0.5 - s * 0.75, (double)u, (double)dv);
                v5.func_78374_a(0.5 + s * 0.75, 0.5 + s, 0.5 + s * 0.75, (double)du, (double)dv);
                v5.func_78374_a(0.5 + s * 0.75, 0.5 - s, 0.5 + s * 0.75, (double)du, (double)v);
                v5.func_78374_a(0.5 - s * 0.75, 0.5 - s, 0.5 - s * 0.75, (double)u, (double)v);
                v5.func_78374_a(0.5 + s * 0.75, 0.5 - s, 0.5 - s * 0.75, (double)u, (double)v);
                v5.func_78374_a(0.5 - s * 0.75, 0.5 - s, 0.5 + s * 0.75, (double)du, (double)v);
                v5.func_78374_a(0.5 - s * 0.75, 0.5 + s, 0.5 + s * 0.75, (double)du, (double)dv);
                v5.func_78374_a(0.5 + s * 0.75, 0.5 + s, 0.5 - s * 0.75, (double)u, (double)dv);
                v5.func_78374_a(0.5 + s * 0.75, 0.5 + s, 0.5 - s * 0.75, (double)u, (double)dv);
                v5.func_78374_a(0.5 - s * 0.75, 0.5 + s, 0.5 + s * 0.75, (double)du, (double)dv);
                v5.func_78374_a(0.5 - s * 0.75, 0.5 - s, 0.5 + s * 0.75, (double)du, (double)v);
                v5.func_78374_a(0.5 + s * 0.75, 0.5 - s, 0.5 - s * 0.75, (double)u, (double)v);
                break;
            }
            case AQUA: {
                v5.func_78380_c(240);
                v5.func_78378_d(65487);
                IIcon ico = ChromaBlocks.DOOR.getBlockInstance().func_149691_a(0, 1);
                float u = ico.func_94209_e();
                float v = ico.func_94206_g();
                float du = ico.func_94212_f();
                float dv = ico.func_94210_h();
                double[] h = new double[4];
                double[][][] ao = new double[][][]{new double[][]{{-1.0, 1.0, 1.0, -1.0}, {-1.0, -1.0, 1.0, 1.0}}, new double[][]{{-1.0, 1.0, 1.0, -1.0}, {-1.0, -1.0, 1.0, 1.0}}, new double[][]{{-1.0, 1.0, 1.0, -1.0}, {-1.0, -1.0, 1.0, 1.0}}};
                double[][] p = new double[][]{{x, z}, {y, z}, {x, y}};
                block16: for (int n = 0; n <= 2; ++n) {
                    double[] da = ao[n][0];
                    double[] db = ao[n][1];
                    double ap = p[n][0];
                    double bp = p[n][1];
                    for (int i = 0; i < 4; ++i) {
                        double idx = 48.0 * ((ap + bp + (da[i] + db[i]) * 0.5) % 16.0);
                        double idx2 = 128.0 * ((ap + bp + (da[i] + db[i]) * 0.5) % 32.0);
                        double fac = 24.0;
                        h[i] = 0.5 + 0.5 * Math.sin(Math.toRadians(idx *= fac)) + 0.05 * Math.sin(Math.toRadians(idx2 *= fac));
                    }
                    switch (n) {
                        case 0: {
                            v5.func_78374_a(0.0, h[0], 0.0, (double)u, (double)v);
                            v5.func_78374_a(1.0, h[1], 0.0, (double)du, (double)v);
                            v5.func_78374_a(1.0, h[2], 1.0, (double)du, (double)dv);
                            v5.func_78374_a(0.0, h[3], 1.0, (double)u, (double)dv);
                            v5.func_78374_a(0.0, h[3], 1.0, (double)u, (double)dv);
                            v5.func_78374_a(1.0, h[2], 1.0, (double)du, (double)dv);
                            v5.func_78374_a(1.0, h[1], 0.0, (double)du, (double)v);
                            v5.func_78374_a(0.0, h[0], 0.0, (double)u, (double)v);
                            continue block16;
                        }
                        case 1: {
                            v5.func_78374_a(h[0], 0.0, 0.0, (double)u, (double)v);
                            v5.func_78374_a(h[1], 1.0, 0.0, (double)du, (double)v);
                            v5.func_78374_a(h[2], 1.0, 1.0, (double)du, (double)dv);
                            v5.func_78374_a(h[3], 0.0, 1.0, (double)u, (double)dv);
                            v5.func_78374_a(h[3], 0.0, 1.0, (double)u, (double)dv);
                            v5.func_78374_a(h[2], 1.0, 1.0, (double)du, (double)dv);
                            v5.func_78374_a(h[1], 1.0, 0.0, (double)du, (double)v);
                            v5.func_78374_a(h[0], 0.0, 0.0, (double)u, (double)v);
                            continue block16;
                        }
                        case 2: {
                            v5.func_78374_a(0.0, 0.0, h[0], (double)u, (double)v);
                            v5.func_78374_a(1.0, 0.0, h[1], (double)du, (double)v);
                            v5.func_78374_a(1.0, 1.0, h[2], (double)du, (double)dv);
                            v5.func_78374_a(0.0, 1.0, h[3], (double)u, (double)dv);
                            v5.func_78374_a(0.0, 0.0, h[3], (double)u, (double)dv);
                            v5.func_78374_a(1.0, 0.0, h[2], (double)du, (double)dv);
                            v5.func_78374_a(1.0, 1.0, h[1], (double)du, (double)v);
                            v5.func_78374_a(0.0, 1.0, h[0], (double)u, (double)v);
                        }
                    }
                }
                break;
            }
            case LIFEWATER: {
                v5.func_78380_c(240);
                v5.func_78378_d(0xFFFFFF);
                IIcon ico = type.getIcons(world, x, y, z, 1, this.rand).get(0);
                float u = ico.func_94209_e();
                float v = ico.func_94206_g();
                float du = ico.func_94212_f();
                float dv = ico.func_94210_h();
                double h1 = 0.9375;
                double h2 = 0.9375;
                double h3 = 0.9375;
                double h4 = 0.9375;
                h1 += 0.03125 * Math.sin(((double)x - 0.5 + ((double)z + 0.5) * 2.0) / 1.0);
                h2 += 0.03125 * Math.sin(((double)x + 0.5 + ((double)z + 0.5) * 2.0) / 1.0);
                h3 += 0.03125 * Math.sin(((double)x + 0.5 + ((double)z - 0.5) * 2.0) / 1.0);
                h4 += 0.03125 * Math.sin(((double)x - 0.5 + ((double)z - 0.5) * 2.0) / 1.0);
                double uu = du - u;
                double vv = dv - v;
                u = (float)((double)u + uu * ((double)((x % 4 + 4) % 4) / 4.0));
                v = (float)((double)v + vv * ((double)((z % 4 + 4) % 4) / 4.0));
                double u2 = (double)u + uu / 4.0;
                double v2 = (double)v + vv / 4.0;
                v5.func_78374_a(0.0, h1, 1.0, (double)u, v2);
                v5.func_78374_a(1.0, h2, 1.0, u2, v2);
                v5.func_78374_a(1.0, h3, 0.0, u2, (double)v);
                v5.func_78374_a(0.0, h4, 0.0, (double)u, (double)v);
                v5.func_78374_a(0.0, 0.0, 1.0, (double)u, (double)v);
                v5.func_78374_a(1.0, 0.0, 1.0, u2, (double)v);
                v5.func_78374_a(1.0, h2, 1.0, u2, v2);
                v5.func_78374_a(0.0, h1, 1.0, (double)u, v2);
                v5.func_78374_a(0.0, h4, 0.0, (double)u, v2);
                v5.func_78374_a(1.0, h3, 0.0, u2, v2);
                v5.func_78374_a(1.0, 0.0, 0.0, u2, (double)v);
                v5.func_78374_a(0.0, 0.0, 0.0, (double)u, (double)v);
                v5.func_78374_a(0.0, h1, 1.0, u2, v2);
                v5.func_78374_a(0.0, h4, 0.0, (double)u, v2);
                v5.func_78374_a(0.0, 0.0, 0.0, u2, (double)v);
                v5.func_78374_a(0.0, 0.0, 1.0, (double)u, (double)v);
                v5.func_78374_a(1.0, h3, 0.0, u2, v2);
                v5.func_78374_a(1.0, h2, 1.0, (double)u, v2);
                v5.func_78374_a(1.0, 0.0, 1.0, u2, (double)v);
                v5.func_78374_a(1.0, 0.0, 0.0, (double)u, (double)v);
                v5.func_78374_a(0.0, 0.0, 0.0, (double)u, (double)v);
                v5.func_78374_a(1.0, 0.0, 0.0, u2, (double)v);
                v5.func_78374_a(1.0, 0.0, 1.0, u2, v2);
                v5.func_78374_a(0.0, 0.0, 1.0, (double)u, v2);
                break;
            }
            case LATTICE: {
                v5.func_78380_c(240);
                v5.func_78378_d(0xFFFFFF);
                IIcon ico = ChromaIcons.WIDEBAR.getIcon();
                float u = ico.func_94209_e();
                float v = ico.func_94206_g();
                float du = ico.func_94212_f();
                float dv = ico.func_94210_h();
                ico = ChromaIcons.BIGFLARE.getIcon();
                float u2 = ico.func_94209_e();
                float v2 = ico.func_94206_g();
                float du2 = ico.func_94212_f();
                float dv2 = ico.func_94210_h();
                int i = (x % 4 + 4) % 4;
                int j = (y % 4 + 4) % 4;
                int k = (z % 4 + 4) % 4;
                for (int n = 0; n < 6; ++n) {
                    TessellatorVertexList vt5 = new TessellatorVertexList(0.5, 0.5, 0.5);
                    double w = 0.0625;
                    double l = 0.9375;
                    int c = ReikaColorAPI.getModifiedHue((int)0xFF4040, (int)((int)((double)n * 7.5) + (i + j + k) % 12 * 30));
                    vt5.addVertexWithUVColor(0.5 - w, 0.5 - l, 0.5 - w, (double)u2, (double)v2, c);
                    vt5.addVertexWithUVColor(0.5 + w, 0.5 - l, 0.5 - w, (double)du2, (double)v2, c);
                    vt5.addVertexWithUVColor(0.5 + w, 0.5 - l, 0.5 + w, (double)du2, (double)dv2, c);
                    vt5.addVertexWithUVColor(0.5 - w, 0.5 - l, 0.5 + w, (double)u2, (double)dv2, c);
                    vt5.addVertexWithUVColor(0.5 - w, 0.5 + l, 0.5 + w, (double)u2, (double)dv2, c);
                    vt5.addVertexWithUVColor(0.5 + w, 0.5 + l, 0.5 + w, (double)du2, (double)dv2, c);
                    vt5.addVertexWithUVColor(0.5 + w, 0.5 + l, 0.5 - w, (double)du2, (double)v2, c);
                    vt5.addVertexWithUVColor(0.5 - w, 0.5 + l, 0.5 - w, (double)u2, (double)v2, c);
                    vt5.addVertexWithUVColor(0.5 - w, 0.5 - l, 0.5 + w, (double)u, (double)v, c);
                    vt5.addVertexWithUVColor(0.5 + w, 0.5 - l, 0.5 + w, (double)u, (double)dv, c);
                    vt5.addVertexWithUVColor(0.5 + w, 0.5 + l, 0.5 + w, (double)du, (double)dv, c);
                    vt5.addVertexWithUVColor(0.5 - w, 0.5 + l, 0.5 + w, (double)du, (double)v, c);
                    vt5.addVertexWithUVColor(0.5 - w, 0.5 + l, 0.5 - w, (double)u, (double)dv, c);
                    vt5.addVertexWithUVColor(0.5 + w, 0.5 + l, 0.5 - w, (double)u, (double)v, c);
                    vt5.addVertexWithUVColor(0.5 + w, 0.5 - l, 0.5 - w, (double)du, (double)v, c);
                    vt5.addVertexWithUVColor(0.5 - w, 0.5 - l, 0.5 - w, (double)du, (double)dv, c);
                    vt5.addVertexWithUVColor(0.5 + w, 0.5 + l, 0.5 - w, (double)u, (double)dv, c);
                    vt5.addVertexWithUVColor(0.5 + w, 0.5 + l, 0.5 + w, (double)u, (double)v, c);
                    vt5.addVertexWithUVColor(0.5 + w, 0.5 - l, 0.5 + w, (double)du, (double)v, c);
                    vt5.addVertexWithUVColor(0.5 + w, 0.5 - l, 0.5 - w, (double)du, (double)dv, c);
                    vt5.addVertexWithUVColor(0.5 - w, 0.5 - l, 0.5 - w, (double)u, (double)v, c);
                    vt5.addVertexWithUVColor(0.5 - w, 0.5 - l, 0.5 + w, (double)u, (double)dv, c);
                    vt5.addVertexWithUVColor(0.5 - w, 0.5 + l, 0.5 + w, (double)du, (double)dv, c);
                    vt5.addVertexWithUVColor(0.5 - w, 0.5 + l, 0.5 - w, (double)du, (double)v, c);
                    this.rand.setSeed(this.calcSeed(x, y, z));
                    this.rand.nextBoolean();
                    double dx = this.rand.nextDouble() * 0.5 - 0.5;
                    double dy = this.rand.nextDouble() * 0.5 - 0.5;
                    double dz = this.rand.nextDouble() * 0.5 - 0.5;
                    vt5.offset(dx, dy, dz);
                    vt5.rotateNonOrthogonal(latticeRotations[0][i][n], latticeRotations[1][j][n], latticeRotations[2][k][n]);
                    vt5.render();
                }
                break;
            }
            case GEMSTONE: {
                break;
            }
            case CRYSTALLEAF: {
                break;
            }
            case OCEANSTONE: {
                break;
            }
            case CLIFFGLASS: {
                break;
            }
        }
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    static {
        for (int i = 0; i < latticeRotations.length; ++i) {
            for (int j = 0; j < latticeRotations[i].length; ++j) {
                for (int k = 0; k < latticeRotations[i][j].length; ++k) {
                    DimensionDecoRenderer.latticeRotations[i][j][k] = ReikaRandomHelper.getRandomBetween((double)0.0, (double)360.0);
                }
            }
        }
    }
}

