/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render.ISBRH;

import Reika.ChromatiCraft.Block.Worldgen.BlockTieredOre;
import Reika.DragonAPI.Base.ISBRH;
import Reika.DragonAPI.Instantiable.Rendering.TessellatorVertexList;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class TieredOreRenderer
extends ISBRH {
    private final int numSections = 8;
    private final double[][] stoneOffsets = new double[16][81];
    private final double[][] oreOffsets = new double[16][81];
    private final int[][][] offsetArray = new int[16][16][16];

    public TieredOreRenderer(int id) {
        super(id);
        int a;
        for (a = 0; a < 16; ++a) {
            double dp;
            double dk;
            double di;
            double dr;
            double dy;
            int k;
            int i;
            for (i = 0; i < 9; ++i) {
                for (k = 0; k < 9; ++k) {
                    dy = 1.0;
                    dr = 0.25;
                    di = (double)Math.min(i, 8 - i) / 8.0;
                    dk = (double)Math.min(k, 8 - k) / 8.0;
                    dp = 0.25;
                    dy = 1.0 - dr * Math.pow(di, dp) * Math.pow(dk, dp);
                    if (di > 0.0 && dk > 0.0) {
                        dy = ReikaRandomHelper.getRandomPlusMinus((double)dy, (double)(dr * 0.125));
                    }
                    this.stoneOffsets[a][i * 8 + k] = dy;
                }
            }
            for (i = 0; i < 9; ++i) {
                for (k = 0; k < 9; ++k) {
                    dy = 1.0;
                    dr = 0.25;
                    di = (double)Math.min(i, 8 - i) / 8.0;
                    dk = (double)Math.min(k, 8 - k) / 8.0;
                    dp = 0.25;
                    dy = 1.0 + dr * Math.pow(di, dp) * Math.pow(dk, dp) - 0.25;
                    if (di > 0.0 && dk > 0.0) {
                        dy = ReikaRandomHelper.getRandomPlusMinus((double)dy, (double)(dr * 0.5));
                    }
                    this.oreOffsets[a][i * 8 + k] = dy;
                }
            }
        }
        for (a = 0; a < 16; ++a) {
            for (int b = 0; b < 16; ++b) {
                for (int c = 0; c < 16; ++c) {
                    this.offsetArray[a][b][c] = ReikaRandomHelper.getSafeRandomInt((int)16);
                }
            }
        }
    }

    public void renderInventoryBlock(Block b, int metadata, int modelId, RenderBlocks rb) {
        IIcon ico;
        BlockTieredOre bt = (BlockTieredOre)b;
        Tessellator v5 = Tessellator.field_78398_a;
        rb.field_147861_i = 1.0;
        rb.field_147855_j = 0.0;
        rb.field_147853_m = 1.0;
        rb.field_147859_h = 0.0;
        rb.field_147851_l = 0.0;
        rb.field_147857_k = 1.0;
        boolean tier = bt.getProgressStage(metadata).isPlayerAtStage((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        IIcon iIcon = ico = tier ? bt.getBacking(metadata) : bt.getDisguise(metadata).func_149691_a(0, 0);
        if (!tier || !BlockTieredOre.TieredOres.list[metadata].renderAsGeode()) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            v5.func_78382_b();
            v5.func_78375_b(0.0f, -1.0f, 0.0f);
            rb.func_147768_a(b, 0.0, 0.0, 0.0, ico);
            v5.func_78381_a();
            v5.func_78382_b();
            v5.func_78375_b(0.0f, 1.0f, 0.0f);
            rb.func_147806_b(b, 0.0, 0.0, 0.0, ico);
            v5.func_78381_a();
            v5.func_78382_b();
            v5.func_78375_b(0.0f, 0.0f, -1.0f);
            rb.func_147761_c(b, 0.0, 0.0, 0.0, ico);
            v5.func_78381_a();
            v5.func_78382_b();
            v5.func_78375_b(0.0f, 0.0f, 1.0f);
            rb.func_147734_d(b, 0.0, 0.0, 0.0, ico);
            v5.func_78381_a();
            v5.func_78382_b();
            v5.func_78375_b(-1.0f, 0.0f, 0.0f);
            rb.func_147798_e(b, 0.0, 0.0, 0.0, ico);
            v5.func_78381_a();
            v5.func_78382_b();
            v5.func_78375_b(1.0f, 0.0f, 0.0f);
            rb.func_147764_f(b, 0.0, 0.0, 0.0, ico);
            v5.func_78381_a();
        }
        if (tier) {
            if (BlockTieredOre.TieredOres.list[metadata].renderAsGeode()) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
                v5.func_78382_b();
                v5.func_78380_c(240);
                this.renderGeode(null, 0, 0, 0, (Block)bt, metadata, rb);
                v5.func_78381_a();
                GL11.glPopMatrix();
            } else {
                ico = ((BlockTieredOre)b).getOverlay(metadata);
                v5.func_78382_b();
                v5.func_78375_b(0.0f, -1.0f, 0.0f);
                rb.func_147768_a(b, 0.0, 0.0, 0.0, ico);
                v5.func_78381_a();
                v5.func_78382_b();
                v5.func_78375_b(0.0f, 1.0f, 0.0f);
                rb.func_147806_b(b, 0.0, 0.0, 0.0, ico);
                v5.func_78381_a();
                v5.func_78382_b();
                v5.func_78375_b(0.0f, 0.0f, -1.0f);
                rb.func_147761_c(b, 0.0, 0.0, 0.0, ico);
                v5.func_78381_a();
                v5.func_78382_b();
                v5.func_78375_b(0.0f, 0.0f, 1.0f);
                rb.func_147734_d(b, 0.0, 0.0, 0.0, ico);
                v5.func_78381_a();
                v5.func_78382_b();
                v5.func_78375_b(-1.0f, 0.0f, 0.0f);
                rb.func_147798_e(b, 0.0, 0.0, 0.0, ico);
                v5.func_78381_a();
                v5.func_78382_b();
                v5.func_78375_b(1.0f, 0.0f, 0.0f);
                rb.func_147764_f(b, 0.0, 0.0, 0.0, ico);
                v5.func_78381_a();
            }
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block b, int modelId, RenderBlocks rb) {
        Tessellator v5 = Tessellator.field_78398_a;
        int meta = world.func_72805_g(x, y, z);
        BlockTieredOre t = (BlockTieredOre)b;
        if (t.isPlayerSufficientTier(world, x, y, z, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            if (BlockTieredOre.TieredOres.list[meta].renderAsGeode()) {
                v5.func_78380_c(240);
                v5.func_78376_a(255, 255, 255);
                this.renderGeode(world, x, y, z, b, meta, rb);
            } else {
                rb.func_147751_a(b, x, y, z, 1.0f, 1.0f, 1.0f);
                v5.func_78380_c(240);
                v5.func_78376_a(255, 255, 255);
                IIcon ico = t.getOverlay(meta);
                if (b.func_149646_a(world, x, y - 1, z, ForgeDirection.DOWN.ordinal())) {
                    rb.func_147768_a(b, (double)x, (double)y, (double)z, ico);
                }
                if (b.func_149646_a(world, x, y + 1, z, ForgeDirection.UP.ordinal())) {
                    rb.func_147806_b(b, (double)x, (double)y, (double)z, ico);
                }
                if (b.func_149646_a(world, x, y, z - 1, ForgeDirection.NORTH.ordinal())) {
                    rb.func_147761_c(b, (double)x, (double)y, (double)z, ico);
                }
                if (b.func_149646_a(world, x, y, z + 1, ForgeDirection.SOUTH.ordinal())) {
                    rb.func_147734_d(b, (double)x, (double)y, (double)z, ico);
                }
                if (b.func_149646_a(world, x - 1, y, z, ForgeDirection.WEST.ordinal())) {
                    rb.func_147798_e(b, (double)x, (double)y, (double)z, ico);
                }
                if (b.func_149646_a(world, x + 1, y, z, ForgeDirection.EAST.ordinal())) {
                    rb.func_147764_f(b, (double)x, (double)y, (double)z, ico);
                }
            }
        } else {
            rb.func_147751_a(t.getDisguise(meta), x, y, z, 1.0f, 1.0f, 1.0f);
        }
        return true;
    }

    private void renderSimpleGeode(IBlockAccess world, int x, int y, int z, Block b, int meta, RenderBlocks rb) {
        IIcon icos = ((BlockTieredOre)b).getGeodeStoneIcon(Math.abs(x + y * x * z + z) % 16);
        IIcon ico = ((BlockTieredOre)b).getGeodeIcon(meta);
        if (b.func_149646_a(world, x, y - 1, z, ForgeDirection.DOWN.ordinal())) {
            rb.func_147768_a(b, (double)x, (double)y, (double)z, icos);
        }
        if (b.func_149646_a(world, x, y + 1, z, ForgeDirection.UP.ordinal())) {
            rb.func_147806_b(b, (double)x, (double)y, (double)z, icos);
        }
        if (b.func_149646_a(world, x, y, z - 1, ForgeDirection.NORTH.ordinal())) {
            rb.func_147761_c(b, (double)x, (double)y, (double)z, icos);
        }
        if (b.func_149646_a(world, x, y, z + 1, ForgeDirection.SOUTH.ordinal())) {
            rb.func_147734_d(b, (double)x, (double)y, (double)z, icos);
        }
        if (b.func_149646_a(world, x - 1, y, z, ForgeDirection.WEST.ordinal())) {
            rb.func_147798_e(b, (double)x, (double)y, (double)z, icos);
        }
        if (b.func_149646_a(world, x + 1, y, z, ForgeDirection.EAST.ordinal())) {
            rb.func_147764_f(b, (double)x, (double)y, (double)z, icos);
        }
        Tessellator.field_78398_a.func_78380_c(240);
        Tessellator.field_78398_a.func_78376_a(255, 255, 255);
        double d = 0.0025;
        if (b.func_149646_a(world, x, y - 1, z, ForgeDirection.DOWN.ordinal())) {
            rb.func_147768_a(b, (double)x, (double)y + d, (double)z, ico);
        }
        if (b.func_149646_a(world, x, y + 1, z, ForgeDirection.UP.ordinal())) {
            rb.func_147806_b(b, (double)x, (double)y - d, (double)z, ico);
        }
        if (b.func_149646_a(world, x, y, z - 1, ForgeDirection.NORTH.ordinal())) {
            rb.func_147761_c(b, (double)x, (double)y, (double)z + d, ico);
        }
        if (b.func_149646_a(world, x, y, z + 1, ForgeDirection.SOUTH.ordinal())) {
            rb.func_147734_d(b, (double)x, (double)y, (double)z - d, ico);
        }
        if (b.func_149646_a(world, x - 1, y, z, ForgeDirection.WEST.ordinal())) {
            rb.func_147798_e(b, (double)x + d, (double)y, (double)z, ico);
        }
        if (b.func_149646_a(world, x + 1, y, z, ForgeDirection.EAST.ordinal())) {
            rb.func_147764_f(b, (double)x - d, (double)y, (double)z, ico);
        }
    }

    private void renderGeode(IBlockAccess world, int x, int y, int z, Block b, int meta, RenderBlocks rb) {
        double d;
        int i;
        TessellatorVertexList v5 = new TessellatorVertexList();
        Tessellator.field_78398_a.func_78378_d(0xFFFFFF);
        Tessellator.field_78398_a.func_78372_c((float)x, (float)y, (float)z);
        IIcon stone = ((BlockTieredOre)b).getDisguise(meta).func_149691_a(0, 0);
        float us = stone.func_94209_e();
        float vs = stone.func_94206_g();
        float dus = stone.func_94212_f();
        float dvs = stone.func_94210_h();
        IIcon obsidian = Blocks.field_150343_Z.func_149691_a(0, 0);
        float ub = obsidian.func_94209_e();
        float vb = obsidian.func_94206_g();
        float dub = obsidian.func_94212_f();
        float dvb = obsidian.func_94210_h();
        IIcon ico = ((BlockTieredOre)b).getGeodeIcon(meta);
        float uo = ico.func_94209_e();
        float vo = ico.func_94206_g();
        float duo = ico.func_94212_f();
        float dvo = ico.func_94210_h();
        double s = 0.125;
        int da = this.offsetArray[(x % 16 + 16) % 16][(y % 16 + 16) % 16][(z % 16 + 16) % 16];
        for (i = 0; i < 8; ++i) {
            d = (double)i * s;
            for (int k = 0; k < 8; ++k) {
                double d2 = (double)k * s;
                boolean center = false;
                float us1 = center ? (float)((double)ub + (double)(dub - ub) * d) : (float)((double)us + (double)(dus - us) * d);
                float vs1 = center ? (float)((double)vb + (double)(dvb - vb) * d2) : (float)((double)vs + (double)(dvs - vs) * d2);
                float us2 = center ? (float)((double)ub + (double)(dub - ub) * (d + s)) : (float)((double)us + (double)(dus - us) * (d + s));
                float vs2 = center ? (float)((double)vb + (double)(dvb - vb) * (d2 + s)) : (float)((double)vs + (double)(dvs - vs) * (d2 + s));
                v5.addVertexWithUV(d, this.stoneOffsets[da][i * 8 + (k + 1)], d2 + s, (double)us1, (double)vs2);
                v5.addVertexWithUV(d + s, this.stoneOffsets[da][(i + 1) * 8 + (k + 1)], d2 + s, (double)us1, (double)vs1);
                v5.addVertexWithUV(d + s, this.stoneOffsets[da][(i + 1) * 8 + k], d2, (double)us2, (double)vs1);
                v5.addVertexWithUV(d, this.stoneOffsets[da][i * 8 + k], d2, (double)us2, (double)vs2);
            }
        }
        if (world == null || b.func_149646_a(world, x, y + 1, z, ForgeDirection.UP.ordinal())) {
            if (world != null) {
                Tessellator.field_78398_a.func_78380_c(b.func_149677_c(world, x, y + 1, z));
                Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
            }
            Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
            v5.render();
        }
        v5.invertY();
        if (world == null || b.func_149646_a(world, x, y - 1, z, ForgeDirection.DOWN.ordinal())) {
            if (world != null) {
                Tessellator.field_78398_a.func_78380_c(b.func_149677_c(world, x, y - 1, z));
                Tessellator.field_78398_a.func_78386_a(0.5f, 0.5f, 0.5f);
            }
            Tessellator.field_78398_a.func_78375_b(0.0f, -1.0f, 0.0f);
            v5.render();
        }
        v5.rotateYtoX();
        if (world == null || b.func_149646_a(world, x - 1, y, z, ForgeDirection.WEST.ordinal())) {
            if (world != null) {
                Tessellator.field_78398_a.func_78380_c(b.func_149677_c(world, x - 1, y, z));
                Tessellator.field_78398_a.func_78386_a(0.8f, 0.8f, 0.8f);
            }
            Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
            v5.render();
        }
        v5.invertX();
        if (world == null || b.func_149646_a(world, x + 1, y, z, ForgeDirection.EAST.ordinal())) {
            if (world != null) {
                Tessellator.field_78398_a.func_78380_c(b.func_149677_c(world, x + 1, y, z));
                Tessellator.field_78398_a.func_78386_a(0.8f, 0.8f, 0.8f);
            }
            Tessellator.field_78398_a.func_78375_b(1.0f, 0.0f, 0.0f);
            v5.render();
        }
        v5.rotateXtoZ();
        if (world == null || b.func_149646_a(world, x, y, z + 1, ForgeDirection.SOUTH.ordinal())) {
            if (world != null) {
                Tessellator.field_78398_a.func_78380_c(b.func_149677_c(world, x, y, z + 1));
                Tessellator.field_78398_a.func_78386_a(0.7f, 0.7f, 0.7f);
            }
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
            v5.render();
        }
        v5.invertZ();
        if (world == null || b.func_149646_a(world, x, y, z - 1, ForgeDirection.NORTH.ordinal())) {
            if (world != null) {
                Tessellator.field_78398_a.func_78380_c(b.func_149677_c(world, x, y, z - 1));
                Tessellator.field_78398_a.func_78386_a(0.7f, 0.7f, 0.7f);
            }
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, 1.0f);
            v5.render();
        }
        v5.clear();
        Tessellator.field_78398_a.func_78380_c(240);
        Tessellator.field_78398_a.func_78378_d(0xFFFFFF);
        for (i = 0; i < 8; ++i) {
            d = (double)i * s;
            double db = d + s;
            for (int k = 0; k < 8; ++k) {
                double d2 = (double)k * s;
                double d2b = d2 + s;
                float uo1 = (float)((double)uo + (double)(duo - uo) * d);
                float vo1 = (float)((double)vo + (double)(dvo - vo) * d2);
                float uo2 = (float)((double)uo + (double)(duo - uo) * (d + s));
                float vo2 = (float)((double)vo + (double)(dvo - vo) * (d2 + s));
                if (i == 0) {
                    d = 0.2;
                } else if (i == 7) {
                    db = 0.8;
                }
                if (k == 0) {
                    d2 = 0.2;
                } else if (k == 7) {
                    d2b = 0.8;
                }
                v5.addVertexWithUV(d, this.oreOffsets[da][i * 8 + (k + 1)], d2b, (double)uo1, (double)vo1);
                v5.addVertexWithUV(db, this.oreOffsets[da][(i + 1) * 8 + (k + 1)], d2b, (double)uo2, (double)vo1);
                v5.addVertexWithUV(db, this.oreOffsets[da][(i + 1) * 8 + k], d2, (double)uo2, (double)vo2);
                v5.addVertexWithUV(d, this.oreOffsets[da][i * 8 + k], d2, (double)uo1, (double)vo2);
            }
        }
        if (world == null || b.func_149646_a(world, x, y + 1, z, ForgeDirection.UP.ordinal())) {
            Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
            v5.render();
        }
        v5.invertY();
        if (world == null || b.func_149646_a(world, x, y - 1, z, ForgeDirection.DOWN.ordinal())) {
            Tessellator.field_78398_a.func_78375_b(0.0f, -1.0f, 0.0f);
            v5.render();
        }
        v5.rotateYtoX();
        if (world == null || b.func_149646_a(world, x - 1, y, z, ForgeDirection.WEST.ordinal())) {
            Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
            v5.render();
        }
        v5.invertX();
        if (world == null || b.func_149646_a(world, x + 1, y, z, ForgeDirection.EAST.ordinal())) {
            Tessellator.field_78398_a.func_78375_b(1.0f, 0.0f, 0.0f);
            v5.render();
        }
        v5.rotateXtoZ();
        if (world == null || b.func_149646_a(world, x, y, z + 1, ForgeDirection.SOUTH.ordinal())) {
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
            v5.render();
        }
        v5.invertZ();
        if (world == null || b.func_149646_a(world, x, y, z - 1, ForgeDirection.NORTH.ordinal())) {
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, 1.0f);
            v5.render();
        }
        Tessellator.field_78398_a.func_78372_c((float)(-x), (float)(-y), (float)(-z));
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }
}

