/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render;

import Reika.ChromatiCraft.Magic.Lore.LoreScriptRenderer;
import Reika.ChromatiCraft.Magic.Lore.LoreScripts;
import Reika.ChromatiCraft.ModInterface.Bees.TileEntityLumenAlveary;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityStructControl;
import Reika.ChromatiCraft.TileEntity.TileEntityDataNode;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class InWorldScriptRenderer {
    private static final Random rand = new Random();

    public static void renderSnowScript(TileEntityStructControl te, float par8, Tessellator v5, double sc) {
        InWorldScriptRenderer.seedRandom((TileEntity)te);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)8.76, (double)2.0);
        GL11.glPushMatrix();
        int c1 = 14047999;
        int c2 = 14717434;
        ArrayList<LoreScripts.LorePanel> li = LoreScripts.ScriptLocations.SNOWSTRUCT.getUniqueRandomPanels(rand, 4);
        for (int r = 0; r < 4; ++r) {
            GL11.glPushMatrix();
            GL11.glRotated((double)(90 * r), (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-2.995);
            switch (r) {
                case 1: {
                    GL11.glTranslated((double)-1.0, (double)0.0, (double)0.0);
                    break;
                }
                case 2: {
                    GL11.glTranslated((double)-1.0, (double)0.0, (double)-1.0);
                    break;
                }
                case 3: {
                    GL11.glTranslated((double)0.0, (double)0.0, (double)-1.0);
                    break;
                }
                case 4: {
                    GL11.glTranslated((double)0.0, (double)0.0, (double)1.0);
                }
            }
            GL11.glTranslated((double)0.25, (double)0.0, (double)0.0);
            GL11.glScaled((double)sc, (double)sc, (double)sc);
            int i = 0;
            LoreScripts.LorePanel p = li.get(r);
            int w = 4 * p.size.maxLength * 2;
            double x = 4.0 * ((double)p.size.maxLength + 1.5);
            for (int k = 0; k < p.lineCount; ++k) {
                LoreScripts.LoreLine l = p.getLine(k);
                double tick = (double)(-i) + 0.125 * (double)((float)te.getTicksExisted() + par8);
                float f1 = (float)(0.5 + 0.5 * Math.sin(tick));
                float f2 = (float)Math.min(1.0, 0.75 + 0.25 * Math.sin(tick * 0.25 - 4.7) + 0.03125 * Math.sin(tick * 5.0 - 1.0));
                int c = ReikaColorAPI.mixColors((int)c1, (int)c2, (float)f1);
                c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)f2);
                LoreScriptRenderer.instance.startRendering(true, c);
                LoreScriptRenderer.instance.renderLine(l.text, x, i, w, true);
                LoreScriptRenderer.instance.stopRendering();
                i -= 11;
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public static void renderPylonScript(TileEntityCrystalPylon te, float par8, Tessellator v5, double sc) {
        int ca = te.getColor().getColor();
        int c1 = ReikaColorAPI.mixColors((int)ca, (int)0xFFFFFF, (float)0.75f);
        int c2 = ReikaColorAPI.mixColors((int)ca, (int)0xFFFFFF, (float)0.5f);
        InWorldScriptRenderer.seedRandom((TileEntity)te);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)-5.225, (double)0.0);
        GL11.glPushMatrix();
        ArrayList<LoreScripts.LorePanel> li = LoreScripts.ScriptLocations.PYLON.getUniqueRandomPanels(rand, 8);
        for (int r = 0; r < 4; ++r) {
            int c;
            float f2;
            float f1;
            double tick;
            LoreScripts.LoreLine l;
            int k;
            GL11.glPushMatrix();
            GL11.glRotated((double)(90 * r), (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)2.5, (double)0.0, (double)2.005);
            switch (r) {
                case 1: {
                    GL11.glTranslated((double)-1.0, (double)0.0, (double)0.0);
                    break;
                }
                case 2: {
                    GL11.glTranslated((double)-1.0, (double)0.0, (double)-1.0);
                    break;
                }
                case 3: {
                    GL11.glTranslated((double)0.0, (double)0.0, (double)-1.0);
                }
            }
            GL11.glTranslated((double)0.25, (double)0.0, (double)0.0);
            GL11.glScaled((double)sc, (double)sc, (double)sc);
            int i = 0;
            LoreScripts.LorePanel p = li.get(r);
            int w = 4 * p.size.maxLength * 2;
            double x = 4.0 * ((double)p.size.maxLength + 1.5);
            for (k = 0; k < p.lineCount; ++k) {
                l = p.getLine(k);
                tick = (double)(-i) + 0.125 * (double)((float)te.getTicksExisted() + par8);
                f1 = (float)(0.5 + 0.5 * Math.sin(tick));
                f2 = (float)Math.min(1.0, 0.75 + 0.25 * Math.sin(tick * 0.25 - 4.7) + 0.03125 * Math.sin(tick * 5.0 - 1.0));
                c = ReikaColorAPI.mixColors((int)c1, (int)c2, (float)f1);
                c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)f2);
                LoreScriptRenderer.instance.startRendering(true, c);
                LoreScriptRenderer.instance.renderLine(l.text, x, i, w, true);
                LoreScriptRenderer.instance.stopRendering();
                i -= 11;
            }
            i = 0;
            p = li.get(r + 1);
            w = 4 * p.size.maxLength * 2;
            x = 4.0 * ((double)p.size.maxLength + 1.5);
            x -= 320.0;
            for (k = 0; k < p.lineCount; ++k) {
                l = p.getLine(k);
                tick = (double)(-i) + 0.125 * (double)((float)te.getTicksExisted() + par8);
                f1 = (float)(0.5 + 0.5 * Math.sin(tick));
                f2 = (float)Math.min(1.0, 0.75 + 0.25 * Math.sin(tick * 0.25 - 4.7) + 0.03125 * Math.sin(tick * 5.0 - 1.0));
                c = ReikaColorAPI.mixColors((int)c1, (int)c2, (float)f1);
                c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)f2);
                LoreScriptRenderer.instance.startRendering(true, c);
                LoreScriptRenderer.instance.renderLine(l.text, x, i, w, true);
                LoreScriptRenderer.instance.stopRendering();
                i -= 11;
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public static void renderAlvearyScript(TileEntityLumenAlveary te, float par8, Tessellator v5, double sc, double maxDSq) {
        int c1 = 0xFFFFFF;
        int c2 = 7593215;
        GL11.glTranslated((double)1.5, (double)2.5, (double)1.5);
        InWorldScriptRenderer.seedRandom((TileEntity)te);
        GL11.glPushMatrix();
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        GL11.glTranslated((double)0.0, (double)-0.225, (double)0.0);
        GL11.glPushMatrix();
        ArrayList<LoreScripts.LorePanel> li = LoreScripts.ScriptLocations.ALVEARY.getUniqueRandomPanels(rand, 4);
        double d = Minecraft.func_71410_x().field_71439_g.func_70092_e((double)te.field_145851_c + 0.5, (double)te.field_145848_d + 0.5, (double)te.field_145849_e + 0.5);
        double da = 1.0;
        if (d >= maxDSq * 0.5) {
            da = 2.0 * (1.0 - d / maxDSq);
        }
        for (int r = 0; r < 4; ++r) {
            GL11.glPushMatrix();
            GL11.glRotated((double)(90 * r), (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)0.0, (double)2.005);
            switch (r) {
                case 1: {
                    GL11.glTranslated((double)-1.0, (double)0.0, (double)0.0);
                    break;
                }
                case 2: {
                    GL11.glTranslated((double)-1.0, (double)0.0, (double)-1.0);
                    break;
                }
                case 3: {
                    GL11.glTranslated((double)0.0, (double)0.0, (double)-1.0);
                }
            }
            GL11.glTranslated((double)0.25, (double)0.0, (double)0.0);
            GL11.glScaled((double)sc, (double)sc, (double)sc);
            int i = 0;
            LoreScripts.LorePanel p = li.get(r);
            int w = 4 * p.size.maxLength * 2 - 24;
            double x = 4.0 * ((double)p.size.maxLength + 1.5) - 16.0;
            for (int k = 0; k < p.lineCount; ++k) {
                LoreScripts.LoreLine l = p.getLine(k);
                double tick = (double)(-i) + 0.125 * (double)((float)te.getTicksExisted() + par8);
                float f1 = (float)(0.5 + 0.5 * Math.sin(tick));
                float f2 = (float)Math.min(1.0, 0.75 + 0.25 * Math.sin(tick * 0.25 - 4.7) + 0.03125 * Math.sin(tick * 5.0 - 1.0));
                f2 = (float)((double)f2 * da);
                int c = ReikaColorAPI.mixColors((int)c1, (int)c2, (float)f1);
                c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)f2);
                LoreScriptRenderer.instance.startRendering(true, c);
                LoreScriptRenderer.instance.renderLine(l.text, x, i, w, true);
                LoreScriptRenderer.instance.stopRendering();
                i -= 11;
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public static void renderTowerScript(TileEntityDataNode te, float par8, Tessellator v5, double sc, double maxDSq) {
        int c1 = 0xFFFFFF;
        int c2 = 7593215;
        InWorldScriptRenderer.seedRandom((TileEntity)te);
        GL11.glPushMatrix();
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        GL11.glTranslated((double)0.0, (double)-0.225, (double)0.0);
        GL11.glPushMatrix();
        ArrayList<LoreScripts.LorePanel> li = LoreScripts.ScriptLocations.TOWER.getUniqueRandomPanels(rand, 4);
        double d = Minecraft.func_71410_x().field_71439_g.func_70092_e((double)te.field_145851_c + 0.5, (double)te.field_145848_d + 0.5, (double)te.field_145849_e + 0.5);
        double da = 1.0;
        if (d >= maxDSq * 0.5) {
            da = 2.0 * (1.0 - d / maxDSq);
        }
        for (int r = 0; r < 4; ++r) {
            GL11.glPushMatrix();
            GL11.glRotated((double)(90 * r), (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)0.0, (double)2.005);
            switch (r) {
                case 1: {
                    GL11.glTranslated((double)-1.0, (double)0.0, (double)0.0);
                    break;
                }
                case 2: {
                    GL11.glTranslated((double)-1.0, (double)0.0, (double)-1.0);
                    break;
                }
                case 3: {
                    GL11.glTranslated((double)0.0, (double)0.0, (double)-1.0);
                }
            }
            GL11.glTranslated((double)0.25, (double)0.0, (double)0.0);
            GL11.glScaled((double)sc, (double)sc, (double)sc);
            int i = 0;
            LoreScripts.LorePanel p = li.get(r);
            int w = 4 * p.size.maxLength * 2;
            double x = 4.0 * ((double)p.size.maxLength + 1.5);
            for (int k = 0; k < p.lineCount; ++k) {
                LoreScripts.LoreLine l = p.getLine(k);
                double tick = (double)(-i) + 0.125 * (double)((float)te.getTicksExisted() + par8);
                float f1 = (float)(0.5 + 0.5 * Math.sin(tick));
                float f2 = (float)Math.min(1.0, 0.75 + 0.25 * Math.sin(tick * 0.25 - 4.7) + 0.03125 * Math.sin(tick * 5.0 - 1.0));
                f2 = (float)((double)f2 * da);
                int c = ReikaColorAPI.mixColors((int)c1, (int)c2, (float)f1);
                c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)f2);
                LoreScriptRenderer.instance.startRendering(true, c);
                LoreScriptRenderer.instance.renderLine(l.text, x, i, w, true);
                LoreScriptRenderer.instance.stopRendering();
                i -= 11;
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public static void renderDesertScript(TileEntityStructControl te, float par8, Tessellator v5, double sc) {
        InWorldScriptRenderer.seedRandom((TileEntity)te);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)1.825, (double)0.0);
        GL11.glPushMatrix();
        int c1 = 16755266;
        int c2 = 0xFFFF70;
        ArrayList<LoreScripts.LorePanel> li = LoreScripts.ScriptLocations.DESERT.getUniqueRandomPanels(rand, 4);
        for (int r = 0; r < 4; ++r) {
            GL11.glPushMatrix();
            GL11.glRotated((double)(90 * r), (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-4.995);
            switch (r) {
                case 1: {
                    GL11.glTranslated((double)-1.0, (double)0.0, (double)0.0);
                    break;
                }
                case 2: {
                    GL11.glTranslated((double)-1.0, (double)0.0, (double)-1.0);
                    break;
                }
                case 3: {
                    GL11.glTranslated((double)0.0, (double)0.0, (double)-1.0);
                }
            }
            GL11.glTranslated((double)0.25, (double)0.0, (double)0.0);
            GL11.glScaled((double)sc, (double)sc, (double)sc);
            int i = 0;
            LoreScripts.LorePanel p = li.get(r);
            int w = 4 * p.size.maxLength * 2;
            double x = 4.0 * ((double)p.size.maxLength + 1.5);
            for (int k = 0; k < p.lineCount; ++k) {
                LoreScripts.LoreLine l = p.getLine(k);
                double tick = (double)(-i) + 0.125 * (double)((float)te.getTicksExisted() + par8);
                float f1 = (float)(0.5 + 0.5 * Math.sin(tick));
                float f2 = (float)Math.min(1.0, 0.75 + 0.25 * Math.sin(tick * 0.25 - 4.7) + 0.03125 * Math.sin(tick * 5.0 - 1.0));
                int c = ReikaColorAPI.mixColors((int)c1, (int)c2, (float)f1);
                c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)f2);
                LoreScriptRenderer.instance.startRendering(true, c);
                LoreScriptRenderer.instance.renderLine(l.text, x, i, w, true);
                LoreScriptRenderer.instance.stopRendering();
                i -= 11;
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public static void renderOceanScript(TileEntityStructControl te, float par8, Tessellator v5, double sc) {
        InWorldScriptRenderer.seedRandom((TileEntity)te);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.825, (double)0.0);
        GL11.glPushMatrix();
        ArrayList<LoreScripts.LorePanel> li = LoreScripts.ScriptLocations.OCEAN.getUniqueRandomPanels(rand, 2);
        int c1 = 2518783;
        int c2 = 7444968;
        for (int r = 2; r < 4; ++r) {
            GL11.glPushMatrix();
            GL11.glRotated((double)(90 * r), (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)0.0, (double)0.0, (double)-20.995);
            switch (r) {
                case 2: {
                    GL11.glTranslated((double)-3.5, (double)0.0, (double)-1.0);
                    break;
                }
                case 3: {
                    GL11.glTranslated((double)2.5, (double)0.0, (double)-1.0);
                }
            }
            GL11.glTranslated((double)0.25, (double)0.0, (double)0.0);
            GL11.glScaled((double)sc, (double)sc, (double)sc);
            int i = 0;
            LoreScripts.LorePanel p = li.get(r - 2);
            int w = 4 * p.size.maxLength * 2;
            double x = 4.0 * ((double)p.size.maxLength + 1.5);
            for (int k = 0; k < p.lineCount; ++k) {
                LoreScripts.LoreLine l = p.getLine(k);
                double tick = (double)(-i) + 0.125 * (double)((float)te.getTicksExisted() + par8);
                float f1 = (float)(0.5 + 0.5 * Math.sin(tick));
                float f2 = (float)Math.min(1.0, 0.75 + 0.25 * Math.sin(tick * 0.25 - 4.7) + 0.03125 * Math.sin(tick * 5.0 - 1.0));
                int c = ReikaColorAPI.mixColors((int)c1, (int)c2, (float)f1);
                c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)f2);
                LoreScriptRenderer.instance.startRendering(true, c);
                LoreScriptRenderer.instance.renderLine(l.text, x, i, w, true);
                LoreScriptRenderer.instance.stopRendering();
                i -= 11;
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public static void renderBurrowScript(TileEntityStructControl te, float par8, Tessellator v5, double sc) {
        int c;
        float f2;
        float f1;
        double tick;
        LoreScripts.LoreLine l;
        int k;
        InWorldScriptRenderer.seedRandom((TileEntity)te);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)-1.175, (double)0.0);
        GL11.glPushMatrix();
        ArrayList<LoreScripts.LorePanel> li = LoreScripts.ScriptLocations.BURROW.getUniqueRandomPanels(rand, 3);
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.995);
        GL11.glTranslated((double)0.25, (double)0.0, (double)0.0);
        GL11.glScaled((double)sc, (double)sc, (double)sc);
        int ca = te.getColor().getColor();
        int cb = ReikaColorAPI.mixColors((int)ca, (int)0xFFFFFF, (float)0.75f);
        int c1 = ReikaColorAPI.getShiftedHue((int)cb, (float)-8.0f);
        int c2 = ReikaColorAPI.getShiftedHue((int)cb, (float)8.0f);
        int i = 0;
        LoreScripts.LorePanel p = li.get(0);
        int w = 4 * p.size.maxLength * 2;
        double x = 4.0 * ((double)p.size.maxLength + 1.5);
        for (k = 0; k < p.lineCount; ++k) {
            l = p.getLine(k);
            tick = (double)(-i) + 0.125 * (double)((float)te.getTicksExisted() + par8);
            f1 = (float)(0.5 + 0.5 * Math.sin(tick));
            f2 = (float)Math.min(1.0, 0.75 + 0.25 * Math.sin(tick * 0.25 - 4.7) + 0.03125 * Math.sin(tick * 5.0 - 1.0));
            c = ReikaColorAPI.mixColors((int)c1, (int)c2, (float)f1);
            c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)f2);
            LoreScriptRenderer.instance.startRendering(true, c);
            LoreScriptRenderer.instance.renderLine(l.text, x, i, w, true);
            LoreScriptRenderer.instance.stopRendering();
            i -= 11;
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-0.75, (double)0.0, (double)-1.995);
        GL11.glScaled((double)sc, (double)sc, (double)sc);
        i = 0;
        p = li.get(1);
        w = 4 * p.size.maxLength * 2;
        x = 4.0 * ((double)p.size.maxLength + 1.5);
        for (k = 0; k < p.lineCount; ++k) {
            l = p.getLine(k);
            tick = (double)(-i - 76) + 0.125 * (double)((float)te.getTicksExisted() + par8);
            f1 = (float)(0.5 + 0.5 * Math.sin(tick));
            f2 = (float)Math.min(1.0, 0.75 + 0.25 * Math.sin(tick * 0.25 - 4.7) + 0.03125 * Math.sin(tick * 5.0 - 1.0));
            c = ReikaColorAPI.mixColors((int)c1, (int)c2, (float)f1);
            c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)f2);
            LoreScriptRenderer.instance.startRendering(true, c);
            LoreScriptRenderer.instance.renderLine(l.text, x, i, w, true);
            LoreScriptRenderer.instance.stopRendering();
            i -= 11;
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-0.75, (double)0.0, (double)-0.995);
        GL11.glScaled((double)sc, (double)sc, (double)sc);
        i = 0;
        p = li.get(2);
        w = 4 * p.size.maxLength * 2;
        x = 4.0 * ((double)p.size.maxLength + 1.5);
        for (k = 0; k < p.lineCount; ++k) {
            l = p.getLine(k);
            tick = (double)(-i + 23) + 0.125 * (double)((float)te.getTicksExisted() + par8);
            f1 = (float)(0.5 + 0.5 * Math.sin(tick));
            f2 = (float)Math.min(1.0, 0.75 + 0.25 * Math.sin(tick * 0.25 - 4.7) + 0.03125 * Math.sin(tick * 5.0 - 1.0));
            c = ReikaColorAPI.mixColors((int)c1, (int)c2, (float)f1);
            c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)f2);
            LoreScriptRenderer.instance.startRendering(true, c);
            LoreScriptRenderer.instance.renderLine(l.text, x, i, w, true);
            LoreScriptRenderer.instance.stopRendering();
            i -= 11;
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public static void renderCavernScript(TileEntityStructControl te, float par8, Tessellator v5, double sc) {
        int c;
        float f2;
        float f1;
        double tick;
        LoreScripts.LoreLine l;
        int k;
        InWorldScriptRenderer.seedRandom((TileEntity)te);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)2.765, (double)0.0);
        GL11.glPushMatrix();
        ArrayList<LoreScripts.LorePanel> li = LoreScripts.ScriptLocations.CAVERN1.getUniqueRandomPanels(rand, 2);
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.995);
        GL11.glTranslated((double)0.25, (double)0.0, (double)0.0);
        GL11.glScaled((double)sc, (double)sc, (double)sc);
        int c1 = 0x70F0FF;
        int c2 = 0x22AAFF;
        int i = 0;
        LoreScripts.LorePanel p = li.get(0);
        int w = 4 * p.size.maxLength * 2;
        double x = 4.0 * ((double)p.size.maxLength + 1.5);
        for (k = 0; k < p.lineCount; ++k) {
            l = p.getLine(k);
            tick = (double)(-i) + 0.125 * (double)((float)te.getTicksExisted() + par8);
            f1 = (float)(0.5 + 0.5 * Math.sin(tick));
            f2 = (float)Math.min(1.0, 0.75 + 0.25 * Math.sin(tick * 0.25 - 4.7) + 0.03125 * Math.sin(tick * 5.0 - 1.0));
            c = ReikaColorAPI.mixColors((int)c1, (int)c2, (float)f1);
            c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)f2);
            LoreScriptRenderer.instance.startRendering(true, c);
            LoreScriptRenderer.instance.renderLine(l.text, x, i, w, true);
            LoreScriptRenderer.instance.stopRendering();
            i -= 11;
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-0.75, (double)0.0, (double)-1.995);
        GL11.glScaled((double)sc, (double)sc, (double)sc);
        i = 0;
        p = li.get(1);
        w = 4 * p.size.maxLength * 2;
        x = 4.0 * ((double)p.size.maxLength + 1.5);
        for (k = 0; k < p.lineCount; ++k) {
            l = p.getLine(k);
            tick = (double)(-i - 76) + 0.125 * (double)((float)te.getTicksExisted() + par8);
            f1 = (float)(0.5 + 0.5 * Math.sin(tick));
            f2 = (float)Math.min(1.0, 0.75 + 0.25 * Math.sin(tick * 0.25 - 4.7) + 0.03125 * Math.sin(tick * 5.0 - 1.0));
            c = ReikaColorAPI.mixColors((int)c1, (int)c2, (float)f1);
            c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)f2);
            LoreScriptRenderer.instance.startRendering(true, c);
            LoreScriptRenderer.instance.renderLine(l.text, x, i, w, true);
            LoreScriptRenderer.instance.stopRendering();
            i -= 11;
        }
        GL11.glPopMatrix();
        GL11.glTranslated((double)0.0, (double)-1.0, (double)0.0);
        GL11.glPushMatrix();
        li = LoreScripts.ScriptLocations.CAVERN2.getUniqueRandomPanels(rand, 2);
        GL11.glTranslated((double)0.0, (double)0.0, (double)-1.995);
        GL11.glTranslated((double)2.75, (double)0.0, (double)0.0);
        GL11.glScaled((double)sc, (double)sc, (double)sc);
        i = 0;
        p = li.get(0);
        w = 4 * p.size.maxLength * 2;
        x = 4.0 * ((double)p.size.maxLength + 1.5);
        for (k = 0; k < p.lineCount; ++k) {
            l = p.getLine(k);
            tick = (double)(-i) + 0.125 * (double)((float)te.getTicksExisted() + par8);
            f1 = (float)(0.5 + 0.5 * Math.sin(tick));
            f2 = (float)Math.min(1.0, 0.75 + 0.25 * Math.sin(tick * 0.25 - 4.7) + 0.03125 * Math.sin(tick * 5.0 - 1.0));
            c = ReikaColorAPI.mixColors((int)c1, (int)c2, (float)f1);
            c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)f2);
            LoreScriptRenderer.instance.startRendering(true, c);
            LoreScriptRenderer.instance.renderLine(l.text, x, i, w, true);
            LoreScriptRenderer.instance.stopRendering();
            i -= 11;
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)-3.25, (double)0.0, (double)-2.995);
        GL11.glScaled((double)sc, (double)sc, (double)sc);
        i = 0;
        p = li.get(1);
        w = 4 * p.size.maxLength * 2;
        x = 4.0 * ((double)p.size.maxLength + 1.5);
        for (k = 0; k < p.lineCount; ++k) {
            l = p.getLine(k);
            tick = (double)(-i - 76) + 0.125 * (double)((float)te.getTicksExisted() + par8);
            f1 = (float)(0.5 + 0.5 * Math.sin(tick));
            f2 = (float)Math.min(1.0, 0.75 + 0.25 * Math.sin(tick * 0.25 - 4.7) + 0.03125 * Math.sin(tick * 5.0 - 1.0));
            c = ReikaColorAPI.mixColors((int)c1, (int)c2, (float)f1);
            c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)f2);
            LoreScriptRenderer.instance.startRendering(true, c);
            LoreScriptRenderer.instance.renderLine(l.text, x, i, w, true);
            LoreScriptRenderer.instance.stopRendering();
            i -= 11;
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        li = LoreScripts.ScriptLocations.CAVERN3.getUniqueRandomPanels(rand, 2);
        GL11.glTranslated((double)0.0, (double)0.0, (double)-1.995);
        GL11.glTranslated((double)-2.25, (double)0.0, (double)0.0);
        GL11.glScaled((double)sc, (double)sc, (double)sc);
        i = 0;
        p = li.get(0);
        w = 4 * p.size.maxLength * 2;
        x = 4.0 * ((double)p.size.maxLength + 1.5);
        for (k = 0; k < p.lineCount; ++k) {
            l = p.getLine(k);
            tick = (double)(-i) + 0.125 * (double)((float)te.getTicksExisted() + par8);
            f1 = (float)(0.5 + 0.5 * Math.sin(tick));
            f2 = (float)Math.min(1.0, 0.75 + 0.25 * Math.sin(tick * 0.25 - 4.7) + 0.03125 * Math.sin(tick * 5.0 - 1.0));
            c = ReikaColorAPI.mixColors((int)c1, (int)c2, (float)f1);
            c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)f2);
            LoreScriptRenderer.instance.startRendering(true, c);
            LoreScriptRenderer.instance.renderLine(l.text, x, i, w, true);
            LoreScriptRenderer.instance.stopRendering();
            i -= 11;
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)1.75, (double)0.0, (double)-2.995);
        GL11.glScaled((double)sc, (double)sc, (double)sc);
        i = 0;
        p = li.get(1);
        w = 4 * p.size.maxLength * 2;
        x = 4.0 * ((double)p.size.maxLength + 1.5);
        for (k = 0; k < p.lineCount; ++k) {
            l = p.getLine(k);
            tick = (double)(-i - 76) + 0.125 * (double)((float)te.getTicksExisted() + par8);
            f1 = (float)(0.5 + 0.5 * Math.sin(tick));
            f2 = (float)Math.min(1.0, 0.75 + 0.25 * Math.sin(tick * 0.25 - 4.7) + 0.03125 * Math.sin(tick * 5.0 - 1.0));
            c = ReikaColorAPI.mixColors((int)c1, (int)c2, (float)f1);
            c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)f2);
            LoreScriptRenderer.instance.startRendering(true, c);
            LoreScriptRenderer.instance.renderLine(l.text, x, i, w, true);
            LoreScriptRenderer.instance.stopRendering();
            i -= 11;
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    private static void seedRandom(TileEntity te) {
        rand.setSeed(te.field_145851_c + (te.field_145848_d << 16) + (te.field_145849_e << 8));
    }
}

