/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render.Particle;

import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Rendering.ParticleEngine;
import Reika.DragonAPI.Interfaces.Entity.CustomRenderFX;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.world.World;

public class EntityRelayPathFX
extends EntityFX
implements CustomRenderFX {
    private static final ParticleEngine.RenderMode renderMode = new ParticleEngine.RenderMode().setFlag(ParticleEngine.RenderModeFlags.ADDITIVE, true).setFlag(ParticleEngine.RenderModeFlags.DEPTH, true).setFlag(ParticleEngine.RenderModeFlags.LIGHT, false).setFlag(ParticleEngine.RenderModeFlags.ALPHACLIP, false);
    private ArrayList<Coordinate> targets;
    private int index = 0;
    private boolean velTick = true;

    public EntityRelayPathFX(CrystalElement e, Coordinate c1, Coordinate c2) {
        this(e, (double)c1.xCoord + 0.5, (double)c1.yCoord + 0.5, (double)c1.zCoord + 0.5);
        double dx = (double)c2.xCoord - this.field_70165_t + 0.5;
        double dy = (double)c2.yCoord - this.field_70163_u + 0.5;
        double dz = (double)c2.zCoord - this.field_70161_v + 0.5;
        double v = 0.1;
        this.field_70159_w = v * dx;
        this.field_70181_x = v * dy;
        this.field_70179_y = v * dz;
        this.targets = new ArrayList();
        this.targets.add(c2);
        this.velTick = false;
    }

    public EntityRelayPathFX(CrystalElement e, ArrayList<Coordinate> li) {
        this(e, (double)li.get((int)0).xCoord + 0.5, (double)li.get((int)0).yCoord + 0.5, (double)li.get((int)0).zCoord + 0.5);
        this.targets = li;
        this.targets.remove(0);
    }

    private EntityRelayPathFX(CrystalElement e, double x, double y, double z) {
        super((World)Minecraft.func_71410_x().field_71441_e, x, y, z);
        this.field_70547_e = Integer.MAX_VALUE;
        this.field_70544_f = (float)ReikaRandomHelper.getRandomBetween((double)2.5, (double)4.0);
        this.field_70545_g = 0.0f;
        this.field_70145_X = true;
        this.field_70552_h = (float)e.getRed() / 255.0f;
        this.field_70553_i = (float)e.getGreen() / 255.0f;
        this.field_70551_j = (float)e.getBlue() / 255.0f;
        switch (this.field_70146_Z.nextInt(4)) {
            case 0: {
                this.field_70550_a = ChromaIcons.BIGFLARE.getIcon();
                break;
            }
            case 1: {
                this.field_70550_a = ChromaIcons.SPINFLARE.getIcon();
                break;
            }
            case 2: {
                this.field_70550_a = ChromaIcons.BLURFLARE.getIcon();
                break;
            }
            case 3: {
                this.field_70550_a = ChromaIcons.FLARE7.getIcon();
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.testAndUpdate();
        if (this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y < 0.015625) {
            this.die();
        }
    }

    private void testAndUpdate() {
        Coordinate c = this.targets.get(this.index);
        double dx = (double)c.xCoord - this.field_70165_t + 0.5;
        double dy = (double)c.yCoord - this.field_70163_u + 0.5;
        double dz = (double)c.zCoord - this.field_70161_v + 0.5;
        double d = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
        double v = 0.5 + 0.125 * Math.sin(this.hashCode());
        if (d < 0.125) {
            if (this.index == this.targets.size() - 1) {
                this.die();
            } else {
                ++this.index;
                this.testAndUpdate();
            }
        } else if (this.velTick) {
            this.field_70159_w = v * dx / d;
            this.field_70181_x = v * dy / d;
            this.field_70179_y = v * dz / d;
        }
    }

    private void die() {
        this.func_70106_y();
    }

    public int func_70070_b(float par1) {
        return 240;
    }

    public int func_70537_b() {
        return 2;
    }

    public final ParticleEngine.RenderMode getRenderMode() {
        return renderMode;
    }

    public final ParticleEngine.TextureMode getTexture() {
        return ParticleEngine.blockTex;
    }

    public boolean rendersOverLimit() {
        return true;
    }

    public double getRenderRange() {
        return 120.0;
    }
}

