/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render;

import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Rendering.ColorBlendList;
import Reika.DragonAPI.Instantiable.Rendering.RenderPolygon;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.MathSci.BlockPolygonizer;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import org.lwjgl.opengl.GL11;

public class PolyCrystal {
    private final BlockArray blocks;
    private Collection<RenderPolygon> polygons;
    private static final ColorBlendList colors = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? PolyCrystal.createColorList() : null;

    @SideOnly(value=Side.CLIENT)
    private static ColorBlendList createColorList() {
        return new ColorBlendList(80.0f, ChromaFX.getChromaColorTiles());
    }

    public PolyCrystal() {
        this(new BlockArray());
    }

    public PolyCrystal(BlockArray arr) {
        this.blocks = arr;
    }

    public PolyCrystal addBlock(int x, int y, int z) {
        this.blocks.addBlockCoordinate(x, y, z);
        this.update();
        return this;
    }

    public PolyCrystal removeBlock(int x, int y, int z) {
        this.blocks.remove(x, y, z);
        this.update();
        return this;
    }

    public void update() {
        this.polygons = BlockPolygonizer.calcVerticesForBlocks((BlockArray)this.blocks);
    }

    public void writeToNBT(String label, NBTTagCompound NBT) {
        this.blocks.writeToNBT(label, NBT);
    }

    public void readFromNBT(String label, NBTTagCompound NBT) {
        this.blocks.readFromNBT(label, NBT);
        this.update();
    }

    public AxisAlignedBB asAABB() {
        return this.blocks.asAABB();
    }

    @SideOnly(value=Side.CLIENT)
    public void render(Tessellator v5, float ptick) {
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)false);
        ReikaRenderHelper.disableEntityLighting();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)3008);
        if (this.polygons.isEmpty() && !this.blocks.isEmpty()) {
            this.update();
        }
        v5.func_78371_b(4);
        v5.func_78380_c(240);
        v5.func_78375_b(0.0f, 1.0f, 0.0f);
        for (RenderPolygon p : this.polygons) {
            int c = colors.getColor((double)System.currentTimeMillis() + (double)p.locationHash() / 40.0);
            c = ReikaColorAPI.mixColors((int)c, (int)0xFFFFFF, (float)0.125f);
            v5.func_78384_a(c, 192);
            v5.func_78377_a(p.pos1.xCoord, p.pos1.yCoord, p.pos1.zCoord);
            v5.func_78377_a(p.pos2.xCoord, p.pos2.yCoord, p.pos2.zCoord);
            v5.func_78377_a(p.pos3.xCoord, p.pos3.yCoord, p.pos3.zCoord);
        }
        v5.func_78381_a();
        GL11.glPopAttrib();
    }
}

