/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render;

import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Math.Spline;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import java.util.Random;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class PulsingRadius {
    private static final Random rand = new Random();
    private final Spline spline;
    public final int density;
    public final double radius;
    public final double radiusVariance;

    public PulsingRadius(double radius, double var) {
        this.density = 60;
        this.radius = radius;
        this.radiusVariance = var;
        this.spline = new Spline(Spline.SplineType.CENTRIPETAL);
        for (int i = 0; i < this.density; ++i) {
            this.spline.addPoint((Spline.SplineAnchor)new RadiusPoint(this.radius, this.radiusVariance, (double)i * 360.0 / (double)this.density));
        }
    }

    public void render(double x, double y, double z, int color) {
        GL11.glPushAttrib((int)1048575);
        Tessellator v5 = Tessellator.field_78398_a;
        this.spline.render(v5, x, y, z, color, true, true, 6, 1.0f, ReikaGLHelper.BlendMode.DEFAULT);
        GL11.glPopAttrib();
    }

    public void update() {
        this.spline.update();
    }

    private static class RadiusPoint
    implements Spline.SplineAnchor {
        public final double baseRadius;
        public final double radiusVariation;
        public final double angle;
        private double radius;
        private double targetRadius;

        private RadiusPoint(double r, double v, double t) {
            this.baseRadius = r;
            this.radiusVariation = v;
            this.radius = this.baseRadius;
            this.angle = t;
            this.pickNewTarget();
        }

        public DecimalPosition asPosition() {
            double a = Math.toRadians(this.angle);
            double dx = this.radius * Math.cos(a);
            double dz = this.radius * Math.sin(a);
            return new DecimalPosition(dx, 0.0, dz);
        }

        public void update() {
            double dr = this.targetRadius - this.radius;
            if (this.atTarget(dr)) {
                this.pickNewTarget();
            }
            this.move(dr);
        }

        private void move(double dr) {
            if (Math.abs(dr) >= 0.05) {
                this.radius += 0.025 * Math.signum(dr);
            }
        }

        private boolean atTarget(double dr) {
            return Math.abs(dr) < 0.05;
        }

        private void pickNewTarget() {
            this.targetRadius = ReikaRandomHelper.getRandomPlusMinus((double)this.baseRadius, (double)this.radiusVariation);
        }
    }
}

