/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render.TESR;

import Reika.ChromatiCraft.Base.ChromaRenderBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.TileEntityAspectJar;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Instantiable.Rendering.ColorBlendList;
import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumItemHelper;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;

public class AspectJarRenderer
extends ChromaRenderBase {
    private static Class jarModelClass;
    private static Method modelRender;
    private static Field liquidIcon;
    private ModelBase model;
    private final ColorBlendList primalAspectColors = new ColorBlendList(20.0f);

    public AspectJarRenderer() {
        if (!ModList.THAUMCRAFT.isLoaded()) {
            return;
        }
        try {
            this.model = (ModelBase)jarModelClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Could not create ThaumCraft jar model instance to use for ChromatiCraft jar!");
        }
        for (Aspect a : Aspect.getPrimalAspects()) {
            this.primalAspectColors.addColor(a.getColor());
        }
    }

    public String getImageFileName(RenderFetcher te) {
        return "jar";
    }

    public void func_147500_a(TileEntity tile, double par2, double par4, double par6, float par8) {
        if (!ModList.THAUMCRAFT.isLoaded()) {
            return;
        }
        TileEntityAspectJar te = (TileEntityAspectJar)tile;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par4, (double)par6);
        GL11.glTranslated((double)0.5, (double)0.01, (double)0.5);
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        if (te.isInWorld() && MinecraftForgeClient.getRenderPass() == 1) {
            if (te.hasDirectDrainUpgrade()) {
                this.renderUpgradeFlare(te, par8);
            }
            if (te.isLockedToCurrent()) {
                this.renderLockFlare(te, par8);
            }
        }
        try {
            ForgeDirection sp = te.getSpill();
            if (sp != null) {
                int a = sp.offsetX == 0 ? 1 : 0;
                int b = 1 - a;
                int dir = sp.offsetX + sp.offsetZ;
                GL11.glRotated((double)(dir * 90), (double)a, (double)0.0, (double)b);
            } else {
                TileEntityAspectJar.JarTilt jt = te.getAngle();
                if (jt != null) {
                    int a = jt.direction.offsetX == 0 ? 1 : 0;
                    int b = 1 - a;
                    int dir = jt.direction.offsetX + jt.direction.offsetZ;
                    GL11.glRotated((double)((float)dir * jt.getAngle()), (double)a, (double)0.0, (double)b);
                }
            }
            this.renderAspects(te);
            this.renderJar(te);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not render ThaumCraft jar model!");
        }
        GL11.glPopMatrix();
    }

    private void renderLockFlare(TileEntityAspectJar te, float par8) {
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        ReikaRenderHelper.disableEntityLighting();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaTextureHelper.bindTerrainTexture();
        IIcon ico = ChromaIcons.LATTICE.getIcon();
        float u = ico.func_94209_e();
        float dv = ico.func_94206_g();
        float du = ico.func_94212_f();
        float v = ico.func_94210_h();
        Tessellator v5 = Tessellator.field_78398_a;
        GL11.glDisable((int)2884);
        double o = 0.01;
        double w = 0.3125;
        double h = 0.75;
        v5.func_78382_b();
        v5.func_78380_c(240);
        v5.func_78378_d(this.primalAspectColors.getColor((double)((float)te.getTicksExisted() + par8)));
        v5.func_78374_a(-w - o, 0.0 + o, w + o, (double)u, (double)v);
        v5.func_78374_a(w + o, 0.0 + o, w + o, (double)du, (double)v);
        v5.func_78374_a(w + o, -h - o, w + o, (double)du, (double)dv);
        v5.func_78374_a(-w - o, -h - o, w + o, (double)u, (double)dv);
        v5.func_78374_a(-w - o, 0.0 + o, -w - o, (double)u, (double)v);
        v5.func_78374_a(w + o, 0.0 + o, -w - o, (double)du, (double)v);
        v5.func_78374_a(w + o, -h - o, -w - o, (double)du, (double)dv);
        v5.func_78374_a(-w - o, -h - o, -w - o, (double)u, (double)dv);
        v5.func_78374_a(-w - o, 0.0 + o, -w - o, (double)u, (double)v);
        v5.func_78374_a(-w - o, 0.0 + o, w + o, (double)du, (double)v);
        v5.func_78374_a(-w - o, -h - o, w + o, (double)du, (double)dv);
        v5.func_78374_a(-w - o, -h - o, -w - o, (double)u, (double)dv);
        v5.func_78374_a(w + o, 0.0 + o, -w - o, (double)u, (double)v);
        v5.func_78374_a(w + o, 0.0 + o, w + o, (double)du, (double)v);
        v5.func_78374_a(w + o, -h - o, w + o, (double)du, (double)dv);
        v5.func_78374_a(w + o, -h - o, -w - o, (double)u, (double)dv);
        v5.func_78374_a(-w - o, -h - o, -w - o, (double)u, (double)v);
        v5.func_78374_a(w + o, -h - o, -w - o, (double)du, (double)v);
        v5.func_78374_a(w + o, -h - o, w + o, (double)du, (double)dv);
        v5.func_78374_a(-w - o, -h - o, w + o, (double)u, (double)dv);
        v5.func_78374_a(-w - o, 0.0 + o, -w - o, (double)u, (double)v);
        v5.func_78374_a(w + o, 0.0 + o, -w - o, (double)du, (double)v);
        v5.func_78374_a(w + o, 0.0 + o, w + o, (double)du, (double)dv);
        v5.func_78374_a(-w - o, 0.0 + o, w + o, (double)u, (double)dv);
        v5.func_78381_a();
        GL11.glEnable((int)2884);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glPopAttrib();
    }

    private void renderUpgradeFlare(TileEntityAspectJar te, float par8) {
        double[] ss;
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        ReikaRenderHelper.disableEntityLighting();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaTextureHelper.bindTerrainTexture();
        IIcon ico = ChromaIcons.SIDEDFLOW.getIcon();
        float u = ico.func_94209_e();
        float dv = ico.func_94206_g();
        float du = ico.func_94212_f();
        float v = ico.func_94210_h();
        Tessellator v5 = Tessellator.field_78398_a;
        GL11.glDisable((int)2884);
        double s1 = 0.45 + 0.2 * Math.sin((2.3 + (double)te.getTicksExisted() + (double)par8) / 11.0);
        double s2 = 0.75 + 0.125 * Math.sin((6.7 + (double)te.getTicksExisted() + (double)par8) / 17.0);
        for (double s : ss = new double[]{s1, s2}) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)-0.85, (double)0.0);
            GL11.glScaled((double)s, (double)s, (double)s);
            RenderManager rm = RenderManager.field_78727_a;
            GL11.glRotatef((float)rm.field_78735_i, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)rm.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            v5.func_78382_b();
            v5.func_78380_c(240);
            v5.func_78378_d(s == s1 ? 0xFFFFFF : this.primalAspectColors.getColor((double)((float)te.getTicksExisted() + par8)));
            v5.func_78374_a(-1.0, -1.0, 0.0, (double)u, (double)v);
            v5.func_78374_a(1.0, -1.0, 0.0, (double)du, (double)v);
            v5.func_78374_a(1.0, 1.0, 0.0, (double)du, (double)dv);
            v5.func_78374_a(-1.0, 1.0, 0.0, (double)u, (double)dv);
            v5.func_78381_a();
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)2884);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glPopAttrib();
    }

    private void renderJar(TileEntityAspectJar te) throws Exception {
        this.bindTextureByName("/Reika/ChromatiCraft/Textures/TileEntity/jar.png");
        modelRender.invoke((Object)this.model, new Object[0]);
    }

    private void renderAspects(TileEntityAspectJar te) throws Exception {
        int i = 0;
        for (Aspect a : te.getAllAspects()) {
            this.renderAspect(te, a, te.getAmount(a), i);
            ++i;
        }
    }

    private void renderAspect(TileEntityAspectJar te, Aspect a, int amt, int i) throws Exception {
        if (amt <= 0) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderBlocks rb = RenderBlocks.getInstance();
        GL11.glDisable((int)2896);
        double cap = a.isPrimal() ? 6000.0 : 500.0;
        double level = 0.625 * Math.sqrt((double)amt / cap);
        Tessellator v5 = Tessellator.field_78398_a;
        double w = 0.125;
        double dx = 0.0 + w * (double)(i / 4);
        double dz = 0.0 + w * (double)(i % 4);
        double minx = 0.25 + dx;
        double minz = 0.25 + dz;
        double maxx = minx + w;
        double maxz = minz + w;
        rb.func_147782_a(minx, 0.0625, minz, maxx, 0.0625 + level, maxz);
        v5.func_78382_b();
        v5.func_78378_d(a.getColor());
        int bright = 200;
        Block jar = ThaumItemHelper.BlockEntry.JAR.getBlock();
        if (te.field_145850_b != null) {
            bright = Math.max(200, jar.func_149677_c((IBlockAccess)te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e));
        }
        v5.func_78380_c(bright);
        IIcon icon = (IIcon)liquidIcon.get(jar);
        ReikaTextureHelper.bindTerrainTexture();
        rb.func_147768_a(jar, -0.5, 0.0, -0.5, icon);
        rb.func_147806_b(jar, -0.5, 0.0, -0.5, icon);
        rb.func_147761_c(jar, -0.5, 0.0, -0.5, icon);
        rb.func_147734_d(jar, -0.5, 0.0, -0.5, icon);
        rb.func_147798_e(jar, -0.5, 0.0, -0.5, icon);
        rb.func_147764_f(jar, -0.5, 0.0, -0.5, icon);
        v5.func_78381_a();
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    static {
        if (ModList.THAUMCRAFT.isLoaded()) {
            try {
                jarModelClass = Class.forName("thaumcraft.client.renderers.models.ModelJar");
                modelRender = jarModelClass.getDeclaredMethod("renderAll", new Class[0]);
                Class<?> jar = Class.forName("thaumcraft.common.blocks.BlockJar");
                liquidIcon = jar.getDeclaredField("iconLiquid");
                liquidIcon.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Could not read ThaumCraft jar renderer to use for ChromatiCraft jar!");
            }
        }
    }
}

