/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Render.TESR;

import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.ChromatiCraft.Base.ChromaModelBase;
import Reika.ChromatiCraft.Base.ChromaRenderBase;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Models.ModelTurbo;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.TileEntity.Auxiliary.TileEntityPylonTurboCharger;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Effects.LightningBolt;
import Reika.DragonAPI.Instantiable.Rendering.StructureRenderer;
import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class RenderPylonTurboCharger
extends ChromaRenderBase {
    private final ModelTurbo model = new ModelTurbo();
    private static final LightningBolt[][] bolts = new LightningBolt[3][TileEntityPylonTurboCharger.Location.list.length + 1];

    public String getImageFileName(RenderFetcher te) {
        return "turbo.png";
    }

    public void func_147500_a(TileEntity tile, double par2, double par4, double par6, float par8) {
        TileEntityPylonTurboCharger te = (TileEntityPylonTurboCharger)tile;
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par4, (double)par6);
        int pass = MinecraftForgeClient.getRenderPass();
        GL11.glEnable((int)3042);
        ReikaRenderHelper.disableLighting();
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2884);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glPushMatrix();
        if (!te.isInWorld()) {
            double s = 1.75;
            GL11.glScaled((double)s, (double)s, (double)s);
            GL11.glTranslated((double)0.0, (double)0.25, (double)0.0);
        }
        if (MinecraftForgeClient.getRenderPass() == 0 || !te.isInWorld() || StructureRenderer.isRenderingTiles()) {
            this.renderModel((TileEntityChromaticBase)te, (ChromaModelBase)this.model, new Object[0]);
        }
        GL11.glPopMatrix();
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        if (te.isInWorld()) {
            if (pass == 1) {
                int tick = te.getTick();
                this.renderConnection(te, par2, par4, par6, par8);
                if (tick > 0) {
                    this.renderLightning(te, par2, par4, par6, par8);
                }
                if (te.getSkyTick() > 0) {
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)0.5, (double)8.5, (double)0.5);
                    GL11.glPushAttrib((int)1048575);
                    GL11.glEnable((int)2884);
                    double t = (double)System.currentTimeMillis() / 600.0 % 360.0 / 30.0;
                    ReikaGLHelper.BlendMode.DEFAULT.apply();
                    GL11.glShadeModel((int)7425);
                    ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"/Reika/ChromatiCraft/Textures/beam.png");
                    int h = 16;
                    for (int i = 0; i < 512; i += h) {
                        GL11.glPushMatrix();
                        GL11.glTranslated((double)0.0, (double)i, (double)0.0);
                        DecimalPosition p1 = new DecimalPosition((TileEntity)te);
                        DecimalPosition p2 = new DecimalPosition((TileEntity)te).offset(0.0, (double)h, 0.0);
                        TileEntityCrystalPylon tp = te.getPylon(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e);
                        if (tp != null) {
                            ChromaFX.drawEnergyTransferBeam(p1, p2, tp.getColor().getColor(), 0.35, 0.35, 6, t, true);
                        }
                        GL11.glPopMatrix();
                    }
                    GL11.glPopAttrib();
                    GL11.glPopMatrix();
                }
            }
        } else {
            this.doNonWorldRender(te, par8);
        }
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void renderConnection(TileEntityPylonTurboCharger te, double par2, double par4, double par6, float par8) {
        TileEntityPylonTurboCharger.Location loc = te.getLocation();
        if (loc != null) {
            TileEntityPylonTurboCharger.Location nx = loc.getNext();
            Coordinate end = nx.position.offset(loc.position.negate());
            Coordinate test = end.offset(te.field_145851_c, te.field_145848_d, te.field_145849_e);
            if (ChromaTiles.getTileFromIDandMetadata(test.getBlock((IBlockAccess)te.field_145850_b), test.getBlockMetadata((IBlockAccess)te.field_145850_b)) == ChromaTiles.PYLONTURBO) {
                ChromaFX.renderBeam(0.5, 0.4375, 0.5, (double)end.xCoord + 0.5, (double)end.yCoord + 0.4375, (double)end.zCoord + 0.5, par8, 192, 0.5);
            }
        }
    }

    private void renderLightning(TileEntityPylonTurboCharger te, double par2, double par4, double par6, float par8) {
        for (int f = 0; f < bolts.length; ++f) {
            TileEntityPylonTurboCharger.Location loc = te.getLocation();
            int idx = loc != null ? loc.ordinal() + 1 : 0;
            LightningBolt b = bolts[f][idx];
            b.update();
            ChromaFX.renderBolt(b, par8, 192, 0.25, 0);
        }
    }

    private void doNonWorldRender(TileEntityPylonTurboCharger te, float par8) {
    }

    static {
        for (int i = 0; i < bolts.length; ++i) {
            for (int k = 0; k < bolts[i].length; ++k) {
                TileEntityPylonTurboCharger.Location loc;
                double px = 0.0;
                double py = 8.0;
                double pz = 0.0;
                TileEntityPylonTurboCharger.Location location = loc = k == 0 ? null : TileEntityPylonTurboCharger.Location.list[k - 1];
                if (loc != null) {
                    Coordinate rel = loc.getRelativePylonLocation();
                    px = rel.xCoord;
                    py = rel.yCoord;
                    pz = rel.zCoord;
                }
                DecimalPosition end = new DecimalPosition(px + 0.5, py + 0.5, pz + 0.5);
                LightningBolt b = new LightningBolt(new DecimalPosition(0.5, 0.5, 0.5), end, 4 + i * 4);
                b.setVariance(0.375);
                b.setVelocity(0.0625);
                RenderPylonTurboCharger.bolts[i][k] = b;
            }
        }
    }
}

