/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE.Defence;

import Reika.ChromatiCraft.API.Interfaces.RangeUpgradeable;
import Reika.ChromatiCraft.Auxiliary.ChromaAux;
import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Auxiliary.PylonDamage;
import Reika.ChromatiCraft.Auxiliary.RangeTracker;
import Reika.ChromatiCraft.Base.TileEntity.CrystalReceiverBase;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.ThreadSafeTileCache;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Interfaces.TileEntity.LocationCached;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class TileEntityCrystalBeacon
extends CrystalReceiverBase
implements LocationCached,
RangeUpgradeable,
MultiBlockChromaTile,
OwnedTile {
    private static final ThreadSafeTileCache cache = new ThreadSafeTileCache().setTileClass(TileEntityCrystalBeacon.class);
    public static final int RATIO = 100;
    public static final int POWER = 2;
    public static final int MAXRANGE = 64;
    public static final int COOLDOWN = 30;
    private static final String NBT_TAG = "LAST_PROTECTION_BEACON_DATA";
    private boolean hasStructure;
    private final RangeTracker range = new RangeTracker(64);

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.BEACON;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        this.range.update(this);
        if (world.field_72995_K) {
            this.spawnParticles(world, x, y, z);
        }
        if (!world.field_72995_K && this.hasStructure && this.getCooldown() == 0 && this.checkTimer.checkCap()) {
            this.checkAndRequest();
        }
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.range.initialize(this);
        this.validateStructure();
        WorldLocation loc = new WorldLocation((TileEntity)this);
        if (!cache.contains((Object)loc)) {
            cache.add((Object)loc);
        }
    }

    @Override
    public void validateStructure() {
        ChromaStructures.PROTECT.getStructure().resetToDefaults();
        this.hasStructure = ChromaStructures.PROTECT.getArray(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).matchInWorld();
        this.syncAllData(false);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.hasStructure() ? ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e).func_72314_b(6.0, 4.0, 6.0) : super.getRenderBoundingBox();
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z) {
        double angle = (double)System.currentTimeMillis() / 15.0 % 360.0;
        double d = 0.05;
        double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)d);
        double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)d);
        double py = ReikaRandomHelper.getRandomPlusMinus((double)((double)y + 1.5 + 0.5 * (1.0 + Math.sin(Math.toRadians(angle)))), (double)d);
        CrystalElement c = CrystalElement.randomElement();
        EntityBlurFX fx = new EntityCCBlurFX(c, world, px, py, pz, 0.0, 0.0, 0.0).setIcon(ChromaIcons.CENTER).setScale(2.0f).setLife(10);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        if (this.energy.contains(CrystalElement.RED) && this.hasStructure) {
            double a = rand.nextDouble() * 360.0;
            double v = rand.nextBoolean() ? 0.03125 : -0.03125;
            double r = 0.25;
            px = (double)x + 0.5 + r * Math.cos(Math.toRadians(a));
            pz = (double)z + 0.5 + r * Math.sin(Math.toRadians(a));
            py = (double)y + ReikaRandomHelper.getRandomBetween((double)0.25, (double)1.5);
            float g = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.125);
            fx = new EntityCCBlurFX(c, world, px, py, pz, 0.0, v, 0.0).setIcon(ChromaIcons.FADE_GENTLE).setScale(1.0f).setLife(30).setColor(CrystalElement.RED.getColor()).setRapidExpand().setGravity(g);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            int[][] dir = new int[][]{{-2, -2}, {-2, 2}, {2, 2}, {2, -2}};
            for (int t = 0; t < 80; t += 30) {
                int i = this.getTicksExisted() % 4;
                int dx = dir[i][0];
                int dz = dir[i][1];
                boolean dy = true;
                d = 1.0 - (double)((this.getTicksExisted() + t + i * 20) % 80) / 80.0;
                px = (double)x + 0.5 + (double)dx * d;
                pz = (double)z + 0.5 + (double)dz * d;
                py = (double)y + 0.5 + (double)dy * d;
                double vx = 0.0;
                double vy = 0.0;
                double vz = 0.0;
                fx = new EntityCCBlurFX(c, world, px, py, pz, vx, vy, vz).setIcon(ChromaIcons.NODE2).setScale(1.5f).setLife(10).setColor(CrystalElement.RED.getColor());
                EntityBlurFX fx2 = new EntityCCBlurFX(c, world, px, py, pz, vx, vy, vz).setIcon(ChromaIcons.NODE2).setScale(0.75f).setLife(10).setColor(0xFFFFFF);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
            }
            int rg = this.getRange();
            double pt = ReikaRenderHelper.getPartialTickTime();
            for (EntityPlayer ep : this.getOwners(false)) {
                long dur = ep.field_70170_p.func_82737_E() - ep.getEntityData().func_74775_l(NBT_TAG).func_74763_f("time");
                if (dur >= 60L) continue;
                float ap = dur < 30L ? 1.0f : 1.0f - (float)(dur - 30L) / 30.0f;
                double dx = ep.field_70165_t + (ep.field_70165_t - ep.field_70142_S) * pt - (double)x - 0.5;
                double dy = ep.field_70163_u + (ep.field_70163_u - ep.field_70137_T) * pt - (double)y - 0.5;
                double dz = ep.field_70161_v + (ep.field_70161_v - ep.field_70136_U) * pt - (double)z - 0.5;
                if (!(dx <= (double)rg) || !(dz <= (double)rg) || !(dy <= (double)(rg / 2))) continue;
                Random rand = new Random(ep.hashCode());
                double a0 = (double)ep.hashCode() % 360.0;
                double dt = 0.0;
                for (int n = 0; n < 8; ++n) {
                    v = 0.5 + 1.5 * rand.nextDouble();
                    for (double dt2 = 0.0; dt2 <= 3.0; dt2 += 1.5) {
                        double t = ((double)ep.field_70173_aa + pt + dt + dt2) * v;
                        double ang = a0 + t * 6.0;
                        r = 1.0 + 0.25 * Math.sin(t * 0.06);
                        ang = Math.toRadians(ang);
                        px = ep.field_70165_t + r * Math.cos(ang);
                        pz = ep.field_70161_v + r * Math.sin(ang);
                        py = ep.field_70163_u - 0.6 + 0.6 * Math.sin(t * 0.017);
                        fx = new EntityCCBlurFX(world, px, py, pz).setIcon(ChromaIcons.CENTER).setScale(0.7f).setLife(8);
                        int clr = ReikaColorAPI.getColorWithBrightnessMultiplier((int)CrystalElement.RED.getColor(), (float)ap);
                        fx.setColor(clr);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    }
                    dt += rand.nextDouble() * 90.0;
                }
            }
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.hasStructure = NBT.func_74767_n("struct");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("struct", this.hasStructure);
    }

    private void checkAndRequest() {
        CrystalElement e = CrystalElement.RED;
        int capacity = this.getMaxStorage(e);
        int space = capacity - this.getEnergy(e);
        if (space > 0) {
            this.requestEnergy(e, space);
        }
    }

    public static boolean isPlayerInvincible(EntityPlayer ep, float dmg) {
        if (TileEntityCrystalBeacon.updateDamageNBT((EntityLivingBase)ep, dmg)) {
            return true;
        }
        if (cache.lookForMatch(ep.field_70170_p, true, (loc, tile) -> {
            TileEntityCrystalBeacon te = (TileEntityCrystalBeacon)tile;
            int r = te.getRange();
            if (Math.abs(ep.field_70163_u - (double)te.field_145848_d) <= (double)(r / 2) && loc.getDistanceTo((Entity)ep) <= (double)r && te.isPlacer(ep) && te.prevent(dmg)) {
                ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
                return true;
            }
            return false;
        }, (loc, te) -> ChromaAux.logTileCacheError(ep.field_70170_p, loc, te, ChromaTiles.BEACON))) {
            return true;
        }
        ep.getEntityData().func_82580_o(NBT_TAG);
        return false;
    }

    private static boolean updateDamageNBT(EntityLivingBase ep, float dmg) {
        NBTTagCompound tag = ep.getEntityData().func_74775_l(NBT_TAG);
        ep.getEntityData().func_74782_a(NBT_TAG, (NBTBase)tag);
        if (ep.field_70170_p.field_73011_w.field_76574_g != tag.func_74762_e("dimension")) {
            ep.getEntityData().func_82580_o(NBT_TAG);
        }
        if (ep.field_70170_p.func_82737_E() - tag.func_74763_f("time") <= 30L) {
            if (dmg <= tag.func_74760_g("damage")) {
                return true;
            }
        } else {
            tag.func_74772_a("time", ep.field_70170_p.func_82737_E());
        }
        tag.func_74776_a("damage", dmg);
        tag.func_74768_a("dimension", ep.field_70170_p.field_73011_w.field_76574_g);
        return false;
    }

    public static boolean isEntityInvincible(EntityLiving ep, String owner, float dmg) {
        if (TileEntityCrystalBeacon.updateDamageNBT((EntityLivingBase)ep, dmg)) {
            return true;
        }
        if (cache.lookForMatch(ep.field_70170_p, true, (loc, tile) -> {
            String n;
            TileEntityCrystalBeacon te = (TileEntityCrystalBeacon)tile;
            int r = te.getRange();
            return Math.abs(ep.field_70163_u - (double)te.field_145848_d) <= (double)(r / 2) && loc.getDistanceTo((Entity)ep) <= (double)r && (n = te.getPlacerName()) != null && n.equals(owner) && te.prevent(dmg);
        }, (loc, te) -> ChromaAux.logTileCacheError(ep.field_70170_p, loc, te, ChromaTiles.BEACON))) {
            return true;
        }
        ep.getEntityData().func_82580_o(NBT_TAG);
        return false;
    }

    private boolean prevent(float dmg) {
        int amt;
        if (this.hasStructure() && this.energy.containsAtLeast(CrystalElement.RED, amt = (int)(100.0 * Math.pow(dmg, 2.0)))) {
            this.drainEnergy(CrystalElement.RED, amt);
            return true;
        }
        return false;
    }

    public boolean hasStructure() {
        return this.hasStructure;
    }

    @Override
    public int getReceiveRange() {
        return 16;
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return e == CrystalElement.RED;
    }

    @Override
    public int maxThroughput() {
        return 250;
    }

    @Override
    public boolean canConduct() {
        return true;
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 250000;
    }

    public void breakBlock() {
        WorldLocation loc = new WorldLocation((TileEntity)this);
        cache.remove((Object)loc);
    }

    public static boolean isDamageBlockable(DamageSource src) {
        return !(src instanceof PylonDamage);
    }

    @Override
    public void upgradeRange(double r) {
    }

    @Override
    public int getRange() {
        return this.range.getRange();
    }

    public static void clearCache() {
        cache.clear();
    }

    @Override
    public ChromaStructures getPrimaryStructure() {
        return ChromaStructures.PROTECT;
    }

    @Override
    public Coordinate getStructureOffset() {
        return null;
    }

    @Override
    public boolean canStructureBeInspected() {
        return true;
    }
}

