/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE.Defence;

import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityRelayPowered;
import Reika.ChromatiCraft.Block.BlockCrystalFence;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.AdjacencyUpgrades;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Perimeter;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCrystalFence
extends TileEntityRelayPowered
implements OwnedTile,
BreakAction {
    private final Perimeter fence = new Perimeter().disallowVertical();
    private ForgeDirection outputFace = ForgeDirection.DOWN;
    private HashMap<Integer, Integer> active = new HashMap();
    private boolean controller = true;
    private int mainCount = 1;
    private int damageAmount;
    public static final int RANGE = 16;
    public static final int MAX_STEPS = ChromaOptions.getMaxFenceSections();
    private final StepTimer calcTimer = new StepTimer(100);
    private static final int FADE_STEP = 32;
    private static final int FADE_LENGTH = 128;
    private static final int FADE_START = 512;
    private int chargingTick;
    private boolean[] colorFade;
    private static final ElementTagCompound required = new ElementTagCompound();

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.FENCE;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (!world.field_72995_K && !this.fence.isEmpty()) {
            if (this.chargingTick > 0) {
                --this.chargingTick;
                int t = 5;
                if (this.getTicksExisted() % t == 0) {
                    int i = this.getTicksExisted() / t % this.fence.segmentCount();
                    this.triggerSegment(i, false);
                    ReikaMusicHelper.Note n = (ReikaMusicHelper.Note)ReikaMusicHelper.KeySignature.C.getScale().get(i % 7);
                    int offset = i / 7 * 12;
                    ReikaMusicHelper.MusicKey key = ReikaMusicHelper.MusicKey.getByIndex((int)(ReikaMusicHelper.MusicKey.C5.ordinal() + n.ordinal() + offset % 12));
                    if (key == null) {
                        key = ReikaMusicHelper.MusicKey.A1;
                    }
                    ChromaSounds.DING.playSoundAtBlock((TileEntity)this, 1.0f, (float)key.getRatio(ReikaMusicHelper.MusicKey.C5));
                }
            } else {
                if (this.controller && this.getTicksExisted() % 10 == 0) {
                    this.validateFence(world, x, y, z);
                }
                if (this.controller && this.fence.isClosed() && this.energy.containsAtLeast(required)) {
                    this.affectEntities();
                }
            }
        }
        for (Integer key : this.active.keySet()) {
            if (key == null) continue;
            int val = this.active.get(key);
            if (val > 0) {
                val -= 32;
            }
            this.active.put(key, val);
        }
    }

    private void validateFence(World world, int x, int y, int z) {
        for (Coordinate c : this.fence.getPoints()) {
            if (c.equals(x, y, z)) continue;
            Block b = c.getBlock((IBlockAccess)world);
            int meta = c.getBlockMetadata((IBlockAccess)world);
            if (b == this.getTile().getBlock() && meta == this.getTile().getBlockMetadata() || b == ChromaBlocks.FENCE.getBlockInstance()) continue;
            this.onFenceBreak(world, x, y, z, true);
            return;
        }
    }

    public void onFenceBreak(World world, int x, int y, int z) {
        this.onFenceBreak(world, x, y, z, false);
    }

    private void onFenceBreak(World world, int x, int y, int z, boolean notify) {
        if (!world.field_72995_K && notify) {
            ChromaSounds.POWERDOWN.playSoundAtBlock((TileEntity)this);
            for (Coordinate c : this.fence.getPoints()) {
                TileEntity te;
                if (c.equals(x, y, z) || !((te = c.getTileEntity((IBlockAccess)world)) instanceof TileEntityCrystalFence)) continue;
                ((TileEntityCrystalFence)te).onFenceBreak(world, x, y, z, false);
            }
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.FENCEBREAK.ordinal(), (World)world, (int)x, (int)y, (int)z, (int)128, (int[])new int[0]);
        }
        this.fence.clear();
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.calcFence(false);
    }

    public void calcFence(boolean renderOnly) {
        this.fence.clear();
        this.fence.addPoint(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.findFrom(this.field_145851_c, this.field_145849_e, this.outputFace, 0);
        int adj = TileEntityAdjacencyUpgrade.getAdjacentUpgrade(this, CrystalElement.PINK);
        double f = adj == 0 ? 1.0 : AdjacencyUpgrades.PINK.getFactor(adj - 1);
        this.damageAmount = (int)((double)this.damageAmount * f);
        if (!renderOnly) {
            this.colorFade = new boolean[this.fence.segmentCount()];
            this.chargingTick = 600;
        }
    }

    public Perimeter getFence() {
        return this.fence;
    }

    public boolean isValid() {
        return this.controller && this.fence.segmentCount() >= 1 && this.fence.isClosed();
    }

    private void findFrom(int x, int z, ForgeDirection dir, int step) {
        this.damageAmount = 2;
        this.mainCount = 0;
        for (int i = 1; i < 16; ++i) {
            int dx = x + dir.offsetX * i;
            int dz = z + dir.offsetZ * i;
            TileEntity te = this.field_145850_b.func_147438_o(dx, this.field_145848_d, dz);
            if (this.isValid()) {
                return;
            }
            if (step > MAX_STEPS) {
                this.fence.clear();
                return;
            }
            if (te == this) {
                this.fence.addPoint(dx, this.field_145848_d, dz);
                this.controller = true;
                return;
            }
            if (te instanceof TileEntityCrystalFence) {
                TileEntityCrystalFence fen = (TileEntityCrystalFence)te;
                fen.controller = false;
                ++this.mainCount;
                this.damageAmount += 2;
                this.fence.addPoint(dx, this.field_145848_d, dz);
                this.findFrom(dx, dz, fen.outputFace, step + 1);
                return;
            }
            if (!(te instanceof BlockCrystalFence.CrystalFenceAuxTile)) continue;
            BlockCrystalFence.CrystalFenceAuxTile fen = (BlockCrystalFence.CrystalFenceAuxTile)te;
            if (fen.getInput() == dir.getOpposite()) {
                this.fence.addPoint(dx, this.field_145848_d, dz);
                this.findFrom(dx, dz, fen.getOutput(), step + 1);
            } else {
                this.fence.clear();
            }
            return;
        }
    }

    private void affectEntities() {
        ArrayList li = this.fence.getAABBs();
        for (int i = 0; i < li.size(); ++i) {
            AxisAlignedBB aabb = (AxisAlignedBB)li.get(i);
            aabb.field_72338_b = this.field_145848_d - this.getFenceDepth();
            aabb.field_72337_e = this.field_145848_d + 1 + this.getFenceHeight();
            List ents = this.field_145850_b.func_72872_a(EntityLivingBase.class, aabb);
            for (EntityLivingBase e : ents) {
                boolean att = true;
                if (e instanceof EntityPlayer) {
                    EntityPlayer ep = (EntityPlayer)e;
                    if (ep == this.getPlacer()) {
                        att = false;
                    } else if (ReikaPlayerAPI.isReika((EntityPlayer)ep)) {
                        att = false;
                    }
                }
                if (!att) continue;
                e.func_70097_a(DamageSource.field_76367_g, (float)this.damageAmount);
                double dx = e.field_70165_t - (double)this.field_145851_c - 0.5;
                double dz = e.field_70161_v - (double)this.field_145849_e - 0.5;
                double dd = ReikaMathLibrary.py3d((double)dx, (double)0.0, (double)dz);
                e.field_70159_w = dx / dd;
                e.field_70181_x = 0.5;
                e.field_70179_y = dz / dd;
                e.field_70133_I = true;
                ChromaSounds.DISCHARGE.playSound((Entity)e, 1.0f, 1.4f);
                this.triggerSegment(i, true);
                this.drainEnergy(required);
            }
        }
    }

    public void triggerSegment(int i, boolean fadeColor) {
        if (this.field_145850_b.field_72995_K) {
            this.active.put(i, 640);
            if (this.colorFade.length > i) {
                this.colorFade[i] = fadeColor;
            }
        } else {
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.FENCETRIGGER.ordinal(), (TileEntity)this, (int)64, (int[])new int[]{i, fadeColor ? 1 : 0});
        }
    }

    public int getSegmentAlpha(int i) {
        Integer get = this.active.get(i);
        if (get == null) {
            return 0;
        }
        if (get > 512) {
            return 512 - (get - 512) * 4;
        }
        return get;
    }

    public boolean colorFade(int i) {
        return false;
    }

    public int getFenceHeight() {
        return 2;
    }

    public int getFenceDepth() {
        return 0;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("enable", this.controller);
        NBT.func_74768_a("main", this.mainCount);
        NBT.func_74768_a("dmg", this.damageAmount);
        NBT.func_74768_a("face", this.outputFace.ordinal());
        NBT.func_74768_a("charge", this.chargingTick);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.controller = NBT.func_74767_n("enable");
        this.mainCount = NBT.func_74762_e("main");
        this.damageAmount = NBT.func_74762_e("dmg");
        this.outputFace = this.dirs[NBT.func_74762_e("face")];
        this.chargingTick = NBT.func_74762_e("charge");
    }

    @Override
    public boolean isAcceptingColor(CrystalElement e) {
        return this.controller && required.contains(e);
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 20000;
    }

    @Override
    public ElementTagCompound getRequiredEnergy() {
        return required.copy();
    }

    @Override
    protected boolean canReceiveFrom(CrystalElement e, ForgeDirection dir) {
        return true;
    }

    public void setFacing(ForgeDirection dir) {
        this.outputFace = dir;
        this.syncAllData(false);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public boolean renderModelsInPass1() {
        return true;
    }

    public void breakBlock() {
        this.onFenceBreak(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * 16.0;
    }

    static {
        required.addTag(CrystalElement.RED, 100);
    }
}

