/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE.Defence;

import Reika.ChromatiCraft.API.Interfaces.RangeUpgradeable;
import Reika.ChromatiCraft.Auxiliary.ChromaAux;
import Reika.ChromatiCraft.Auxiliary.RangeTracker;
import Reika.ChromatiCraft.Base.TileEntity.CrystalReceiverBase;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.ThreadSafeTileCache;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.TileEntity.LocationCached;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class TileEntityExplosionShield
extends CrystalReceiverBase
implements LocationCached,
RangeUpgradeable {
    private static final ThreadSafeTileCache cache = new ThreadSafeTileCache().setTileClass(TileEntityExplosionShield.class);
    public static final int MAXRANGE = 32;
    public static final double RANGE_Y_FACTOR = 0.75;
    private final RangeTracker range = new RangeTracker(32);

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.EXPLOSIONSHIELD;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        this.range.update(this);
        if (world.field_72995_K && !this.energy.isEmpty()) {
            this.spawnParticles(world, x, y, z);
        }
        if (!world.field_72995_K && this.getCooldown() == 0 && this.checkTimer.checkCap()) {
            this.checkAndRequest();
            this.energy.subtract(CrystalElement.RED, Math.min(1000, Math.max(10, this.energy.getValue(CrystalElement.RED) / 5000)));
        }
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.range.initialize(this);
        WorldLocation loc = new WorldLocation((TileEntity)this);
        if (!cache.contains((Object)loc)) {
            cache.add((Object)loc);
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z) {
        double pz;
        double py;
        double px;
        int i;
        int r = this.getRange();
        int ry = this.getYRange();
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        double mx = (double)this.field_145851_c + 0.5 - (double)r;
        double my = Math.max(0.0, (double)this.field_145848_d + 0.5 - (double)ry);
        double mz = (double)this.field_145849_e + 0.5 - (double)r;
        double ax = (double)this.field_145851_c + 0.5 + (double)r;
        double ay = (double)this.field_145848_d + 0.5 + (double)ry;
        double az = (double)this.field_145849_e + 0.5 + (double)r;
        double mx2 = Math.max(ep.field_70165_t - 60.0, mx);
        double mz2 = Math.max(ep.field_70161_v - 60.0, mz);
        double ax2 = Math.min(ep.field_70165_t + 60.0, ax);
        double az2 = Math.min(ep.field_70161_v + 60.0, az);
        if (mx2 > ax2 || mz2 >= az2) {
            return;
        }
        double dx = ax2 - mx2;
        double dy = ay - my;
        double dz = az2 - mz2;
        int n = (int)Math.ceil(3.0 * dx * dy * dz / 32768.0);
        int n2 = 9 * n;
        for (i = 0; i < n; ++i) {
            int piz;
            int piy;
            px = ReikaRandomHelper.getRandomBetween((double)mx2, (double)ax2);
            py = ReikaRandomHelper.getRandomBetween((double)my, (double)ay);
            pz = ReikaRandomHelper.getRandomBetween((double)mz2, (double)az2);
            int pix = MathHelper.func_76128_c((double)px);
            Block b = world.func_147439_a(pix, piy = MathHelper.func_76128_c((double)py), piz = MathHelper.func_76128_c((double)pz));
            if (b.func_149662_c() && b.func_149686_d() && b.func_149645_b() == 0) continue;
            EntityCCBlurFX fx = new EntityCCBlurFX(world, px, py, pz);
            fx.setLife(ReikaRandomHelper.getRandomBetween((int)5, (int)100)).setScale(1.0f + rand.nextFloat()).setColor(CrystalElement.RED.getColor());
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        for (i = 0; i < n2; ++i) {
            px = ReikaRandomHelper.getRandomBetween((double)mx, (double)ax);
            py = ReikaRandomHelper.getRandomBetween((double)my, (double)ay);
            pz = ReikaRandomHelper.getRandomBetween((double)mz, (double)az);
            switch (rand.nextInt(6)) {
                case 0: {
                    px = x - r;
                    break;
                }
                case 1: {
                    px = x + r + 1;
                    break;
                }
                case 2: {
                    pz = z - r;
                    break;
                }
                case 3: {
                    pz = z + r + 1;
                    break;
                }
                case 4: {
                    py = y - ry;
                    break;
                }
                case 5: {
                    py = y + ry + 1;
                }
            }
            if (Math.abs(px - ep.field_70165_t) > 12.0 || Math.abs(py - ep.field_70163_u) > 12.0 || Math.abs(pz - ep.field_70161_v) > 12.0) continue;
            int l = ReikaRandomHelper.getRandomBetween((int)5, (int)100);
            float s = 1.5f + rand.nextFloat() * 1.5f;
            EntityCCBlurFX fx = new EntityCCBlurFX(world, px, py, pz);
            fx.setLife(l).setScale(s).setColor(CrystalElement.RED.getColor());
            EntityCCBlurFX fx2 = new EntityCCBlurFX(world, px, py, pz);
            fx2.setIcon(ChromaIcons.FADE_GENTLE).setLife(l).setScale(s * 0.5f).setColor(0xFFFFFF).lockTo((EntityFX)fx);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        }
    }

    private int getYRange() {
        return (int)((double)this.getRange() * 0.75);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.range.readFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.range.writeToNBT(NBT);
    }

    private void checkAndRequest() {
        int has;
        CrystalElement e = CrystalElement.RED;
        int capacity = this.getMaxStorage(e);
        int space = capacity - (has = this.getEnergy(e));
        if (space * 4 > has) {
            this.requestEnergy(e, space);
        }
    }

    public static void dampenExplosion(World world, Explosion e) {
        cache.applyToMatches(world, true, (loc, tile) -> {
            TileEntityExplosionShield te = (TileEntityExplosionShield)tile;
            Iterator it = e.field_77281_g.iterator();
            while (it.hasNext()) {
                ChunkPosition p = (ChunkPosition)it.next();
                if (!te.isLocationProtectedBy(world, p.field_151329_a, p.field_151327_b, p.field_151328_c, e.field_77280_f)) continue;
                it.remove();
            }
        }, (loc, te) -> ChromaAux.logTileCacheError(world, loc, te, ChromaTiles.EXPLOSIONSHIELD));
    }

    public static boolean isLocationProtected(World world, int x, int y, int z, double power) {
        return cache.lookForMatch(world, true, (loc, te) -> ((TileEntityExplosionShield)te).isLocationProtectedBy(world, x, y, z, power), (loc, te) -> ChromaAux.logTileCacheError(world, loc, te, ChromaTiles.EXPLOSIONSHIELD));
    }

    public boolean isLocationProtectedBy(World world, int x, int y, int z, double power) {
        int cost = 50 * (int)Math.pow(2.0, power);
        if (this.energy.containsAtLeast(CrystalElement.RED, cost)) {
            int r = this.getRange();
            int ry = this.getYRange();
            if (Math.abs(x - this.field_145851_c) <= r && Math.abs(z - this.field_145849_e) <= r && Math.abs(y - this.field_145848_d) <= ry) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getReceiveRange() {
        return 32;
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return e == CrystalElement.RED;
    }

    @Override
    public int maxThroughput() {
        return 4000;
    }

    @Override
    public boolean canConduct() {
        return true;
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 5000000;
    }

    public void breakBlock() {
        WorldLocation loc = new WorldLocation((TileEntity)this);
        cache.remove((Object)loc);
    }

    @Override
    public void upgradeRange(double r) {
    }

    @Override
    public int getRange() {
        return this.range.getRange();
    }

    public static void clearCache() {
        cache.clear();
    }
}

