/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE.Defence;

import Reika.ChromatiCraft.Auxiliary.GuardianStoneManager;
import Reika.ChromatiCraft.Auxiliary.HoldingChecks;
import Reika.ChromatiCraft.Auxiliary.ProtectionZone;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityGuardianStone
extends TileEntityChromaticBase {
    public static final int RANGE = TileEntityGuardianStone.calculateRange();
    private final ArrayList<String> extraPlayers = new ArrayList();
    private ProtectionZone zone;

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.extraPlayers.size(); ++i) {
            NBTTagString sg = new NBTTagString(this.extraPlayers.get(i));
            list.func_74742_a((NBTBase)sg);
        }
        NBT.func_74782_a("players", (NBTBase)list);
        if (this.zone != null) {
            NBT.func_74782_a("zone", (NBTBase)this.zone.writeToNBT());
        }
    }

    private static int calculateRange() {
        return Math.min(Math.max(ChromaOptions.GUARDIAN.getValue(), 8), 64);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        NBTTagList list = NBT.func_150295_c("players", ReikaNBTHelper.NBTTypes.STRING.ID);
        this.extraPlayers.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            String sg = list.func_150307_f(i);
            this.extraPlayers.add(sg);
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && NBT.func_74764_b("zone")) {
            this.zone = ProtectionZone.readFromNBT(NBT.func_74775_l("zone"));
        }
    }

    public void addPlayer(String name) {
        if (!this.extraPlayers.contains(name)) {
            this.extraPlayers.add(name);
        }
    }

    public void addPlayer(EntityPlayer ep) {
        this.addPlayer(ep.func_70005_c_());
    }

    public void removePlayer(String name) {
        this.extraPlayers.remove(name);
    }

    public void removePlayer(EntityPlayer ep) {
        this.removePlayer(ep.func_70005_c_());
    }

    public boolean isPlayerInList(String name) {
        return this.extraPlayers.contains(name);
    }

    public boolean isPlayerInList(EntityPlayer ep) {
        return this.isPlayerInList(ep.func_70005_c_());
    }

    public List<String> getExtraPlayers() {
        return Collections.unmodifiableList(this.extraPlayers);
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.placer != null) {
            if (world.field_72995_K) {
                if (this.zone != null && HoldingChecks.MANIPULATOR.isClientHolding()) {
                    this.doAreaParticles(world, x, y, z);
                }
            } else if (this.getTicksExisted() == 0 || this.getZone() == null) {
                this.zone = GuardianStoneManager.instance.addZone(world, x, y, z, this.getPlacer(), RANGE);
                this.syncAllData(true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doAreaParticles(World world, int x, int y, int z) {
        double minX0 = this.zone.originX - this.zone.range;
        double minY0 = ChromaOptions.GUARDCHUNK.getState() ? 0.0 : (double)(this.zone.originY - this.zone.range);
        double minZ0 = this.zone.originZ - this.zone.range;
        double maxX0 = this.zone.originX + 1 + this.zone.range;
        double maxY0 = ChromaOptions.GUARDCHUNK.getState() ? 256.0 : (double)(this.zone.originY + 1 + this.zone.range);
        double maxZ0 = this.zone.originZ + 1 + this.zone.range;
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        double minX = Math.max(ep.field_70165_t - 60.0, minX0);
        double minY = Math.max(ep.field_70163_u - 40.0, minY0);
        double minZ = Math.max(ep.field_70161_v - 60.0, minZ0);
        double maxX = Math.min(ep.field_70165_t + 60.0, maxX0);
        double maxY = Math.min(ep.field_70163_u + 40.0, maxY0);
        double maxZ = Math.min(ep.field_70161_v + 60.0, maxZ0);
        int n = (int)Math.ceil((maxX - minX) * (maxY - minY) * (maxZ - minZ) / 2048.0);
        for (int i = 0; i < n; ++i) {
            double px = ReikaRandomHelper.getRandomBetween((double)minX, (double)maxX);
            double py = ReikaRandomHelper.getRandomBetween((double)minY, (double)maxY);
            double pz = ReikaRandomHelper.getRandomBetween((double)minZ, (double)maxZ);
            boolean side = rand.nextInt(8) > 0;
            boolean edge = rand.nextInt(3) == 0;
            boolean line = rand.nextInt(8) == 0;
            HashSet<ForgeDirection> set = new HashSet<ForgeDirection>();
            if (minX == minX0) {
                set.add(ForgeDirection.WEST);
            }
            if (maxX == maxX0) {
                set.add(ForgeDirection.EAST);
            }
            if (minZ == minZ0) {
                set.add(ForgeDirection.NORTH);
            }
            if (maxZ == maxZ0) {
                set.add(ForgeDirection.SOUTH);
            }
            if (minY == minY0) {
                set.add(ForgeDirection.DOWN);
            }
            if (maxY == maxY0) {
                set.add(ForgeDirection.UP);
            }
            if (line) {
                int signX = rand.nextBoolean() ? 1 : -1;
                int signY = rand.nextBoolean() ? 1 : -1;
                int signZ = rand.nextBoolean() ? 1 : -1;
                double f = rand.nextDouble();
                px = (double)this.zone.originX + 0.5 + (double)signX * (maxX - (double)this.zone.originX - 0.5) * f;
                py = (double)this.zone.originY + 0.5 + (double)signY * (maxY - (double)this.zone.originY - 0.5) * f;
                pz = (double)this.zone.originZ + 0.5 + (double)signZ * (maxZ - (double)this.zone.originZ - 0.5) * f;
                px = MathHelper.func_151237_a((double)px, (double)minX, (double)maxX);
                py = MathHelper.func_151237_a((double)py, (double)minY, (double)maxY);
                pz = MathHelper.func_151237_a((double)pz, (double)minZ, (double)maxZ);
            } else if (side && !set.isEmpty()) {
                ForgeDirection face = (ForgeDirection)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, set);
                switch (face) {
                    case DOWN: {
                        py = minY;
                        break;
                    }
                    case UP: {
                        py = maxY;
                        break;
                    }
                    case WEST: {
                        px = minX;
                        break;
                    }
                    case EAST: {
                        px = maxX;
                        break;
                    }
                    case NORTH: {
                        pz = minZ;
                        break;
                    }
                    case SOUTH: {
                        pz = maxZ;
                        break;
                    }
                }
                if (edge) {
                    ForgeDirection face2 = this.dirs[rand.nextInt(6)];
                    while (face2 == face || face2 == face.getOpposite()) {
                        face2 = this.dirs[rand.nextInt(6)];
                    }
                    switch (face2) {
                        case DOWN: {
                            py = minY;
                            break;
                        }
                        case UP: {
                            py = maxY;
                            break;
                        }
                        case WEST: {
                            px = minX;
                            break;
                        }
                        case EAST: {
                            px = maxX;
                            break;
                        }
                        case NORTH: {
                            pz = minZ;
                            break;
                        }
                        case SOUTH: {
                            pz = maxZ;
                            break;
                        }
                    }
                }
            }
            float s = 1.0f + rand.nextFloat() * 1.5f;
            int l = ReikaRandomHelper.getRandomBetween((int)5, (int)15);
            if (line) {
                l *= 8;
            } else if (edge) {
                l *= 4;
            }
            EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz).setScale(s).setLife(l);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public ProtectionZone getZone() {
        return this.zone;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.GUARDIAN;
    }
}

