/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE.Effect;

import Reika.ChromatiCraft.API.AcceleratorBlacklist;
import Reika.ChromatiCraft.API.Interfaces.CustomAcceleration;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.ModList;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityAccelerator
extends TileEntityAdjacencyUpgrade {
    public static final long MAX_LAG = TileEntityAccelerator.calculateLagLimit();
    private static HashMap<Class<? extends TileEntity>, Acceleration> actions = new HashMap();
    public static int debugLevel = 0;
    private int[] lagTimer = new int[6];
    private static final Acceleration blacklistKey = new Acceleration(){

        @Override
        public void tick(TileEntity te, int factor, TileEntity accelerator) {
        }

        @Override
        public boolean usesParentClasses() {
            return false;
        }
    };
    private static final Acceleration defaultKey = new Acceleration(){

        @Override
        public void tick(TileEntity te, int factor, TileEntity accelerator) {
        }

        @Override
        public boolean usesParentClasses() {
            return false;
        }
    };
    private static boolean doRecursiveChecks = false;

    public static void blacklistTile(Class<? extends TileEntity> cl) {
        if (cl == TileEntity.class) {
            throw new IllegalArgumentException("You cannot blacklist the core TE class!");
        }
        actions.put(cl, blacklistKey);
    }

    public static void customizeTile(Class c, Acceleration a) {
        actions.put(c, a);
        doRecursiveChecks = a.usesParentClasses();
    }

    private static void blacklistTile(String name, ModList mod, AcceleratorBlacklist.BlacklistReason r) {
        if (mod != null && !mod.isLoaded()) {
            return;
        }
        try {
            Class<?> cl = Class.forName(name);
            if (cl == TileEntity.class) {
                throw new IllegalArgumentException("You cannot blacklist the core TE class!");
            }
            ChromatiCraft.logger.log((Object)("TileEntity \"" + name + "\" has been blacklisted from the TileEntity Accelerator, because " + r.message));
            actions.put(cl, blacklistKey);
        }
        catch (ClassNotFoundException e) {
            ChromatiCraft.logger.log((Object)("Could not add " + name + " to the Accelerator blacklist: Class not found!"));
        }
    }

    private static long calculateLagLimit() {
        int base = ChromaOptions.TILELAG.getValue();
        return base >= 0 ? Math.max((long)base, 100000L) : -1L;
    }

    public static int getAccelFromTier(int tier) {
        return ReikaMathLibrary.intpow2((int)2, (int)(tier + 1)) - 1;
    }

    public int getAccel() {
        return TileEntityAccelerator.getAccelFromTier(this.getTier());
    }

    @Override
    public boolean canRun(World world, int x, int y, int z) {
        return super.canRun(world, x, y, z);
    }

    @Override
    protected TileEntityAdjacencyUpgrade.EffectResult tickDirection(World world, int x, int y, int z, ForgeDirection dir, long time) {
        if (this.lagTimer[dir.ordinal()] > 0) {
            ReikaParticleHelper.CLOUD.spawnAroundBlock(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, 4);
            int n = dir.ordinal();
            this.lagTimer[n] = this.lagTimer[n] - 1;
        }
        TileEntity te = this.getEffectiveTileOnSide(dir);
        Acceleration a = TileEntityAccelerator.getAccelerate(te);
        if (debugLevel > 0) {
            ReikaJavaLibrary.pConsole((Object)(te + ": " + (a != null ? a.getClass() : null)));
        }
        if (a != blacklistKey) {
            int max = this.getAccel();
            if (debugLevel > 1) {
                ReikaJavaLibrary.pConsole((Object)(this + " > " + max));
            }
            if (a != defaultKey) {
                try {
                    te = a.getActingTileEntity(te);
                    a.tick(te, max, (TileEntity)this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.writeError(e);
                }
                if (MAX_LAG > 0L && System.nanoTime() - time >= MAX_LAG) {
                    this.logLagWarning(time, dir, te);
                    return TileEntityAdjacencyUpgrade.EffectResult.FINAL_ACTION;
                }
            } else {
                for (int k = 0; k < max; ++k) {
                    if (debugLevel > 2) {
                        ReikaJavaLibrary.pConsole((Object)("Ticked " + te + " " + k + "th time"));
                    }
                    te.func_145845_h();
                    if (MAX_LAG <= 0L || System.nanoTime() - time < MAX_LAG) continue;
                    this.logLagWarning(time, dir, te);
                    return TileEntityAdjacencyUpgrade.EffectResult.FINAL_ACTION;
                }
            }
            return TileEntityAdjacencyUpgrade.EffectResult.ACTION;
        }
        return TileEntityAdjacencyUpgrade.EffectResult.CONTINUE;
    }

    private void logLagWarning(long time, ForgeDirection dir, TileEntity te) {
        this.lagTimer[dir.ordinal()] = 20;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        if (NBT.func_74764_b("lag")) {
            this.lagTimer = NBT.func_74759_k("lag");
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74783_a("lag", this.lagTimer);
    }

    private static Acceleration getAccelerate(TileEntity te) {
        if (te == null) {
            return blacklistKey;
        }
        if (te instanceof TileEntityAdjacencyUpgrade) {
            return blacklistKey;
        }
        if (te.func_145837_r()) {
            return blacklistKey;
        }
        Acceleration a = TileEntityAccelerator.getAccelerate(te.getClass());
        if (a == null && !te.canUpdate()) {
            return blacklistKey;
        }
        return a;
    }

    private static Acceleration getAccelerate(Class<? extends TileEntity> c) {
        Acceleration a = actions.get(c);
        if (a != null) {
            return a;
        }
        a = TileEntityAccelerator.calculateAccelerate(c);
        if (a != null) {
            if (a == blacklistKey) {
                ChromatiCraft.logger.log((Object)("Calculated acceleration blacklist " + a + " for tile class " + c));
            } else {
                ChromatiCraft.logger.log((Object)("Calculated acceleration mode " + a + " for tile class " + c));
            }
        }
        actions.put(c, a);
        return a;
    }

    private static Acceleration calculateAccelerate(Class<? extends TileEntity> c) {
        if (TileEntityChromaticBase.class.isAssignableFrom(c)) {
            return defaultKey;
        }
        Class<? extends TileEntity> parent = c.getSuperclass();
        if (parent == TileEntity.class) {
            return defaultKey;
        }
        Acceleration a = TileEntityAccelerator.getAccelerate(parent);
        if (a != null) {
            return a;
        }
        String s = c.getSimpleName().toLowerCase(Locale.ENGLISH);
        if (s.contains("conduit") || s.contains("wire") && !s.contains("wireless") || s.contains("cable")) {
            return blacklistKey;
        }
        if (s.contains("solar")) {
            return blacklistKey;
        }
        if (s.contains("windturbine") || s.contains("wind turbine") || s.contains("windmill") || s.contains("wind mill")) {
            return blacklistKey;
        }
        if (s.contains("watermill") || s.contains("water mill")) {
            return blacklistKey;
        }
        if (c.getName().contains("appeng")) {
            return blacklistKey;
        }
        return defaultKey;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public CrystalElement getColor() {
        return CrystalElement.LIGHTBLUE;
    }

    static {
        TileEntityAccelerator.blacklistTile("icbm.sentry.turret.Blocks.TileTurret", ModList.ICBM, AcceleratorBlacklist.BlacklistReason.BUGS);
        TileEntityAccelerator.blacklistTile("bluedart.tile.decor.TileForceTorch", ModList.DARTCRAFT, AcceleratorBlacklist.BlacklistReason.CRASH);
        TileEntityAccelerator.blacklistTile("com.sci.torcherino.tile.TileTorcherino", null, AcceleratorBlacklist.BlacklistReason.CRASH);
        TileEntityAccelerator.blacklistTile("mrtjp.projectred.integration.Timer", ModList.PROJRED, AcceleratorBlacklist.BlacklistReason.BUGS);
        TileEntityAccelerator.blacklistTile("mrtjp.projectred.integration.Sequencer", ModList.PROJRED, AcceleratorBlacklist.BlacklistReason.BUGS);
        TileEntityAccelerator.blacklistTile("mrtjp.projectred.integration.Repeater", ModList.PROJRED, AcceleratorBlacklist.BlacklistReason.BUGS);
        TileEntityAccelerator.blacklistTile("mrtjp.projectred.integration.StateCell", ModList.PROJRED, AcceleratorBlacklist.BlacklistReason.BUGS);
        for (int i = 0; i < ChromaTiles.TEList.length; ++i) {
            ChromaTiles c = ChromaTiles.TEList[i];
            if (c.allowsAcceleration()) continue;
            TileEntityAccelerator.blacklistTile(c.getTEClass());
        }
    }

    private static final class APIAcceleration
    extends Acceleration {
        private final CustomAcceleration accel;

        private APIAcceleration(CustomAcceleration acc) {
            this.accel = acc;
        }

        @Override
        protected void tick(TileEntity te, int factor, TileEntity accelerator) {
            this.accel.tick(factor);
        }

        @Override
        public boolean usesParentClasses() {
            return this.accel.usesParentClasses();
        }
    }

    public static abstract class Acceleration {
        protected abstract void tick(TileEntity var1, int var2, TileEntity var3) throws Exception;

        public abstract boolean usesParentClasses();

        protected final void registerClass(String sg) {
            Class<?> c = null;
            try {
                c = Class.forName(sg);
                this.registerClass(c);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected final void registerClass(Class c) {
            TileEntityAccelerator.customizeTile(c, this);
        }

        protected TileEntity getActingTileEntity(TileEntity root) throws Exception {
            return root;
        }
    }
}

