/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE.Effect;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Event.BlockTickEvent;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBlockTicker
extends TileEntityAdjacencyUpgrade {
    @Override
    protected TileEntityAdjacencyUpgrade.EffectResult tickDirection(World world, int x, int y, int z, ForgeDirection dir, long startTime) {
        double n = TileEntityBlockTicker.getTicksPerTick(this.getTier());
        if (n < 1.0) {
            n = ReikaRandomHelper.doWithChance((double)n) ? 1.0 : 0.0;
        }
        TileEntityAdjacencyUpgrade.EffectResult ret = TileEntityAdjacencyUpgrade.EffectResult.CONTINUE;
        int i = 0;
        while ((double)i < n) {
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            Block b = world.func_147439_a(dx, dy, dz);
            if (this.canTickBlock(b)) {
                if (!world.field_72995_K) {
                    BlockTickEvent.fire((Block)b, (World)world, (int)dx, (int)dy, (int)dz, (Random)rand, (int)BlockTickEvent.UpdateFlags.getForcedUnstoppableTick());
                }
                ret = TileEntityAdjacencyUpgrade.EffectResult.ACTION;
            }
            ++i;
        }
        return ret;
    }

    private boolean canTickBlock(Block b) {
        return !(b instanceof BlockRedstoneDiode);
    }

    @Override
    public CrystalElement getColor() {
        return CrystalElement.GREEN;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public static double getTicksPerTick(int tier) {
        return Math.pow(2.0, tier - 5);
    }
}

