/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE.Effect;

import Reika.ChromatiCraft.API.Interfaces.Repairable;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.MultiblockControllerFinder;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityHealingCore
extends TileEntityAdjacencyUpgrade {
    private static final HashMap<Class, RepairInterface> interactions = new HashMap();
    private boolean[] warnedSides = new boolean[6];

    @Override
    protected TileEntityAdjacencyUpgrade.EffectResult tickDirection(World world, int x, int y, int z, ForgeDirection dir, long startTime) {
        RepairInterface s;
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        int tier = this.getTier();
        TileEntityAdjacencyUpgrade.EffectResult ret = TileEntityAdjacencyUpgrade.EffectResult.CONTINUE;
        Block b = world.func_147439_a(dx, dy, dz);
        if (b instanceof Repairable) {
            ((Repairable)b).repair(world, dx, dy, dz, tier);
            ret = TileEntityAdjacencyUpgrade.EffectResult.ACTION;
        } else if (b instanceof BlockAnvil) {
            int meta = world.func_72805_g(dx, dy, dz);
            if (meta > 0 && rand.nextInt(200) < 1 + tier * 8) {
                world.func_72921_c(dx, dy, dz, meta - 4, 3);
            }
            ret = TileEntityAdjacencyUpgrade.EffectResult.ACTION;
        }
        TileEntity te = this.getEffectiveTileOnSide(dir);
        if (te != null && (s = this.getInterface(te)) != NoInterface.instance && (s.runOnClient() || !world.field_72995_K)) {
            try {
                int r = s.getTickRand(this.getTier());
                if (r <= 1 || rand.nextInt(r) == 0) {
                    s.tick(te, this.getTier());
                }
            }
            catch (Exception ex) {
                ChromatiCraft.logger.logError((Object)("Could not tick repair interface " + s + " for " + te + " @ " + this));
                this.writeError(ex);
            }
            return TileEntityAdjacencyUpgrade.EffectResult.ACTION;
        }
        if (te instanceof Repairable) {
            ((Repairable)te).repair(world, dx, dy, dz, tier);
            ret = TileEntityAdjacencyUpgrade.EffectResult.ACTION;
        } else if (te instanceof IInventory) {
            IInventory ii = (IInventory)te;
            if (ii.func_70302_i_() == 0) {
                if (!this.warnedSides[dir.ordinal()]) {
                    String sg = "Found an inventory '" + te + "' with zero size!?";
                    ChromatiCraft.logger.log((Object)sg);
                    ReikaChatHelper.sendChatToPlayer((EntityPlayer)this.getPlacer(), (String)sg);
                    this.warnedSides[dir.ordinal()] = true;
                }
            } else {
                int slot = rand.nextInt(ii.func_70302_i_());
                ItemStack is = ii.func_70301_a(slot);
                if (this.canRepair(is)) {
                    this.repair(is);
                    ret = TileEntityAdjacencyUpgrade.EffectResult.ACTION;
                }
            }
        }
        return ret;
    }

    protected void onAdjacentBlockUpdate() {
        this.warnedSides = new boolean[6];
    }

    private RepairInterface getInterface(TileEntity te) {
        Class<?> c;
        Class<?> c2;
        RepairInterface e = interactions.get(c2);
        for (c2 = c = te.getClass(); e == null && c2 != TileEntity.class; c2 = c2.getSuperclass()) {
            e = interactions.get(c2);
        }
        if (e == null) {
            e = NoInterface.instance;
        }
        interactions.put(c, e);
        return e;
    }

    private boolean canRepair(ItemStack is) {
        if (is == null) {
            return false;
        }
        return is.func_77973_b().isRepairable() && is.func_77960_j() > 0;
    }

    private void repair(ItemStack is) {
        is.func_77964_b(is.func_77960_j() - this.getTier());
    }

    @Override
    public CrystalElement getColor() {
        return CrystalElement.MAGENTA;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    static {
        new DecalcificationInterface();
        new RailTurbineInterface();
    }

    private static class DecalcificationInterface
    extends FieldSetRepairInterface {
        private Field calcification;

        private DecalcificationInterface() {
        }

        @Override
        protected void init() throws Exception {
            Class<?> c = Class.forName("ic2.core.block.machine.tileentity.TileEntitySteamGenerator");
            this.calcification = c.getDeclaredField("calcification");
            this.calcification.setAccessible(true);
        }

        @Override
        protected ModList getMod() {
            return ModList.IC2;
        }

        @Override
        protected String[] getClasses() {
            return new String[]{"ic2.core.block.machine.tileentity.TileEntitySteamGenerator"};
        }

        @Override
        protected Field getSetField(TileEntity te) throws Exception {
            return this.calcification;
        }

        @Override
        protected double getReplacedValue(TileEntity te, int tier, Number original) throws Exception {
            int current = this.calcification.getInt(te);
            double rem = (double)current * this.getReductionFactor(tier);
            if (rem >= 1.0 || ReikaRandomHelper.doWithChance((double)rem)) {
                int rem2 = (int)Math.max(1.0, rem);
                return Math.max(0, current - rem2);
            }
            return current;
        }

        private double getReductionFactor(int tier) {
            return 1.0 - Math.pow(0.99997, 1 + tier);
        }

        @Override
        protected boolean runOnClient() {
            return false;
        }
    }

    private static class RailTurbineInterface
    extends ItemSlotRepairInterface {
        private Field inventory;

        private RailTurbineInterface() {
        }

        @Override
        protected void init() throws Exception {
            Class<?> c = Class.forName("mods.railcraft.common.blocks.machine.alpha.TileSteamTurbine");
            this.inventory = c.getDeclaredField("inv");
            this.inventory.setAccessible(true);
        }

        @Override
        protected ModList getMod() {
            return ModList.RAILCRAFT;
        }

        @Override
        protected String[] getClasses() {
            return new String[]{"mods.railcraft.common.blocks.machine.alpha.TileSteamTurbine"};
        }

        @Override
        protected IInventory getInventory(TileEntity te) throws Exception {
            return (IInventory)this.inventory.get(te);
        }

        @Override
        public int getTickRand(int tier) {
            return 100 - tier * 10;
        }

        @Override
        public boolean repairSlot(int slot) {
            return slot == 0;
        }

        @Override
        public boolean shouldRepairItem(ItemStack is) {
            return is.func_77960_j() > 0 && is.func_77973_b() == GameRegistry.findItem((String)ModList.RAILCRAFT.modLabel, (String)"part.turbine.rotor");
        }

        @Override
        public void doRepairItem(ItemStack is, int tier) {
            is.func_77964_b(Math.max(is.func_77960_j() - 1, 0));
        }

        @Override
        protected TileEntity getActingTileEntity(TileEntity te) throws Exception {
            return MultiblockControllerFinder.instance.getController(te);
        }

        @Override
        protected boolean runOnClient() {
            return false;
        }
    }

    private static abstract class ItemSlotRepairInterface
    extends RepairInterface {
        private ItemSlotRepairInterface() {
        }

        @Override
        protected final void tick(TileEntity te, int tier) throws Exception {
            IInventory ii = this.getInventory(te = this.getActingTileEntity(te));
            if (ii != null) {
                for (int i = 0; i < ii.func_70302_i_(); ++i) {
                    ItemStack in;
                    if (!this.repairSlot(i) || (in = ii.func_70301_a(0)) == null || !this.shouldRepairItem(in)) continue;
                    this.doRepairItem(in, tier);
                }
            }
        }

        public abstract boolean repairSlot(int var1);

        public abstract boolean shouldRepairItem(ItemStack var1);

        public abstract void doRepairItem(ItemStack var1, int var2);

        protected IInventory getInventory(TileEntity te) throws Exception {
            return te instanceof IInventory ? (IInventory)te : null;
        }
    }

    private static abstract class FieldSetRepairInterface
    extends RepairInterface {
        private FieldSetRepairInterface() {
        }

        @Override
        protected final void tick(TileEntity te, int tier) throws Exception {
            te = this.getActingTileEntity(te);
            Field f = this.getSetField(te);
            Number get = (Number)f.get(te);
            double val = this.getReplacedValue(te, tier, get);
            Number set = null;
            if (get instanceof Integer || get.getClass() == Integer.TYPE) {
                set = (int)val;
            } else if (get instanceof Double || get.getClass() == Double.TYPE) {
                set = val;
            } else if (get instanceof Float || get.getClass() == Float.TYPE) {
                set = Float.valueOf((float)val);
            } else if (get instanceof Short || get.getClass() == Short.TYPE) {
                set = (short)val;
            } else if (get instanceof Byte || get.getClass() == Byte.TYPE) {
                set = (byte)val;
            }
            f.set(te, set);
        }

        protected abstract double getReplacedValue(TileEntity var1, int var2, Number var3) throws Exception;

        protected abstract Field getSetField(TileEntity var1) throws Exception;
    }

    private static class NoInterface
    extends RepairInterface {
        private static final NoInterface instance = new NoInterface();

        private NoInterface() {
        }

        @Override
        protected void tick(TileEntity te, int tier) throws Exception {
        }

        @Override
        protected void init() throws Exception {
        }

        @Override
        protected ModList getMod() {
            return null;
        }

        @Override
        protected String[] getClasses() {
            return new String[0];
        }

        @Override
        protected boolean runOnClient() {
            return false;
        }
    }

    private static abstract class RepairInterface {
        protected RepairInterface() {
            if (this.getMod() == null || this.getMod().isLoaded()) {
                try {
                    String[] cs = this.getClasses();
                    for (int i = 0; i < cs.length; ++i) {
                        Class<?> c = Class.forName(cs[i]);
                        interactions.put(c, this);
                    }
                    this.init();
                    ChromatiCraft.logger.log((Object)("Loaded " + this + " for " + this.getMod()));
                }
                catch (Exception e) {
                    ChromatiCraft.logger.logError((Object)("Could not load " + this + " for " + this.getMod() + ":"));
                    e.printStackTrace();
                    ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)this.getMod(), e);
                }
            } else {
                ChromatiCraft.logger.log((Object)("Not loading " + this + " for " + this.getMod() + "; Mod not present."));
            }
        }

        protected abstract void tick(TileEntity var1, int var2) throws Exception;

        protected abstract boolean runOnClient();

        protected abstract void init() throws Exception;

        protected abstract ModList getMod();

        protected abstract String[] getClasses();

        protected TileEntity getActingTileEntity(TileEntity te) throws Exception {
            return te;
        }

        public int getTickRand(int tier) {
            return 1;
        }
    }
}

