/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE.Effect;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Maps.BlockMap;
import Reika.DragonAPI.Interfaces.TileEntity.ThermalTile;
import Reika.DragonAPI.ModList;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.Processing.TileEntityElectrolyzer;
import Reika.ReactorCraft.TileEntities.Processing.TileEntitySynthesizer;
import Reika.RotaryCraft.TileEntities.Farming.TileEntityComposter;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityCompactor;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityCrystallizer;
import Reika.RotaryCraft.TileEntities.Production.TileEntityBlastFurnace;
import Reika.RotaryCraft.TileEntities.Production.TileEntityFermenter;
import ic2.api.energy.tile.IHeatSource;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"ic2.api.energy.tile.IHeatSource"})
public class TileEntityHeatRelay
extends TileEntityAdjacencyUpgrade
implements IHeatSource {
    private static final BlockMap<Integer> blockTemps = new BlockMap();
    private static final HashMap<String, Integer> tileList = new HashMap();
    private static final int machineHeat = 0;
    private static final int tieredMachineHeat = 1;
    private static final int reactorHeat = 10;
    private static final double[] factors = new double[]{0.03125, 0.0625, 0.125, 0.25, 0.375, 0.5, 0.75, 1.0};
    private static final int[] ic2HeatMax = new int[]{2, 5, 10, 20, 50, 100, 250, 1000};
    private static final double[] ic2HeatEff = new double[]{0.1, 0.25, 0.5, 1.0, 1.5, 2.5, 5.0, 10.0};

    @DependentMethodStripper.ModDependent(value={ModList.ROTARYCRAFT})
    private static void addRC() {
        tileList.put(TileEntityBlastFurnace.class.getName(), 1);
        tileList.put(TileEntityCompactor.class.getName(), 0);
        tileList.put(TileEntityComposter.class.getName(), 0);
        tileList.put(TileEntityCrystallizer.class.getName(), 0);
        tileList.put(TileEntityFermenter.class.getName(), 0);
    }

    @DependentMethodStripper.ModDependent(value={ModList.REACTORCRAFT})
    private static void addReC() {
        for (int i = 0; i < ReactorTiles.TEList.length; ++i) {
            ReactorTiles r = ReactorTiles.TEList[i];
            if (!r.isReactorCore()) continue;
            tileList.put(r.getTEClass().getName(), 10);
        }
        tileList.put(TileEntitySynthesizer.class.getName(), 0);
        tileList.put(TileEntityElectrolyzer.class.getName(), 0);
    }

    @Override
    protected boolean ticksIndividually() {
        return false;
    }

    @Override
    protected void doCollectiveTick(World world, int x, int y, int z) {
        int Tavg = 0;
        int n = 0;
        HashMap<ThermalTile, Integer> set = new HashMap<ThermalTile, Integer>();
        int tierThisCycle = Integer.MAX_VALUE;
        double f = this.getEqualizationFactor();
        for (int i = 0; i < 6; ++i) {
            BlockKey bk = BlockKey.getAt((IBlockAccess)world, (int)(x + this.dirs[i].offsetX), (int)(y + this.dirs[i].offsetY), (int)(z + this.dirs[i].offsetZ));
            TileEntity te = this.getEffectiveTileOnSide(this.dirs[i]);
            if (te instanceof ThermalTile && tileList.containsKey(te.getClass().getName())) {
                ++n;
                int tier = tileList.get(te.getClass().getName());
                set.put((ThermalTile)te, tier);
                tierThisCycle = Math.min(tierThisCycle, tier);
                Tavg += ((ThermalTile)te).getTemperature();
                continue;
            }
            if (blockTemps.get(bk) == null) continue;
            ++n;
            Tavg += ((Integer)blockTemps.get(bk)).intValue();
        }
        if (n <= 1) {
            return;
        }
        Tavg /= n;
        for (ThermalTile te : set.keySet()) {
            int hr = (Integer)set.get(te);
            if (hr > tierThisCycle) continue;
            int t1 = te.getTemperature();
            int t2 = (int)(this.getEqualizationFactor() * (double)Tavg + (1.0 - this.getEqualizationFactor()) * (double)t1);
            te.setTemperature(t2);
        }
    }

    private double getEqualizationFactor() {
        return factors[this.getTier()];
    }

    @Override
    protected TileEntityAdjacencyUpgrade.EffectResult tickDirection(World world, int x, int y, int z, ForgeDirection dir, long startTime) {
        return TileEntityAdjacencyUpgrade.EffectResult.STOP;
    }

    @Override
    public CrystalElement getColor() {
        return CrystalElement.ORANGE;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public static double getFactor(int tier) {
        return factors[tier];
    }

    @DependentMethodStripper.ModDependent(value={ModList.IC2})
    public int maxrequestHeatTick(ForgeDirection dir) {
        return !this.hasRedstoneSignal() && this.hasSufficientEnergy() ? ic2HeatMax[this.getTier()] : 0;
    }

    @DependentMethodStripper.ModDependent(value={ModList.IC2})
    public int requestHeat(ForgeDirection dir, int amt) {
        return this.collectHeat(dir, Math.min(this.maxrequestHeatTick(dir), amt));
    }

    @DependentMethodStripper.ModDependent(value={ModList.IC2})
    private int collectHeat(ForgeDirection skip, int seek) {
        if (seek <= 0) {
            return 0;
        }
        int has = 0;
        for (int i = 0; i < 6; ++i) {
            int max;
            ForgeDirection opp;
            IHeatSource hs;
            int take;
            TileEntity te;
            ForgeDirection dir = this.dirs[i];
            if (dir == skip || !((te = this.getEffectiveTileOnSide(dir)) instanceof IHeatSource) || (take = (hs = (IHeatSource)te).requestHeat(opp = dir.getOpposite(), Math.min(max = hs.maxrequestHeatTick(opp), seek))) <= 0) continue;
            has += take;
            if ((seek -= take) == 0) break;
        }
        return (int)((double)has * ic2HeatEff[this.getTier()]);
    }

    public static int getIc2Max(int tier) {
        return ic2HeatMax[tier];
    }

    public static double getIc2Eff(int tier) {
        return ic2HeatEff[tier];
    }

    static {
        blockTemps.put(Blocks.field_150432_aD, (Object)0);
        blockTemps.put(Blocks.field_150355_j, (Object)15);
        blockTemps.put((Block)Blocks.field_150480_ab, (Object)90);
        if (ModList.ROTARYCRAFT.isLoaded()) {
            TileEntityHeatRelay.addRC();
            if (ModList.REACTORCRAFT.isLoaded()) {
                TileEntityHeatRelay.addReC();
            }
        }
    }
}

