/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE.Effect;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.RailcraftHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerBlockHandler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityOreCreator
extends TileEntityAdjacencyUpgrade {
    private static final ArrayList<OreType>[][] oreLists = new ArrayList[OreType.OreRarity.values().length][3];
    private static final OreType.OreRarity[] rarities = new OreType.OreRarity[]{OreType.OreRarity.EVERYWHERE, OreType.OreRarity.EVERYWHERE, OreType.OreRarity.COMMON, OreType.OreRarity.AVERAGE, OreType.OreRarity.SCATTERED, OreType.OreRarity.SCARCE, OreType.OreRarity.SCARCE, OreType.OreRarity.RARE};

    public static void initOreMap() {
        for (int k = 0; k < 3; ++k) {
            EnumSet locs;
            OreType.OreRarity r;
            ReikaOreHelper ore;
            int i;
            OreType.OreLocation loc = OreType.OreLocation.list[k];
            for (i = 0; i < oreLists.length; ++i) {
                TileEntityOreCreator.oreLists[i][k] = new ArrayList();
            }
            for (i = 0; i < ReikaOreHelper.oreList.length; ++i) {
                ore = ReikaOreHelper.oreList[i];
                r = ore.getRarity();
                locs = ore.getOreLocations();
                if (!locs.contains(loc)) continue;
                oreLists[r.ordinal()][k].add((OreType)ore);
            }
            for (i = 0; i < ModOreList.oreList.length; ++i) {
                ore = ModOreList.oreList[i];
                if (!ore.existsInGame()) continue;
                r = ore.getRarity();
                locs = ore.getOreLocations();
                if (!locs.contains(loc)) continue;
                oreLists[r.ordinal()][k].add((OreType)ore);
            }
        }
    }

    private static boolean isItemStackGenerationPermitted(ItemStack is) {
        if (ModList.TINKERER.isLoaded() && ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)TinkerBlockHandler.getInstance().gravelOreID)) {
            return false;
        }
        Block b = Block.func_149634_a((Item)is.func_77973_b());
        if (b == null || b == Blocks.field_150350_a) {
            return false;
        }
        if (b.getClass().getName().startsWith("shukaro.artifice")) {
            return false;
        }
        if (ModList.RAILCRAFT.isLoaded() && RailcraftHandler.getInstance().isDarkOre(b, is.func_77960_j())) {
            return false;
        }
        String mod = ReikaItemHelper.getRegistrantMod((ItemStack)is);
        return mod != null && !mod.equalsIgnoreCase("gregtech") && !mod.equalsIgnoreCase("gt");
    }

    @Override
    protected TileEntityAdjacencyUpgrade.EffectResult tickDirection(World world, int x, int y, int z, ForgeDirection dir, long startTime) {
        OreType type;
        if (world.field_72995_K) {
            return TileEntityAdjacencyUpgrade.EffectResult.ACTION;
        }
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        Block b = world.func_147439_a(dx, dy, dz);
        OreType.OreLocation idx = this.getOreListIndex(world, dx, dy, dz, b);
        if (idx != null && (type = this.tryCreateOre(world, dx, dy, dz, idx)) != null) {
            return TileEntityAdjacencyUpgrade.EffectResult.ACTION;
        }
        return TileEntityAdjacencyUpgrade.EffectResult.CONTINUE;
    }

    private OreType tryCreateOre(World world, int x, int y, int z, OreType.OreLocation loc) {
        int tier = this.getTier();
        if (ReikaRandomHelper.doWithChance((double)TileEntityOreCreator.getOreChance(tier))) {
            OreType.OreRarity max = TileEntityOreCreator.getMaxSpawnableRarity(tier);
            int list = rand.nextInt(1 + max.ordinal());
            ArrayList<OreType>[] arr = oreLists[list];
            ArrayList<OreType> li = arr[loc.ordinal()];
            if (li.isEmpty()) {
                return null;
            }
            OreType ore = li.get(rand.nextInt(li.size()));
            this.doCreateOre(world, x, y, z, ore);
            return ore;
        }
        return null;
    }

    private void doCreateOre(World world, int x, int y, int z, OreType ore) {
        Collection li = ore.getAllOreBlocks();
        ItemStack is = (ItemStack)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, (Collection)li);
        if (!TileEntityOreCreator.isItemStackGenerationPermitted(is)) {
            return;
        }
        BlockKey b = ReikaItemHelper.getWorldBlockFromItem((ItemStack)is);
        if (b.blockID == Blocks.field_150350_a) {
            return;
        }
        world.func_147465_d(x, y, z, b.blockID, b.metadata, 3);
        ReikaSoundHelper.playPlaceSound((World)world, (int)x, (int)y, (int)z, (Block)b.blockID);
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.ORECREATE.ordinal(), (World)world, (int)x, (int)y, (int)z, (int)64, (int[])new int[]{b.getBlockID(), b.metadata});
    }

    public static void doOreCreationFX(World world, int x, int y, int z, int id, int meta) {
        Block b = Block.func_149729_e((int)id);
        ItemStack is = new ItemStack(b, 1, meta);
        ReikaSoundHelper.playPlaceSound((World)world, (int)x, (int)y, (int)z, (Block)b);
        for (int i = 0; i < 2; ++i) {
            ReikaRenderHelper.spawnDropParticles((World)world, (int)x, (int)y, (int)z, (Block)b, (int)meta);
        }
    }

    private OreType.OreLocation getOreListIndex(World world, int x, int y, int z, Block b) {
        if (b.isReplaceableOreGen(world, x, y, z, Blocks.field_150348_b)) {
            return OreType.OreLocation.OVERWORLD;
        }
        if (b.isReplaceableOreGen(world, x, y, z, Blocks.field_150424_aL)) {
            return OreType.OreLocation.NETHER;
        }
        if (b.isReplaceableOreGen(world, x, y, z, Blocks.field_150377_bs)) {
            return OreType.OreLocation.END;
        }
        return null;
    }

    public static double getOreChance(int tier) {
        return 0.5 / Math.pow(4.0, 8 - tier);
    }

    public static OreType.OreRarity getMaxSpawnableRarity(int tier) {
        return rarities[tier];
    }

    @Override
    public CrystalElement getColor() {
        return CrystalElement.BROWN;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }
}

