/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE.Effect;

import Reika.ChromatiCraft.Base.CrystalBlock;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.CrystalPotionController;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Acquisition.TileEntityCollector;
import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaThaumHelper;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;

public class TileEntityPlayerDelegate
extends TileEntityAdjacencyUpgrade {
    private static final HashMap<Class, DelegateInterface> interactions = new HashMap();

    @Override
    protected TileEntityAdjacencyUpgrade.EffectResult tickDirection(World world, int x, int y, int z, ForgeDirection dir, long startTime) {
        int dz;
        int dy;
        int dx;
        Block b;
        TileEntity te = this.getAdjacentTileEntity(dir);
        if (te != null) {
            DelegateInterface s = this.getInterface(te);
            if (s != NoInterface.instance) {
                try {
                    EntityPlayer ep = this.getPlacer();
                    if (ep == null || ReikaPlayerAPI.isFake((EntityPlayer)ep) && !s.canRunWithPlayerOffline()) {
                        return TileEntityAdjacencyUpgrade.EffectResult.CONTINUE;
                    }
                    s.tick(te, this.getTier(), ep);
                }
                catch (Exception ex) {
                    ChromatiCraft.logger.logError((Object)("Could not tick Delegate interface " + s + " for " + te + " @ " + this));
                    this.writeError(ex);
                }
                return TileEntityAdjacencyUpgrade.EffectResult.ACTION;
            }
        } else if (!world.field_72995_K && (b = world.func_147439_a(dx = x + dir.offsetX, dy = y + dir.offsetY, dz = z + dir.offsetZ)) instanceof CrystalBlock && rand.nextInt(80 / (this.getTier() + 1)) == 0) {
            CrystalBlock c = (CrystalBlock)b;
            CrystalElement e = CrystalElement.elements[world.func_72805_g(dx, dy, dz)];
            if (e == CrystalElement.PURPLE) {
                CrystalPotionController.instance.applyEffectFromColor(c.getDuration(e), c.getPotionLevel(e), (EntityLivingBase)this.getPlacer(), e, false);
            } else if (c.shouldGiveEffects(e) && c.performEffect(e)) {
                c.updateEffects(world, dx, dy, dz);
            }
            return TileEntityAdjacencyUpgrade.EffectResult.ACTION;
        }
        return TileEntityAdjacencyUpgrade.EffectResult.CONTINUE;
    }

    private DelegateInterface getInterface(TileEntity te) {
        Class<?> c;
        Class<?> c2;
        DelegateInterface e = interactions.get(c2);
        for (c2 = c = te.getClass(); e == null && c2 != TileEntity.class; c2 = c2.getSuperclass()) {
            e = interactions.get(c2);
        }
        if (e == null) {
            e = NoInterface.instance;
        }
        interactions.put(c, e);
        return e;
    }

    @Override
    public CrystalElement getColor() {
        return CrystalElement.LIGHTGRAY;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    static {
        new DeconstructionTableDelegateInterface();
        new ChromaCollectorDelegateInterface();
    }

    private static class ChromaCollectorDelegateInterface
    extends DelegateInterface {
        private ChromaCollectorDelegateInterface() {
        }

        @Override
        protected void tick(TileEntity te, int tier, EntityPlayer ep) throws Exception {
            TileEntityCollector tc = (TileEntityCollector)te;
            tc.tryIntakeXPFromPlayer(ep, false);
        }

        @Override
        protected void init() throws Exception {
        }

        @Override
        protected ModList getMod() {
            return ModList.CHROMATICRAFT;
        }

        @Override
        protected String[] getClasses() {
            return new String[]{TileEntityCollector.class.getName()};
        }

        @Override
        protected boolean canRunWithPlayerOffline() {
            return false;
        }
    }

    private static class DeconstructionTableDelegateInterface
    extends DelegateInterface {
        private Field aspectOutput;

        private DeconstructionTableDelegateInterface() {
        }

        @Override
        protected void tick(TileEntity te, int tier, EntityPlayer ep) throws Exception {
            Aspect a = (Aspect)this.aspectOutput.get(te);
            if (a != null) {
                ReikaThaumHelper.giveResearchPoint((Aspect)a, (short)1, (EntityPlayer)ep);
                this.aspectOutput.set(te, null);
            }
        }

        @Override
        protected void init() throws Exception {
            this.aspectOutput = Class.forName("thaumcraft.common.tiles.TileDeconstructionTable").getDeclaredField("aspect");
            this.aspectOutput.setAccessible(true);
        }

        @Override
        protected ModList getMod() {
            return ModList.THAUMCRAFT;
        }

        @Override
        protected String[] getClasses() {
            return new String[]{"thaumcraft.common.tiles.TileDeconstructionTable"};
        }

        @Override
        protected boolean canRunWithPlayerOffline() {
            return false;
        }
    }

    private static abstract class FieldSetDelegateInterface
    extends DelegateInterface {
        private FieldSetDelegateInterface() {
        }

        @Override
        protected final void tick(TileEntity te, int tier, EntityPlayer ep) throws Exception {
            te = this.getActingTileEntity(te);
            Field f = this.getSetField(te);
            Number get = (Number)f.get(te);
            double val = this.getReplacedValue(te, tier, get);
            Number set = null;
            if (get instanceof Integer || get.getClass() == Integer.TYPE) {
                set = (int)val;
            } else if (get instanceof Double || get.getClass() == Double.TYPE) {
                set = val;
            } else if (get instanceof Float || get.getClass() == Float.TYPE) {
                set = Float.valueOf((float)val);
            } else if (get instanceof Short || get.getClass() == Short.TYPE) {
                set = (short)val;
            } else if (get instanceof Byte || get.getClass() == Byte.TYPE) {
                set = (byte)val;
            }
            f.set(te, set);
        }

        protected abstract double getReplacedValue(TileEntity var1, int var2, Number var3) throws Exception;

        protected abstract Field getSetField(TileEntity var1) throws Exception;
    }

    private static class NoInterface
    extends DelegateInterface {
        private static final NoInterface instance = new NoInterface();

        private NoInterface() {
        }

        @Override
        protected void tick(TileEntity te, int tier, EntityPlayer ep) throws Exception {
        }

        @Override
        protected void init() throws Exception {
        }

        @Override
        protected ModList getMod() {
            return null;
        }

        @Override
        protected String[] getClasses() {
            return new String[0];
        }

        @Override
        protected boolean canRunWithPlayerOffline() {
            return false;
        }
    }

    private static abstract class DelegateInterface {
        protected DelegateInterface() {
            if (this.getMod() == null || this.getMod().isLoaded()) {
                try {
                    String[] cs = this.getClasses();
                    for (int i = 0; i < cs.length; ++i) {
                        Class<?> c = Class.forName(cs[i]);
                        interactions.put(c, this);
                    }
                    this.init();
                    ChromatiCraft.logger.log((Object)("Loaded " + this + " for " + this.getMod()));
                }
                catch (Exception e) {
                    ChromatiCraft.logger.logError((Object)("Could not load " + this + " for " + this.getMod() + ":"));
                    e.printStackTrace();
                    ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)this.getMod(), e);
                }
            } else {
                ChromatiCraft.logger.log((Object)("Not loading " + this + " for " + this.getMod() + "; Mod not present."));
            }
        }

        protected abstract void tick(TileEntity var1, int var2, EntityPlayer var3) throws Exception;

        protected abstract void init() throws Exception;

        protected abstract ModList getMod();

        protected abstract String[] getClasses();

        protected TileEntity getActingTileEntity(TileEntity te) throws Exception {
            return te;
        }

        protected abstract boolean canRunWithPlayerOffline();
    }
}

