/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE.Effect;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.Registry.CrystalElement;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityProtectionUpgrade
extends TileEntityAdjacencyUpgrade {
    private static double[] MAX_BLAST = new double[]{0.5, 1.0, 2.0, 4.0, 6.0, 12.0, 48.0, Double.POSITIVE_INFINITY};

    @Override
    protected TileEntityAdjacencyUpgrade.EffectResult tickDirection(World world, int x, int y, int z, ForgeDirection dir, long startTime) {
        return TileEntityAdjacencyUpgrade.EffectResult.STOP;
    }

    @Override
    public CrystalElement getColor() {
        return CrystalElement.RED;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public static boolean canExplode(World world, double dx, double dy, double dz, double power, boolean ic2Nuke) {
        int x = MathHelper.func_76128_c((double)dx);
        int y = MathHelper.func_76128_c((double)dy);
        int z = MathHelper.func_76128_c((double)dz);
        Integer get = TileEntityProtectionUpgrade.getAdjacentUpgrades(world, x, y, z).get(CrystalElement.RED);
        if (ic2Nuke && (get == null || get == 0)) {
            get = TileEntityProtectionUpgrade.checkForStep2(world, x, y, z);
        }
        if (get == null || get == 0) {
            return true;
        }
        return power > TileEntityProtectionUpgrade.getMaxProtectedPower(get - 1);
    }

    private static Integer checkForStep2(World world, int x, int y, int z) {
        Integer ret = null;
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            Integer at = TileEntityProtectionUpgrade.getAdjacentUpgrades(world, dx, dy, dz).get(CrystalElement.RED);
            if (at == null) continue;
            ret = ret == null ? at : Integer.valueOf(Math.max(ret, at));
        }
        return ret;
    }

    public static double getMaxProtectedPower(int tier) {
        return MAX_BLAST[tier];
    }
}

