/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE.Effect;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import java.util.HashMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityStabilityCore
extends TileEntityAdjacencyUpgrade {
    private static final HashMap<Class, StabilityInterface> interactions = new HashMap();

    @Override
    protected TileEntityAdjacencyUpgrade.EffectResult tickDirection(World world, int x, int y, int z, ForgeDirection dir, long startTime) {
        StabilityInterface s;
        TileEntity te = this.getAdjacentTileEntity(dir);
        if (te != null && (s = this.getInterface(te)) != NoInterface.instance) {
            try {
                s.tick(te, this.getTier());
            }
            catch (Exception ex) {
                ChromatiCraft.logger.logError((Object)("Could not tick stability interface " + s + " for " + te + " @ " + this));
                this.writeError(ex);
            }
            return TileEntityAdjacencyUpgrade.EffectResult.ACTION;
        }
        return TileEntityAdjacencyUpgrade.EffectResult.CONTINUE;
    }

    private StabilityInterface getInterface(TileEntity te) {
        Class<?> c;
        Class<?> c2;
        StabilityInterface e = interactions.get(c2);
        for (c2 = c = te.getClass(); e == null && c2 != TileEntity.class; c2 = c2.getSuperclass()) {
            e = interactions.get(c2);
        }
        if (e == null) {
            e = NoInterface.instance;
        }
        interactions.put(c, e);
        return e;
    }

    @Override
    public CrystalElement getColor() {
        return CrystalElement.WHITE;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    static {
        new InfusionStabilityInterface();
    }

    private static class InfusionStabilityInterface
    extends FieldSetStabilityInterface {
        private Field instability;
        private Field recipeInstability;

        private InfusionStabilityInterface() {
        }

        @Override
        protected void init() throws Exception {
            Class<?> c = Class.forName("thaumcraft.common.tiles.TileInfusionMatrix");
            this.instability = c.getDeclaredField("instability");
            this.instability.setAccessible(true);
            this.recipeInstability = c.getDeclaredField("recipeInstability");
            this.recipeInstability.setAccessible(true);
        }

        @Override
        protected ModList getMod() {
            return ModList.THAUMCRAFT;
        }

        @Override
        protected String[] getClasses() {
            return new String[]{"thaumcraft.common.tiles.TileInfusionMatrix"};
        }

        @Override
        protected Field getSetField(TileEntity te) throws Exception {
            return this.instability;
        }

        @Override
        protected double getReplacedValue(TileEntity te, int tier, Number original) throws Exception {
            return (double)this.recipeInstability.getInt(te) * this.getReductionFactor(tier);
        }

        private double getReductionFactor(int tier) {
            return Math.pow(0.67, 1 + tier);
        }
    }

    private static abstract class FieldSetStabilityInterface
    extends StabilityInterface {
        private FieldSetStabilityInterface() {
        }

        @Override
        protected final void tick(TileEntity te, int tier) throws Exception {
            te = this.getActingTileEntity(te);
            Field f = this.getSetField(te);
            Number get = (Number)f.get(te);
            double val = this.getReplacedValue(te, tier, get);
            Number set = null;
            if (get instanceof Integer || get.getClass() == Integer.TYPE) {
                set = (int)val;
            } else if (get instanceof Double || get.getClass() == Double.TYPE) {
                set = val;
            } else if (get instanceof Float || get.getClass() == Float.TYPE) {
                set = Float.valueOf((float)val);
            } else if (get instanceof Short || get.getClass() == Short.TYPE) {
                set = (short)val;
            } else if (get instanceof Byte || get.getClass() == Byte.TYPE) {
                set = (byte)val;
            }
            f.set(te, set);
        }

        protected abstract double getReplacedValue(TileEntity var1, int var2, Number var3) throws Exception;

        protected abstract Field getSetField(TileEntity var1) throws Exception;
    }

    private static class NoInterface
    extends StabilityInterface {
        private static final NoInterface instance = new NoInterface();

        private NoInterface() {
        }

        @Override
        protected void tick(TileEntity te, int tier) throws Exception {
        }

        @Override
        protected void init() throws Exception {
        }

        @Override
        protected ModList getMod() {
            return null;
        }

        @Override
        protected String[] getClasses() {
            return new String[0];
        }
    }

    private static abstract class StabilityInterface {
        protected StabilityInterface() {
            if (this.getMod() == null || this.getMod().isLoaded()) {
                try {
                    String[] cs = this.getClasses();
                    for (int i = 0; i < cs.length; ++i) {
                        Class<?> c = Class.forName(cs[i]);
                        interactions.put(c, this);
                    }
                    this.init();
                    ChromatiCraft.logger.log((Object)("Loaded " + this + " for " + this.getMod()));
                }
                catch (Exception e) {
                    ChromatiCraft.logger.logError((Object)("Could not load " + this + " for " + this.getMod() + ":"));
                    e.printStackTrace();
                    ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)this.getMod(), e);
                }
            } else {
                ChromatiCraft.logger.log((Object)("Not loading " + this + " for " + this.getMod() + "; Mod not present."));
            }
        }

        protected abstract void tick(TileEntity var1, int var2) throws Exception;

        protected abstract void init() throws Exception;

        protected abstract ModList getMod();

        protected abstract String[] getClasses();

        protected TileEntity getActingTileEntity(TileEntity te) throws Exception {
            return te;
        }
    }
}

