/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE;

import Reika.ChromatiCraft.Auxiliary.Interfaces.ItemOnRightClick;
import Reika.ChromatiCraft.Base.TileEntity.ChargedCrystalPowered;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Base.BlockTieredResource;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockSpiral;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Effects.LightningBolt;
import Reika.DragonAPI.Interfaces.Block.MachineRegistryBlock;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import buildcraft.api.core.IAreaProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class TileEntityAreaBreaker
extends ChargedCrystalPowered
implements BreakAction,
ItemOnRightClick {
    public static final int MAX_ACTIVE_BREAKERS = 4;
    public static final float TICKS_PER_HARDNESS = 5.0f;
    public static final int MAX_RANGE = 16;
    private final BlockSpiral[] area = new BlockSpiral[16];
    private final HashMap<Coordinate, ImmutablePair<Integer, Integer>> breakLocs = new HashMap();
    private final MultiMap<Coordinate, LightningBolt> bolts = new MultiMap();
    private int newloctick = 0;
    private int activeIndex = 0;
    private BreakShape shape = BreakShape.CUBOID;
    private BlockBox areaOverride = null;
    private int range = 16;
    private static final ElementTagCompound required = new ElementTagCompound();

    @Override
    public ElementTagCompound getRequiredEnergy() {
        return required.copy();
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.AREABREAKER;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.isRunning()) {
            EntityPlayer ep = this.getPlacer();
            if (this.newloctick == 0) {
                if (this.breakLocs.size() < Math.max(1, Math.min(4, this.area[this.activeIndex].getSize() / 16))) {
                    Block b;
                    Coordinate c = this.area[this.activeIndex].getNextAndMoveOn();
                    Block block = b = c != null ? c.getBlock((IBlockAccess)world) : Blocks.field_150350_a;
                    while (!this.area[this.activeIndex].isEmpty() && !this.isCoordValid(c, b, world, x, y, z)) {
                        c = this.area[this.activeIndex].getNextAndMoveOn();
                        b = c != null ? c.getBlock((IBlockAccess)world) : Blocks.field_150350_a;
                    }
                    if (this.isCoordValid(c, b, world, x, y, z)) {
                        this.newloctick = 4;
                        float h = b.func_149712_f(world, c.xCoord, c.yCoord, c.zCoord);
                        if (h >= 0.0f) {
                            int t = Math.max((int)(5.0f * h), 4);
                            this.breakLocs.put(c, (ImmutablePair<Integer, Integer>)new ImmutablePair((Object)t, (Object)t));
                            this.createBolts(c);
                        }
                    }
                    if (this.activeIndex < this.area.length - 1 && this.area[this.activeIndex].isEmpty()) {
                        ++this.activeIndex;
                    }
                }
            } else {
                --this.newloctick;
            }
            HashMap<Coordinate, ImmutablePair> put = new HashMap<Coordinate, ImmutablePair>();
            for (Coordinate c : this.breakLocs.keySet()) {
                if (!this.hasEnergy(required)) continue;
                ImmutablePair<Integer, Integer> get = this.breakLocs.get(c);
                c.destroyBlockPartially(world, 10.0 - 10.0 * (double)((Integer)get.left).intValue() / (double)((Integer)get.right).intValue());
                if ((Integer)get.left > 1) {
                    put.put(c, new ImmutablePair((Object)((Integer)get.left - 1), get.right));
                    this.useEnergy(required.copy().scale(this.getEnergyCostScale() * 0.25f));
                    Collection li = this.bolts.get((Object)c);
                    for (LightningBolt b : li) {
                        b.update();
                    }
                    continue;
                }
                this.useEnergy(required.copy().scale(this.getEnergyCostScale()));
                this.breakBlock(world, c.xCoord, c.yCoord, c.zCoord, ep);
                this.bolts.remove((Object)c);
            }
            this.breakLocs.clear();
            this.breakLocs.putAll(put);
        }
    }

    private boolean isRunning() {
        return this.hasRedstoneSignal();
    }

    private boolean isCoordValid(Coordinate c, Block b, World world, int x, int y, int z) {
        return c != null && this.shouldTryBreaking(world, c.xCoord, c.yCoord, c.zCoord, b) && !c.equals(x, y, z) && c.getTileEntity((IBlockAccess)world) == null && (this.areaOverride != null ? this.areaOverride.isBlockInside(c) : this.shape.isBlockInShape(c.xCoord - x, c.yCoord - y, c.zCoord - z, this.range));
    }

    private boolean shouldTryBreaking(World world, int x, int y, int z, Block b) {
        return !b.isAir((IBlockAccess)world, x, y, z) && !ReikaBlockHelper.isLiquid((Block)b);
    }

    private void createBolts(Coordinate c) {
        for (int i = 0; i < 3; ++i) {
            LightningBolt b = new LightningBolt(new DecimalPosition((TileEntity)this), new DecimalPosition(c), 8);
            b.setVariance(0.25);
            b.setVelocity(0.0625);
            this.bolts.addValue((Object)c, (Object)b);
        }
    }

    public Map<Coordinate, ImmutablePair<Integer, Integer>> getBreakLocs() {
        return Collections.unmodifiableMap(this.breakLocs);
    }

    public Collection<LightningBolt> getBolts(Coordinate c) {
        return this.bolts.get((Object)c);
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        this.getCoordsFromIAP(world, x, y, z);
        this.initArea();
    }

    private void initArea() {
        for (int i = 0; i < this.area.length; ++i) {
            this.area[i] = new BlockSpiral(this.field_145851_c, this.field_145848_d + i, this.field_145849_e, this.range).setRightHanded().setGridSize(1).calculate();
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    private void breakBlock(World world, int x, int y, int z, EntityPlayer ep) {
        Block b = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (world.field_72995_K) {
            ReikaRenderHelper.spawnDropParticles((World)world, (int)x, (int)y, (int)z, (Block)b, (int)meta);
        } else {
            this.dropItems(world, x, y, z, b, meta, ep);
        }
        ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)y, (int)z, (Block)b);
        world.func_147449_b(x, y, z, Blocks.field_150350_a);
    }

    private void dropItems(World world, int x, int y, int z, Block b, int meta, EntityPlayer ep) {
        Collection items = null;
        if (b instanceof BlockTieredResource) {
            BlockTieredResource bt = (BlockTieredResource)b;
            boolean harvest = ep != null && bt.isPlayerSufficientTier((IBlockAccess)world, x, y, z, ep);
            items = harvest ? bt.getHarvestResources(world, x, y, z, 0, ep) : bt.getNoHarvestResources(world, x, y, z, 0, ep);
        } else {
            items = b instanceof MachineRegistryBlock ? ReikaJavaLibrary.makeListFrom((Object)((MachineRegistryBlock)b).getMachine((IBlockAccess)world, x, y, z).getCraftedProduct()) : ReikaJavaLibrary.makeListFrom((Object)ReikaBlockHelper.getSilkTouch((World)world, (int)x, (int)y, (int)z, (Block)b, (int)meta, (EntityPlayer)this.getPlacer(), (boolean)false));
        }
        if (items != null) {
            for (ItemStack is : items) {
                ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (ItemStack)is);
            }
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.shape = BreakShape.list[NBT.func_74762_e("shape")];
        if (NBT.func_74764_b("override")) {
            NBTTagCompound tag = NBT.func_74775_l("override");
            this.areaOverride = BlockBox.readFromNBT((NBTTagCompound)tag);
        }
        this.range = NBT.func_74762_e("range");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (this.areaOverride != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.areaOverride.writeToNBT(tag);
            NBT.func_74782_a("override", (NBTBase)tag);
        }
        NBT.func_74768_a("shape", this.shape.ordinal());
        NBT.func_74768_a("range", this.range);
    }

    public void breakBlock() {
        for (Coordinate c : this.breakLocs.keySet()) {
            c.destroyBlockPartially(this.field_145850_b, -1.0);
        }
    }

    public BreakShape getShape() {
        return this.shape;
    }

    public void cycleShape() {
        this.initArea();
        this.shape = this.shape.next();
        ChromaSounds.USE.playSoundAtBlock((TileEntity)this);
    }

    public void incRange() {
        ++this.range;
        if (this.range > 16) {
            this.range = 1;
        }
        this.initArea();
        ReikaPacketHelper.sendDataPacketWithRadius((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.NUMBERPARTICLE.ordinal(), (TileEntity)this, (int)512, (int[])new int[]{this.range});
        ChromaSounds.USE.playSoundAtBlock((TileEntity)this);
    }

    public int getRange() {
        return this.range;
    }

    public int func_70302_i_() {
        return 1;
    }

    public int func_70297_j_() {
        return 1;
    }

    @Override
    public float getCostModifier() {
        return 1.0f;
    }

    @Override
    public boolean usesColor(CrystalElement e) {
        return required.contains(e);
    }

    @Override
    protected boolean canExtractOtherItem(int slot, ItemStack is, int side) {
        return false;
    }

    @Override
    protected boolean isItemValidForOtherSlot(int slot, ItemStack is) {
        return false;
    }

    @Override
    public ItemStack onRightClickWith(ItemStack item, EntityPlayer ep) {
        if (item == null) {
            ItemStack is = this.inv[0];
            this.inv[0] = null;
            return is;
        }
        if (this.func_94041_b(0, item)) {
            this.inv[0] = item;
            return null;
        }
        return item;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.isRunning() ? ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b(16.0, 16.0, 16.0) : super.getRenderBoundingBox();
    }

    private void getCoordsFromIAP(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            TileEntity te = world.func_147438_o(dx, dy, dz);
            if (!InterfaceCache.AREAPROVIDER.instanceOf((Object)te)) continue;
            IAreaProvider iap = (IAreaProvider)te;
            this.areaOverride = new BlockBox(iap.xMin(), iap.yMin(), iap.zMin(), iap.xMax() + 1, iap.yMax() + 1, iap.zMax() + 1);
            this.range = this.areaOverride.getLongestEdge() + 2;
            iap.removeFromWorld();
            this.syncAllData(false);
            return;
        }
    }

    static {
        required.addTag(CrystalElement.YELLOW, 50);
        required.addTag(CrystalElement.LIGHTGRAY, 20);
        required.addTag(CrystalElement.PURPLE, 10);
    }

    public static enum BreakShape {
        CUBOID,
        HEMISPHERE,
        CYLINDER,
        DIAMONDPRISM,
        PYRAMID,
        HEXAGON,
        OCTAGON;

        private static final BreakShape[] list;

        public boolean isBlockInShape(int dx, int dy, int dz, int r) {
            r = this.getRangeForHeight(dy, r);
            switch (this) {
                case CUBOID: {
                    return Math.abs(dx) <= r && Math.abs(dy) <= r && Math.abs(dz) <= r;
                }
                case HEMISPHERE: {
                    return ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz) <= (double)r + 0.5;
                }
                case CYLINDER: {
                    return ReikaMathLibrary.py3d((double)dx, (double)0.0, (double)dz) <= (double)r + 0.5;
                }
                case PYRAMID: {
                    return new Coordinate(dx, dy, dz).getTaxicabDistanceTo(new Coordinate(0, 0, 0)) <= r;
                }
                case DIAMONDPRISM: {
                    return new Coordinate(dx, 0, dz).getTaxicabDistanceTo(new Coordinate(0, 0, 0)) <= r;
                }
                case HEXAGON: {
                    return ReikaMathLibrary.isPointInsidePolygon((double)dx, (double)dz, (double)6.0, (double)r);
                }
                case OCTAGON: {
                    return ReikaMathLibrary.isPointInsidePolygon((double)dx, (double)dz, (double)8.0, (double)r);
                }
            }
            return false;
        }

        public BreakShape next() {
            return list[(this.ordinal() + 1) % list.length];
        }

        private int getRangeForHeight(int i, int r) {
            if (this == DIAMONDPRISM || this == CYLINDER) {
                return r;
            }
            if (this == PYRAMID) {
                return r - i;
            }
            return i <= 3 ? r : r + 3 - (i < 8 ? i : 8 + (i - 8) * 2);
        }

        public void renderPreview(Tessellator v5, double s) {
            switch (this) {
                case CUBOID: {
                    v5.func_78377_a(-s, -s, -s);
                    v5.func_78377_a(s, -s, -s);
                    v5.func_78377_a(s, -s, -s);
                    v5.func_78377_a(s, -s, s);
                    v5.func_78377_a(s, -s, s);
                    v5.func_78377_a(-s, -s, s);
                    v5.func_78377_a(-s, -s, s);
                    v5.func_78377_a(-s, -s, -s);
                    v5.func_78377_a(-s, s, -s);
                    v5.func_78377_a(s, s, -s);
                    v5.func_78377_a(s, s, -s);
                    v5.func_78377_a(s, s, s);
                    v5.func_78377_a(s, s, s);
                    v5.func_78377_a(-s, s, s);
                    v5.func_78377_a(-s, s, s);
                    v5.func_78377_a(-s, s, -s);
                    v5.func_78377_a(-s, -s, -s);
                    v5.func_78377_a(-s, s, -s);
                    v5.func_78377_a(s, -s, -s);
                    v5.func_78377_a(s, s, -s);
                    v5.func_78377_a(-s, -s, s);
                    v5.func_78377_a(-s, s, s);
                    v5.func_78377_a(s, -s, s);
                    v5.func_78377_a(s, s, s);
                    break;
                }
                case HEMISPHERE: {
                    for (double s2 = 0.0; s2 <= s; s2 += s / 8.0) {
                        for (double a = 0.0; a <= 350.0; a += 10.0) {
                            double a1 = Math.toRadians(a);
                            double a2 = Math.toRadians(a + 10.0);
                            double r = 0.75 * Math.sqrt(s - s2);
                            double x1 = r * Math.cos(a1);
                            double z1 = r * Math.sin(a1);
                            double x2 = r * Math.cos(a2);
                            double z2 = r * Math.sin(a2);
                            v5.func_78377_a(x1, s2, z1);
                            v5.func_78377_a(x2, s2, z2);
                        }
                    }
                    break;
                }
                case CYLINDER: {
                    for (double a = 0.0; a <= 350.0; a += 10.0) {
                        double a1 = Math.toRadians(a);
                        double a2 = Math.toRadians(a + 10.0);
                        double x1 = s * Math.cos(a1);
                        double z1 = s * Math.sin(a1);
                        double x2 = s * Math.cos(a2);
                        double z2 = s * Math.sin(a2);
                        v5.func_78377_a(x1, -s, z1);
                        v5.func_78377_a(x2, -s, z2);
                        v5.func_78377_a(x1, s, z1);
                        v5.func_78377_a(x2, s, z2);
                        v5.func_78377_a(x1, -s, z1);
                        v5.func_78377_a(0.0, -s, 0.0);
                        v5.func_78377_a(x1, s, z1);
                        v5.func_78377_a(0.0, s, 0.0);
                        v5.func_78377_a(x1, -s, z1);
                        v5.func_78377_a(x1, s, z1);
                    }
                    break;
                }
                case DIAMONDPRISM: {
                    v5.func_78377_a(s, -s, 0.0);
                    v5.func_78377_a(0.0, -s, s);
                    v5.func_78377_a(0.0, -s, s);
                    v5.func_78377_a(-s, -s, 0.0);
                    v5.func_78377_a(-s, -s, 0.0);
                    v5.func_78377_a(0.0, -s, -s);
                    v5.func_78377_a(0.0, -s, -s);
                    v5.func_78377_a(s, -s, 0.0);
                    v5.func_78377_a(s, s, 0.0);
                    v5.func_78377_a(0.0, s, s);
                    v5.func_78377_a(0.0, s, s);
                    v5.func_78377_a(-s, s, 0.0);
                    v5.func_78377_a(-s, s, 0.0);
                    v5.func_78377_a(0.0, s, -s);
                    v5.func_78377_a(0.0, s, -s);
                    v5.func_78377_a(s, s, 0.0);
                    v5.func_78377_a(s, -s, 0.0);
                    v5.func_78377_a(s, s, 0.0);
                    v5.func_78377_a(0.0, -s, s);
                    v5.func_78377_a(0.0, s, s);
                    v5.func_78377_a(-s, -s, 0.0);
                    v5.func_78377_a(-s, s, 0.0);
                    v5.func_78377_a(0.0, -s, -s);
                    v5.func_78377_a(0.0, s, -s);
                    break;
                }
                case PYRAMID: {
                    v5.func_78377_a(0.0, -s, s);
                    v5.func_78377_a(0.0, -s, -s);
                    v5.func_78377_a(-s, -s, 0.0);
                    v5.func_78377_a(s, -s, 0.0);
                    v5.func_78377_a(s, -s, 0.0);
                    v5.func_78377_a(0.0, s, 0.0);
                    v5.func_78377_a(-s, -s, 0.0);
                    v5.func_78377_a(0.0, s, 0.0);
                    v5.func_78377_a(0.0, -s, s);
                    v5.func_78377_a(0.0, s, 0.0);
                    v5.func_78377_a(0.0, -s, -s);
                    v5.func_78377_a(0.0, s, 0.0);
                    v5.func_78377_a(s, -s, 0.0);
                    v5.func_78377_a(0.0, -s, s);
                    v5.func_78377_a(0.0, -s, s);
                    v5.func_78377_a(-s, -s, 0.0);
                    v5.func_78377_a(-s, -s, 0.0);
                    v5.func_78377_a(0.0, -s, -s);
                    v5.func_78377_a(0.0, -s, -s);
                    v5.func_78377_a(s, -s, 0.0);
                    break;
                }
                case HEXAGON: {
                    for (int i = 0; i < 6; ++i) {
                        double a = Math.toRadians(30 + i * 60);
                        double a2 = Math.toRadians(30 + (i + 1) * 60);
                        double dx = s * Math.cos(a);
                        double dz = s * Math.sin(a);
                        double dx2 = s * Math.cos(a2);
                        double dz2 = s * Math.sin(a2);
                        v5.func_78377_a(dx, -s, dz);
                        v5.func_78377_a(dx, s, dz);
                        v5.func_78377_a(dx, -s, dz);
                        v5.func_78377_a(dx2, -s, dz2);
                        v5.func_78377_a(dx, s, dz);
                        v5.func_78377_a(dx2, s, dz2);
                    }
                    break;
                }
                case OCTAGON: {
                    for (int i = 0; i < 8; ++i) {
                        double a = Math.toRadians(22.5 + (double)(i * 45));
                        double a2 = Math.toRadians(22.5 + (double)((i + 1) * 45));
                        double dx = s * Math.cos(a);
                        double dz = s * Math.sin(a);
                        double dx2 = s * Math.cos(a2);
                        double dz2 = s * Math.sin(a2);
                        v5.func_78377_a(dx, -s, dz);
                        v5.func_78377_a(dx, s, dz);
                        v5.func_78377_a(dx, -s, dz);
                        v5.func_78377_a(dx2, -s, dz2);
                        v5.func_78377_a(dx, s, dz);
                        v5.func_78377_a(dx2, s, dz2);
                    }
                    break;
                }
            }
        }

        static {
            list = BreakShape.values();
        }
    }
}

