/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE;

import Reika.ChromatiCraft.Auxiliary.ChromaAux;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityLocusPoint;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.Render.GlowKnot;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.Instantiable.Data.Collections.FastPlayerCache;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Interfaces.Registry.CropType;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.ModList;
import Reika.VoidMonster.Entity.EntityVoidMonster;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import vazkii.botania.api.boss.IBotaniaBoss;

public class TileEntityAuraPoint
extends TileEntityLocusPoint {
    @SideOnly(value=Side.CLIENT)
    public GlowKnot knot;
    private static final String NBT_TAG = "aurapoint";
    private int hue;
    private float saturation;
    private int hueTarget;
    private float saturationTarget;
    private final FastPlayerCache hostilePlayers = new FastPlayerCache();
    private boolean doPVP = true;

    public TileEntityAuraPoint() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.loadGlowKnot();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void loadGlowKnot() {
        this.knot = new GlowKnot(0.875);
    }

    @Override
    public void breakBlock() {
        super.breakBlock();
    }

    public void togglePVP() {
        this.doPVP = !this.doPVP;
        this.hostilePlayers.clear();
    }

    public boolean doPvP() {
        return this.doPVP;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (!world.field_72995_K) {
            this.playSounds(world, x, y, z);
            this.doAmbientEffects(world, x, y, z);
        }
    }

    private void playSounds(World world, int x, int y, int z) {
        int n;
        int n2 = n = world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue() ? 2 : 1;
        if (this.getTicksExisted() % (244 / n) == 0) {
            ChromaSounds.AURALOCUS.playSoundAtBlock(world, x, y, z, 2.0f, n);
        }
    }

    private void doAmbientEffects(World world, int x, int y, int z) {
        if (rand.nextInt(20) == 0) {
            this.killEntities(world, x, y, z);
        }
        if (rand.nextInt(160) == 0) {
            this.healFriendly(world, x, y, z);
        }
    }

    private void killEntities(World world, int x, int y, int z) {
        int r = this.getAttackRange();
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(x - r), (double)0.0, (double)(z - r), (double)(x + 1 + r), (double)256.0, (double)(z + 1 + r));
        List li = world.func_72872_a(EntityLivingBase.class, box);
        boolean flag = false;
        int i = 0;
        for (EntityLivingBase e : li) {
            if (!this.shouldAttack(e)) continue;
            this.attack(world, x, y, z, e);
            flag = true;
            ++i;
        }
        if (flag) {
            ChromaSounds.DISCHARGE.playSoundAtBlock((TileEntity)this);
            EntityPlayer ep = this.getPlacer();
            if (ep != null && ep.func_70011_f((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) < 32.0) {
                ChromaSounds.DISCHARGE.playSound((Entity)ep, 0.125f, 0.75f);
            }
        }
    }

    private int getAttackRange() {
        return (int)Math.min(8L + this.getTileEntityAge() / 16L, 96L);
    }

    private int getHealRange() {
        return (int)Math.min(4L + this.getTileEntityAge() / 64L, 32L);
    }

    private int getLootingLevel() {
        return (int)Math.min(6L, this.getTileEntityAge() / 288000L);
    }

    private void attack(World world, int x, int y, int z, EntityLivingBase e) {
        float dmg = this.getAttackDamage(e);
        ChromaAux.doPylonAttack(null, e, dmg, false, this.getLootingLevel(), false);
        ChromaSounds.DISCHARGE.playSound(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, 1.0f, 1.0f);
        ChromaSounds.DISCHARGE.playSound((Entity)e, 0.5f, 1.0f);
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.AURATTACK.ordinal(), (TileEntity)this, (int)192, (int[])new int[]{e.func_145782_y()});
    }

    private float getAttackDamage(EntityLivingBase e) {
        if (ModList.BOTANIA.isLoaded() && e instanceof IBotaniaBoss) {
            return 100.0f;
        }
        if (e instanceof EntityPlayer) {
            return 10.0f;
        }
        return Math.max(4.0f, e.func_110143_aJ() / 2.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void doAttackFX(Entity e) {
        if (e != null) {
            double x = (double)this.field_145851_c + 0.5;
            double y = (double)this.field_145848_d + 0.5;
            double z = (double)this.field_145849_e + 0.5;
            double dx = e.field_70165_t - x;
            double dy = e.field_70163_u + (double)(e.field_70131_O / 2.0f) - y;
            double dz = e.field_70161_v - z;
            double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
            for (double d = 0.0; d <= dd; d += 0.5) {
                double f = d / dd;
                double f2 = f < 0.5 ? 1.0 - f : f;
                double px = x + f * dx;
                double py = y + f * dy;
                double pz = z + f * dz;
                px = ReikaRandomHelper.getRandomPlusMinus((double)px, (double)0.25);
                py = ReikaRandomHelper.getRandomPlusMinus((double)py, (double)0.25);
                pz = ReikaRandomHelper.getRandomPlusMinus((double)pz, (double)0.25);
                float sc = 2.5f + (float)((1.0 - f2) * 20.0);
                sc = (float)ReikaRandomHelper.getRandomPlusMinus((double)sc, (double)0.25);
                EntityBlurFX fx = new EntityCCBlurFX(e.field_70170_p, px, py, pz).setIcon(ChromaIcons.FLARE).setScale(sc).setRapidExpand().setLife(10);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    private boolean shouldAttack(EntityLivingBase e) {
        if (e.func_110143_aJ() <= 0.0f || e.field_70128_L) {
            return false;
        }
        if (e instanceof EntityPlayer) {
            if (!this.doPVP) {
                return false;
            }
            EntityPlayer ep = (EntityPlayer)e;
            if (this.isPlacer(ep)) {
                return false;
            }
            return this.hostilePlayers.containsPlayer(ep);
        }
        if (ModList.VOIDMONSTER.isLoaded() && e instanceof EntityVoidMonster) {
            return e.field_70163_u > 4.0;
        }
        return ReikaEntityHelper.isHostile((EntityLivingBase)e) || e instanceof EntityEnderman || e instanceof EntityPigZombie;
    }

    @SideOnly(value=Side.CLIENT)
    public static void doGrowFX(World world, int x, int y, int z) {
        ReikaParticleHelper.BONEMEAL.spawnAroundBlockWithOutset(world, x, y, z, 4, 0.0625);
    }

    private void healFriendly(World world, int x, int y, int z) {
        int r = this.getHealRange();
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(x - r), (double)0.0, (double)(z - r), (double)(x + 1 + r), (double)256.0, (double)(z + 1 + r));
        List li = world.func_72872_a(EntityLivingBase.class, box);
        boolean flag = false;
        for (EntityLivingBase e : li) {
            if (!this.shouldHeal(e)) continue;
            this.heal(e);
            flag = true;
        }
    }

    private void heal(EntityLivingBase e) {
        e.func_70691_i(e.func_110138_aP());
        ChromaSounds.CAST.playSound((Entity)e, 0.5f, 1.0f);
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.AURAHEAL.ordinal(), (TileEntity)this, (int)64, (int[])new int[]{e.func_145782_y()});
    }

    @SideOnly(value=Side.CLIENT)
    public void doHealFX(Entity e) {
        for (int i = 0; i < 32; ++i) {
            double x = ReikaRandomHelper.getRandomPlusMinus((double)e.field_70165_t, (double)1.5);
            double z = ReikaRandomHelper.getRandomPlusMinus((double)e.field_70161_v, (double)1.5);
            double y = e.field_70163_u - 1.0 + (double)(rand.nextFloat() * (e.field_70131_O + 2.0f));
            ReikaParticleHelper.MOBSPELL.spawnAt(e.field_70170_p, x, y, z);
        }
    }

    private boolean shouldHeal(EntityLivingBase e) {
        if (e.func_110143_aJ() >= e.func_110138_aP()) {
            return false;
        }
        if (e instanceof EntityPlayer) {
            EntityPlayer ep = (EntityPlayer)e;
            return this.isPlacer(ep) || !this.hostilePlayers.containsPlayer(ep);
        }
        return e instanceof EntityAnimal;
    }

    public void markHostile(EntityPlayer ep) {
        this.hostilePlayers.addPlayer(ep);
    }

    private void updateColors() {
        float ds = this.saturationTarget - this.saturation;
        int dh = this.hueTarget - this.hue;
        if (dh == 0 && (double)Math.abs(ds) < 0.03125) {
            this.hueTarget = rand.nextInt(360);
            this.saturationTarget = rand.nextFloat() * rand.nextFloat();
        }
        this.saturation = (float)((double)this.saturation + 0.00390625 * (double)Math.signum(ds));
        int hd = (int)Math.signum(dh);
        this.hue = Math.abs(dh) >= 180 ? (this.hue -= hd) : (this.hue += hd);
        if (this.hue < 0 || this.hue >= 360) {
            this.hue = (this.hue % 360 + 360) % 360;
        }
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.AURAPOINT;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            if (world != null) {
                for (int i = 0; i < 5; ++i) {
                    this.knot.update();
                }
            }
            this.knot.update();
        }
        this.updateColors();
    }

    @Override
    public int getRenderColor() {
        return Color.HSBtoRGB((float)this.hue / 360.0f, this.saturation, 1.0f);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBTTagCompound tag = new NBTTagCompound();
        NBT.func_74782_a("crops", (NBTBase)tag);
        tag = new NBTTagCompound();
        this.hostilePlayers.writeToNBT(tag);
        NBT.func_74782_a("hostile", (NBTBase)tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.hostilePlayers.readFromNBT(NBT.func_74775_l("hostile"));
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("pvp", this.doPVP);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.doPVP = NBT.func_74767_n("pvp");
    }

    public static Collection<TileEntityAuraPoint> getPoints(EntityPlayer ep) {
        Collection<WorldLocation> c = TileEntityLocusPoint.getCache(TileEntityAuraPoint.class, ep);
        ArrayList<TileEntityAuraPoint> ret = new ArrayList<TileEntityAuraPoint>();
        if (c == null || c.isEmpty()) {
            return ret;
        }
        for (WorldLocation loc : c) {
            TileEntity te = loc.getTileEntity();
            if (!(te instanceof TileEntityAuraPoint)) continue;
            ret.add((TileEntityAuraPoint)te);
        }
        return ret;
    }

    public static boolean hasAuraPoints(EntityPlayer ep) {
        return TileEntityAuraPoint.hasAuraPoints(ep.func_110124_au());
    }

    public static boolean hasAuraPoints(UUID uid) {
        if (uid == null) {
            return false;
        }
        Collection<WorldLocation> c = TileEntityLocusPoint.getCache(TileEntityAuraPoint.class, uid);
        return c != null && !c.isEmpty();
    }

    public static boolean isPointWithin(World world, int x, int y, int z, int r) {
        Collection<WorldLocation> c = TileEntityLocusPoint.getCaches(TileEntityAuraPoint.class);
        for (WorldLocation loc : c) {
            if (!(loc.getDistanceTo((double)x, (double)y, (double)z) <= (double)r)) continue;
            return true;
        }
        return false;
    }

    private static class SugarCaneCrop
    implements CropType {
        private SugarCaneCrop() {
        }

        public boolean existsInGame() {
            return true;
        }

        public boolean isRipe(World world, int x, int y, int z) {
            return false;
        }

        public void setHarvested(World world, int x, int y, int z) {
            ++y;
            while (world.func_147439_a(x, y, z) == Blocks.field_150436_aH) {
                world.func_147468_f(x, y, z);
                ++y;
            }
            world.func_72921_c(x, y, z, 0, 3);
        }

        public void makeRipe(World world, int x, int y, int z) {
            world.func_72921_c(x, y, z, 15, 3);
        }

        public int getGrowthState(World world, int x, int y, int z) {
            return world.func_72805_g(x, y, z);
        }

        public boolean isSeedItem(ItemStack is) {
            return false;
        }

        public boolean destroyOnHarvest() {
            return true;
        }

        public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int fortune) {
            return ReikaJavaLibrary.makeListFrom((Object)new ItemStack(Items.field_151120_aE));
        }

        public boolean isCrop(Block id, int meta) {
            return id == Blocks.field_150436_aH;
        }

        public boolean neverDropsSecondSeed() {
            return false;
        }
    }
}

