/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Block.BlockHoverPad;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.Auxiliary.Trackers.KeyWatcher;
import Reika.DragonAPI.Instantiable.CompoundAABB;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.PlayerMap;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityHoverPad
extends TileEntityChromaticBase {
    private static final double ACCELERATION_HORIZONTAL = 0.035;
    private static final double ACCELERATION_VERTICAL = 0.025;
    private static final double MAX_VEL_HORIZ = 0.45;
    private static final double MAX_VEL_VERT = 0.35;
    private CompoundAABB hoverBox;
    private final PlayerMap<Vec3> playerVelocities = new PlayerMap();
    @SideOnly(value=Side.CLIENT)
    private ParticleField playerParticles;
    private int particleBoost = 20;
    private int particleExpiry = 100;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.hoverBox == null) {
            this.hoverBox = this.calculateBox(world, x, y, z);
        }
        if (this.particleBoost > 0) {
            --this.particleBoost;
        }
        HashSet watching = new HashSet(this.playerVelocities.keySet());
        if (this.hasRedstoneSignal()) {
            this.playerVelocities.clear();
            if (world.field_72995_K) {
                this.updateMode(ParticleMode.DISABLED);
            }
        } else {
            ArrayList li = this.hoverBox.getEntitiesWithinAABB(EntityPlayer.class, world);
            for (EntityPlayer ep : li) {
                ParticleMode mode = this.handlePlayer(ep);
                watching.remove(ep.func_110124_au());
                if (!world.field_72995_K) continue;
                this.updateMode(mode);
            }
            for (UUID uid : watching) {
                this.playerVelocities.directRemove(uid);
            }
        }
        if (world.field_72995_K) {
            this.spawnParticles(world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z) {
        if (this.playerVelocities.isEmpty()) {
            if (this.particleExpiry > 0) {
                --this.particleExpiry;
            } else {
                this.playerParticles = null;
            }
        } else {
            this.particleExpiry = 100;
        }
        if (this.playerParticles != null) {
            this.playerParticles.doParticles(world, x, y, z, this);
        }
    }

    private ParticleMode handlePlayer(EntityPlayer ep) {
        ParticleMode ret = ParticleMode.HOVER;
        if (ep.field_70122_E) {
            this.playerVelocities.remove(ep);
            return ret;
        }
        ep.field_70143_R = 0.0f;
        Vec3 v = (Vec3)this.playerVelocities.get(ep);
        if (v == null) {
            v = Vec3.func_72443_a((double)ep.field_70159_w, (double)(ep.field_70181_x * 0.0), (double)ep.field_70179_y);
            this.playerVelocities.put(ep, (Object)v);
        }
        if (KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.LCTRL)) {
            v.field_72450_a *= 0.86;
            v.field_72448_b *= 0.86;
            v.field_72449_c *= 0.86;
        } else {
            Vec3 look;
            if (KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.JUMP)) {
                v.field_72448_b += 0.025;
                ret = ParticleMode.RISE;
            }
            if (KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.SNEAK)) {
                v.field_72448_b -= 0.025;
                ret = ParticleMode.FALL;
            }
            if (KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.FORWARD)) {
                look = ep.func_70040_Z();
                v.field_72450_a += 0.035 * look.field_72450_a;
                v.field_72449_c += 0.035 * look.field_72449_c;
                ret = ParticleMode.MOVE;
            }
            if (KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.BACK)) {
                look = ep.func_70040_Z();
                v.field_72450_a -= 0.035 * look.field_72450_a;
                v.field_72449_c -= 0.035 * look.field_72449_c;
                ret = ParticleMode.MOVE;
            }
            if (KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.LEFT)) {
                look = ep.func_70040_Z();
                look = ReikaVectorHelper.rotateVector((Vec3)look, (double)0.0, (double)-90.0, (double)0.0);
                v.field_72450_a += 0.035 * look.field_72450_a;
                v.field_72449_c += 0.035 * look.field_72449_c;
                ret = ParticleMode.MOVE;
            }
            if (KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.RIGHT)) {
                look = ep.func_70040_Z();
                look = ReikaVectorHelper.rotateVector((Vec3)look, (double)0.0, (double)90.0, (double)0.0);
                v.field_72450_a += 0.035 * look.field_72450_a;
                v.field_72449_c += 0.035 * look.field_72449_c;
                ret = ParticleMode.MOVE;
            }
        }
        v.field_72450_a = MathHelper.func_151237_a((double)v.field_72450_a, (double)-0.45, (double)0.45);
        v.field_72448_b = MathHelper.func_151237_a((double)v.field_72448_b, (double)-0.35, (double)0.35);
        v.field_72449_c = MathHelper.func_151237_a((double)v.field_72449_c, (double)-0.45, (double)0.45);
        if (ret == ParticleMode.HOVER) {
            if (v.field_72448_b < -0.025) {
                ret = ParticleMode.FALL;
            } else if (v.field_72448_b > 0.025) {
                ret = ParticleMode.RISE;
            } else if (ReikaMathLibrary.py3d((double)v.field_72450_a, (double)0.0, (double)v.field_72449_c) > 0.025) {
                ret = ParticleMode.MOVE;
            }
        }
        ep.field_70159_w = v.field_72450_a;
        ep.field_70181_x = v.field_72448_b;
        ep.field_70179_y = v.field_72449_c;
        ep.field_70133_I = true;
        return ret;
    }

    protected void onFirstTick(World world, int x, int y, int z) {
    }

    public void clearBox() {
        this.hoverBox = this.calculateBox(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.particleBoost = 20;
        if (this.field_145850_b.field_72995_K && this.playerParticles != null) {
            this.playerParticles.initParticleVectors(this);
        }
        if (!this.field_145850_b.field_72995_K) {
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.CLEARHOVERBOX.ordinal(), (TileEntity)this, (int)192, (int[])new int[0]);
        }
    }

    private CompoundAABB calculateBox(World world, int x, int y, int z) {
        BlockArray b = new BlockArray();
        HashSet<BlockKey> ids = new HashSet<BlockKey>();
        ids.add(new BlockKey(ChromaBlocks.PAD.getBlockInstance(), 0));
        ids.add(new BlockKey(this.getTile().getBlock(), this.getTile().getBlockMetadata()));
        b.recursiveAddMultipleWithBounds((IBlockAccess)world, x, y, z, ids, x - 32, y, z - 32, x + 32, y, z + 32);
        HashSet set = new HashSet(b.keySet());
        for (Coordinate c : set) {
            Block bk;
            Block b1 = c.getBlock((IBlockAccess)world);
            if (b1 == ChromaBlocks.PAD.getBlockInstance()) {
                BlockHoverPad.HoverPadAuxTile te = (BlockHoverPad.HoverPadAuxTile)c.getTileEntity((IBlockAccess)world);
                te.setTile(this);
            }
            for (int i = 1; i < 24 && (bk = world.func_147439_a(c.xCoord, c.yCoord + i, c.zCoord)).func_149668_a(world, c.xCoord, c.yCoord, c.zCoord) == null; ++i) {
                b.addBlockCoordinate(c.xCoord, c.yCoord + i, c.zCoord);
            }
        }
        return new CompoundAABB(b);
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.HOVERPAD;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @SideOnly(value=Side.CLIENT)
    private void updateMode(ParticleMode to) {
        ParticleMode prev;
        ParticleMode particleMode = prev = this.playerParticles != null ? this.playerParticles.mode : null;
        if (prev != to) {
            this.playerParticles = new ParticleField(to);
            this.playerParticles.initParticleVectors(this);
        }
    }

    private static class ParticleField {
        private final ParticleMode mode;
        private double[] particleX;
        private double[] particleY;
        private double[] particleZ;

        private ParticleField(ParticleMode m) {
            this.mode = m;
        }

        private void initParticleVectors(TileEntityHoverPad te) {
            this.particleX = new double[this.mode.getParticleRate(te)];
            this.particleY = new double[this.mode.getParticleRate(te)];
            this.particleZ = new double[this.mode.getParticleRate(te)];
            this.randomizeParticleLocations(te);
        }

        private void randomizeParticleLocations(TileEntityHoverPad te) {
            for (int i = 0; i < this.particleX.length; ++i) {
                AxisAlignedBB box = te.hoverBox.getRandomComponentBox(true);
                this.particleX[i] = ReikaRandomHelper.getRandomBetween((double)box.field_72340_a, (double)box.field_72336_d);
                this.particleY[i] = ReikaRandomHelper.getRandomBetween((double)box.field_72338_b, (double)box.field_72337_e);
                this.particleZ[i] = ReikaRandomHelper.getRandomBetween((double)box.field_72339_c, (double)box.field_72334_f);
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void doParticles(World world, int x, int y, int z, TileEntityHoverPad te) {
            int n = this.mode.getParticleRate(te);
            for (int i = 0; i < n; ++i) {
                if ((te.getTicksExisted() + i * this.mode.particleModulo / n) % this.mode.particleModulo == 0) {
                    AxisAlignedBB box = te.hoverBox.getRandomComponentBox(true);
                    this.particleX[i] = ReikaRandomHelper.getRandomBetween((double)box.field_72340_a, (double)box.field_72336_d);
                    this.particleY[i] = ReikaRandomHelper.getRandomBetween((double)box.field_72338_b, (double)box.field_72337_e);
                    this.particleZ[i] = ReikaRandomHelper.getRandomBetween((double)box.field_72339_c, (double)box.field_72334_f);
                }
                float s = 1.5f;
                int l = 25;
                float g = 0.0f;
                int c = this.mode.particleColor;
                double v = -this.mode.particleGravity * 2.0f;
                double vx = 0.0;
                double vz = 0.0;
                if (this.mode == ParticleMode.MOVE) {
                    double dv = 0.05;
                    EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
                    double dd = ReikaMathLibrary.py3d((double)ep.field_70159_w, (double)0.0, (double)ep.field_70179_y);
                    vx = ep.field_70159_w / dd * dv;
                    vz = ep.field_70179_y / dd * dv;
                }
                if (this.mode == ParticleMode.DISABLED) {
                    l = (int)((double)l * 0.4);
                    s = (float)((double)s * 0.8);
                }
                EntityCCBlurFX fx = new EntityCCBlurFX(world, this.particleX[i], this.particleY[i], this.particleZ[i], vx, v, vz);
                fx.setIcon(ChromaIcons.FADE_GENTLE).setGravity(g).setColor(c).setLife(l).setScale(s);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    private static enum ParticleMode {
        HOVER(0xFFFF00, 0.0f, 2, 1),
        RISE(65280, -0.0625f, 8, 4),
        FALL(0xFF0000, 0.0625f, 8, 4),
        MOVE(0x22AAFF, 0.0f, 5, 2),
        DISABLED(0xBABABA, 0.0f, 2, 1);

        public final int particleColor;
        public final float particleGravity;
        public final int particleModulo;
        public final int particleCount;
        private static final ParticleMode[] list;

        private ParticleMode(int c, float g, int m, int n2) {
            this.particleColor = c;
            this.particleGravity = g;
            this.particleModulo = m;
            this.particleCount = n2;
        }

        private int getParticleRate(TileEntityHoverPad te) {
            int base = this.particleCount;
            base = (int)((double)base * (4.0 * Math.sqrt(te.hoverBox.getVolume() / 480.0)));
            return Math.max(1, base);
        }

        static {
            list = ParticleMode.values();
        }
    }
}

