/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE;

import Reika.ChromatiCraft.API.Interfaces.RangeUpgradeable;
import Reika.ChromatiCraft.Auxiliary.ChromaAux;
import Reika.ChromatiCraft.Auxiliary.Interfaces.NBTTile;
import Reika.ChromatiCraft.Auxiliary.RangeTracker;
import Reika.ChromatiCraft.Base.ItemWithItemFilter;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedRelayPowered;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.ThreadSafeTileCache;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.LocationCached;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.ModInteract.ReikaXPFluidHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityItemCollector
extends InventoriedRelayPowered
implements NBTTile,
LocationCached,
IFluidHandler,
RangeUpgradeable {
    private int experience = 0;
    public boolean canIntake = false;
    public static final int MAXRANGE = 24;
    private final RangeTracker.ConfigurableRangeTracker range = new RangeTracker.ConfigurableRangeTracker(24, 24, 1);
    private ItemWithItemFilter.Filter[] filter = new ItemWithItemFilter.Filter[45];
    private final StepTimer scanTimer = new StepTimer(200);
    private static final ElementTagCompound required = new ElementTagCompound();
    private static final ThreadSafeTileCache cache = new ThreadSafeTileCache().setTileClass(TileEntityItemCollector.class);
    public static boolean haltCollection = false;

    @Override
    public ElementTagCompound getRequiredEnergy() {
        return required.copy();
    }

    public int getExperience() {
        return this.experience;
    }

    public int getMaxFilterCount() {
        int adj = TileEntityAdjacencyUpgrade.getAdjacentUpgrade(this, CrystalElement.PURPLE);
        if (adj <= 0) {
            return 9;
        }
        return Math.min(this.filter.length, 9 + 9 * adj / 2);
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return true;
    }

    public int func_70302_i_() {
        return 27;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return false;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.ITEMCOLLECTOR;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        this.range.update(this);
        if (this.canIntake && !world.field_72995_K) {
            this.scanTimer.update();
            if (this.scanTimer.checkCap()) {
                this.doScan(world, x, y, z);
            }
        }
    }

    private void doScan(World world, int x, int y, int z) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(x - this.getRange()), (double)(y - this.getYRange()), (double)(z - this.getRange()), (double)(x + this.getRange() + 1), (double)(y + this.getYRange() + 1), (double)(z + this.getRange() + 1));
        List li = world.func_82733_a(Entity.class, box, ReikaEntityHelper.itemOrXPSelector);
        for (Entity e : li) {
            if (!this.checkAbsorb(e)) continue;
            e.func_70106_y();
        }
    }

    private int getYRange() {
        return Math.max(Math.min(4, this.getRange()), this.getRange() / 4);
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        WorldLocation loc = new WorldLocation((TileEntity)this);
        if (!cache.contains((Object)loc)) {
            cache.add((Object)loc);
        }
        this.canIntake = true;
        this.range.initialize(this);
    }

    public void breakBlock() {
        WorldLocation loc = new WorldLocation((TileEntity)this);
        cache.remove((Object)loc);
    }

    public static boolean absorbItem(World world, Entity e) {
        if (haltCollection) {
            return false;
        }
        return cache.lookForMatch(world, true, (loc, te) -> ((TileEntityItemCollector)te).checkAbsorb(e), (loc, te) -> ChromaAux.logTileCacheError(world, loc, te, ChromaTiles.ITEMCOLLECTOR));
    }

    public boolean checkAbsorb(Entity e) {
        if (e.field_70128_L) {
            return false;
        }
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        if (!this.isInWorld()) {
            return false;
        }
        if (!this.canIntake) {
            return false;
        }
        if (e.field_70170_p.field_73011_w.field_76574_g != this.field_145850_b.field_73011_w.field_76574_g) {
            return false;
        }
        if (this.hasRedstoneSignal()) {
            return false;
        }
        if (!this.energy.containsAtLeast(required)) {
            return false;
        }
        if ((e instanceof EntityItem || e instanceof EntityXPOrb) && Math.abs(e.field_70165_t - (double)x - 0.5) <= (double)this.getRange() && Math.abs(e.field_70163_u - (double)y - 0.5) <= (double)this.getYRange() && Math.abs(e.field_70161_v - (double)z - 0.5) <= (double)this.getRange()) {
            if (e instanceof EntityItem) {
                EntityItem ei = (EntityItem)e;
                if (this.canAbsorbItem(ei)) {
                    return this.absorbItem(this.field_145850_b, x, y, z, ei);
                }
            } else {
                this.absorbXP(this.field_145850_b, x, y, z, (EntityXPOrb)e);
                this.drainEnergy(required);
                return true;
            }
        }
        return false;
    }

    private boolean canAbsorbItem(EntityItem ei) {
        if (ei.getEntityData().func_74767_n("item_inserter_dropped")) {
            return false;
        }
        ItemStack is = ei.func_92059_d();
        for (int i = 0; i < this.getMaxFilterCount(); ++i) {
            if (this.filter[i] == null || !this.filter[i].match(is)) continue;
            return true;
        }
        return false;
    }

    private boolean match(ItemStack is, ItemStack filter) {
        if (ChromaItems.SEED.matchWith(is)) {
            return ChromaItems.SEED.matchWith(filter) && is.func_77960_j() % 16 == filter.func_77960_j() % 16;
        }
        return ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)filter) && ItemStack.func_77970_a((ItemStack)is, (ItemStack)filter);
    }

    private boolean absorbItem(World world, int x, int y, int z, EntityItem ent) {
        ItemStack is = ent.func_92059_d();
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            TileEntity te = this.getAdjacentTileEntity(dir);
            if (!(te instanceof IInventory) || !ReikaInventoryHelper.addToIInv((ItemStack)is, (IInventory)((IInventory)te))) continue;
            return true;
        }
        int targetslot = this.checkForStack(is);
        if (targetslot != -1) {
            if (this.inv[targetslot] == null) {
                this.inv[targetslot] = is.func_77946_l();
            } else {
                this.inv[targetslot].field_77994_a += is.field_77994_a;
            }
        } else {
            return false;
        }
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.pop", 0.1f + 0.5f * rand.nextFloat(), rand.nextFloat());
        ent.func_85030_a("random.pop", 0.5f, 2.0f);
        this.drainEnergy(required);
        return true;
    }

    private void absorbXP(World world, int x, int y, int z, EntityXPOrb xp) {
        int val = xp.func_70526_d();
        this.experience += val;
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.orb", 0.1f, 0.5f * ((rand.nextFloat() - rand.nextFloat()) * 0.7f + 1.8f));
        xp.func_85030_a("random.pop", 0.5f, 2.0f);
    }

    private int checkForStack(ItemStack is) {
        int target = -1;
        Item id = is.func_77973_b();
        int meta = is.func_77960_j();
        int size = is.field_77994_a;
        int firstempty = -1;
        for (int k = 0; k < this.inv.length; ++k) {
            if (this.inv[k] != null) continue;
            firstempty = k;
            k = this.inv.length;
        }
        for (int j = 0; j < this.inv.length; ++j) {
            if (this.inv[j] == null || !ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)this.inv[j]) || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)this.inv[j])) continue;
            if (this.inv[j].field_77994_a + size <= this.func_70297_j_()) {
                target = j;
                j = this.inv.length;
                continue;
            }
            int diff = is.func_77976_d() - this.inv[j].field_77994_a;
            this.inv[j].field_77994_a += diff;
            is.field_77994_a -= diff;
        }
        if (target == -1) {
            target = firstempty;
        }
        return target;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.experience = NBT.func_74762_e("xp");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("xp", this.experience);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        this.saveFilters(NBT);
        this.range.writeToNBT(NBT);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.readFilters(NBT);
        this.range.readFromNBT(NBT);
    }

    private void saveFilters(NBTTagCompound NBT) {
        NBTTagCompound fil = new NBTTagCompound();
        for (int i = 0; i < this.filter.length; ++i) {
            ItemWithItemFilter.Filter is = this.filter[i];
            if (is == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            is.writeToNBT(tag);
            fil.func_74782_a("filter_" + i, (NBTBase)tag);
        }
        NBT.func_74782_a("filter", (NBTBase)fil);
    }

    private void readFilters(NBTTagCompound NBT) {
        this.filter = new ItemWithItemFilter.Filter[this.filter.length];
        NBTTagCompound fil = NBT.func_74775_l("filter");
        for (int i = 0; i < this.filter.length; ++i) {
            String name = "filter_" + i;
            if (!fil.func_74764_b(name)) continue;
            NBTTagCompound tag = fil.func_74775_l(name);
            if (tag.func_74764_b("filterType")) {
                this.filter[i] = new ItemWithItemFilter.Filter();
                this.filter[i].readFromNBT(tag);
                continue;
            }
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)tag);
            this.filter[i] = is != null ? new ItemWithItemFilter.Filter(is) : null;
        }
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        this.saveFilters(NBT);
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        if (is.field_77990_d == null) {
            return;
        }
        this.readFilters(is.field_77990_d);
    }

    @Override
    public boolean isAcceptingColor(CrystalElement e) {
        return required.contains(e);
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 48000;
    }

    @Override
    protected boolean canReceiveFrom(CrystalElement e, ForgeDirection dir) {
        return true;
    }

    public void setMapping(int slot, ItemStack is) {
        if (slot >= this.getMaxFilterCount()) {
            return;
        }
        this.filter[slot] = is == null ? null : new ItemWithItemFilter.Filter(is);
        this.syncAllData(true);
    }

    public void toggleNBT(int slot) {
        if (slot >= this.getMaxFilterCount() || this.filter[slot] == null) {
            return;
        }
        this.filter[slot].toggleNBT();
        this.syncAllData(true);
    }

    public ItemStack getMapping(int slot) {
        return this.filter[slot] != null ? this.filter[slot].getDisplay() : null;
    }

    public boolean hasNBT(int slot) {
        return this.filter[slot] != null && this.filter[slot].hasNBT();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return resource.getFluidID() == ReikaXPFluidHelper.getFluid().getFluidID() ? this.drain(from, resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack fs;
        FluidStack fluidStack = fs = this.experience > 0 ? ReikaXPFluidHelper.getFluid((int)this.experience) : null;
        if (fs != null) {
            if (fs.amount > maxDrain) {
                fs.amount = maxDrain;
            }
            if (doDrain) {
                this.experience -= ReikaXPFluidHelper.getXPForAmount((int)fs.amount);
            }
        }
        return fs;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return ReikaXPFluidHelper.fluidsExist() && this.experience > 0 && fluid.equals(ReikaXPFluidHelper.getFluidType());
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[0];
    }

    public void decreaseRange(int amt) {
        if (this.range.decrement(this, amt)) {
            this.syncAllData(false);
        }
    }

    public void increaseRange(int amt) {
        if (this.range.increment(this, amt)) {
            this.syncAllData(false);
        }
    }

    @Override
    public int getRange() {
        return this.range.getRange();
    }

    public static void clearCache() {
        cache.clear();
    }

    @Override
    public void upgradeRange(double r) {
    }

    static {
        required.addTag(CrystalElement.LIME, 25);
        required.addTag(CrystalElement.BLACK, 5);
    }
}

