/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE;

import Reika.ChromatiCraft.Auxiliary.Interfaces.LinkerCallback;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedChromaticBase;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.ItemElementCalculator;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCFloatingSeedsFX;
import Reika.ChromatiCraft.TileEntity.AOE.TileEntityItemCollector;
import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.World.ReikaRedstoneHelper;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.item.ItemTossEvent;

public class TileEntityItemInserter
extends InventoriedChromaticBase
implements LinkerCallback {
    public static final String DROP_TAG = "item_inserter_dropped";
    private final Coordinate[] targets = new Coordinate[this.func_70302_i_()];
    private final HashMap<Coordinate, InsertionType> locations = new HashMap();
    private final ItemHashMap<ArrayList<Coordinate>> routing = new ItemHashMap();
    private boolean[][] connections = new boolean[6][6];
    private int maxCoord = 0;
    public boolean omniMode = false;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        Coordinate c;
        if (world.field_72995_K) {
            return;
        }
        int slot = this.getTicksExisted() % this.func_70302_i_();
        if (this.inv[slot] != null && (this.omniMode || this.inv[slot].field_77994_a > 1) && !ReikaRedstoneHelper.isPoweredOnSide((World)world, (int)x, (int)y, (int)z, (ForgeDirection)this.dirs[slot]) && (c = this.sendItem(slot)) != null) {
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.INSERTERACTION.ordinal(), (TileEntity)this, (int)64, (int[])new int[]{Item.func_150891_b((Item)this.inv[slot].func_77973_b()), this.inv[slot].func_77960_j(), c.xCoord, c.yCoord, c.zCoord});
            ReikaInventoryHelper.decrStack((int)slot, (ItemStack[])this.inv);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void sendItemClientside(int id, int meta, int x, int y, int z) {
        ItemStack is = new ItemStack(Item.func_150899_d((int)id), 1, meta);
        double dx = x - this.field_145851_c;
        double dy = y - this.field_145848_d;
        double dz = z - this.field_145849_e;
        double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
        double v = 0.125;
        double vx = v * dx / dd;
        double vy = v * dy / dd;
        double vz = v * dz / dd;
        double[] angs = ReikaPhysicsHelper.cartesianToPolar((double)dx, (double)dy, (double)dz);
        int n = 6 + rand.nextInt(16);
        ElementTagCompound tag = ItemElementCalculator.instance.getValueForItem(is);
        for (int i = 0; i < n; ++i) {
            double px = (double)this.field_145851_c + rand.nextDouble();
            double py = (double)this.field_145848_d + rand.nextDouble();
            double pz = (double)this.field_145849_e + rand.nextDouble();
            EntityCCFloatingSeedsFX fx = new EntityCCFloatingSeedsFX(this.field_145850_b, px, py, pz, -angs[2] + 270.0, angs[1] - 90.0, ChromaIcons.CENTER);
            fx.angleVelocity = 2.5;
            fx.particleVelocity = v;
            fx.freedom = 10.0;
            int c = tag == null || tag.isEmpty() ? 0x22AAFF : ((CrystalElement)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, tag.elementSet())).getColor();
            AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72314_b(dx, dy, dz);
            fx.setColor(c).setLife(100).setScale(2.5f).markDestination(x, y, z).setNoSlowdown().bound(box, false, false);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.rebuildCache();
    }

    @Override
    protected void onPreSlotSet(int slot, ItemStack is) {
        if (!this.omniMode && !ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)this.inv[slot])) {
            for (int i = 0; i < 6; ++i) {
                this.connections[slot][i] = false;
            }
        }
    }

    @Override
    protected void onSlotSet(int slot, ItemStack is) {
        this.rebuildCache();
    }

    private void rebuildCache() {
        this.routing.clear();
        for (int i = 0; i < this.targets.length; ++i) {
            ItemStack is = this.inv[i];
            if (is == null) continue;
            ArrayList<Coordinate> li = (ArrayList<Coordinate>)this.routing.get(is);
            if (li == null) {
                li = new ArrayList<Coordinate>();
                this.routing.put(is, li);
            }
            for (int k = 0; k < this.targets.length; ++k) {
                Coordinate c = this.targets[k];
                if (c == null || !this.isLinkEnabled(i, k)) continue;
                li.add(c);
            }
        }
        this.syncAllData(false);
        ReikaPacketHelper.sendDataPacketWithRadius((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.GUIRELOAD.ordinal(), (TileEntity)this, (int)12, (int[])new int[0]);
    }

    public boolean isLinkEnabled(int i, int k) {
        return this.connections[i][k];
    }

    public void toggleConnection(int i, int k) {
        this.connections[i][k] = !this.connections[i][k];
        this.rebuildCache();
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.INSERTER;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public void linkTo(World world, int x, int y, int z) {
        if (world.field_73011_w.field_76574_g == this.field_145850_b.field_73011_w.field_76574_g && this.isLinkable(world, x, y, z)) {
            this.addCoordinate(x, y, z);
        }
    }

    private boolean isLinkable(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null) {
            return true;
        }
        String c = te.getClass().getName().toLowerCase(Locale.ENGLISH);
        if (c.endsWith("manualkineticgenerator")) {
            return false;
        }
        if (c.endsWith("engineclockwork") && c.contains("forestry")) {
            return false;
        }
        return !c.endsWith("crank") || !c.contains("appeng");
    }

    private void addCoordinate(int x, int y, int z) {
        if (this.maxCoord >= this.inv.length) {
            return;
        }
        Coordinate c = new Coordinate(x, y, z);
        if (this.locations.containsKey(c)) {
            return;
        }
        this.locations.put(c, InsertionType.INVENTORY);
        this.targets[this.maxCoord] = c;
        ++this.maxCoord;
        this.rebuildCache();
    }

    public void removeCoordinate(int slot) {
        Coordinate c = this.targets[slot];
        if (c != null) {
            this.targets[slot] = null;
            this.locations.remove(c);
            if (this.inv[slot] != null) {
                ((ArrayList)this.routing.get(this.inv[slot])).remove(c);
            }
        }
        for (int i = 0; i < 6; ++i) {
            this.connections[i][slot] = false;
        }
        this.maxCoord = slot;
        this.rebuildCache();
    }

    public InsertionType getInsertionType(int slot) {
        Coordinate c = this.targets[slot];
        return c != null ? this.locations.get(c) : null;
    }

    public Coordinate getLink(int slot) {
        return this.targets[slot];
    }

    public void setInsertionType(int slot, InsertionType type) {
        Coordinate c = this.targets[slot];
        if (c != null) {
            this.locations.put(c, type);
        }
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return false;
    }

    public int func_70302_i_() {
        return 6;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return this.omniMode ? this.targets[slot] != null : ReikaItemHelper.matchStacks((ItemStack)this.inv[slot], (ItemStack)is);
    }

    private Coordinate sendItem(int slot) {
        Coordinate c;
        ItemStack is = this.inv[slot];
        if (this.omniMode) {
            c = this.isLinkEnabled(slot, slot) ? this.targets[slot] : null;
        } else {
            ArrayList li = (ArrayList)this.routing.get(is);
            if (li == null || li.isEmpty()) {
                return null;
            }
            c = (Coordinate)li.get(rand.nextInt(li.size()));
            while (c.getBlock((IBlockAccess)this.field_145850_b) == Blocks.field_150350_a && !li.isEmpty()) {
                li.remove(c);
                if (!li.isEmpty()) {
                    c = (Coordinate)li.get(rand.nextInt(li.size()));
                    continue;
                }
                c = null;
            }
        }
        return c != null ? (this.locations.get(c).send(this.field_145850_b, c, ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)1), this.getPlacer()) ? c : null) : null;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            Coordinate c = this.targets[i];
            if (c == null) continue;
            c.writeToNBT("loc_" + i, NBT);
        }
        NBTTagList li = new NBTTagList();
        for (Coordinate c : this.locations.keySet()) {
            InsertionType type = this.locations.get(c);
            NBTTagCompound tag = new NBTTagCompound();
            c.writeToNBT("loc", tag);
            tag.func_74768_a("type", type.ordinal());
            li.func_74742_a((NBTBase)tag);
        }
        NBT.func_74782_a("locs", (NBTBase)li);
        for (int i = 0; i < 6; ++i) {
            byte n = ReikaArrayHelper.booleanToByteBitflags((boolean[])this.connections[i]);
            NBT.func_74774_a("conn_" + i, n);
        }
        NBT.func_74768_a("maxc", this.maxCoord);
        NBT.func_74757_a("uselast", this.omniMode);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.targets[i] = NBT.func_74764_b("loc_" + i) ? Coordinate.readFromNBT((String)("loc_" + i), (NBTTagCompound)NBT) : null;
        }
        this.locations.clear();
        NBTTagList li = NBT.func_150295_c("locs", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (NBTTagCompound tag : li.field_74747_a) {
            Coordinate c = Coordinate.readFromNBT((String)"loc", (NBTTagCompound)tag);
            InsertionType type = InsertionType.list[tag.func_74762_e("type")];
            this.locations.put(c, type);
        }
        for (int i = 0; i < 6; ++i) {
            byte n = NBT.func_74771_c("conn_" + i);
            this.connections[i] = ReikaArrayHelper.booleanFromByteBitflags((byte)n, (int)6);
        }
        this.maxCoord = NBT.func_74762_e("maxc");
        this.omniMode = NBT.func_74767_n("uselast");
    }

    public static enum InsertionType {
        INVENTORY("Inventory"),
        RIGHTCLICK("Right-Click"),
        LEFTCLICK("Left-Click"),
        ENTITY("Entity");

        public final String displayName;
        private static final InsertionType[] list;

        private InsertionType(String s) {
            this.displayName = s;
        }

        private boolean send(World world, Coordinate c, ItemStack is, EntityPlayer ep) {
            switch (this) {
                case INVENTORY: {
                    TileEntity te = c.getTileEntity((IBlockAccess)world);
                    if (te instanceof IInventory) {
                        return ReikaInventoryHelper.addToIInv((ItemStack)is, (IInventory)((IInventory)te));
                    }
                    return false;
                }
                case RIGHTCLICK: {
                    int orig = is.field_77994_a;
                    ItemStack hold = ep.func_71045_bC();
                    ep.func_70062_b(0, is);
                    boolean flag = c.getBlock((IBlockAccess)world).func_149727_a(world, c.xCoord, c.yCoord, c.zCoord, ep, 1, 0.0f, 0.0f, 0.0f);
                    ItemStack ret = ep.func_71045_bC();
                    ep.func_70062_b(0, hold);
                    return ret == null || ret.field_77994_a < orig;
                }
                case LEFTCLICK: {
                    ItemStack hold = ep.func_71045_bC();
                    int orig = is.field_77994_a;
                    ep.func_70062_b(0, is);
                    c.getBlock((IBlockAccess)world).func_149699_a(world, c.xCoord, c.yCoord, c.zCoord, ep);
                    ItemStack ret = ep.func_71045_bC();
                    ep.func_70062_b(0, hold);
                    return ret == null || ret.field_77994_a < orig;
                }
                case ENTITY: {
                    TileEntityItemCollector.haltCollection = true;
                    EntityItem ei = ReikaItemHelper.dropItem((World)world, (double)((double)c.xCoord + 0.5), (double)((double)c.yCoord + c.getBlock((IBlockAccess)world).func_149669_A() + 0.125), (double)((double)c.zCoord + 0.5), (ItemStack)is);
                    ei.field_70179_y = 0.0;
                    ei.field_70181_x = 0.0;
                    ei.field_70159_w = 0.0;
                    ei.field_145804_b = 0;
                    ei.lifespan = Integer.MAX_VALUE;
                    ei.getEntityData().func_74757_a(TileEntityItemInserter.DROP_TAG, true);
                    MinecraftForge.EVENT_BUS.post((Event)new ItemTossEvent(ei, ep));
                    TileEntityItemCollector.haltCollection = false;
                    return true;
                }
            }
            return false;
        }

        public InsertionType next() {
            return this.ordinal() != list.length - 1 ? list[this.ordinal() + 1] : list[0];
        }

        static {
            list = InsertionType.values();
        }
    }
}

