/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.AOE;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Block.Decoration.BlockRangedLamp;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityRangeBoost;
import Reika.DragonAPI.Instantiable.Data.Collections.ThreadSafeSet;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Interfaces.TileEntity.LocationCached;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.ModRegistry.PowerTypes;
import Reika.RotaryCraft.API.Power.PowerTransferHelper;
import Reika.RotaryCraft.API.Power.SimpleShaftPowerReceiver;
import cofh.api.energy.IEnergyHandler;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLampController
extends TileEntityChromaticBase
implements LocationCached,
GuiController,
SimpleShaftPowerReceiver {
    private static final MultiMap<Integer, LightSource> map = new MultiMap(MultiMap.CollectionType.CONCURRENTSET, (MultiMap.MapDeterminator)new MultiMap.ConcurrencyDeterminator());
    private static final MultiMap<Integer, WorldLocation> lights = new MultiMap(MultiMap.CollectionType.CONCURRENTSET, (MultiMap.MapDeterminator)new MultiMap.ConcurrencyDeterminator());
    public static final int MAXRANGE = 64;
    public static final int MAXCHANNEL = 999;
    private int channel = 0;
    private Control control = Control.MANUAL;
    private boolean active = false;
    private boolean shaftpower;

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.LAMPCONTROL;
    }

    public boolean isActive() {
        return this.active;
    }

    public int getChannel() {
        return this.channel;
    }

    public Control getControlType() {
        return this.control;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.control = Control.list[NBT.func_74762_e("control")];
        this.channel = NBT.func_74762_e("channel");
        this.active = NBT.func_74767_n("active");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("control", this.control.ordinal());
        NBT.func_74768_a("channel", this.channel);
        NBT.func_74757_a("active", this.active);
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K) {
            boolean changed = false;
            boolean on = this.active;
            switch (this.control) {
                case REDSTONE: {
                    on = this.hasRedstoneSignal();
                    break;
                }
                case MANUAL: {
                    break;
                }
                case RFSTORAGE: {
                    on = this.hasAdjacentRF();
                    break;
                }
                case SHAFTPOWER: {
                    this.shaftpower &= PowerTransferHelper.checkPowerFromAllSides((TileEntity)this, (boolean)true);
                    on = this.shaftpower;
                }
            }
            if (on != this.active) {
                changed = true;
            }
            this.active = on;
            if (changed) {
                TileEntityLampController.updateLightAt(this);
            }
        }
    }

    private boolean hasAdjacentRF() {
        if (!PowerTypes.RF.isLoaded()) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            TileEntity te = this.getAdjacentTileEntity(dir);
            if (!(te instanceof IEnergyHandler) || ((IEnergyHandler)te).getEnergyStored(dir.getOpposite()) <= 0) continue;
            return true;
        }
        return false;
    }

    public void onFirstTick(World world, int x, int y, int z) {
        for (int i = -this.getRange(); i <= this.getRange(); ++i) {
            for (int j = -this.getRange(); j <= this.getRange(); ++j) {
                for (int k = -this.getRange(); k <= this.getRange(); ++k) {
                    int dx = x + i;
                    int dy = y + j;
                    int dz = z + k;
                    if (world.func_147439_a(dx, dy, dz) != ChromaBlocks.LAMPBLOCK.getBlockInstance()) continue;
                    TileEntityLampController.addLight((BlockRangedLamp.TileEntityRangedLamp)world.func_147438_o(dx, dy, dz));
                }
            }
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public void setChannel(int ch) {
        if (ch < 0) {
            return;
        }
        TileEntityLampController.removeSource(this);
        this.channel = ch;
        TileEntityLampController.addSource(this);
    }

    public void breakBlock() {
        TileEntityLampController.removeSource(this);
    }

    public void incrementMode() {
        this.control = this.control.next();
    }

    public void toggleState() {
        this.active = !this.active;
        TileEntityLampController.updateLightAt(this);
    }

    private static void addSource(TileEntityLampController te) {
        LightSource ls = new LightSource(te);
        map.addValue((Object)te.channel, (Object)ls);
        TileEntityLampController.onLightsChanged(te.channel);
    }

    private static void removeSource(TileEntityLampController te) {
        LightSource ls = new LightSource(te);
        map.remove((Object)te.channel, (Object)ls);
        TileEntityLampController.onLightsChanged(te.channel);
    }

    public static void addLight(BlockRangedLamp.TileEntityRangedLamp te) {
        lights.addValue((Object)te.getChannel(), (Object)new WorldLocation((TileEntity)te));
    }

    public static void removeLight(BlockRangedLamp.TileEntityRangedLamp te) {
        lights.remove((Object)te.getChannel(), (Object)new WorldLocation((TileEntity)te));
    }

    private static void onLightsChanged(int channel) {
        ThreadSafeSet c = (ThreadSafeSet)lights.get((Object)channel);
        c.simpleIterate(loc -> {
            BlockRangedLamp.TileEntityRangedLamp te = (BlockRangedLamp.TileEntityRangedLamp)loc.getTileEntity();
            te.setLit(TileEntityLampController.activeSourceInRange(te));
        });
    }

    private static void updateLightAt(TileEntityLampController te) {
        LightSource ls = new LightSource(te);
        map.remove((Object)te.channel, (Object)ls);
        map.addValue((Object)te.channel, (Object)ls);
        TileEntityLampController.onLightsChanged(te.channel);
    }

    public static boolean activeSourceInRange(BlockRangedLamp.TileEntityRangedLamp te) {
        ThreadSafeSet c = (ThreadSafeSet)map.get((Object)te.getChannel());
        WorldLocation loc = new WorldLocation((TileEntity)te);
        boolean ret = (Boolean)c.iterate(it -> {
            while (it.hasNext()) {
                LightSource l = (LightSource)it.next();
                if (!l.isActive || !(l.location.getDistanceTo(loc) <= (double)l.range)) continue;
                return true;
            }
            return false;
        });
        return ret;
    }

    private int getRange() {
        double fac;
        int base = 64;
        int lvl = TileEntityAdjacencyUpgrade.getAdjacentUpgrade(this, CrystalElement.LIME);
        double d = fac = lvl > 0 ? TileEntityRangeBoost.getFactor(lvl - 1) : 1.0;
        if (fac > 1.0) {
            base = ReikaMathLibrary.ceilPseudo2Exp((int)((int)((double)base * fac)));
        }
        return base;
    }

    public void setPowered(boolean power) {
        this.shaftpower = power;
    }

    public boolean canReadFrom(ForgeDirection dir) {
        return true;
    }

    public static void clearCache() {
        map.clear();
        lights.clear();
    }

    private static class LightSource {
        public final WorldLocation location;
        public final int range;
        private boolean isActive;

        public LightSource(TileEntityLampController te) {
            this.location = new WorldLocation((TileEntity)te);
            this.range = te.getRange();
            this.isActive = te.isActive();
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof LightSource && ((LightSource)o).location.equals((Object)this.location);
        }
    }

    public static enum Control {
        MANUAL,
        REDSTONE,
        RFSTORAGE,
        SHAFTPOWER;

        private static final Control[] list;

        public Control next() {
            Control c = list[(this.ordinal() + 1) % list.length];
            while (!c.isValid()) {
                c = list[(c.ordinal() + 1) % list.length];
            }
            return c;
        }

        private boolean isValid() {
            switch (this) {
                case RFSTORAGE: {
                    return PowerTypes.RF.isLoaded();
                }
                case SHAFTPOWER: {
                    return PowerTypes.ROTARYCRAFT.isLoaded();
                }
            }
            return true;
        }

        static {
            list = Control.values();
        }
    }
}

