/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Acquisition;

import Reika.ChromatiCraft.Auxiliary.Interfaces.ChromaExtractable;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Base.TileEntity.FluidIOInventoryBase;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityRuneFX;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.ModInteract.ReikaXPFluidHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityCollector
extends FluidIOInventoryBase
implements OwnedTile,
ChromaExtractable {
    public static final int XP_PER_CHROMA = 1;
    private static final int XP_PER_BOTTLE = 300;

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.COLLECTOR;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        int speed;
        int produce;
        FluidStack fs;
        if (this.output.canTakeIn(300)) {
            this.internalizeXP();
        }
        if (!this.input.isEmpty() && !this.hasRedstoneSignal() && (fs = ReikaXPFluidHelper.getFluid()) != null && (produce = Math.min(speed = this.getConversionSpeed(), this.input.getLevel() / fs.amount / 1)) > 0 && this.output.canTakeIn(produce)) {
            this.input.removeLiquid(1 * speed * fs.amount);
            this.output.addLiquid(produce, FluidRegistry.getFluid((String)"chroma"));
        }
        for (EntityPlayer ep : this.getOwners(false)) {
            this.tryIntakeXPFromPlayer(ep, true);
        }
        if (world.field_72995_K && rand.nextInt(4) == 0) {
            this.spawnParticles(world, x, y, z, meta);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z, int meta) {
        double r = 0.75;
        double dx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)r);
        double dy = rand.nextDouble();
        double dz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)r);
        while (ReikaMathLibrary.py3d((double)dx, (double)0.0, (double)dz) < 0.65) {
            dx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)r);
            dz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)r);
        }
        CrystalElement e = CrystalElement.randomElement();
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityRuneFX(world, (double)x + dx + 0.5, (double)y + dy + 0.5, (double)z + dz + 0.5, e));
    }

    private void internalizeXP() {
        if (this.inv[0] != null && this.inv[0].func_77973_b() == Items.field_151062_by && (this.inv[1] == null || this.inv[1].field_77994_a < this.inv[1].func_77976_d())) {
            ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
            this.output.addLiquid(300, FluidRegistry.getFluid((String)"chroma"));
            ReikaInventoryHelper.addOrSetStack((Item)Items.field_151069_bo, (int)1, (int)0, (ItemStack[])this.inv, (int)1);
        }
    }

    private int getConversionSpeed() {
        return 5;
    }

    public void tryIntakeXPFromPlayer(EntityPlayer ep, boolean doAABB) {
        if (this.output.canTakeIn(this.getConversionSpeed())) {
            this.intakeXPFromPlayer(ep, doAABB);
        }
    }

    private void intakeXPFromPlayer(EntityPlayer ep, boolean doAABB) {
        int mult;
        if (ep != null && !(!doAABB ? ReikaPlayerAPI.isFake((EntityPlayer)ep) : ReikaPlayerAPI.isFakeOrNotInteractable((EntityPlayer)ep, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (double)2.0)) && ep.field_71067_cb >= 1 * (mult = this.getConversionSpeed())) {
            int add;
            AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e).func_72317_d(0.0, 1.0, 0.0);
            if ((!doAABB || ep.field_70121_D.func_72326_a(box)) && (add = Math.min(this.output.getRemainingSpace(), mult)) > 0) {
                this.output.addLiquid(add, FluidRegistry.getFluid((String)"chroma"));
                ReikaPlayerAPI.removeExperience((EntityPlayer)ep, (int)(1 * add));
                ProgressStage.MAKECHROMA.stepPlayerTo(ep);
            }
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public int getCapacity() {
        return 3000;
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        if (f.equals(FluidRegistry.getFluid((String)"xp"))) {
            return true;
        }
        if (f.equals(FluidRegistry.getFluid((String)"experience"))) {
            return true;
        }
        if (f.equals(FluidRegistry.getFluid((String)"xpjuice"))) {
            return true;
        }
        return ReikaXPFluidHelper.fluidsExist() && f.equals(ReikaXPFluidHelper.getFluid().getFluid());
    }

    @Override
    public Fluid getInputFluid() {
        return null;
    }

    @Override
    public boolean canOutputTo(ForgeDirection to) {
        return true;
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return true;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 0 && itemstack.func_77973_b() == Items.field_151062_by;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 1;
    }

    public int func_70302_i_() {
        return 2;
    }

    public int getProgressScaled(int i) {
        return 0;
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        this.writeOwnerData(NBT);
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        this.readOwnerData(is);
    }

    @Override
    public int getChromaLevel() {
        return this.output.getLevel();
    }
}

