/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Acquisition;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OperationInterval;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.FabricationRecipes;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedCrystalReceiver;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityAccelerator;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.InertItem;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityItemFabricator
extends InventoriedCrystalReceiver
implements OperationInterval {
    public int progress = 0;
    private Recipe recipe = null;
    private int craftingTick = 0;
    private EntityItem entity;

    private void setRecipe(ItemStack out) {
        Recipe last = this.recipe;
        if (out == null) {
            this.recipe = null;
            this.onRecipeChanged(last);
        } else if (this.recipe == null || !ReikaItemHelper.matchStacks((ItemStack)this.recipe.output, (ItemStack)out) || this.craftingTick == 0) {
            Fluid f;
            FabricationRecipes.FabricationRecipe rec = FabricationRecipes.recipes().getItemRecipe(out);
            FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)out);
            Fluid fluid = f = fs != null ? fs.getFluid() : null;
            if (f != null) {
                rec = FabricationRecipes.recipes().getOrCreateFluidRecipe(out, f);
            }
            if (rec != null && rec.hasProgress(this.getPlacer())) {
                this.recipe = f != null ? new FluidRecipe(rec.getCost(), out, f) : new Recipe(rec.getCost(), out);
                this.onRecipeChanged(last);
            }
        }
        this.entity = this.recipe != null ? new InertItem(this.field_145850_b, this.recipe.output) : null;
    }

    private static boolean areRecipesDifferent(Recipe r1, Recipe r2) {
        if (r1 == r2) {
            return false;
        }
        if (r1 == null || r2 == null) {
            return true;
        }
        return !r1.craftsSame(r2);
    }

    private void onRecipeChanged(Recipe last) {
        int n = this.craftingTick = this.recipe != null ? this.recipe.duration : 0;
        if (TileEntityItemFabricator.areRecipesDifferent(last, this.recipe)) {
            CrystalNetworker.instance.breakPaths(this);
            this.checkTimer.reset();
        }
    }

    public ElementTagCompound getCurrentRequirements() {
        return this.recipe != null ? this.recipe.energy.copy() : null;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (!world.field_72995_K && this.checkTimer.checkCap()) {
            this.checkAndRequest();
        }
        if (DragonAPICore.debugtest) {
            for (CrystalElement e : CrystalElement.elements) {
                this.energy.setTag(e, this.getMaxStorage(e));
            }
        }
        if (this.recipe != null && this.energy.containsAtLeast(this.recipe.energy) && this.craftingTick > 0 && !this.hasRedstoneSignal()) {
            this.onCraftingTick(world, x, y, z);
        }
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        this.setRecipe(this.inv[0]);
    }

    @Override
    public void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.func_70296_d();
    }

    private void checkAndRequest() {
        if (this.recipe == null) {
            return;
        }
        int n = TileEntityAdjacencyUpgrade.getAdjacentUpgrade(this, CrystalElement.LIGHTBLUE);
        if (n > 0) {
            n = TileEntityAccelerator.getAccelFromTier(n - 1);
        }
        ++n;
        for (CrystalElement e : this.recipe.energy.elementSet()) {
            int total = (int)Math.min((long)this.getMaxStorage(e), 24L * (long)this.recipe.energy.getValue(e) * (long)n);
            int space = total - this.getEnergy(e);
            if (space <= 0) continue;
            this.requestEnergy(e, space);
        }
    }

    private void onCraftingTick(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            this.craftingFX(world, x, y, z);
        }
        --this.craftingTick;
        this.progress = this.recipe.duration - this.craftingTick;
        if (this.craftingTick == 0) {
            if (this.canCraft()) {
                this.craft(world, x, y, z);
            } else {
                this.craftingTick = 5;
            }
        }
    }

    private boolean canCraft() {
        if (this.recipe instanceof FluidRecipe) {
            return this.canExportFluid(((FluidRecipe)this.recipe).fluid);
        }
        if (this.inv[1] == null) {
            return true;
        }
        return ReikaItemHelper.matchStacks((ItemStack)this.inv[1], (ItemStack)this.recipe.output) && this.inv[1].field_77994_a + ((Recipe)this.recipe).output.field_77994_a <= this.inv[1].func_77976_d();
    }

    private boolean canExportFluid(Fluid f) {
        TileEntity te = this.getAdjacentTileEntity(ForgeDirection.DOWN);
        return te instanceof IFluidHandler && ((IFluidHandler)te).fill(ForgeDirection.UP, new FluidStack(f, 1000), false) == 1000;
    }

    private void craft(World world, int x, int y, int z) {
        if (this.recipe instanceof FluidRecipe) {
            TileEntity te = this.getAdjacentTileEntity(ForgeDirection.DOWN);
            ((IFluidHandler)te).fill(ForgeDirection.UP, new FluidStack(((FluidRecipe)this.recipe).fluid, 1000), true);
        } else {
            int n = 1;
            EntityPlayer ep = this.getPlacer();
            if (ep != null && !ReikaPlayerAPI.isFake((EntityPlayer)ep) && Chromabilities.DOUBLECRAFT.enabledOn(ep)) {
                n = 2;
            }
            ReikaInventoryHelper.addOrSetStack((ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)this.recipe.output, (int)n), (ItemStack[])this.inv, (int)1);
        }
        this.energy.subtract(this.recipe.energy);
        this.progress = 0;
        this.func_70296_d();
    }

    @SideOnly(value=Side.CLIENT)
    private void craftingFX(World world, int x, int y, int z) {
    }

    public int getProgressScaled(int a) {
        return this.recipe != null ? a * this.progress / this.recipe.duration : 0;
    }

    public ItemStack getRecipe() {
        return this.recipe != null ? this.recipe.output.func_77946_l() : null;
    }

    @Override
    public int getReceiveRange() {
        return 16;
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return true;
    }

    @Override
    public int maxThroughput() {
        return 1000;
    }

    @Override
    public boolean canConduct() {
        return true;
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return slot == 1;
    }

    public int func_70302_i_() {
        return 2;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return slot == 0 && ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ChromaStacks.chromaDust);
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return FabricationRecipes.recipes().getMaximumCost() * 3 / 2;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.FABRICATOR;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.craftingTick = NBT.func_74762_e("craft");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("craft", this.craftingTick);
    }

    @Override
    public DecimalPosition getTargetRenderOffset(CrystalElement e) {
        double ang = Math.toRadians((double)e.ordinal() * 22.5);
        double r = 1.5;
        double dx = r * Math.sin(ang);
        double dy = 0.55;
        double dz = r * Math.cos(ang);
        return new DecimalPosition(dx, dy, dz);
    }

    @Override
    public double getIncomingBeamRadius() {
        return 0.25;
    }

    @SideOnly(value=Side.CLIENT)
    public EntityItem getEntityItem() {
        return this.entity;
    }

    @Override
    public ElementTagCompound getRequestedTotal() {
        return this.craftingTick > 0 && this.recipe != null ? this.recipe.energy.copy() : null;
    }

    public double func_145833_n() {
        return super.func_145833_n() * 4.0;
    }

    @Override
    public float getOperationFraction() {
        return this.recipe == null ? 0.0f : 1.0f - (float)this.craftingTick / (float)this.recipe.duration;
    }

    @Override
    public OperationInterval.OperationState getState() {
        return this.recipe == null ? OperationInterval.OperationState.INVALID : (this.energy.containsAtLeast(this.recipe.energy) ? OperationInterval.OperationState.RUNNING : OperationInterval.OperationState.PENDING);
    }

    public boolean hasWork() {
        return this.getState() == OperationInterval.OperationState.RUNNING;
    }

    private static class FluidRecipe
    extends Recipe {
        private final Fluid fluid;

        private FluidRecipe(ElementTagCompound tag, ItemStack is, Fluid f) {
            super(tag, is);
            this.fluid = f;
        }

        @Override
        public boolean craftsSame(Recipe r) {
            return r instanceof FluidRecipe && ((FluidRecipe)r).fluid == this.fluid;
        }
    }

    private static class Recipe {
        private final ItemStack output;
        private final ElementTagCompound energy;
        private final int duration;

        private Recipe(ElementTagCompound tag, ItemStack is) {
            this.energy = tag;
            this.output = is;
            this.duration = Recipe.duration(this.energy);
        }

        public boolean craftsSame(Recipe r) {
            return ReikaItemHelper.matchStacks((ItemStack)this.output, (ItemStack)r.output);
        }

        private static int duration(ElementTagCompound energy) {
            return ReikaMathLibrary.roundUpToX((int)20, (int)((int)Math.sqrt(energy.getTotalEnergy())));
        }
    }
}

