/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Acquisition;

import Reika.ChromatiCraft.API.Interfaces.MinerBlock;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Base.TileEntity.ChargedCrystalPowered;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredOre;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityCenterBlurFX;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityRangeBoost;
import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Auxiliary.ChunkManager;
import Reika.DragonAPI.Base.BlockTieredResource;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.Block.SemiUnbreakable;
import Reika.DragonAPI.Interfaces.Block.SpecialOreBlock;
import Reika.DragonAPI.Interfaces.TileEntity.ChunkLoadingTile;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModRegistry.ModOreList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityMiner
extends ChargedCrystalPowered
implements OwnedTile,
ChunkLoadingTile {
    public static final int MAXRANGE = 128;
    private boolean digging = false;
    private boolean digReady = false;
    private boolean finishedDigging = false;
    private int range = 128;
    private int readX = 0;
    private int readY = 0;
    private int readZ = 0;
    private double particleX;
    private double particleY;
    private double particleVX;
    private double particleVY;
    public int progress;
    private boolean dropFlag = false;
    private long lastWarning;
    private boolean preparedScanning;
    private static final int TICKSTEP = 2048;
    private int index;
    private StepTimer miningTimer = new StepTimer(5);
    private static final ElementTagCompound required = new ElementTagCompound();
    private final EnumMap<MineralCategory, ArrayList<Coordinate>> coords = new EnumMap(MineralCategory.class);
    private final ItemHashMap<ItemDisplay> found = new ItemHashMap();
    private MineralCategory selectedCategory = null;
    private boolean silkTouch;
    private int fortuneLevel;

    @Override
    public ElementTagCompound getRequiredEnergy() {
        return required.copy();
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.MINER;
    }

    public int getReadX() {
        return this.readX;
    }

    public int getReadY() {
        return this.readY;
    }

    public int getReadZ() {
        return this.readZ;
    }

    public int getRange() {
        return this.range;
    }

    @Override
    public void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.updateRange();
        this.calcSilkTouchAndFortune();
        this.dropFlag = false;
        this.digReady = false;
        this.digging = false;
        this.readY = 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        block13: {
            block16: {
                block15: {
                    Coordinate c;
                    block14: {
                        if (world.field_72995_K) break block13;
                        if (!this.dropFlag) break block14;
                        if (this.getTicksExisted() % 20 == 0) {
                            this.doDropWarning(world, x, y, z);
                        }
                        break block13;
                    }
                    if (!this.digging || this.coords.isEmpty()) break block15;
                    this.calcSilkTouchAndFortune();
                    if (this.selectedCategory == null) break block16;
                    this.miningTimer.update();
                    if (!this.miningTimer.checkCap() || !this.hasEnergy(required)) break block16;
                    ArrayList<Coordinate> li = this.coords.get((Object)this.selectedCategory);
                    Coordinate coordinate = c = this.index >= 0 && this.index < li.size() ? li.get(this.index) : null;
                    if (c != null) {
                        int dx = c.xCoord;
                        int dy = c.yCoord;
                        int dz = c.zCoord;
                        Block id = this.parseBlock(world.func_147439_a(dx, dy, dz));
                        int meta2 = world.func_72805_g(dx, dy, dz);
                        this.removeFound(world, dx, dy, dz, id, meta2, this.selectedCategory);
                        if (id instanceof SpecialOreBlock) {
                            this.dropSpecialOreBlock(world, x, y, z, dx, dy, dz, (SpecialOreBlock)id, meta2);
                        } else if (this.isTieredResource(world, dx, dy, dz, id, meta2)) {
                            this.dropTieredResource(world, x, y, z, dx, dy, dz, id, meta2);
                        } else if (id instanceof MinerBlock) {
                            this.dropMineableBlock(world, x, y, z, dx, dy, dz, id, meta2);
                        } else {
                            this.dropBlock(world, x, y, z, dx, dy, dz, id, meta2);
                        }
                        this.useEnergy(required.copy().scale(this.getEnergyCostScale()));
                    }
                    ++this.index;
                    if (this.index < li.size()) break block16;
                    this.finishDigging();
                    break block16;
                }
                if (!this.digReady && !this.finishedDigging) {
                    this.prepareScanning();
                    for (int i = 0; i < 2048; ++i) {
                        int dx = x + this.readX;
                        int dy = this.readY;
                        int dz = z + this.readZ;
                        ReikaWorldHelper.forceGenAndPopulate((World)world, (int)dx, (int)dz);
                        Block id = this.parseBlock(world.func_147439_a(dx, dy, dz));
                        int meta2 = world.func_72805_g(dx, dy, dz);
                        MineralCategory mc = this.getMiningCategory(world, dx, dy, dz, id, meta2);
                        if (mc != null && this.coords.containsKey((Object)mc)) {
                            Coordinate c = new Coordinate(dx, dy, dz);
                            if (this.coords.get((Object)mc).add(c)) {
                                this.coords.get((Object)MineralCategory.ANY).add(c);
                                this.addFound(world, dx, dy, dz, id, meta2, mc);
                            }
                        }
                        this.updateReadPosition();
                        if (this.readY < this.field_145850_b.func_72940_L()) continue;
                        this.prepareDigging();
                    }
                }
            }
            this.progress = this.readY;
        }
        if (world.field_72995_K && this.isTickingNaturally()) {
            this.spawnParticles(world, x, y, z);
        }
    }

    private void prepareScanning() {
        if (!this.preparedScanning) {
            this.preparedScanning = true;
            ChunkManager.instance.loadChunks((ChunkLoadingTile)this);
            for (MineralCategory mc : MineralCategory.list) {
                this.coords.put(mc, new ArrayList());
            }
        }
    }

    private void prepareDigging() {
        this.digReady = true;
        this.readX = 0;
        this.readY = 0;
        this.readZ = 0;
        this.index = 0;
        ChunkManager.instance.unloadChunks((TileEntity)this);
    }

    private void finishDigging() {
        this.digging = false;
        this.finishedDigging = true;
        this.index = 0;
        if (this.selectedCategory == MineralCategory.ANY || this.hasDepletedAllBlocks()) {
            this.digReady = false;
            this.coords.clear();
            this.found.clear();
        }
        ChromaSounds.CRAFTDONE.playSoundAtBlock((TileEntity)this);
        this.selectedCategory = null;
        this.syncAllData(true);
        this.scheduleBlockUpdate(5);
    }

    private boolean hasDepletedAllBlocks() {
        for (ArrayList<Coordinate> li : this.coords.values()) {
            if (li.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private Block parseBlock(Block b) {
        if (b == Blocks.field_150439_ay) {
            return Blocks.field_150450_ax;
        }
        return b;
    }

    private MineralCategory getMiningCategory(World world, int x, int y, int z, Block b, int meta) {
        if (b == Blocks.field_150350_a || b == Blocks.field_150348_b || b == Blocks.field_150424_aL || b == Blocks.field_150377_bs || b == Blocks.field_150346_d || b == Blocks.field_150349_c) {
            return null;
        }
        if (b == Blocks.field_150426_aN) {
            return MineralCategory.MISC_UNDERGROUND_VALUABLE;
        }
        if (Item.func_150898_a((Block)b) == null) {
            return null;
        }
        if (b instanceof SemiUnbreakable && ((SemiUnbreakable)b).isUnbreakable(world, x, y, z, meta)) {
            return null;
        }
        ReikaOreHelper ore = ReikaOreHelper.getEntryByOreDict((ItemStack)new ItemStack(b, meta));
        if (ore != null) {
            switch (ore.getRarity()) {
                case EVERYWHERE: 
                case COMMON: {
                    return MineralCategory.UBIQUITOUS_ORE;
                }
                case AVERAGE: {
                    return MineralCategory.COMMON_ORE;
                }
                case SCATTERED: {
                    return MineralCategory.UNCOMMON_ORE;
                }
                case SCARCE: 
                case RARE: {
                    return MineralCategory.RARE_ORE;
                }
            }
        }
        if ((ore = ModOreList.getModOreFromOre((Block)b, (int)meta)) != null) {
            switch (ore.getRarity()) {
                case EVERYWHERE: 
                case COMMON: {
                    return MineralCategory.UBIQUITOUS_ORE;
                }
                case AVERAGE: {
                    return MineralCategory.COMMON_ORE;
                }
                case SCATTERED: {
                    return MineralCategory.UNCOMMON_ORE;
                }
                case SCARCE: 
                case RARE: {
                    return MineralCategory.RARE_ORE;
                }
            }
        }
        if (this.isTieredResource(world, x, y, z, b, meta)) {
            return b instanceof BlockTieredOre ? MineralCategory.UNCOMMON_ORE : MineralCategory.MISC_UNDERGROUND_VALUABLE;
        }
        if (b instanceof MinerBlock && ((MinerBlock)b).isMineable(meta)) {
            return MineralCategory.from(((MinerBlock)b).getCategory());
        }
        return null;
    }

    public float getDigCompletion() {
        return this.isReady() ? 1.0f : (float)this.progress / (float)this.field_145850_b.func_72940_L();
    }

    public boolean isReady() {
        return this.digReady && this.selectedCategory != null;
    }

    private void removeFound(World world, int x, int y, int z, Block b, int meta, MineralCategory mc) {
        if (Item.func_150898_a((Block)b) == null) {
            return;
        }
        ItemStack is = new ItemStack(b, 1, meta);
        if (b instanceof SpecialOreBlock) {
            is = ((SpecialOreBlock)b).getDisplayItem(world, x, y, z);
        } else if (ReikaBlockHelper.isOre((Block)b, (int)meta)) {
            ReikaOreHelper ore = ReikaOreHelper.getEntryByOreDict((ItemStack)is);
            ModOreList mod = ModOreList.getModOreFromOre((ItemStack)is);
            if (ore != null) {
                is = ore.getOreBlock();
            } else if (mod != null && mod != ModOreList.CERTUSQUARTZ) {
                is = mod.getFirstOreBlock();
            }
        }
        ItemDisplay i = (ItemDisplay)this.found.get(is);
        if (i != null) {
            if (i.amount > 1) {
                i.amount--;
            } else {
                this.found.remove(is);
            }
        }
    }

    private void addFound(World world, int x, int y, int z, Block b, int meta, MineralCategory mc) {
        if (b != null && Item.func_150898_a((Block)b) == null) {
            ChromatiCraft.logger.logError((Object)("Block " + b + " has no item to drop when mined???"));
            return;
        }
        ItemStack is = new ItemStack(b, 1, meta);
        if (b instanceof SpecialOreBlock) {
            is = ((SpecialOreBlock)b).getDisplayItem(world, x, y, z);
        } else if (ReikaBlockHelper.isOre((Block)b, (int)meta)) {
            ReikaOreHelper ore = ReikaOreHelper.getEntryByOreDict((ItemStack)is);
            ModOreList mod = ModOreList.getModOreFromOre((ItemStack)is);
            if (ore != null) {
                is = ore.getOreBlock();
            } else if (mod != null && mod != ModOreList.CERTUSQUARTZ) {
                is = mod.getFirstOreBlock();
            }
        }
        ItemDisplay i = (ItemDisplay)this.found.get(is);
        if (i == null) {
            i = new ItemDisplay(mc, is);
            this.found.put(is, (Object)i);
        }
        i.amount++;
    }

    public Collection<ItemDisplay> getFound() {
        return Collections.unmodifiableCollection(this.found.values());
    }

    public EnumMap<MineralCategory, ArrayList<ItemDisplay>> getFoundByCategory() {
        EnumMap<MineralCategory, ArrayList<ItemDisplay>> map = new EnumMap<MineralCategory, ArrayList<ItemDisplay>>(MineralCategory.class);
        for (ItemDisplay i : this.found.values()) {
            ArrayList<ItemDisplay> li = (ArrayList<ItemDisplay>)map.get((Object)i.category);
            if (li == null) {
                li = new ArrayList<ItemDisplay>();
                map.put(i.category, li);
            }
            li.add(i);
        }
        for (ArrayList li : map.values()) {
            Collections.sort(li);
        }
        return map;
    }

    public ItemDisplay getNumberFound(ItemStack is) {
        return (ItemDisplay)this.found.get(is);
    }

    private boolean isTieredResource(World world, int x, int y, int z, Block id, int meta) {
        EntityPlayer ep = this.getPlacer();
        return ep != null && id instanceof BlockTieredResource && ((BlockTieredResource)id).isPlayerSufficientTier((IBlockAccess)world, x, y, z, ep);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z) {
        double px = (double)x + this.particleX;
        double py = (double)y + this.particleY;
        double pz = z;
        int color = CrystalElement.getBlendedColor(this.getTicksExisted(), 40);
        EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz).setScale(0.5f).setLife(40).setColor(color);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        px = (double)(x + 1) - this.particleX;
        py = (double)(y + 1) - this.particleY;
        fx = new EntityCCBlurFX(world, px, py, pz).setScale(0.5f).setLife(40).setColor(color);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        pz = z + 1;
        px = (double)(x + 1) - this.particleX;
        py = (double)y + this.particleY;
        fx = new EntityCCBlurFX(world, px, py, pz).setScale(0.5f).setLife(40).setColor(color);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        px = (double)x + this.particleX;
        py = (double)(y + 1) - this.particleY;
        fx = new EntityCCBlurFX(world, px, py, pz).setScale(0.5f).setLife(40).setColor(color);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        px = x;
        pz = (double)z + this.particleX;
        py = (double)y + this.particleY;
        fx = new EntityCCBlurFX(world, px, py, pz).setScale(0.5f).setLife(40).setColor(color);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        pz = (double)(z + 1) - this.particleX;
        py = (double)(y + 1) - this.particleY;
        fx = new EntityCCBlurFX(world, px, py, pz).setScale(0.5f).setLife(40).setColor(color);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        px = x + 1;
        pz = (double)(z + 1) - this.particleX;
        py = (double)y + this.particleY;
        fx = new EntityCCBlurFX(world, px, py, pz).setScale(0.5f).setLife(40).setColor(color);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        pz = (double)z + this.particleX;
        py = (double)(y + 1) - this.particleY;
        fx = new EntityCCBlurFX(world, px, py, pz).setScale(0.5f).setLife(40).setColor(color);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        double d = 0.05;
        this.particleX += this.particleVX;
        this.particleY += this.particleVY;
        this.particleX = MathHelper.func_151237_a((double)this.particleX, (double)0.0, (double)1.0);
        this.particleY = MathHelper.func_151237_a((double)this.particleY, (double)0.0, (double)1.0);
        if (this.particleX == 1.0 && this.particleY == 0.0) {
            this.particleVX = 0.0;
            this.particleVY = d;
        }
        if (this.particleY == 1.0 && this.particleY == 1.0) {
            this.particleVX = -d;
            this.particleVY = 0.0;
        }
        if (this.particleX == 0.0 && this.particleY == 1.0) {
            this.particleVX = 0.0;
            this.particleVY = -d;
        }
        if (this.particleX == 0.0 && this.particleY == 0.0) {
            this.particleVX = d;
            this.particleVY = 0.0;
        }
    }

    private void dropSpecialOreBlock(World world, int x, int y, int z, int dx, int dy, int dz, SpecialOreBlock id, int meta2) {
        if (this.silkTouch) {
            this.dropItems(world, x, y, z, ReikaJavaLibrary.makeListFrom((Object)id.getSilkTouchVersion(world, dx, dy, dz)));
        } else {
            this.dropItems(world, x, y, z, id.getDrops(world, dx, dy, dz, this.fortuneLevel));
        }
        id.getReplacementBlock(world, dx, dy, dz).place(world, dx, dy, dz);
    }

    private void dropBlock(World world, int x, int y, int z, int dx, int dy, int dz, Block id, int meta2) {
        if (this.silkTouch) {
            this.dropItems(world, x, y, z, ReikaJavaLibrary.makeListFrom((Object)new ItemStack(id, 1, meta2)));
        } else {
            this.dropItems(world, x, y, z, id.getDrops(world, dx, dy, dz, meta2, this.fortuneLevel));
        }
        this.getFillerBlock(world, dx, dy, dz, id, meta2).place(world, dx, dy, dz);
        ReikaSoundHelper.playBreakSound((World)world, (int)dx, (int)dy, (int)dz, (Block)id);
        ReikaPacketHelper.sendDataPacketWithRadius((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.BREAKPARTICLES.ordinal(), (World)world, (int)dx, (int)dy, (int)dz, (int)128, (int[])new int[]{Block.func_149682_b((Block)id), meta2});
    }

    private void dropTieredResource(World world, int x, int y, int z, int dx, int dy, int dz, Block id, int meta2) {
        Collection li = ((BlockTieredResource)id).getHarvestResources(world, dx, dy, dz, 10, this.getPlacer());
        this.dropItems(world, x, y, z, li);
        this.getFillerBlock(world, dx, dy, dz, id, meta2).place(world, dx, dy, dz);
        ReikaSoundHelper.playBreakSound((World)world, (int)dx, (int)dy, (int)dz, (Block)id);
        ReikaPacketHelper.sendDataPacketWithRadius((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.BREAKPARTICLES.ordinal(), (World)world, (int)dx, (int)dy, (int)dz, (int)128, (int[])new int[]{Block.func_149682_b((Block)id), meta2});
    }

    private void dropMineableBlock(World world, int x, int y, int z, int dx, int dy, int dz, Block id, int meta2) {
        if (this.silkTouch && ((MinerBlock)id).allowSilkTouch(meta2)) {
            this.dropItems(world, x, y, z, ReikaJavaLibrary.makeListFrom((Object)new ItemStack(id, 1, meta2)));
        } else {
            this.dropItems(world, x, y, z, ((MinerBlock)id).getHarvestItems(world, dx, dy, dz, meta2, this.fortuneLevel));
        }
        this.getFillerBlock(world, dx, dy, dz, id, meta2).place(world, dx, dy, dz);
        ReikaSoundHelper.playBreakSound((World)world, (int)dx, (int)dy, (int)dz, (Block)id);
        ReikaPacketHelper.sendDataPacketWithRadius((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.BREAKPARTICLES.ordinal(), (World)world, (int)dx, (int)dy, (int)dz, (int)128, (int[])new int[]{Block.func_149682_b((Block)id), meta2});
    }

    private BlockKey getFillerBlock(World world, int dx, int dy, int dz, Block id, int meta2) {
        if (id instanceof MinerBlock) {
            return new BlockKey(((MinerBlock)id).getReplacedBlock(world, dx, dy, dz));
        }
        if (!id.func_149688_o().func_76220_a()) {
            return new BlockKey(Blocks.field_150350_a);
        }
        if (id == Blocks.field_150426_aN) {
            return new BlockKey(Blocks.field_150350_a);
        }
        if (id == Blocks.field_150474_ac) {
            return new BlockKey(Blocks.field_150350_a);
        }
        if (world.field_73011_w.field_76574_g == -1) {
            return new BlockKey(Blocks.field_150424_aL);
        }
        if (world.field_73011_w.field_76574_g == 1) {
            return new BlockKey(Blocks.field_150377_bs);
        }
        return new BlockKey(Blocks.field_150348_b);
    }

    public boolean hasCrystal() {
        return ChromaItems.STORAGE.matchWith(this.inv[0]);
    }

    private void calcSilkTouchAndFortune() {
        int lvl = TileEntityAdjacencyUpgrade.getAdjacentUpgrade(this, CrystalElement.PURPLE);
        this.silkTouch = lvl > 5;
        this.fortuneLevel = lvl + 1;
    }

    @Override
    public void onAdjacentUpdate(World world, int x, int y, int z, Block b) {
        this.calcSilkTouchAndFortune();
        this.updateRange();
        super.onAdjacentUpdate(world, x, y, z, b);
    }

    private void dropItems(World world, int x, int y, int z, Collection<ItemStack> li) {
        for (ItemStack is : li) {
            if (is == null || is.func_77973_b() == null) {
                BlockKey bk = BlockKey.getAt((IBlockAccess)world, (int)x, (int)y, (int)z);
                ChromatiCraft.logger.logError((Object)("Block " + bk + " @ " + x + ", " + y + ", " + z + " dropped a stack of null! This is a bug on their end!"));
                continue;
            }
            boolean flag = true;
            for (int i = 0; i < 6 && flag; ++i) {
                TileEntity te = this.getAdjacentTileEntity(this.dirs[i]);
                if (!(te instanceof IInventory) || !ReikaInventoryHelper.addToIInv((ItemStack)is, (IInventory)((IInventory)te))) continue;
                flag = false;
            }
            if (!flag) continue;
            ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 1.5), (double)((double)z + 0.5), (ItemStack)is);
            this.dropFlag = true;
            this.doDropWarning(world, x, y, z);
        }
    }

    private void doDropWarning(World world, int x, int y, int z) {
        if (this.lastWarning != world.func_82737_E()) {
            ChromaSounds.ERROR.playSoundAtBlock((TileEntity)this);
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.MINERJAM.ordinal(), (TileEntity)this, (int)32, (int[])new int[0]);
        }
        this.lastWarning = world.func_82737_E();
    }

    @SideOnly(value=Side.CLIENT)
    public void doWarningParticles(World world, int x, int y, int z) {
        int n = 2 + rand.nextInt(6);
        for (int i = 0; i < n; ++i) {
            double rx = (double)x + rand.nextDouble();
            double ry = (double)y + rand.nextDouble();
            double rz = (double)z + rand.nextDouble();
            int l = 10 + rand.nextInt(20);
            float g = -((float)ReikaRandomHelper.getRandomPlusMinus((double)0.0625, (double)0.03125));
            EntityCenterBlurFX fx = new EntityCenterBlurFX(world, rx, ry, rz).setGravity(g).setLife(l);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    private void updateReadPosition() {
        boolean flag1 = false;
        boolean flag2 = false;
        ++this.readX;
        if (this.readX > this.range) {
            this.readX = -this.range;
            flag1 = true;
        }
        if (flag1) {
            ++this.readZ;
            if (this.readZ > this.range) {
                this.readZ = -this.range;
                flag2 = true;
            }
            if (flag2) {
                ++this.readY;
            }
        }
    }

    public boolean triggerDigging() {
        if (this.isReady()) {
            this.digging = true;
            this.dropFlag = false;
            ChromaSounds.USE.playSoundAtBlock((TileEntity)this);
            return true;
        }
        ChromaSounds.ERROR.playSoundAtBlock((TileEntity)this);
        return false;
    }

    public void setCategory(int idx) {
        this.selectedCategory = MineralCategory.list[idx];
        this.syncAllData(false);
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.readX = NBT.func_74762_e("rx");
        this.readY = NBT.func_74762_e("ry");
        this.readZ = NBT.func_74762_e("rz");
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74768_a("rx", this.readX);
        NBT.func_74768_a("ry", this.readY);
        NBT.func_74768_a("rz", this.readZ);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.digging = NBT.func_74767_n("dig");
        this.digReady = NBT.func_74767_n("dig2");
        this.finishedDigging = NBT.func_74767_n("finish");
        this.index = NBT.func_74762_e("index");
        this.dropFlag = NBT.func_74767_n("dropped");
        this.silkTouch = NBT.func_74767_n("silk");
        this.fortuneLevel = NBT.func_74762_e("fortune");
        this.found.clear();
        NBTTagList li = NBT.func_150295_c("count", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            NBTTagCompound tag = (NBTTagCompound)o;
            ItemDisplay is = ItemDisplay.readFromNBT(tag);
            this.found.put(is.item, (Object)is);
        }
        int mode = NBT.func_74762_e("mode");
        this.selectedCategory = mode >= 0 ? MineralCategory.list[mode] : null;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("dig", this.digging);
        NBT.func_74757_a("dig2", this.digReady);
        NBT.func_74768_a("index", this.index);
        NBT.func_74757_a("finish", this.finishedDigging);
        NBT.func_74757_a("silk", this.silkTouch);
        NBT.func_74768_a("fortune", this.fortuneLevel);
        NBTTagList li = new NBTTagList();
        for (ItemDisplay is : this.found.values()) {
            NBTTagCompound tag = new NBTTagCompound();
            is.writeToNBT(tag);
            li.func_74742_a((NBTBase)tag);
        }
        NBT.func_74782_a("count", (NBTBase)li);
        NBT.func_74757_a("dropped", this.dropFlag);
        NBT.func_74768_a("mode", this.selectedCategory != null ? this.selectedCategory.ordinal() : -1);
    }

    public int func_70302_i_() {
        return 1;
    }

    public int func_70297_j_() {
        return 1;
    }

    @Override
    protected boolean canExtractOtherItem(int slot, ItemStack is, int side) {
        return false;
    }

    @Override
    protected boolean isItemValidForOtherSlot(int slot, ItemStack is) {
        return false;
    }

    public void breakBlock() {
        ChunkManager.instance.unloadChunks((TileEntity)this);
    }

    public Collection<ChunkCoordIntPair> getChunksToLoad() {
        return ChunkManager.getChunkSquare((int)this.field_145851_c, (int)this.field_145849_e, (int)(this.range >> 4));
    }

    @Override
    public float getCostModifier() {
        float f = 1.0f;
        if (this.silkTouch) {
            f *= 8.0f;
        }
        return f *= 1.0f + (float)this.fortuneLevel / 4.0f;
    }

    @Override
    public boolean usesColor(CrystalElement e) {
        return required.contains(e);
    }

    private void updateRange() {
        int oldrange = this.range;
        double r = 1.0;
        int val = TileEntityAdjacencyUpgrade.getAdjacentUpgrade(this, CrystalElement.LIME);
        if (val > 0) {
            r = TileEntityRangeBoost.getFactor(val - 1);
        }
        this.range = (int)(128.0 * r);
        if (this.range != oldrange && !this.digging) {
            this.readX = 0;
            this.readY = 0;
            this.readZ = 0;
            this.digReady = false;
            this.found.clear();
            this.coords.clear();
        }
    }

    public boolean hasSilkTouch() {
        return this.silkTouch;
    }

    public int getFortune() {
        return this.fortuneLevel;
    }

    public MineralCategory getCategory() {
        return this.selectedCategory;
    }

    public int getTotalFound(MineralCategory mc) {
        return this.coords.isEmpty() ? 0 : this.coords.get((Object)mc).size();
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        this.writeOwnerData(NBT);
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        this.readOwnerData(is);
    }

    static {
        required.addTag(CrystalElement.YELLOW, 50);
        required.addTag(CrystalElement.LIME, 30);
        required.addTag(CrystalElement.GRAY, 20);
        required.addTag(CrystalElement.BROWN, 40);
    }

    public static class ItemDisplay
    implements Comparable<ItemDisplay> {
        private int amount = 0;
        public final MineralCategory category;
        private final ItemStack item;

        private ItemDisplay(MineralCategory mc, ItemStack is) {
            this.category = mc;
            this.item = is;
        }

        public int getAmount() {
            return this.amount;
        }

        public ItemStack getDisplayItem() {
            return this.item.func_77946_l();
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("amt", this.amount);
            tag.func_74768_a("cat", this.category.ordinal());
            this.item.func_77955_b(tag);
        }

        public static ItemDisplay readFromNBT(NBTTagCompound tag) {
            int amt = tag.func_74762_e("amt");
            int cat = tag.func_74762_e("cat");
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)tag);
            ItemDisplay id = new ItemDisplay(MineralCategory.list[cat], is);
            id.amount = amt;
            return id;
        }

        @Override
        public int compareTo(ItemDisplay o) {
            if (o.category != this.category) {
                return this.category.compareTo(o.category);
            }
            if (o.item.func_77973_b() != this.item.func_77973_b()) {
                Block b1 = Block.func_149634_a((Item)this.item.func_77973_b());
                Block b2 = Block.func_149634_a((Item)o.item.func_77973_b());
                if (b1 != null && b2 != null) {
                    if (b1 instanceof BlockTieredResource) {
                        return Integer.MAX_VALUE;
                    }
                    if (b2 instanceof BlockTieredResource) {
                        return Integer.MIN_VALUE;
                    }
                }
            }
            return ReikaItemHelper.comparator.compare(this.item, o.item);
        }
    }

    public static enum MineralCategory {
        UBIQUITOUS_ORE("Ubiquitous Ore"),
        COMMON_ORE("Common Ore"),
        UNCOMMON_ORE("Uncommon Ore"),
        RARE_ORE("Rare Ore"),
        MISC_UNDERGROUND("Misc Material"),
        MISC_UNDERGROUND_VALUABLE("Misc Valuable"),
        ANY("Any");

        private static final MineralCategory[] list;
        public final String displayName;

        private MineralCategory(String s) {
            this.displayName = s;
        }

        public static MineralCategory from(MinerBlock.MineralCategory category) {
            return list[category.ordinal()];
        }

        static {
            list = MineralCategory.values();
        }
    }
}

