/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Acquisition;

import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Base.TileEntity.ChargedCrystalPowered;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityRangeBoost;
import Reika.DragonAPI.Auxiliary.ChunkManager;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.CountMap;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Interfaces.TileEntity.ChunkLoadingTile;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityTeleportationPump
extends ChargedCrystalPowered
implements IFluidHandler,
OwnedTile,
ChunkLoadingTile {
    public static final int MAXRANGE = 256;
    private final HybridTank tank = new HybridTank("telepump", 4000);
    private HashMap<Fluid, ArrayList<FluidSource>> fluids = new HashMap();
    private CountMap<Fluid> counts = new CountMap();
    private Fluid selected = null;
    private boolean scanning = true;
    private boolean fastscan = false;
    private int scanY = 0;
    private int range = 256;
    private static final ElementTagCompound required = new ElementTagCompound();
    private static final HashMap<Fluid, ProgressStage> liquidProgress = new HashMap();
    private static final Comparator<FluidSource> comparator = new Comparator<FluidSource>(){

        @Override
        public int compare(FluidSource o1, FluidSource o2) {
            return ((FluidSource)o2).location.yCoord - ((FluidSource)o1).location.yCoord;
        }
    };

    public static void buildProgressionMap() {
        liquidProgress.put(FluidRegistry.getFluid((String)"luma"), ProgressStage.LUMA);
    }

    public static boolean isFluidDiscovered(Fluid f, EntityPlayer ep) {
        ProgressStage p = liquidProgress.get(f);
        return p == null || p.isPlayerAtStage(ep);
    }

    @Override
    public ElementTagCompound getRequiredEnergy() {
        return required.copy();
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.updateRange();
    }

    @Override
    public void onAdjacentUpdate(World world, int x, int y, int z, Block b) {
        this.updateRange();
        super.onAdjacentUpdate(world, x, y, z, b);
    }

    public int func_70302_i_() {
        return 2;
    }

    public int func_70297_j_() {
        return 1;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.tank);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    protected boolean canExtractOtherItem(int slot, ItemStack is, int side) {
        switch (slot) {
            case 1: {
                return FluidContainerRegistry.isFilledContainer((ItemStack)is);
            }
        }
        return false;
    }

    @Override
    protected boolean isItemValidForOtherSlot(int slot, ItemStack is) {
        switch (slot) {
            case 1: {
                return is.func_77973_b() == Items.field_151133_ar;
            }
        }
        return false;
    }

    public Set<Fluid> getFluids() {
        return Collections.unmodifiableSet(this.counts.keySet());
    }

    public int getFluidCount(Fluid f) {
        return this.counts.containsKey((Object)f) ? this.counts.get((Object)f) : 0;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.TELEPUMP;
    }

    public void setTargetedFluid(int fid) {
        this.selected = FluidRegistry.getFluid((int)fid);
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        block14: {
            Fluid f;
            FluidSource src;
            block13: {
                if (this.scanning) {
                    this.onScan(world, x, y, z);
                }
                if (world.field_72995_K) {
                    return;
                }
                int boost = (int)Math.ceil((float)this.getRange() / 256.0f);
                if (boost == 1 && !this.scanning && this.fluids.isEmpty() && this.getTicksExisted() == 0) {
                    this.fastscan = true;
                }
                if (!this.scanning && !this.fastscan) break block13;
                for (int n = rand.nextInt(boost); n == 0 || this.fastscan && n < 32; ++n) {
                    int r = this.getRange();
                    for (int i = -r; i <= r; ++i) {
                        for (int k = -r; k <= r; ++k) {
                            int dx = x + i;
                            int dy = this.scanY;
                            int dz = z + k;
                            Block b = world.func_147439_a(dx, dy, dz);
                            FluidStack fs = this.getDrainableFluid(world, dx, dy, dz);
                            if (fs == null) continue;
                            this.addFluidBlock(dx, dy, dz, fs);
                        }
                    }
                    ++this.scanY;
                    if (this.scanY <= 255) continue;
                    this.scanning = false;
                    this.fastscan = false;
                    Collection<ArrayList<FluidSource>> vals = this.fluids.values();
                    for (ArrayList<FluidSource> li : vals) {
                        Collections.shuffle(li);
                        Collections.sort(li, comparator);
                    }
                }
                break block14;
            }
            if (this.selected == null) break block14;
            ArrayList<FluidSource> li = this.fluids.get(this.selected);
            if (li != null && !li.isEmpty() && (src = li.get(0)).matchInWorld(world) && this.canAddFluid(((FluidSource)src).fluid.amount, this.selected) && this.hasEnergy(required)) {
                this.tank.addLiquid(((FluidSource)src).fluid.amount, this.selected);
                src.location.setBlock(world, Blocks.field_150350_a);
                this.useEnergy(required.copy().scale(this.getEnergyCostScale()));
                li.remove(0);
                this.decrFluid(((FluidSource)src).fluid.amount, this.selected);
            }
            if ((f = this.tank.getActualFluid()) != null) {
                if (this.tank.getLevel() >= 1000) {
                    this.fillBucket(f);
                }
                if (!this.tank.isEmpty()) {
                    for (int k = 0; k < 6; ++k) {
                        IFluidHandler ifl;
                        int amt;
                        ForgeDirection dir = this.dirs[k];
                        TileEntity te = this.getAdjacentTileEntity(dir);
                        if (!(te instanceof IFluidHandler) || (amt = (ifl = (IFluidHandler)te).fill(dir.getOpposite(), this.tank.getFluid(), true)) <= 0) continue;
                        this.tank.removeLiquid(amt);
                        if (!this.tank.isEmpty()) {
                            continue;
                        }
                        break;
                    }
                }
            }
        }
    }

    private FluidStack getDrainableFluid(World world, int x, int y, int z) {
        FluidStack ret = ReikaWorldHelper.getDrainableFluid((World)world, (int)x, (int)y, (int)z);
        if (ret == null) {
            return null;
        }
        if ((ret = ret.copy()).getFluid() == FluidRegistry.WATER) {
            ret.amount /= 10;
        }
        return ret.amount > 0 ? ret : null;
    }

    private void fillBucket(Fluid f) {
        int amt;
        ItemStack is;
        if (this.inv[1] != null && (is = FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(f, amt = FluidContainerRegistry.getContainerCapacity((ItemStack)this.inv[1])), (ItemStack)this.inv[1])) != null) {
            this.inv[1] = is;
            this.tank.removeLiquid(amt);
        }
    }

    private void decrFluid(int rem, Fluid f) {
        this.counts.increment((Object)f, -rem);
    }

    public boolean isPlayerAccessible(EntityPlayer var1) {
        return !this.scanning && super.isPlayerAccessible(var1);
    }

    private void onScan(World world, int x, int y, int z) {
        ReikaParticleHelper.PORTAL.spawnAroundBlock(world, x, y, z, 8);
    }

    public int getRange() {
        return this.range;
    }

    private void addFluidBlock(int x, int y, int z, FluidStack fs) {
        Fluid f = fs.getFluid();
        ArrayList<FluidSource> li = this.fluids.get(f);
        if (li == null) {
            li = new ArrayList();
            this.fluids.put(f, li);
            this.counts.set((Object)f, 0);
        }
        li.add(new FluidSource(x, y, z, fs));
        this.counts.increment((Object)f, fs.amount);
    }

    public int getLiquidScaled(int a) {
        return a * this.tank.getLevel() / this.tank.getCapacity();
    }

    public Fluid getTankFluid() {
        return this.tank.getActualFluid();
    }

    private boolean canAddFluid(int amt, Fluid f) {
        return this.tank.canTakeIn(amt);
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
        NBT.func_74757_a("scan", this.scanning);
        NBT.func_74778_a("fluid", this.selected != null ? this.selected.getName() : "null");
        NBTTagCompound tag = new NBTTagCompound();
        for (Fluid f : this.counts.keySet()) {
            String s = f.getName();
            int c = this.counts.get((Object)f);
            tag.func_74768_a(s, c);
        }
        NBT.func_74782_a("counts", (NBTBase)tag);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
        this.scanning = NBT.func_74767_n("scan");
        String fid = NBT.func_74764_b("fluid") ? NBT.func_74779_i("fluid") : null;
        this.selected = fid == null || fid.equals("null") ? null : FluidRegistry.getFluid((String)fid);
        NBTTagCompound tag = NBT.func_74775_l("counts");
        for (Object o : tag.func_150296_c()) {
            String s = (String)o;
            Fluid f = FluidRegistry.getFluid((String)s);
            if (f == null) continue;
            this.counts.set((Object)f, tag.func_74762_e(s));
        }
    }

    @Override
    public float getCostModifier() {
        return 1.0f;
    }

    @Override
    public boolean usesColor(CrystalElement e) {
        return required.contains(e);
    }

    public void breakBlock() {
        ChunkManager.instance.unloadChunks((TileEntity)this);
    }

    public Collection<ChunkCoordIntPair> getChunksToLoad() {
        return ChunkManager.getChunkSquare((int)this.field_145851_c, (int)this.field_145849_e, (int)(this.range >> 4));
    }

    private void updateRange() {
        int oldrange = this.range;
        double r = 1.0;
        int val = TileEntityAdjacencyUpgrade.getAdjacentUpgrade(this, CrystalElement.LIME);
        if (val > 0) {
            r = TileEntityRangeBoost.getFactor(val - 1);
        }
        this.range = (int)(256.0 * r);
        if (this.scanning && oldrange != this.range) {
            this.scanY = 0;
            this.fluids.clear();
            this.counts.clear();
        }
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        this.writeOwnerData(NBT);
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        this.readOwnerData(is);
    }

    static {
        required.addTag(CrystalElement.CYAN, 250);
        required.addTag(CrystalElement.BLACK, 100);
        required.addTag(CrystalElement.LIME, 500);
    }

    private static class FluidSource {
        private final Coordinate location;
        private final FluidStack fluid;

        private FluidSource(int x, int y, int z, FluidStack fs) {
            this.location = new Coordinate(x, y, z);
            this.fluid = fs;
        }

        public boolean matchInWorld(World world) {
            return ReikaFluidHelper.lookupFluidForBlock((Block)this.location.getBlock((IBlockAccess)world)) == this.fluid.getFluid();
        }
    }
}

