/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Auxiliary;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityPylonEnhancer;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Magic.Progression.ProgressionCatchupHandling;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCFloatingSeedsFX;
import Reika.ChromatiCraft.Render.Particle.EntityChromaFluidFX;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.ChromatiCraft.World.IWG.PylonGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Effects.EntityFloatingSeedsFX;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityChromaCrystal
extends TileEntityPylonEnhancer {
    private int omega;
    private int torque;
    private long power;
    private Coordinate pylonLocation;

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.CRYSTAL;
    }

    public boolean isConnected() {
        return this.pylonLocation != null;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (world.field_72995_K && this.pylonLocation != null) {
            ProgressionCatchupHandling.instance.attemptSync(this, 9.0, ProgressStage.POWERCRYSTAL);
        }
        if (this.getTicksExisted() < 5) {
            this.update();
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            this.pylonLocation = this.findPylonLocation(world, x, y, z);
        }
        this.update();
    }

    private void update() {
        this.syncAllData(true);
        this.triggerBlockUpdate();
    }

    private Coordinate findPylonLocation(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y - 1, z) != ChromaBlocks.RUNE.getBlockInstance()) {
            return null;
        }
        CrystalElement e = CrystalElement.elements[world.func_72805_g(x, y - 1, z)];
        Collection<TileEntityCrystalPylon> c = CrystalNetworker.instance.getNearbyPylons(world, x, y, z, e, 8, false);
        for (TileEntityCrystalPylon te : c) {
            if (!te.isValidPowerCrystal(this)) continue;
            PylonGenerator.instance.cachePylon(te);
            return new Coordinate((TileEntity)te);
        }
        return null;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public void destroy() {
        ChromaSounds.POWERDOWN.playSoundAtBlock((TileEntity)this, 2.0f, 1.0f);
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.POWERCRYSDESTROY.ordinal(), (TileEntity)this, (int)32, (int[])new int[0]);
        this.delete();
    }

    @SideOnly(value=Side.CLIENT)
    public static void doDestroyParticles(World world, int x, int y, int z) {
        int i;
        for (i = 0; i < 24; ++i) {
            double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.125);
            double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.125);
            double vy = ReikaRandomHelper.getRandomPlusMinus((double)0.125, (double)0.0625);
            double px = (double)x + rand.nextDouble();
            double py = (double)y + rand.nextDouble();
            double pz = (double)z + rand.nextDouble();
            EntityChromaFluidFX fx = new EntityChromaFluidFX(world, px, py, pz, vx, vy, vz).setLife(80).setGravity(0.25f).setScale(1.0f + rand.nextFloat());
            fx.field_70145_X = false;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        for (i = 0; i < 16; ++i) {
            double px = (double)x + rand.nextDouble();
            double py = (double)y + rand.nextDouble();
            double pz = (double)z + rand.nextDouble();
            EntityFloatingSeedsFX fx = (EntityFloatingSeedsFX)new EntityCCFloatingSeedsFX(world, px, py, pz, 0.0, 90.0, ChromaIcons.CHROMA).setLife(80);
            fx.particleVelocity = 0.125;
            fx.freedom *= 2.0;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        if (this.pylonLocation != null) {
            this.pylonLocation.writeToNBT("pylon", NBT);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        if (NBT.func_74764_b("pylon")) {
            this.pylonLocation = Coordinate.readFromNBT((String)"pylon", (NBTTagCompound)NBT);
        }
    }

    public void breakBlock() {
        if (this.pylonLocation != null) {
            TileEntityCrystalPylon te = (TileEntityCrystalPylon)this.pylonLocation.getTileEntity((IBlockAccess)this.field_145850_b);
            te.onPowerCrystalBreak(this);
        }
    }
}

